package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummaryService;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;

/**
 * 月度周转工具租赁费结算汇总
 *
 * @author generator
 */
@Controller
@RequestMapping("revolvingleasesummary")
public class RevolvingleasesummaryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-revolvingleasesummary";//此处需要根据实际修改

    @Autowired
    private IRevolvingleasesummaryService service;

    @Autowired
    private IRevolvingleaseService revolvingleaseService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> saveOrUpdate(@RequestBody RevolvingleasesummaryVO saveorUpdateVO) {
        RevolvingleasesummaryEntity entity = BeanMapper.map(saveorUpdateVO, RevolvingleasesummaryEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {//新增

            //1.校验（同一项目，如有未审批通过的单据，不允许新增）
            //创建条件构造器
            QueryWrapper<RevolvingleasesummaryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.in("bill_state", 0, 2, 4, 5);
            List<RevolvingleasesummaryEntity> pro = service.list(queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("同一项目只能存在一份自由态、审批中、审批驳回的\"月度周转租赁结算汇总单\"!");
            }
        }
        entity = checkBillCodeUniq(entity);
        service.saveOrUpdate(entity, false);

        //2.保存或更新后，更新租赁单的被引用状态
        if (entity.getId() != null) {
            //2.1更新后，先把老数据的被引用状态改为0
            //创建条件构造器
            QueryWrapper<RevolvingleaseEntity> queryWrapperOld = new QueryWrapper<>();
            queryWrapperOld.in("reference_code", saveorUpdateVO.getBillCode());
            queryWrapperOld.eq("dr", 0);
            List<RevolvingleaseEntity> oldList = revolvingleaseService.list(queryWrapperOld);
            if (oldList != null && oldList.size() > 0) {
                for (RevolvingleaseEntity item : oldList) {
                    item.setIsReference(0);
                    item.setReferenceCode(null);
                }
                revolvingleaseService.saveOrUpdateBatch(oldList);
            }
        }

        //2.2更新被引用单据的引用状态
        List<String> referenceIdList = saveorUpdateVO.getReferenceIdList();
        if (referenceIdList != null && referenceIdList.size() > 0) {
            //创建条件构造器
            QueryWrapper<RevolvingleaseEntity> queryWrapperByIdsNew = new QueryWrapper<>();
            queryWrapperByIdsNew.in("id", referenceIdList);
            queryWrapperByIdsNew.eq("dr", 0);
            List<RevolvingleaseEntity> newList = revolvingleaseService.list(queryWrapperByIdsNew);
            if (newList != null && newList.size() > 0) {
                for (RevolvingleaseEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(entity.getBillCode());
                }
                revolvingleaseService.saveOrUpdateBatch(newList);
            }
        }
        RevolvingleasesummaryVO vo = BeanMapper.map(entity, RevolvingleasesummaryVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private RevolvingleasesummaryEntity checkBillCodeUniq(RevolvingleasesummaryEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<RevolvingleasesummaryEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne("id", id);
            }
            List<RevolvingleasesummaryEntity> proBillCode = service.list(queryWrapperBillCode);
            if (proBillCode != null && proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> queryDetail(Long id) {
        RevolvingleasesummaryEntity entity = service.selectById(id);
        RevolvingleasesummaryVO vo = BeanMapper.map(entity, RevolvingleasesummaryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleasesummaryVO> vos) {
        List<Long> idList = vos.stream().map(RevolvingleasesummaryVO::getId).collect(Collectors.toList());
        QueryWrapper<RevolvingleasesummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.in("id", idList);
        List<RevolvingleasesummaryEntity> revolvingleasesummaryEntityList = service.list(queryWrapper);

        List<String> codeList = new ArrayList<>();
        for (RevolvingleasesummaryEntity entity : revolvingleasesummaryEntityList) {
            codeList.add(entity.getBillCode());
        }

        QueryWrapper<RevolvingleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.in("reference_code", codeList);
        List<RevolvingleaseEntity> list = revolvingleaseService.list(wrapper);
        //删除时去掉结算单的引用状态
        for (RevolvingleaseEntity entity : list) {
            entity.setIsReference(0);
            entity.setReferenceCode(null);
        }
        if (list.size() > 0) {
            //保存结算单
            revolvingleaseService.saveOrUpdateBatch(list);
        }
        service.removeByIds(idList, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<RevolvingleasesummaryEntity> page = service.queryPage(param, false);
        IPage<RevolvingleasesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RevolvingleasesummaryVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<RevolvingleasesummaryEntity> list = service.queryList(param);
        //时间转换
        List<RevolvingleasesummaryVO> revolvingleasesummaryVOList = BeanMapper.mapList(list, RevolvingleasesummaryVO.class);
        for (int i = 0; i < revolvingleasesummaryVOList.size(); i++) {
            RevolvingleasesummaryVO revolvingleasesummaryVO = revolvingleasesummaryVOList.get(i);
            revolvingleasesummaryVO.setSort(String.valueOf(i + 1));
            if (revolvingleasesummaryVO.getStatisticalTime() != null) {
                revolvingleasesummaryVO.setStatisticalTimeShow(DateUtils.dateSimple3(revolvingleasesummaryVO.getStatisticalTime()));
            }

            String billStateStr = revolvingleasesummaryVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                revolvingleasesummaryVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", revolvingleasesummaryVOList);
        ExcelExport.getInstance().export("RevolvingleasesummaryMain-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRevolvingleasesummaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> refRevolvingleasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                       String condition,
                                                                                       String searchObject,
                                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RevolvingleasesummaryEntity> page = service.queryPage(param, false);
        IPage<RevolvingleasesummaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RevolvingleasesummaryVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @param projectId
     * @Description queryDetail 查询该项目是否已有月度周转租赁结算汇总单据
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<RevolvingleasesummaryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.notIn("bill_state", 1, 3);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<RevolvingleasesummaryEntity> entityList = service.list(queryWrapper);

        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("同一项目只能存在一份自由态或审批中的月度周转租赁结算汇总单");
        }

        return CommonResponse.success("查询成功！", "0");
    }

    /**
     * 查询被引用的结算单
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/getSelectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> getSelectId(Long id) {
        RevolvingleasesummaryEntity revolvingleasesummary = service.selectById(id);
        String billCode = revolvingleasesummary.getBillCode();
        QueryWrapper<RevolvingleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr", 0);
        wrapper.eq("reference_code", billCode);
        List<RevolvingleaseEntity> list = revolvingleaseService.list(wrapper);
        List<Long> idList = new ArrayList<>();
        for (RevolvingleaseEntity entity : list) {
            idList.add(entity.getId());
        }

        return CommonResponse.success("查询成功！", idList);
    }
}
