package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("subcontractaccount") 
public class SubcontractaccountBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ISubcontractaccountService service;

	@Autowired
	private ISubcontractaccountdetailService subcontractaccountdetailService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//创建条件构造器
		QueryWrapper<SubcontractaccountdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", billId);
		queryWrapper.eq("dr", "0");
		List<SubcontractaccountdetailEntity> detailEntities = subcontractaccountdetailService.list(queryWrapper);
		if(detailEntities != null && detailEntities.size() > 0){
			for (int i = 0; i < detailEntities.size(); i++) {
				SubcontractaccountdetailEntity detail = detailEntities.get(i);
				detail.setBillState(state);//更新子表审批状态
			}

			subcontractaccountdetailService.saveOrUpdateBatch(detailEntities);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SubcontractaccountEntity entity = service.selectById(billId);
		Long projectId = entity.getProjectId();//项目id

		//只能弃审最新的单据
		QueryWrapper<SubcontractaccountEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByDesc("create_time");
		queryWrapper.last("limit 1");
		List<SubcontractaccountEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			SubcontractaccountEntity resEntity = pro.get(0);
			Integer billState = resEntity.getBillState();
			if(!billId.equals(resEntity.getId())){//本单据不是最新
				if(billState == 1 || billState == 3){
					return CommonResponse.error("只能弃审该合同下最后一次做的已生效单据！");
				}else {
					return CommonResponse.error("已存在一个审批中或自由态的最新单据，不允许弃审！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
