package com.ejianc.business.middlemeasurement.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 月度机械设备租赁单参照
 *
 * @author generator
 *
 */
public class MechanicalleasedataVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Date settlementTime;   //结算月份
    private String settlementTimeMonth;   //结算月份
    private Long mid; // 主表id
    private String billCode; // 单据编号
    private String sort; // 序号
    private String name; // 租赁物资名称
    private String spec; // 规格型号
    private String measuringUnit; // 计量单位
    private BigDecimal leaseNum; // 租赁数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billingStartTime; // 本期计算起始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billingEndTime; // 本期计算终止日期
    private Integer leaseDaysThisTime; // 本期租赁期长（天）
    private BigDecimal inTaxLeaseUnit; // 租赁单价（含税）（元）
    private BigDecimal exTaxLeaseUnit; // 租赁单价（除税）（元）
    private BigDecimal inTaxLeaseTotal; // 租赁合价（含税）（元）
    private BigDecimal exTaxLeaseTotal; // 租赁合价（除税）（元）
    private BigDecimal inTaxSettlementMonth; // 月度结算费用（含税）（元）
    private BigDecimal exTaxSettlementMonth; // 月度结算费用（除税）（元）
    private Integer month; // 月份

    public Integer getMonth() {
        return month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getSettlementTime() {
        return settlementTime;
    }

    public void setSettlementTime(Date settlementTime) {
        this.settlementTime = settlementTime;
    }

    /**
     * 主表id
     */
    public Long getMid() {
        return mid;
    }

    /**
     * 主表id
     */
    public void setMid(Long mid) {
        this.mid = mid;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 序号
     */
    public String getSort() {
        return sort;
    }

    /**
     * 序号
     */
    public void setSort(String sort) {
        this.sort = sort;
    }
    /**
     * 租赁物资名称
     */
    public String getName() {
        return name;
    }

    /**
     * 租赁物资名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getMeasuringUnit() {
        return measuringUnit;
    }

    /**
     * 计量单位
     */
    public void setMeasuringUnit(String measuringUnit) {
        this.measuringUnit = measuringUnit;
    }
    /**
     * 租赁数量
     */
    public BigDecimal getLeaseNum() {
        return leaseNum;
    }

    /**
     * 租赁数量
     */
    public void setLeaseNum(BigDecimal leaseNum) {
        this.leaseNum = leaseNum;
    }
    /**
     * 本期计算起始日期
     */
    public Date getBillingStartTime() {
        return billingStartTime;
    }

    /**
     * 本期计算起始日期
     */
    public void setBillingStartTime(Date billingStartTime) {
        this.billingStartTime = billingStartTime;
    }
    /**
     * 本期计算终止日期
     */
    public Date getBillingEndTime() {
        return billingEndTime;
    }

    /**
     * 本期计算终止日期
     */
    public void setBillingEndTime(Date billingEndTime) {
        this.billingEndTime = billingEndTime;
    }
    /**
     * 本期租赁期长（天）
     */
    public Integer getLeaseDaysThisTime() {
        return leaseDaysThisTime;
    }

    /**
     * 本期租赁期长（天）
     */
    public void setLeaseDaysThisTime(Integer leaseDaysThisTime) {
        this.leaseDaysThisTime = leaseDaysThisTime;
    }
    /**
     * 租赁单价（含税）（元）
     */
    public BigDecimal getInTaxLeaseUnit() {
        return inTaxLeaseUnit;
    }

    /**
     * 租赁单价（含税）（元）
     */
    public void setInTaxLeaseUnit(BigDecimal inTaxLeaseUnit) {
        this.inTaxLeaseUnit = inTaxLeaseUnit;
    }
    /**
     * 租赁单价（除税）（元）
     */
    public BigDecimal getExTaxLeaseUnit() {
        return exTaxLeaseUnit;
    }

    /**
     * 租赁单价（除税）（元）
     */
    public void setExTaxLeaseUnit(BigDecimal exTaxLeaseUnit) {
        this.exTaxLeaseUnit = exTaxLeaseUnit;
    }
    /**
     * 租赁合价（含税）（元）
     */
    public BigDecimal getInTaxLeaseTotal() {
        return inTaxLeaseTotal;
    }

    /**
     * 租赁合价（含税）（元）
     */
    public void setInTaxLeaseTotal(BigDecimal inTaxLeaseTotal) {
        this.inTaxLeaseTotal = inTaxLeaseTotal;
    }
    /**
     * 租赁合价（除税）（元）
     */
    public BigDecimal getExTaxLeaseTotal() {
        return exTaxLeaseTotal;
    }

    /**
     * 租赁合价（除税）（元）
     */
    public void setExTaxLeaseTotal(BigDecimal exTaxLeaseTotal) {
        this.exTaxLeaseTotal = exTaxLeaseTotal;
    }

    /**
     * 月度结算费用（含税）（元）
     */
    public BigDecimal getInTaxSettlementMonth() {
        return inTaxSettlementMonth;
    }

    /**
     * 月度结算费用（含税）（元）
     */
    public void setInTaxSettlementMonth(BigDecimal inTaxSettlementMonth) {
        this.inTaxSettlementMonth = inTaxSettlementMonth;
    }
    /**
     * 月度结算费用（除税）（元）
     */
    public BigDecimal getExTaxSettlementMonth() {
        return exTaxSettlementMonth;
    }

    /**
     * 月度结算费用（除税）（元）
     */
    public void setExTaxSettlementMonth(BigDecimal exTaxSettlementMonth) {
        this.exTaxSettlementMonth = exTaxSettlementMonth;
    }

    public String getSettlementTimeMonth() {
        return settlementTimeMonth;
    }

    public void setSettlementTimeMonth(String settlementTimeMonth) {
        this.settlementTimeMonth = settlementTimeMonth;
    }
}
