package com.ejianc.business.middlemeasurement.excel;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.util.NumberUtil;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumemdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeodetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumemdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeodetailService;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetdetailVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumemdetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量及申请报告导入导出
 */
@Controller
@RequestMapping("subcontractingvolumeExport")
public class ExcelSubcontractingvolumeController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private ISubcontractingvolumemdetailService subcontractingvolumemdetailService;
	@Autowired
	private ISubcontractingvolumeodetailService subcontractingvolumeodetailService;

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumedetail-import.xlsx", "分包月度报量及申请报告");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download2", method = RequestMethod.POST)
	@ResponseBody
	public void download2(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumemdetail-import.xlsx", "物资代扣及超用扣款清单");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumeodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, String contractId)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumedetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumedetailVO> errorList = new ArrayList<>();
		Map<String, SubcontractingvolumedetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					List<String> datas = result.get(i);
					StringBuilder errorsMsgBuilder = new StringBuilder();

					String subitemCode = datas.get(0);//清单编号
					String section = datas.get(1);//区段
					String subitemName = datas.get(2);//清单项目名称
					String subitemDesc = datas.get(3);//子目特征描述
					String unit = datas.get(4);//单位
					String quantity = datas.get(5);//数量（分包商上报：本期）
					String unitprice = datas.get(6);//除税单价（分包商上报：本期）
					String taxUnitprice = datas.get(7);//含税单价（分包商上报：本期）
					String amounts = datas.get(8);//除税金额（分包商上报：本期）
					String taxAmounts = datas.get(9);//含税金额（分包商上报：本期）
					String cumulativeQuantity = datas.get(10);//数量（分包商上报：累计）
					String cumulativeAmounts = datas.get(11);//除税金额（分包商上报：累计）
					String cumulativeTaxAmounts = datas.get(12);//含税金额（分包商上报：累计）
					String examineQuantity = datas.get(13);//数量（项目部审批：本期）
					String examineUnitprice = datas.get(14);//除税单价（项目部审批：本期）
					String examineTaxUnitprice = datas.get(15);//含税单价（项目部审批：本期）
					String examineAmounts = datas.get(16);//除税金额（项目部审批：本期）
					String examineTaxAmounts = datas.get(17);//含税金额（项目部审批：本期）
					String examineCumulativeQuantity = datas.get(18);//数量（项目部审批：累计）
					String examineCumulativeAmounts = datas.get(19);//除税金额（项目部审批：累计）
					String examineCumulativeTaxAmounts = datas.get(20);//含税金额（项目部审批：累计）
					String source = datas.get(21);//来源
					String memo = datas.get(22);//备注

					SubcontractingvolumedetailVO detailVO = new SubcontractingvolumedetailVO();
					detailVO.setId(IdWorker.getId());//id
					detailVO.setTid(String.valueOf(IdWorker.getId()));//tid
					detailVO.setContractId(Long.parseLong(contractId));//合同id

					detailVO.setSubitemCode(subitemCode); // 清单编号\
					detailVO.setSection(section);
					detailVO.setSubitemName(subitemName); // 清单项目名称
					detailVO.setSubitemDesc(subitemDesc);//子目特征描述
					detailVO.setUnit(unit); //单位

					if("合同内".equals(source)){
						detailVO.setSource("1"); //来源
					}else if("合同外".equals(source)){
						detailVO.setSource("2"); //来源
					}

					detailVO.setMemo(memo); //备注

					//必填项校验
					if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
						detailVO.setErrorMsg("清单编号不能为空！");
						errorsMsgBuilder.append("清单编号不能为空！");
					}
					if (section == null || TextUtils.isEmpty(section)) {
						detailVO.setErrorMsg("区段不能为空！");
						errorsMsgBuilder.append("区段不能为空！");
					}
					if (subitemName == null || TextUtils.isEmpty(subitemName)) {
						detailVO.setErrorMsg("清单项目名称不能为空！");
						errorsMsgBuilder.append("清单项目名称不能为空！");
					}
					if (unit == null || TextUtils.isEmpty(unit)) {
						detailVO.setErrorMsg("单位不能为空！");
						errorsMsgBuilder.append("单位不能为空！");
					}
					if (quantity == null || TextUtils.isEmpty(quantity)) {
						detailVO.setErrorMsg("数量（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("数量（分包商上报：本期）不能为空！");
					}
					if (unitprice == null || TextUtils.isEmpty(unitprice)) {
						detailVO.setErrorMsg("除税单价（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("除税单价（分包商上报：本期）不能为空！");
					}
					if (taxUnitprice == null || TextUtils.isEmpty(taxUnitprice)) {
						detailVO.setErrorMsg("含税单价（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("含税单价（分包商上报：本期）不能为空！");
					}
					if (examineQuantity == null || TextUtils.isEmpty(examineQuantity)) {
						detailVO.setErrorMsg("数量（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("数量（项目部审批：本期）不能为空！");
					}
					if (examineUnitprice == null || TextUtils.isEmpty(examineUnitprice)) {
						detailVO.setErrorMsg("除税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("除税单价（项目部审批：本期）不能为空！");
					}
					if (examineTaxUnitprice == null || TextUtils.isEmpty(examineTaxUnitprice)) {
						detailVO.setErrorMsg("含税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("含税单价（项目部审批：本期）不能为空！");
					}

					if (StringUtils.isNotBlank(subitemCode)) {
						detailVO.setInnercode(subitemCode+ "_" + section);//清单编号确定唯一性
						if ("01".equals(subitemCode) && subitemName != null && subitemName.contains("装饰")) {
							detailVO.setInnercode("a1"+ "_" + detailVO.getSection());
						}
						//判断是否是装饰工程的子节点编码
						if (subitemCode.length() >= 4) {
							//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
							String code = subitemCode.substring(0, 4);
							if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
								//若是的话，将内码改为a1xx
								detailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()) + "_" + section);
							}
						}
						//1、校验编码是否符合规则--2、4、6、9、9以上
						if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
							detailVO.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
							errorsMsgBuilder.append("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
						}
						detailVO.setSubitemCode(subitemCode);

						//重复性校验
						SubcontractingvolumedetailVO mapVO = map.get(detailVO.getInnercode());
						if (mapVO == null) {
							map.put(detailVO.getInnercode(), detailVO);
						} else {
							detailVO.setErrorMsg("清单编号已存在！");
							errorsMsgBuilder.append("清单编号已存在！");
						}
						detailVO.setSubitemCode(subitemCode);
					}

					//格式校验
					if (StringUtils.isNotBlank(quantity)) {
						if(!NumberUtil.isNumber(quantity)){
							detailVO.setErrorMsg("数量（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("数量（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setQuantity(new BigDecimal(quantity));
						}
					}

					if (StringUtils.isNotBlank(unitprice)) {
						if(!NumberUtil.isNumber(unitprice)){
							detailVO.setErrorMsg("除税单价（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("除税单价（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setUnitprice(new BigDecimal(unitprice));
						}
					}

					if (StringUtils.isNotBlank(taxUnitprice)) {
						if(!NumberUtil.isNumber(taxUnitprice)){
							detailVO.setErrorMsg("含税单价（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("含税单价（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(amounts)) {
						if(!NumberUtil.isNumber(amounts)){
							detailVO.setErrorMsg("除税金额（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("除税金额（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setAmounts(new BigDecimal(amounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal unitpriceB = detailVO.getUnitprice();
						if(quantityB != null && unitpriceB != null){
							detailVO.setAmounts(quantityB.multiply(unitpriceB));
						}
					}

					if (StringUtils.isNotBlank(taxAmounts)) {
						if(!NumberUtil.isNumber(taxAmounts)){
							detailVO.setErrorMsg("含税金额（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("含税金额（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setTaxAmounts(new BigDecimal(taxAmounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal taxUnitpriceB = detailVO.getTaxUnitprice();
						if(quantityB != null && taxUnitpriceB != null){
							detailVO.setTaxAmounts(quantityB.multiply(taxUnitpriceB));
						}
					}

					if (StringUtils.isNotBlank(examineQuantity)) {
						if(!NumberUtil.isNumber(examineQuantity)){
							detailVO.setErrorMsg("数量（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("数量（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineQuantity(new BigDecimal(examineQuantity));
						}
					}

					if (StringUtils.isNotBlank(examineUnitprice)) {
						if(!NumberUtil.isNumber(examineUnitprice)){
							detailVO.setErrorMsg("除税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("除税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineUnitprice(new BigDecimal(examineUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineTaxUnitprice)) {
						if(!NumberUtil.isNumber(examineTaxUnitprice)){
							detailVO.setErrorMsg("含税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("含税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineTaxUnitprice(new BigDecimal(examineTaxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineAmounts)) {
						if(!NumberUtil.isNumber(examineAmounts)){
							detailVO.setErrorMsg("除税金额（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("除税金额（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineAmounts(new BigDecimal(examineAmounts));
						}
					} else {
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineUnitpriceB = detailVO.getExamineUnitprice();
						if(examineQuantityB != null && examineUnitpriceB != null){
							detailVO.setExamineAmounts(examineQuantityB.multiply(examineUnitpriceB));
						}
					}

					if (StringUtils.isNotBlank(examineTaxAmounts)) {
						if(!NumberUtil.isNumber(examineTaxAmounts)){
							detailVO.setErrorMsg("含税金额（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("含税金额（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineTaxAmounts(new BigDecimal(examineTaxAmounts));
						}
					} else {
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineTaxUnitpriceB = detailVO.getExamineTaxUnitprice();
						if(examineQuantityB != null && examineTaxUnitpriceB != null){
							detailVO.setExamineTaxAmounts(examineQuantityB.multiply(examineTaxUnitpriceB));
						}
					}

					//抓取子表累计值
					if(StringUtils.isNotBlank(subitemCode)){
						//导入的本期
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal amountsB = detailVO.getAmounts();
						BigDecimal taxAmountsB = detailVO.getTaxAmounts();
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineAmountsB = detailVO.getExamineAmounts();
						BigDecimal examineTaxAmountsB = detailVO.getExamineTaxAmounts();

						//查询该清单编码往期累计
						//创建条件构造器
						QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("contract_id", contractId);
						queryWrapper.eq("subitem_code", subitemCode);
						queryWrapper.eq("section", section);
						queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
						queryWrapper.eq("dr", "0");
						queryWrapper.orderByDesc("create_time");//最新往期
						queryWrapper.last("limit 1");
						List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
						if(pastDetails != null && pastDetails.size() > 0){
							SubcontractingvolumedetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
							BigDecimal pastQuantityB = pastSubcontractingvolumedetail.getCumulativeQuantity();
							BigDecimal pastAmountsB = pastSubcontractingvolumedetail.getCumulativeAmounts();
							BigDecimal pastTaxAmountsB = pastSubcontractingvolumedetail.getCumulativeTaxAmounts();
							BigDecimal pastExamineQuantityB = pastSubcontractingvolumedetail.getExamineCumulativeQuantity();
							BigDecimal pastExamineAmountsB = pastSubcontractingvolumedetail.getExamineCumulativeAmounts();
							BigDecimal pastExamineTaxAmountsB = pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts();
							if(quantityB != null){
								pastQuantityB = pastQuantityB.add(quantityB);
							}
							if(amountsB != null){
								pastAmountsB = pastAmountsB.add(amountsB);
							}
							if(taxAmountsB != null){
								pastTaxAmountsB = pastTaxAmountsB.add(taxAmountsB);
							}
							if(examineQuantityB != null){
								pastExamineQuantityB = pastExamineQuantityB.add(examineQuantityB);
							}
							if(examineAmountsB != null){
								pastExamineAmountsB = pastExamineAmountsB.add(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								pastExamineTaxAmountsB = pastExamineTaxAmountsB.add(examineTaxAmountsB);
							}
							//数量（分包商上报累计）
							detailVO.setCumulativeQuantity(pastQuantityB);
							//除税金额（分包商上报累计）
							detailVO.setCumulativeAmounts(pastAmountsB);
							//含税金额（分包商上报累计）
							detailVO.setCumulativeTaxAmounts(pastTaxAmountsB);
							//数量（项目部审核累计）
							detailVO.setExamineCumulativeQuantity(pastExamineQuantityB);
							//除税金额（项目部审核累计）
							detailVO.setExamineCumulativeAmounts(pastExamineAmountsB);
							//含税金额（项目部审核累计）
							detailVO.setExamineCumulativeTaxAmounts(pastExamineTaxAmountsB);
						}else {
							if(quantityB != null){
								detailVO.setCumulativeQuantity(quantityB);
							}
							if(amountsB != null){
								detailVO.setCumulativeAmounts(amountsB);
							}
							if(taxAmountsB != null){
								detailVO.setCumulativeTaxAmounts(taxAmountsB);
							}
							if(examineQuantityB != null){
								detailVO.setExamineCumulativeQuantity(examineQuantityB);
							}
							if(examineAmountsB != null){
								detailVO.setExamineCumulativeAmounts(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								detailVO.setExamineCumulativeTaxAmounts(examineTaxAmountsB);
							}
						}
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(detailVO);
					} else {
						successList.add(detailVO);
					}
				}
			}
		}

		//按子目编码排序
		Collections.sort(successList, new Comparator<SubcontractingvolumedetailVO>() {
			@Override
			public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
				return (o1.getSubitemCode()+ o1.getSection()).compareTo(o2.getSubitemCode()+ o1.getSection());
			}
		});

		//设置tid和tpid
		List<SubcontractingvolumedetailVO> resList = setTidAndTpid(successList, map);
		//构建树
		resList = createTreeData(resList);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(resList);

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", resList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入 物资代扣及超用扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import2", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData2(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumemdetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumemdetailVO> errorList = new ArrayList<>();
		Map<String, SubcontractingvolumemdetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();

					SubcontractingvolumemdetailVO vo = new SubcontractingvolumemdetailVO();
					List<String> datas = result.get(i);
					String billCode = datas.get(0);//编码
					String section = datas.get(1);//区段
					String billName = datas.get(2);//物资名称
					String subitemDesc = datas.get(3);//子目特征描述
					String unit = datas.get(4);//单位
					String unitprice = datas.get(5);//单价(元)
					String budgetquantity = datas.get(6);//预算数量
					String actualConsumption = datas.get(7);//实际消耗数量
					String excessdosage = datas.get(8);//超用量
					String overdraftDeduction = datas.get(9);//超用扣款（元）
					String withholding = datas.get(10);//代扣款
					BigDecimal bd = new BigDecimal(withholding);
					vo.setId(IdWorker.getId());//id
					vo.setTid(String.valueOf(IdWorker.getId()));//tid
					vo.setBillCode(billCode);
					vo.setSection(section);
					vo.setBillName(billName);
					vo.setSubitemDesc(subitemDesc);
					vo.setUnit(unit);
					vo.setWithholding(bd);




					if (StringUtils.isNotBlank(billCode)) {
						vo.setInnercode(billCode+ "_" + section);//清单编号确定唯一性
						if ("01".equals(billCode) && billCode != null && billCode.contains("装饰")) {
							vo.setInnercode("a1"+ "_" + vo.getSection());
						}
						//判断是否是装饰工程的子节点编码
						if (billCode.length() >= 4) {
							//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
							String code = billCode.substring(0, 4);
							if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
								//若是的话，将内码改为a1xx
								vo.setInnercode("a1" + billCode.substring(2, billCode.length()) + "_" + section);
							}
						}
						//1、校验编码是否符合规则--2、4、6、9、9以上
						if (billCode == null || !(billCode.length() == 2 || billCode.length() == 4 || billCode.length() == 6 || billCode.length() >= 9)) {
							vo.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
							errorsMsgBuilder.append("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
						}
						vo.setBillCode(billCode);
						//重复性校验

						//重复性校验
						SubcontractingvolumemdetailVO mapVO = map.get(vo.getInnercode());
						if (mapVO == null) {
							map.put(vo.getInnercode(), vo);
						} else {
							vo.setErrorMsg("清单编号已存在！");
							errorsMsgBuilder.append("清单编号已存在！");
						}
						vo.setBillCode(billCode);
					}

					//格式校验
					if(StringUtils.isNotBlank(unitprice)){
						if(NumberUtil.isNumber(unitprice)){
							vo.setmUnitprice(new BigDecimal(unitprice));
						}else {
							vo.setErrorMsg("单价(元)格式不正确！");
							errorsMsgBuilder.append("单价(元)格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(budgetquantity)){
						if(NumberUtil.isNumber(budgetquantity)){
							vo.setBudgetquantity(new BigDecimal(budgetquantity));
						}else {
							vo.setErrorMsg("预算数量格式不正确！");
							errorsMsgBuilder.append("预算数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(actualConsumption)){
						if(NumberUtil.isNumber(actualConsumption)){
							vo.setActualConsumption(new BigDecimal(actualConsumption));
						}else {
							vo.setErrorMsg("实际消耗数量格式不正确！");
							errorsMsgBuilder.append("实际消耗数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(excessdosage)){
						if(NumberUtil.isNumber(excessdosage)){
							vo.setExcessdosage(new BigDecimal(excessdosage));
						}else {
							vo.setErrorMsg("超用量格式不正确！");
							errorsMsgBuilder.append("超用量格式不正确！");
						}
					}else {//超用量 = 实际消耗数量-预算数量
						BigDecimal actualConsumptionB = vo.getActualConsumption();
						BigDecimal budgetquantityB = vo.getBudgetquantity();
						if(budgetquantityB != null && actualConsumptionB != null){
							BigDecimal excessdosageB = actualConsumptionB.subtract(budgetquantityB);
							vo.setExcessdosage(excessdosageB);
						}
					}

					if(StringUtils.isNotBlank(overdraftDeduction)){
						if(NumberUtil.isNumber(overdraftDeduction)){
							vo.setOverdraftDeduction(new BigDecimal(overdraftDeduction));
						}else {
							vo.setErrorMsg("超用扣款（元）格式不正确！");
							errorsMsgBuilder.append("超用扣款（元）格式不正确！");
						}
					}else {//未填写，自动计算
						BigDecimal excessdosageB = vo.getExcessdosage();
						BigDecimal unitpriceB = vo.getmUnitprice();
						if(excessdosageB != null && unitpriceB != null){
							BigDecimal overdraftDeductionB = excessdosageB.multiply(unitpriceB);
							vo.setOverdraftDeduction(overdraftDeductionB);
						}
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}

			}
		}

		//按子目编码排序
		Collections.sort(successList, new Comparator<SubcontractingvolumemdetailVO>() {
			@Override
			public int compare(SubcontractingvolumemdetailVO o1, SubcontractingvolumemdetailVO o2) {
				return (o1.getBillCode() + o1.getSection()).compareTo(o2.getBillCode() + o2.getSection());
			}
		});

		//设置tid和tpid
		List<SubcontractingvolumemdetailVO> resList = setTidAndTpid1(successList, map);
		//构建树
		resList = createTreeData1(resList);

		//统计父级的合计数值
//        getChildrenUnitTotalAmount(resList);

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}


	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<SubcontractingvolumemdetailVO> setTidAndTpid1(List<SubcontractingvolumemdetailVO> vos, Map<String, SubcontractingvolumemdetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			SubcontractingvolumemdetailVO SubcontractingvolumemdetailVO = vos.get(i);
			//设置父级id
			String innercode = SubcontractingvolumemdetailVO.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid1(pcode, map);
			}

			if (pid != null) {
				SubcontractingvolumemdetailVO.setTpid(pid.toString());
			} else {
				SubcontractingvolumemdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid1(String pcode, Map<String, SubcontractingvolumemdetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid1(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid1(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid1(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}


	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<SubcontractingvolumemdetailVO> createTreeData1(List<SubcontractingvolumemdetailVO> list) {
		List<SubcontractingvolumemdetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumemdetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumemdetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumemdetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumemdetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumemdetailVO> child = (List<SubcontractingvolumemdetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumemdetailVO> children = new ArrayList<SubcontractingvolumemdetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumeodetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumeodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();
					SubcontractingvolumeodetailVO vo = new SubcontractingvolumeodetailVO();

					List<String> datas = result.get(i);
					String expenseName = datas.get(0);//费用名称
					String unit = datas.get(1);//单位
					String quantity = datas.get(2);//数量
					String unitPrice = datas.get(3);//单价
					String amounts = datas.get(4);//金额
					String remarks = datas.get(5);//备注

					vo.setId(IdWorker.getId());
					vo.setExpenseName(expenseName);
					vo.setUnit(unit);
					vo.setRemarks(remarks);

					//格式校验
					if(StringUtils.isNotBlank(quantity)){
						if(NumberUtil.isNumber(quantity)){
							vo.setoQuantity(new BigDecimal(quantity));
						}else {
							vo.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitPrice)){
						if(NumberUtil.isNumber(unitPrice)){
							vo.setoUnitPrice(new BigDecimal(unitPrice));
						}else {
							vo.setErrorMsg("单价格式不正确！");
							errorsMsgBuilder.append("单价格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(amounts)){
						if(NumberUtil.isNumber(amounts)){
							vo.setAmounts(new BigDecimal(amounts));
						}else {
							vo.setErrorMsg("金额格式不正确！");
							errorsMsgBuilder.append("金额格式不正确！");
						}
					}else {
						BigDecimal quantityB = vo.getoQuantity();
						BigDecimal unitPriceB = vo.getoUnitPrice();
						if(quantityB != null && unitPriceB != null){
							BigDecimal amountsB = quantityB.multiply(unitPriceB);
							vo.setAmounts(amountsB);
						}
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody SubcontractingvolumeVO subcontractingvolumeVO, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", subcontractingvolumeVO.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumedetailEntity> list = this.subcontractingvolumedetailService.list(queryWrapper);
		List<SubcontractingvolumedetailVO> voList = BeanMapper.mapList(list, SubcontractingvolumedetailVO.class);
		List<SubcontractingvolumedetailVO> records = new ArrayList<>();

		//构建树
		voList = createTreeData(voList);

		for(SubcontractingvolumedetailVO vo : voList){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		List<SubcontractingvolumedetailVO> records = new ArrayList<>();
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumedetailVO vo = list.get(i);
				String source = vo.getSource();
				if("1".equals(source)){//来源：1合同内 2合同外
					source = "合同内";
				}else if("2".equals(source)){
					source = "合同外";
				}
				vo.setSource(source);
				records.add(vo);
				if(vo.getChildren()!=null&&vo.getChildren().size()>0){
					this.splitList(vo.getChildren(),records);
				}
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

	/**
	 * 导出遍历加上所有子表
	 * @param list
	 * @param records
	 */
	private void splitList(List<SubcontractingvolumedetailVO> list,List<SubcontractingvolumedetailVO> records) {
		for(SubcontractingvolumedetailVO vo : list){
			String source = vo.getSource();
			if("1".equals(source)){//来源：1合同内 2合同外
				source = "合同内";
			}else if("2".equals(source)){
				source = "合同外";
			}
			vo.setSource(source);
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export2", method = RequestMethod.POST)
	@ResponseBody
	public void export2(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumemdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumemdetailEntity> list = subcontractingvolumemdetailService.list(queryWrapper);
		List<SubcontractingvolumemdetailVO> vOList = BeanMapper.mapList(list, SubcontractingvolumemdetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				SubcontractingvolumemdetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("subcontractingvolumemdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage2", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage2(@RequestBody List<SubcontractingvolumemdetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumemdetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractingvolumemdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export3", method = RequestMethod.POST)
	@ResponseBody
	public void export3(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumeodetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumeodetailEntity> list = this.subcontractingvolumeodetailService.list(queryWrapper);
		List<SubcontractingvolumeodetailVO> vOList = BeanMapper.mapList(list, SubcontractingvolumeodetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				SubcontractingvolumeodetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("subcontractingvolumeodetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage3", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage3(@RequestBody List<SubcontractingvolumeodetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumeodetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractingvolumeodetail-export.xlsx", beans, response);
	}

	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<SubcontractingvolumedetailVO> setTidAndTpid(List<SubcontractingvolumedetailVO> vos, Map<String, SubcontractingvolumedetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			SubcontractingvolumedetailVO consdrawbudgetdetailVO = vos.get(i);
			//设置父级id
			String innercode = consdrawbudgetdetailVO.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			}


			if (pid != null) {
				consdrawbudgetdetailVO.setTpid(pid.toString());
			} else {
				consdrawbudgetdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, SubcontractingvolumedetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<SubcontractingvolumedetailVO> createTreeData(List<SubcontractingvolumedetailVO> list) {
		List<SubcontractingvolumedetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumedetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumedetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumedetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumedetailVO> child = (List<SubcontractingvolumedetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumedetailVO> children = new ArrayList<SubcontractingvolumedetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
