package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Controller
@RequestMapping("mechanicalleaseExport")
public class ExcelmechanicalleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMechanicalleaseService service;

    @Autowired
    private IMechanicalleasedetailService detailService;

    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMechanicalleasedetail",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "mechanicalleasedetail-imports.xlsx", "月度机械设备租赁单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelMechanicallease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMechanicallease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MechanicalleasedetailVO> successList = new ArrayList<>();
        List<MechanicalleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
           /* QueryWrapper<MechanicalleasedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<MechanicalleasedetailEntity> list = detailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }
*/
            if (result != null && result.size() > 0) {
                HashMap<String, String> map = new HashMap<>();

                for (int i = 1; i < result.size(); i++) {
                    MechanicalleasedetailVO mechanicalleasedetailVO = new MechanicalleasedetailVO();
                    List<String> datas = result.get(i);
                    mechanicalleasedetailVO.setId(IdWorker.getId());//id
                    mechanicalleasedetailVO.setSort(StringUtils.isNotEmpty(datas.get(0)) ? datas.get(0) : null);// 序号
                    if(StringUtils.isBlank(datas.get(1)) || datas.get(1) == null){
                        mechanicalleasedetailVO.setErrorMsg("'编码'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        mechanicalleasedetailVO.setEquipmentCode(StringUtils.isNotEmpty(datas.get(1)) ? datas.get(1) : null);// 单据编号
                    }

                    if(StringUtils.isBlank(datas.get(2)) || datas.get(2) == null){
                        mechanicalleasedetailVO.setErrorMsg("'租赁物资名称'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        mechanicalleasedetailVO.setName(StringUtils.isNotEmpty(datas.get(2)) ? datas.get(2) : null);// 租赁物资名称
                    }

                    if(StringUtils.isBlank(datas.get(3)) || datas.get(3) == null){
                        mechanicalleasedetailVO.setErrorMsg("'规格型号'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        mechanicalleasedetailVO.setSpec(StringUtils.isNotEmpty(datas.get(3)) ? datas.get(3) : null); // 规格型号
                    }

                    if(StringUtils.isBlank(datas.get(4)) || datas.get(4) == null){
                        mechanicalleasedetailVO.setErrorMsg("'计量单位'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotEmpty(datas.get(4)) ? datas.get(4) : null);// 计量单位
                    }

                    //校验库中物资
                    CommonResponse<EquipmentVO> back0 = shareEquipmentApi.queryEquipmentByCode(datas.get(1));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        mechanicalleasedetailVO.setErrorMsg("未查询到该物资编码下的物资详情");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }
                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(2))) {
                            mechanicalleasedetailVO.setErrorMsg("'租赁物资名称'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(3))) {
                            mechanicalleasedetailVO.setErrorMsg("'规格型号'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(4))) {
                            mechanicalleasedetailVO.setErrorMsg("'计量单位'未在库中,请检查！");
                            errorList.add(mechanicalleasedetailVO);
                            continue;
                        }
                    }else{
                        mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null);
                    }


                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(3) != null && StringUtils.isNotBlank(datas.get(3))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
                    if (map.containsKey(materConcat.toString())) {
                        mechanicalleasedetailVO.setErrorMsg("'编码','物资名称','物资规格','计量单位不能重复'");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    } else {
                        map.put(materConcat.toString(), materConcat.toString());
                    }

                    BigDecimal leaseNum = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(5)) || datas.get(5) == null){
                        mechanicalleasedetailVO.setErrorMsg("'租赁数量'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(5))){
                            mechanicalleasedetailVO.setErrorMsg("'租赁数量'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setLeaseNum(StringUtils.isNotEmpty(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);// 租赁数量
                            leaseNum = leaseNum.add(new BigDecimal(datas.get(5)));
                        }
                    }

                    if(StringUtils.isBlank(datas.get(6)) || datas.get(6) == null){
                        mechanicalleasedetailVO.setErrorMsg("'本期计算起始日期'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else{
                        if(!DateUtils.grepDate(datas.get(6))){
                            mechanicalleasedetailVO.setErrorMsg("'本期计算起始日期'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setBillingStartTime(StringUtils.isNotEmpty(datas.get(6)) ? DateUtils.Date(datas.get(6)) : null);// 本期计算起始日期
                        }
                     }

                    if(StringUtils.isBlank(datas.get(7)) || datas.get(7) == null){
                        mechanicalleasedetailVO.setErrorMsg("'本期计算终止日期'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }else {
                        if(!DateUtils.grepDate(datas.get(7))){
                            mechanicalleasedetailVO.setErrorMsg("'本期计算终止日期'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setBillingEndTime(StringUtils.isNotEmpty(datas.get(7)) ? DateUtils.Date(datas.get(7)) : null);// 本期计算终止日期
                        }
                     }

                    long dayNum = 0;
                    if(StringUtils.isNotBlank(datas.get(8)) && datas.get(8) != null){
                        if (!NumberUtil.isNumber(datas.get(8))) {
                            mechanicalleasedetailVO.setErrorMsg("'本期租赁期长(天)'输入格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else {
                            dayNum = Long.parseLong(datas.get(8));
                            mechanicalleasedetailVO.setLeaseDaysThisTime(StringUtils.isNotBlank(datas.get(8)) ? (int) Float.parseFloat(datas.get(8)) : null);//  本期租赁期长(天)
                        }
                    }else{
                        long between = DateUtil.between(DateUtils.Date(datas.get(6)), DateUtils.Date(datas.get(7)), DateUnit.DAY);
                        dayNum = between;
                        Long day = dayNum;
                        mechanicalleasedetailVO.setLeaseDaysThisTime(Integer.valueOf(Math.toIntExact(day))+1);
                    }


                    BigDecimal inTaxLeaseUnit = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(9)) || datas.get(9) == null){
                        mechanicalleasedetailVO.setErrorMsg("'租赁单价（含税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(9))){
                            mechanicalleasedetailVO.setErrorMsg("'租赁单价（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            inTaxLeaseUnit = inTaxLeaseUnit.add(new BigDecimal(datas.get(9)));
                            mechanicalleasedetailVO.setInTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);// 租赁单价（含税）（元）
                        }
                    }

                    BigDecimal exTaxLeaseUnit = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(10)) || datas.get(10) == null){
                        mechanicalleasedetailVO.setErrorMsg("'租赁单价（除税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(10))){
                            mechanicalleasedetailVO.setErrorMsg("'租赁单价（除税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            exTaxLeaseUnit = exTaxLeaseUnit.add(new BigDecimal(datas.get(10)));
                            mechanicalleasedetailVO.setExTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 租赁单价（除税）（元）
                        }
                    }

                    if(StringUtils.isNotBlank(datas.get(11)) && datas.get(11) != null ){
                        if(!NumberUtil.isNumber(datas.get(11))){
                            mechanicalleasedetailVO.setErrorMsg("'租赁合价（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setInTaxLeaseTotal(new BigDecimal(datas.get(11)));
                        }
                    }else{
                        BigDecimal multiply = new BigDecimal(dayNum).multiply(leaseNum).multiply(inTaxLeaseUnit);
                        mechanicalleasedetailVO.setInTaxLeaseTotal(multiply);// 租赁合价（含税）（元）
                    }

                    if(StringUtils.isNotBlank(datas.get(12)) && datas.get(12) != null ){
                        if(!NumberUtil.isNumber(datas.get(12))){
                            mechanicalleasedetailVO.setErrorMsg("'租赁合价（除税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setExTaxLeaseTotal(new BigDecimal(datas.get(12)));
                        }
                    }else{
                        BigDecimal multiply = new BigDecimal(dayNum).multiply(leaseNum).multiply(exTaxLeaseUnit);
                        mechanicalleasedetailVO.setExTaxLeaseTotal(multiply);// 租赁合价（除税）（元）
                    }


                    BigDecimal loseDestroyNum = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(13)) || datas.get(13) == null){
                        mechanicalleasedetailVO.setErrorMsg("'丢失损坏量'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(13))){
                            mechanicalleasedetailVO.setErrorMsg("'丢失损坏量'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            loseDestroyNum = loseDestroyNum.add(new BigDecimal(datas.get(13)));
                            mechanicalleasedetailVO.setLoseDestroyNum(StringUtils.isNotEmpty(datas.get(13)) ?  Integer.valueOf((int) Float.parseFloat(datas.get(13))) : null);// 丢失损坏量
                        }
                     }

                    BigDecimal inTaxCompensationUnit = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(14)) || datas.get(14) == null){
                        mechanicalleasedetailVO.setErrorMsg("'赔偿单价（含税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(14))){
                            mechanicalleasedetailVO.setErrorMsg("'赔偿单价（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            inTaxCompensationUnit = inTaxCompensationUnit.add(new BigDecimal(datas.get(14)));
                            mechanicalleasedetailVO.setInTaxCompensationUnit(StringUtils.isNotEmpty(datas.get(14)) ? new BigDecimal(datas.get(14)) : null);// 赔偿单价（含税）（元）
                        }
                    }

                    BigDecimal exTaxCompensationUnit = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(15)) || datas.get(15) == null){
                        mechanicalleasedetailVO.setErrorMsg("'赔偿单价（除税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(15))){
                            mechanicalleasedetailVO.setErrorMsg("'赔偿单价（除税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            exTaxCompensationUnit = exTaxCompensationUnit.add(new BigDecimal(datas.get(15)));
                            mechanicalleasedetailVO.setExTaxCompensationUnit(StringUtils.isNotEmpty(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 赔偿单价（除税）（元）
                        }
                    }

                    if(StringUtils.isNotBlank(datas.get(16)) && datas.get(16) != null ){
                        if(!NumberUtil.isNumber(datas.get(16))){
                            mechanicalleasedetailVO.setErrorMsg("'赔偿合价（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setInTaxCompensationTotal(new BigDecimal(datas.get(16)));
                        }
                    }else{
                        mechanicalleasedetailVO.setInTaxCompensationTotal(loseDestroyNum.multiply(inTaxCompensationUnit)); // 赔偿合价（含税）（元）
                    }


                    if(StringUtils.isNotBlank(datas.get(17)) && datas.get(17) != null ){
                       if(!NumberUtil.isNumber(datas.get(17))){
                           mechanicalleasedetailVO.setErrorMsg("'赔偿合价（除税）（元）'格式错误");
                           errorList.add(mechanicalleasedetailVO);
                       }else{
                           mechanicalleasedetailVO.setExTaxCompensationTotal(new BigDecimal(datas.get(17)));
                       }
                    }else{
                        mechanicalleasedetailVO.setExTaxCompensationTotal(loseDestroyNum.multiply(exTaxCompensationUnit));// 赔偿合价（除税）（元）
                    }
                    BigDecimal exTaxCompensation = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(18)) || datas.get(18) == null){
                        mechanicalleasedetailVO.setErrorMsg("'清理维修费等其他费用（含税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(18))){
                            mechanicalleasedetailVO.setErrorMsg("'清理维修费等其他费用（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            exTaxCompensation= exTaxCompensation.add(new BigDecimal(datas.get(18)));
                            mechanicalleasedetailVO.setInTaxMaintain(StringUtils.isNotEmpty(datas.get(18)) ? new BigDecimal(datas.get(18)) : null); // 清理维修费等其他费用（含税）（元）
                        }
                    }

                    BigDecimal inTaxCompensation = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(19)) || datas.get(19) == null){
                        mechanicalleasedetailVO.setErrorMsg("'清理维修费等其他费用（除税）（元）'不能为空");
                        errorList.add(mechanicalleasedetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(19))){
                            mechanicalleasedetailVO.setErrorMsg("'清理维修费等其他费用（除税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            inTaxCompensation= inTaxCompensation.add(new BigDecimal(datas.get(18)));
                            mechanicalleasedetailVO.setExTaxMaintain(StringUtils.isNotEmpty(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 清理维修费等其他费用（除税）（元）
                        }
                    }

                    if(StringUtils.isNotBlank(datas.get(20)) && datas.get(20) != null ){
                        if(!NumberUtil.isNumber(datas.get(20))){
                            mechanicalleasedetailVO.setErrorMsg("'月度结算费用（含税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setInTaxSettlementMonth(new BigDecimal(datas.get(20)));
                        }
                    }else{
                        BigDecimal multiply = new BigDecimal(dayNum).multiply(leaseNum).multiply(inTaxLeaseUnit);
                        BigDecimal add = multiply.add(loseDestroyNum.multiply(inTaxCompensationUnit)).add(exTaxCompensation);
                        mechanicalleasedetailVO.setInTaxSettlementMonth(add); // 月度结算费用（含税）（元）
                    }

                    if(StringUtils.isNotBlank(datas.get(21)) && datas.get(21) != null ){
                        if(!NumberUtil.isNumber(datas.get(21))){
                            mechanicalleasedetailVO.setErrorMsg("'月度结算费用（除税）（元）'格式错误");
                            errorList.add(mechanicalleasedetailVO);
                        }else{
                            mechanicalleasedetailVO.setExTaxSettlementMonth(new BigDecimal(datas.get(21)));
                        }
                    }else{
                        BigDecimal multiply = new BigDecimal(dayNum).multiply(leaseNum).multiply(exTaxLeaseUnit);
                        BigDecimal add = multiply.add(loseDestroyNum.multiply(exTaxCompensationUnit)).add(inTaxCompensation);
                        mechanicalleasedetailVO.setExTaxSettlementMonth(add);// 月度结算费用（除税）（元）
                    }

                    mechanicalleasedetailVO.setRemarks(StringUtils.isNotEmpty(datas.get(22)) ? datas.get(22) : null);// 备注

                    if( errorList.size()==0){
                        successList.add(mechanicalleasedetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleaseFromDatabase(@RequestBody MechanicalleasedetailVO detailVo, HttpServletResponse response) {
        QueryWrapper<MechanicalleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<MechanicalleasedetailEntity> list = detailService.list(queryWrapper);
        List<MechanicalleasedetailVO> mechanicalleasedetailVOList = BeanMapper.mapList(list, MechanicalleasedetailVO.class);
        if (mechanicalleasedetailVOList != null && mechanicalleasedetailVOList.size() > 0) {
            for (int i = 0; i < mechanicalleasedetailVOList.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = mechanicalleasedetailVOList.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingStartTime()!= null) {
                    mechanicalleasedetailVO.setBillingStartTime(mechanicalleasedetailVO.getBillingStartTime());
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", mechanicalleasedetailVOList);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleasedetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleasedetailFromPage(@RequestBody List<MechanicalleasedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = list.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingEndTime() != null) {
                    mechanicalleasedetailVO.setBillingEndTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingEndTime()));
                }
                if(mechanicalleasedetailVO.getBillingStartTime()!=null){
                    mechanicalleasedetailVO.setBillingStartTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingStartTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", list);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

}
