package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.change.bean.ChangeVisaclaimaccountEntity;
import com.ejianc.business.change.bean.ChangeVisaclaimaccountdetailEntity;
import com.ejianc.business.change.service.IChangeVisaclaimaccountService;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountdetailEntity;
import com.ejianc.business.middlemeasurement.service.IVisaclaimaccountService;
import com.ejianc.business.record.bean.RecordVisaclaimaccountEntity;
import com.ejianc.business.record.bean.RecordVisaclaimaccountdetailEntity;
import com.ejianc.business.record.service.IRecordVisaclaimaccountService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeVisaclaimaccount") 
public class ChangeVisaclaimaccountBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Visaclaimaccount = "zjkj-visaclaimaccount";//总包签证索赔台账
	private static final String VisaclaimaccountT_CHANGE = "zjkj-visaclaimaccountChange";//总包签证索赔台账变更
	private static final String Visaclaimaccount_RECORD = "zjkj-visaclaimaccountRecord";//总包签证索赔台账变更记录

	//单据类型
	private static final String Visaclaimaccount_BILLTYPE_CODE = "BT202203000041";//总包签证索赔台账
	private static final String Visaclaimaccount_CHANGE_BILLTYPE_CODE = "BT202210000010";//总包签证索赔台账变更
	private static final String Visaclaimaccount_RECORD_BILLTYPE_CODE = "BT202210000012";//总包签证索赔台账变更记录

	@Autowired
	private IAttachmentApi attachmentApi;

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IChangeVisaclaimaccountService changeVisaclaimaccountService;

	@Autowired
	private IVisaclaimaccountService visaclaimaccountService;

	@Autowired
	private IRecordVisaclaimaccountService recordVisaclaimaccountService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeVisaclaimaccountEntity changeEntity = changeVisaclaimaccountService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getOriginalId());
		VisaclaimaccountEntity visaclaimaccountEntity = visaclaimaccountService.selectById(changeEntity.getOriginalId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordVisaclaimaccountEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("original_id", visaclaimaccountEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordVisaclaimaccountService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordVisaclaimaccountEntity recordvisaclaimaccountEntity = BeanMapper.map(visaclaimaccountEntity, RecordVisaclaimaccountEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordvisaclaimaccountEntity);
		recordvisaclaimaccountEntity.setBillState(null);
		recordvisaclaimaccountEntity.setOriginalId(visaclaimaccountEntity.getId());
		recordvisaclaimaccountEntity.setVisaclaimaccountCode(visaclaimaccountEntity.getBillCode()+"-"+(count+1));
		recordvisaclaimaccountEntity.setId(recordId);
		recordvisaclaimaccountEntity.setBillCode(visaclaimaccountEntity.getBillCode());
		recordvisaclaimaccountEntity.setChangeReason(changeEntity.getChangeReason());
		recordvisaclaimaccountEntity.setEffectDate(new Date());


		logger.info("---------给变更记录子表赋值--------");
		List<VisaclaimaccountdetailEntity> visaclaimaccountdetailEntities = visaclaimaccountEntity.getVisaclaimaccountdetailEntities();
		if(visaclaimaccountdetailEntities!=null&&visaclaimaccountdetailEntities.size()>0){
			List<RecordVisaclaimaccountdetailEntity> recordVisaclaimaccountdetailEntities = new ArrayList<>();
			for(VisaclaimaccountdetailEntity entity : visaclaimaccountdetailEntities){
				RecordVisaclaimaccountdetailEntity reEntity = BeanMapper.map(entity, RecordVisaclaimaccountdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setId(IdWorker.getId());
				reEntity.setOriginalId(entity.getId());
				recordVisaclaimaccountdetailEntities.add(reEntity);
			}
			recordvisaclaimaccountEntity.setRecordOutcontractList(recordVisaclaimaccountdetailEntities);
		}

		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Visaclaimaccount_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Visaclaimaccount_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(visaclaimaccountEntity.getId().toString(), sourceBillType, Visaclaimaccount , recordId.toString(), targetBillType, Visaclaimaccount_RECORD);
		recordVisaclaimaccountService.saveOrUpdate(recordvisaclaimaccountEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + visaclaimaccountEntity.getCreateUserCode());
		//3、修改当前单据状态
		VisaclaimaccountEntity newVisaclaimaccountEntity = BeanMapper.map(changeEntity, VisaclaimaccountEntity.class);
		newVisaclaimaccountEntity.setChangeState("3");//状态改为已变更
		newVisaclaimaccountEntity.setChangeId(null);
		newVisaclaimaccountEntity.setBillState(visaclaimaccountEntity.getBillState());
		newVisaclaimaccountEntity.setId(visaclaimaccountEntity.getId());
		newVisaclaimaccountEntity.setCreateTime(visaclaimaccountEntity.getCreateTime());
		newVisaclaimaccountEntity.setCreateUserCode(visaclaimaccountEntity.getCreateUserCode());
		newVisaclaimaccountEntity.setTenantId(visaclaimaccountEntity.getTenantId());
		newVisaclaimaccountEntity.setVersion(visaclaimaccountEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangeVisaclaimaccountdetailEntity> changeVisaclaimaccountdetailList = changeEntity.getVisaclaimaccountdetailEntities();
		if(changeVisaclaimaccountdetailList != null && changeVisaclaimaccountdetailList.size()>0){
			List<VisaclaimaccountdetailEntity> newVisaclaimaccountdetailList = BeanMapper.mapList(changeVisaclaimaccountdetailList, VisaclaimaccountdetailEntity.class);

			//原始单据子表
			if(visaclaimaccountdetailEntities != null && visaclaimaccountdetailEntities.size() > 0){
				VisaclaimaccountdetailEntity originalVisaclaimaccountdetailInfo = visaclaimaccountdetailEntities.get(0);

				for (int i = 0; i < changeVisaclaimaccountdetailList.size(); i++) {
					ChangeVisaclaimaccountdetailEntity changeVisaclaimaccountdetail = changeVisaclaimaccountdetailList.get(i);
					VisaclaimaccountdetailEntity newVisaclaimaccountdetail = newVisaclaimaccountdetailList.get(i);

					boolean isChangeUpdate = false;//true 变更更新数据 false 变更新增数据
					for (int j = 0; j < visaclaimaccountdetailEntities.size(); j++) {
						VisaclaimaccountdetailEntity originalVisaclaimaccountdetail = visaclaimaccountdetailEntities.get(j);
						if(originalVisaclaimaccountdetail.getId().equals(changeVisaclaimaccountdetail.getOriginalId())){

							newVisaclaimaccountdetail.setId(originalVisaclaimaccountdetail.getId());
							newVisaclaimaccountdetail.setCreateTime(originalVisaclaimaccountdetailInfo.getCreateTime());
							newVisaclaimaccountdetail.setCreateUserCode(originalVisaclaimaccountdetailInfo.getCreateUserCode());

							newVisaclaimaccountdetail.setUpdateTime(changeVisaclaimaccountdetail.getUpdateTime());
							newVisaclaimaccountdetail.setUpdateUserCode(changeVisaclaimaccountdetail.getCreateUserCode());

							isChangeUpdate = true;
							break;
						}
					}

					if(!isChangeUpdate){//变更新增
						newVisaclaimaccountdetail.setCreateTime(changeVisaclaimaccountdetail.getUpdateTime());
						newVisaclaimaccountdetail.setCreateUserCode(changeVisaclaimaccountdetail.getCreateUserCode());
					}

					newVisaclaimaccountdetail.setBillState(originalVisaclaimaccountdetailInfo.getBillState());
					newVisaclaimaccountdetail.setTenantId(originalVisaclaimaccountdetailInfo.getTenantId());
					newVisaclaimaccountdetail.setVersion(originalVisaclaimaccountdetailInfo.getVersion());
				}
			}
			//原始单与变更单对比后（新增）
			newVisaclaimaccountEntity.setVisaclaimaccountdetailEntities(newVisaclaimaccountdetailList);

			//原始单与变更单对比后（删除）
			List<VisaclaimaccountdetailEntity> deleteDatas = new ArrayList<>();
			for (int i = 0; i < visaclaimaccountdetailEntities.size(); i++) {
				VisaclaimaccountdetailEntity visaclaimaccountdetail = visaclaimaccountdetailEntities.get(i);
				boolean isSame = false;
				for (int j = 0; j < newVisaclaimaccountdetailList.size(); j++) {
					VisaclaimaccountdetailEntity newDetail = newVisaclaimaccountdetailList.get(j);
					if(visaclaimaccountdetail.getId().equals(newDetail.getId())) {
						isSame = true;
					}
				}
				if(!isSame){//变更已删除行
					visaclaimaccountdetail.setRowState("del");
					deleteDatas.add(visaclaimaccountdetail);
				}
			}

			if(deleteDatas.size() > 0){
				newVisaclaimaccountdetailList.addAll(deleteDatas);
				newVisaclaimaccountEntity.setVisaclaimaccountdetailEntities(newVisaclaimaccountdetailList);
			}
		}
		logger.info("---------保存--------");
		visaclaimaccountService.saveOrUpdate(newVisaclaimaccountEntity, false);

		sourceBillType = Visaclaimaccount_CHANGE_BILLTYPE_CODE;
		targetBillType = Visaclaimaccount_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, VisaclaimaccountT_CHANGE, visaclaimaccountEntity.getId().toString(), targetBillType, Visaclaimaccount);
		recordVisaclaimaccountService.saveOrUpdate(recordvisaclaimaccountEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
