package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;

import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;

import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;

import com.ejianc.foundation.middlemeasurement.vo.SubVO;

import com.ejianc.foundation.middlemeasurement.vo.SubVOList;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("api/Subcontracting")
public class SubcontractingApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubcontractingvolumedetailService subcontractingvolumedetailService;
    @Autowired
    private ISubcontractingvolumeService subcontractingvolumeService;


    /**
     * @param
     * @Description 根据合同id查询详情
     * @Return void
     */
    @RequestMapping(value = "/getAmount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String, SubVO>> getAmount(@RequestBody List<SubVOList> sublist) {
        Map<String, SubVO> map = new HashMap<>();
        QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", sublist.get(0).getContractId());
        queryWrapper.lt("reporting_time", new Date());
        queryWrapper.orderByDesc("reporting_time");
        List<SubcontractingvolumeEntity> list = subcontractingvolumeService.list(queryWrapper);
        if (!list.isEmpty() && list.size() > 0) {
            for (SubVOList subVOList : sublist) {
                //字母编码 的list
                QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("subitem_code", subVOList.getSubitemCode());
                queryWrapper1.eq("section", subVOList.getSection());
                queryWrapper1.eq("mid", list.get(0).getId());
                SubcontractingvolumedetailEntity subcontractingvolumedetailEntity = subcontractingvolumedetailService.getOne(queryWrapper1);
                if (subcontractingvolumedetailEntity != null) {
                    SubVO vo = new SubVO();
                    vo.setExamineCumulativeAmounts(subcontractingvolumedetailEntity.getExamineCumulativeAmounts());
                    vo.setExamineCumulativeTaxAmounts(subcontractingvolumedetailEntity.getExamineCumulativeTaxAmounts());
                    vo.setExamineCumulativeQuantity(subcontractingvolumedetailEntity.getExamineCumulativeQuantity());
                    //去查询
                    //获取两个字段
                    map.put(subVOList.getSubitemCode() + subVOList.getSection(), vo);
                }
            }
        }
        return CommonResponse.success("查询数据成功", map);
    }
}
