package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度周转租赁单清单导入导出
 */
@Controller
@RequestMapping("revolvingleaseExport")
public class ExcelRevolvingleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "revolvingleasedetail-import.xlsx", "月度周转租赁单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RevolvingleasedetailVO> successList = new ArrayList<>();
        List<RevolvingleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            HashMap<String, String> map = new HashMap<>();

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int num1=0;
                    RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                    CommonResponse<MaterialVO> back = null;
                    List<String> datas = result.get(i);
                    revolvingleasedetailVO.setId(IdWorker.getId());//id


                    String encode = datas.get(1);
                    String section = datas.get(2);
                    String branch = datas.get(3);
                    String subitemDesc = datas.get(4);

                    if (encode == null || TextUtils.isEmpty(encode)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'编码'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }else{
                        revolvingleasedetailVO.setEncode(StringUtils.isNotBlank(encode)?encode:null);
                    }
                    if (section == null || TextUtils.isEmpty(section)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'区段'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setSection(StringUtils.isNotBlank(section)?section:null);
                    }
                    if (branch == null || TextUtils.isEmpty(branch)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'子目名称'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setBranch(StringUtils.isNotBlank(branch)?branch:null);
                    }
                    if (subitemDesc == null || TextUtils.isEmpty(subitemDesc)) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'子目特征描述'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    }{
                        revolvingleasedetailVO.setSubitemDesc(StringUtils.isNotBlank(subitemDesc)?subitemDesc:null);
                    }


                    if (datas.get(5) == null && StringUtils.isBlank(datas.get(5))) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'物资编码'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                        continue;
                    }else{
                        revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank(datas.get(5))?datas.get(5):null);
                    }

                    if (StringUtils.isBlank(datas.get(6)) && datas.get(6) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'物资名称'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                        continue;
                    }else{
                        revolvingleasedetailVO.setLesseeMaterialsName(StringUtils.isNotBlank(datas.get(6))?datas.get(6):null);
                    }

                    if (StringUtils.isBlank(datas.get(7)) && datas.get(7) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'规格型号'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                        continue;
                    }else{
                        revolvingleasedetailVO.setSpecifications(StringUtils.isNotBlank(datas.get(7))?datas.get(7):null);
                    }


                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(5));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="未查询到该物资编码下的物资详情";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                        continue;
                    }
                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(6))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁物资名称'未在库中,请检查！";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(7))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'规格型号'未在库中,请检查！";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(8))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'计量单位'未在库中,请检查！";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            revolvingleasedetailVO.setMeasurementUnit(StringUtils.isNotBlank(datas.get(8))?datas.get(8):null);

                        }
                    }


                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(7) != null && StringUtils.isNotBlank(datas.get(7))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(8) != null && StringUtils.isNotBlank(datas.get(8))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
                    if (map.containsKey(materConcat.toString())) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'物资编码','物资名称','物资规格','计量单位不能重复'";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;



                    } else {
                        map.put(materConcat.toString(), materConcat.toString());
                    }

                    revolvingleasedetailVO.setMaterialCategoryId(back0.getData().getCategoryId());
                    revolvingleasedetailVO.setMaterialCategoryCode(back0.getData().getCode());
                    revolvingleasedetailVO.setMaterialCategoryName(back0.getData().getCategoryName());

                    BigDecimal num = new BigDecimal(0);

                    if (StringUtils.isBlank(datas.get(9)) || datas.get(9) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'租赁数量'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);


                        if (!NumberUtil.isNumber(datas.get(9))) {
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁数量'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);

                        }
                        num1++;
                    } else {
                        num = num.add(new BigDecimal((int) Float.parseFloat(datas.get(9))));
                        revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank(datas.get(9)) ? Integer.valueOf((int) Float.parseFloat(datas.get(9))) : null); //  租赁数量
                    }

                    if (StringUtils.isNotBlank(datas.get(10)) && datas.get(10) != null) {
                        //revolvingleasedetailVO.setSettleTime(DateUtils.Date(datas.get(10))); // 本期计算起始时间
                        if (!DateUtils.grepDate(datas.get(10))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期计算起始时间'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else {
                            revolvingleasedetailVO.setSettleTime(DateUtils.Date(datas.get(10))); // 本期计算起始时间

                        }
                    } else {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'本期计算起始时间'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    }

                    if (StringUtils.isNotBlank(datas.get(11)) && datas.get(11) != null) {
                        revolvingleasedetailVO.setEndTime(DateUtils.Date(datas.get(11))); //本期计算终止时间
                        if (!DateUtils.grepDate(datas.get(11))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期计算终止时间'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }
                    } else {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'本期计算终止时间'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    }

                    BigDecimal dayValue = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(12)) && datas.get(12) != null) {
                        Integer value = Integer.valueOf((int) Float.parseFloat(datas.get(12)));
                        if (!NumberUtil.isNumber(datas.get(12))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'本期租赁期长(天)'输入格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        } else {
                            revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank(datas.get(12)) ? value : null);//  本期租赁期长(天)
                            dayValue = dayValue.add(new BigDecimal(value));
                            revolvingleasedetailVO.setTaxLesseeUnitprice(dayValue);
                        }
                        revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int) value));
                    } else {
                        if(StringUtils.isNotBlank(datas.get(11)) && datas.get(11) != null&&StringUtils.isNotBlank(datas.get(10)) && datas.get(10) != null){
                        long between = DateUtil.between(DateUtils.Date(datas.get(10)), DateUtils.Date(datas.get(11)), DateUnit.DAY);
                        dayValue = new BigDecimal((int) between);
                        revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int) between)+1);}
                    }

                    BigDecimal exUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(13)) && datas.get(13) != null) {
                        if (!NumberUtil.isNumber(datas.get(13))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁单价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            exUnitPrice = exUnitPrice.add(new BigDecimal(datas.get(13)));
                            revolvingleasedetailVO.setLesseeUnitprice(exUnitPrice);// 租赁单价(除税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setLesseeUnitprice(null);
                    }

                    BigDecimal inUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(14)) && datas.get(14) != null) {
                        if (!NumberUtil.isNumber(datas.get(14))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁单价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            inUnitPrice = inUnitPrice.add(new BigDecimal(datas.get(14)));
                            revolvingleasedetailVO.setTaxLesseeUnitprice(inUnitPrice);// 租赁单价(含税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                    }

                    BigDecimal exTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(15)) && datas.get(15) != null) {
                        if (!NumberUtil.isNumber(datas.get(15))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁合价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            exTotal = exTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setLesseeTotalprice(num.multiply(dayValue).multiply(exUnitPrice));// 租赁合价(除税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setLesseeTotalprice(null);
                    }

                    BigDecimal inTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(16)) && datas.get(16) != null) {
                        if (!NumberUtil.isNumber(datas.get(16))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'租赁合价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            inTotal = inTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setTaxLesseeTotalprice(num.multiply(dayValue).multiply(inUnitPrice));// 租赁合价(含税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setTaxLesseeTotalprice(null);
                    }

                    BigDecimal findNum = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'丢失损坏量'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    } else {
                        if (!NumberUtil.isNumber(datas.get(17))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'丢失损坏量'输入格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            findNum = findNum.add(new BigDecimal(datas.get(17)));
                            revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 丢失损坏量
                        }
                    }

                    BigDecimal pexUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(18)) || datas.get(18) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'赔偿单价(除税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(18))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿单价(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            pexUnitPrice = pexUnitPrice.add(new BigDecimal(datas.get(18)));
                            revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null);// 赔偿单价(除税)(元)
                        }
                     }

                    BigDecimal pinUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(19)) || datas.get(19) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'赔偿单价(含税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(19))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿单价(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            pinUnitPrice = pinUnitPrice.add(new BigDecimal(datas.get(19)));
                            revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 赔偿单价(含税)(元)
                        }
                    }

                    BigDecimal exAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(20)) || datas.get(20) == null) {
                        exAmount = exAmount.add(findNum.multiply(pexUnitPrice));
                        revolvingleasedetailVO.setCompensateAccount(exAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(20))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿金额((除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setCompensateAccount(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : null);// 赔偿金额((除税)(元)
                        }
                    }

                    BigDecimal inAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(21)) || datas.get(21) == null) {
                        inAmount = inAmount.add(findNum.multiply(pinUnitPrice));
                        revolvingleasedetailVO.setTaxCompensateAccount(inAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(21))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'赔偿金额((含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null);// 赔偿金额((含税)(元)
                        }
                    }

                    BigDecimal cleanEx = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(22)) || datas.get(22) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'清理维修费非等其他费用(除税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;

                    } else {
                        if (!NumberUtil.isNumber(datas.get(22))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'清理维修费非等其他费用(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            cleanEx = cleanEx.add(new BigDecimal(datas.get(22)));
                            revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : null);// 清理维修费非等其他费用(除税)(元)
                        }
                    }

                    BigDecimal cleanIn = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(23)) || datas.get(23) == null) {
                        String errorMessage = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'清理维修费非等其他费用(含税)(元)'不能为空";
                        revolvingleasedetailVO.setErrorMsg(errorMessage);
                        num1++;
                    } else {
                        if (!NumberUtil.isNumber(datas.get(23))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'清理维修费非等其他费用(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;
                        }else{
                            cleanIn = cleanIn.add(new BigDecimal(datas.get(23)));
                            revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank(datas.get(23)) ? new BigDecimal(datas.get(23)) : null);// 清理维修费非等其他费用(含税)(元)
                        }
                     }

                    if (datas.get(24) != null || StringUtils.isBlank(datas.get(24))) {
                        revolvingleasedetailVO.setMonthlyExpenses(exTotal.add(exAmount).add(cleanEx));
                    } else {
                        if (!NumberUtil.isNumber(datas.get(24))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'月度结算费用(除税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank(datas.get(24)) ? new BigDecimal(datas.get(24)) : null);// 月度结算费用(除税)(元)
                        }
                    }

                    if (datas.get(25) != null || StringUtils.isBlank(datas.get(25))) {
                        revolvingleasedetailVO.setTaxMonthlyExpenses(inTotal.add(inAmount).add(cleanIn));
                    } else {
                        if (!NumberUtil.isNumber(datas.get(25))) {
                            String errorMessage = revolvingleasedetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'月度结算费用(含税)(元)'格式错误";
                            revolvingleasedetailVO.setErrorMsg(errorMessage);
                            num1++;

                        }else{
                            revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank(datas.get(25)) ? new BigDecimal(datas.get(25)) : null);// 月度结算费用(含税)(元)
                        }
                    }

                    revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(26)) ? String.valueOf(datas.get(26)) : null); // 备注

                    if (num1 > 0){
                        errorList.add(revolvingleasedetailVO);
                    }else{
                        successList.add(revolvingleasedetailVO);
                    }
                }

            }
        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper<RevolvingleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", revolvingleaseVO.getId());
        queryWrapper.eq("dr", 0);
        List<RevolvingleasedetailEntity> list = revolvingleasedetailService.list(queryWrapper);
        List<RevolvingleasedetailVO> revolvingleasedetailVOList = BeanMapper.mapList(list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

}
