package com.ejianc.business.middlemeasurement.service.impl;

import com.ejianc.foundation.middlemeasurement.vo.LaborCostVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.mapper.SubcontractingvolumedetailMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 分包月度报量及申请报告月度子表
 * 
 * @author generator
 * 
 */
@Service("subcontractingvolumedetailService")
public class SubcontractingvolumedetailServiceImpl
		extends BaseServiceImpl<SubcontractingvolumedetailMapper, SubcontractingvolumedetailEntity>
		implements ISubcontractingvolumedetailService {

	@Autowired
	private SubcontractingvolumedetailMapper subcontractingvolumedetailMapper;

	@Override
	public LaborCostVO getPricing(String contractType, Long projectId, String subitemCode, String section, String reportingTime) {
		LaborCostVO vo = subcontractingvolumedetailMapper.getPricing(contractType,projectId,subitemCode,section,reportingTime);
		return vo;
	}

	@Override
	public LaborCostVO getOverdeduction(String contractType, Long projectId, String reportingTime) {
		LaborCostVO vo = subcontractingvolumedetailMapper.getOverdeduction(contractType,projectId,reportingTime);
		return vo;
	}

	@Override
	public LaborCostVO getOtherCost(String contractType, Long projectId, String reportingTime) {
		LaborCostVO vo = subcontractingvolumedetailMapper.getOtherCost(contractType,projectId,reportingTime);
		return vo;
	}
}
