/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountdetailEntity;
import com.ejianc.business.middlemeasurement.service.IVisaclaimaccountService;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountVO;
import com.ejianc.business.record.service.IRecordVisaclaimaccountService;
import com.ejianc.business.record.vo.RecordVisaclaimaccountVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"visaclaimaccount"})
public class VisaclaimaccountController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-visaclaimaccount";
    @Autowired
    private IVisaclaimaccountService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRecordVisaclaimaccountService recordVisaclaimaccountService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<VisaclaimaccountVO> saveOrUpdate(@RequestBody VisaclaimaccountVO saveorUpdateVO) {
        List pro;
        VisaclaimaccountEntity entity = (VisaclaimaccountEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), VisaclaimaccountEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract", (Object)entity.getContract());
        queryWrapper.eq((Object)"bill_state", (Object)0);
        if (entity.getId() != null && entity.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if (!(pro = this.service.list((Wrapper)queryWrapper)).isEmpty()) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u7b7e\u8bc1\u7d22\u8d54\u53f0\u8d26\"!");
        }
        entity.setChangeState("1");
        List<VisaclaimaccountdetailEntity> list = entity.getVisaclaimaccountdetailEntities();
        int sumDay = 0;
        for (VisaclaimaccountdetailEntity detailEntity : list) {
            if ("del".equals(detailEntity.getRowState())) continue;
            sumDay += detailEntity.getDeferredDays().intValue();
        }
        entity.setDeferredTotalDays(new BigDecimal(sumDay));
        entity = this.checkBillCodeUniq(entity);
        this.service.saveOrUpdate((Object)entity, false);
        VisaclaimaccountVO vo = (VisaclaimaccountVO)((Object)BeanMapper.map((Object)((Object)entity), VisaclaimaccountVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VisaclaimaccountEntity checkBillCodeUniq(VisaclaimaccountEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)).size() <= 0) return entity;
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38,\u91cd\u590d\u5355\u636e\u7f16\u7801\u751f\u6210\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        }
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<VisaclaimaccountVO> queryDetail(Long id) {
        VisaclaimaccountEntity entity = (VisaclaimaccountEntity)((Object)this.service.selectById(id));
        VisaclaimaccountVO vo = (VisaclaimaccountVO)((Object)BeanMapper.map((Object)((Object)entity), VisaclaimaccountVO.class));
        if (!"1".equals(vo.getChangeState())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"original_id", (Object)vo.getId());
            List records = this.recordVisaclaimaccountService.list((Wrapper)queryWrapper);
            if (records != null && records.size() > 0) {
                vo.setRecordOutcontractList(BeanMapper.mapList((Iterable)records, RecordVisaclaimaccountVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<VisaclaimaccountVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<VisaclaimaccountVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("agent_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("bill_code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), VisaclaimaccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("agent_name");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List visaclaimaccountVOList = BeanMapper.mapList((Iterable)list, VisaclaimaccountVO.class);
        for (int i = 0; i < visaclaimaccountVOList.size(); ++i) {
            String billStateStr;
            VisaclaimaccountVO visaclaimaccountVO = (VisaclaimaccountVO)((Object)visaclaimaccountVOList.get(i));
            visaclaimaccountVO.setSort(String.valueOf(i + 1));
            if (visaclaimaccountVO.getHappenTime() != null) {
                visaclaimaccountVO.setHappenTime((Date)DateUtil.date((Date)visaclaimaccountVO.getHappenTime()));
            }
            if ((billStateStr = visaclaimaccountVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            visaclaimaccountVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", visaclaimaccountVOList);
        ExcelExport.getInstance().export("visaclaimaccount-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refVisaclaimaccountData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<VisaclaimaccountVO>> refVisaclaimaccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), VisaclaimaccountVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<VisaclaimaccountEntity> queryProject(Long id, Long contractId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)).size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u7b7e\u8bc1\u7d22\u8d54\u53f0\u8d26");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f");
    }
}

