/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesummarydetatilService;
import com.ejianc.business.middlemeasurement.vo.PurchasesummaryVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesummarydetatilVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchasesummaryExport"})
public class ExcelPurchasesummaryController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesummarydetatilService purchasesummarydetatilService;

    @RequestMapping(value={"/downloadPurchasesummary"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchasesummarydetail-import.xlsx", (String)"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6c47\u603b\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPurchasesummary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response, String purchaseSummaryDetailVo) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchasesummarydetatilVO> successList = new ArrayList<PurchasesummarydetatilVO>();
        ArrayList<PurchasesummarydetatilVO> errorList = new ArrayList<PurchasesummarydetatilVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        HashMap<String, String> frontMap = new HashMap<String, String>();
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                Object vo2;
                List datas = (List)result.get(i);
                PurchasesummarydetatilVO purchasesummarydetatilVO = new PurchasesummarydetatilVO();
                List purchasesummarydetatilVOList = JSON.parseArray((String)purchaseSummaryDetailVo, PurchasesummarydetatilVO.class);
                for (Object vo2 : purchasesummarydetatilVOList) {
                    StringBuffer materBuffer = new StringBuffer();
                    if (((PurchasesummarydetatilVO)((Object)vo2)).getContractName() != null && StringUtils.isNotBlank((CharSequence)((PurchasesummarydetatilVO)((Object)vo2)).getContractName())) {
                        materBuffer.append(((PurchasesummarydetatilVO)((Object)vo2)).getContractName());
                    }
                    if (((PurchasesummarydetatilVO)((Object)vo2)).getCategoryCode() != null && StringUtils.isNotBlank((CharSequence)((PurchasesummarydetatilVO)((Object)vo2)).getCategoryCode())) {
                        materBuffer.append(((PurchasesummarydetatilVO)((Object)vo2)).getCategoryCode());
                    }
                    if (((PurchasesummarydetatilVO)((Object)vo2)).getMaterialCategory() != null && StringUtils.isNotBlank((CharSequence)((PurchasesummarydetatilVO)((Object)vo2)).getMaterialCategory())) {
                        materBuffer.append(((PurchasesummarydetatilVO)((Object)vo2)).getMaterialCategory());
                    }
                    if (((PurchasesummarydetatilVO)((Object)vo2)).getSupplierName() != null && StringUtils.isNotBlank((CharSequence)((PurchasesummarydetatilVO)((Object)vo2)).getSupplierName())) {
                        materBuffer.append(((PurchasesummarydetatilVO)((Object)vo2)).getSupplierName());
                    }
                    if (((PurchasesummarydetatilVO)((Object)vo2)).getPaymentProportion() != null) {
                        materBuffer.append(((PurchasesummarydetatilVO)((Object)vo2)).getPaymentProportion());
                    }
                    frontMap.put(materBuffer.toString(), materBuffer.toString());
                }
                purchasesummarydetatilVO.setId(IdWorker.getId());
                purchasesummarydetatilVO.setContractName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                purchasesummarydetatilVO.setCategoryCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                purchasesummarydetatilVO.setMaterialCategory(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                purchasesummarydetatilVO.setSupplierName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                purchasesummarydetatilVO.setPaymentProportion(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                String keyValue = (String)frontMap.get((String)datas.get(0) + (String)datas.get(1) + (String)datas.get(2) + (String)datas.get(3) + (String)datas.get(8));
                if (keyValue == null || !StringUtils.isNotBlank((CharSequence)keyValue)) {
                    purchasesummarydetatilVO.setErrorMsg("'\u5408\u540c\u540d\u79f0,\u7c7b\u522b\u7f16\u7801,\u7269\u8d44\u7c7b\u522b\u540d\u79f0,\u4f9b\u5e94\u5546\u540d\u79f0,\u5408\u540c\u4ed8\u6b3e\u6bd4\u4f8b'\u4e0e\u53c2\u7167\u5185\u5bb9\u4e0d\u7b26,\u8bf7\u68c0\u67e5!");
                    errorList.add(purchasesummarydetatilVO);
                }
                vo2 = purchasesummarydetatilVOList.iterator();
                while (vo2.hasNext()) {
                    PurchasesummarydetatilVO vos = (PurchasesummarydetatilVO)((Object)vo2.next());
                    if (vos.getPaymentProportion() == null) {
                        if (!vos.getContractName().equals(datas.get(0)) || !vos.getCategoryCode().equals(datas.get(1)) || !vos.getMaterialCategory().equals(datas.get(2)) || !vos.getSupplierName().equals(datas.get(3))) continue;
                        purchasesummarydetatilVO.setSettlementAmount(vos.getSettlementAmount());
                        purchasesummarydetatilVO.setTaxSettlementAmount(vos.getTaxSettlementAmount());
                        purchasesummarydetatilVO.setSettlementTotal(vos.getSettlementTotal());
                        purchasesummarydetatilVO.setTaxSettlementTotal(vos.getTaxSettlementTotal());
                        continue;
                    }
                    if (!vos.getContractName().equals(datas.get(0)) || !vos.getCategoryCode().equals(datas.get(1)) || !vos.getMaterialCategory().equals(datas.get(2)) || !vos.getSupplierName().equals(datas.get(3)) || !vos.getPaymentProportion().equals(datas.get(8))) continue;
                    purchasesummarydetatilVO.setSettlementAmount(vos.getSettlementAmount());
                    purchasesummarydetatilVO.setTaxSettlementAmount(vos.getTaxSettlementAmount());
                    purchasesummarydetatilVO.setSettlementTotal(vos.getSettlementTotal());
                    purchasesummarydetatilVO.setTaxSettlementTotal(vos.getTaxSettlementTotal());
                }
                int count = 0;
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9))) || datas.get(9) == null) {
                    purchasesummarydetatilVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u5e94\u4ed8\u6b3e\u91d1\u989d'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(9)))) {
                    purchasesummarydetatilVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u5e94\u4ed8\u6b3e\u91d1\u989d'\u683c\u5f0f\u9519\u8bef");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else {
                    purchasesummarydetatilVO.setCumulativePayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10))) || datas.get(10) == null) {
                    purchasesummarydetatilVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(10)))) {
                    purchasesummarydetatilVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d'\u683c\u5f0f\u9519\u8bef");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else {
                    purchasesummarydetatilVO.setCumulativePayment(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11))) || datas.get(11) == null) {
                    purchasesummarydetatilVO.setErrorMsg("'\u8054\u7cfb\u4eba'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else {
                    purchasesummarydetatilVO.setContacts(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? (String)datas.get(11) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12))) || datas.get(12) == null) {
                    purchasesummarydetatilVO.setErrorMsg("'\u8054\u7cfb\u4eba\u7535\u8bdd'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++count;
                    errorList.add(purchasesummarydetatilVO);
                } else {
                    purchasesummarydetatilVO.setContactsWay(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? (String)datas.get(12) : null);
                }
                purchasesummarydetatilVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? (String)datas.get(13) : null);
                if (count != 0) continue;
                successList.add(purchasesummarydetatilVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportPurchasesummaryFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesummaryVO purchasesummaryVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)purchasesummaryVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.purchasesummarydetatilService.list((Wrapper)queryWrapper);
        List purchasesummarydetatilVOList = BeanMapper.mapList((Iterable)list, PurchasesummarydetatilVO.class);
        if (purchasesummarydetatilVOList != null && purchasesummarydetatilVOList.size() > 0) {
            for (int i = 0; i < purchasesummarydetatilVOList.size(); ++i) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = (PurchasesummarydetatilVO)((Object)purchasesummarydetatilVOList.get(i));
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchasesummarydetatilVOList);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportPurchasesummaryFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesummarydetatilVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = list.get(i);
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<PurchasesummarydetatilVO>> beans = new HashMap<String, List<PurchasesummarydetatilVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }
}

