package com.ejianc.business.middlemeasurement.controller.api;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.business.middlemeasurement.service.IVisaclaimaccountService;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 总包签证索赔台账
 *
 * @author generator
 */
@Controller
@RequestMapping("api/visaclaimaccount")
public class VisaclaimaccountApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IVisaclaimaccountService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description 根据合同id和时间查询 发包人认可工期顺延天数合计 字段
     * @param
     * @Return void
     */
    @RequestMapping(value = "/selectByContractIdTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> selectByContractIdTime(@RequestParam(value = "contractId") Long contractId, @RequestParam String reportTime){
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.in("bill_state", 1, 3);
        //当月
        String start = reportTime.substring(0, 7) + "-01";
        //当月最后一天
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(reportTime.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(reportTime.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.between("happen_time", start,end);
        VisaclaimaccountEntity visaclaimaccountEntity = service.getOne(queryWrapper);
        List<VisaclaimaccountEntity> list = service.list(queryWrapper);
        BigDecimal days = BigDecimal.ZERO;
        if (!list.isEmpty()){
            for (VisaclaimaccountEntity entity : list) {
                if (entity.getDeferredTotalDays() != null){
                    days = days.add(entity.getDeferredTotalDays());
                }
            }
        }
        return CommonResponse.success("查询数据成功！",days);
    }
}
