package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SubDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/11/28
 * @description:查询分包月度报量及申请报告相关api
 */
@RestController
@RequestMapping("api/subcontractingvolume")
public class SubcontractingvolumeApiController implements Serializable {
    @Autowired
    private ISubcontractingvolumeService service;
    /**
     * 根据合同id查询所有的分包月度报量及申请报告的子表数据
     * 查到数据汇总累计工程量，汇总累计含税金额和不含税金额
     * 本期相关数据只查询不汇总
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeDetailByContractId", method = RequestMethod.GET)
    public CommonResponse<List<SettlementBookStatementDetailVO>> querySubcontractingvolumeDetailByContractId(@RequestParam(value = "contractId") Long contractId) {
        List<SettlementBookStatementDetailVO> settlementBookStatementDetailVOS = service.querySubcontractingvolumeDetailByContractId(contractId);
        return CommonResponse.success(settlementBookStatementDetailVOS);
    }
    /**
     * 根据合同id查询所有的分包月度报量及申请报告的物资节超子表数据
     * 查到数据汇总数量相关数据
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/querySubcontractingvolumeByContractId", method = RequestMethod.GET)
    public CommonResponse<List<SettlementBookMaterialDetailVO>> querySubcontractingvolumeByContractId(@RequestParam(value = "contractId") Long contractId) {
        List<SettlementBookMaterialDetailVO> settlementBookMaterialDetailVOS = service.querySubcontractingvolumeMaterialByContractId(contractId);
        for (SettlementBookMaterialDetailVO settlementBookMaterialDetailVO : settlementBookMaterialDetailVOS) {
            settlementBookMaterialDetailVO.setId(IdWorker.getId());
        }
        return CommonResponse.success(settlementBookMaterialDetailVOS);
    }

}
