package com.ejianc.business.middlemeasurement.service.impl;

import java.math.BigDecimal;
import java.util.List;

import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumemdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeodetailEntity;
import com.ejianc.business.middlemeasurement.mapper.SubcontractingvolumeMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountPullVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量及申请报告
 * 
 * @author generator
 * 
 */
@Service("subcontractingvolumeService")
public class SubcontractingvolumeServiceImpl
		extends BaseServiceImpl<SubcontractingvolumeMapper, SubcontractingvolumeEntity>
		implements ISubcontractingvolumeService {

	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private IOutcontractApi outcontractApi;
	@Autowired
	private SubcontractingvolumeMapper mapper;

	private void setDefaultValue(SubcontractingvolumedetailEntity entity) {
		if (entity.getQuantity() == null) {
			entity.setQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeQuantity() == null) {
			entity.setCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeAmounts() == null) {
			entity.setCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getCumulativeTaxAmounts() == null) {
			entity.setCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineQuantity() == null) {
			entity.setExamineQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineAmounts() == null) {
			entity.setExamineAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineTaxAmounts() == null) {
			entity.setExamineTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeQuantity() == null) {
			entity.setExamineCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeAmounts() == null) {
			entity.setExamineCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeTaxAmounts() == null) {
			entity.setExamineCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		BigDecimal cumulativeQuantity = new BigDecimal(0.0);
		BigDecimal cumulativeAmounts = new BigDecimal(0.0);
		BigDecimal cumulativeTaxAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeQuantity = new BigDecimal(0.0);
		BigDecimal examineCumulativeAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeTaxAmounts = new BigDecimal(0.0);
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("subitem_code", entity.getSubitemCode());
		List<SubcontractingvolumedetailEntity> list = subcontractingvolumedetailService.list(queryWrapper);
		if (!CollectionUtil.isEmpty(list)) {
			for (SubcontractingvolumedetailEntity subc : list) {
				cumulativeQuantity = cumulativeQuantity.add(subc.getQuantity());
				cumulativeAmounts = cumulativeAmounts.add(subc.getAmounts());
				cumulativeTaxAmounts = cumulativeTaxAmounts.add(subc.getTaxAmounts());
				examineCumulativeQuantity = examineCumulativeQuantity.add(subc.getExamineQuantity());
				examineCumulativeAmounts = examineCumulativeAmounts.add(subc.getExamineAmounts());
				examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(subc.getExamineTaxAmounts());
			}
		}
		if (entity.getId() != null && entity.getId() > 0) {// 更新
			SubcontractingvolumedetailEntity oldEntity = subcontractingvolumedetailService.getById(entity.getId());
			cumulativeQuantity = oldEntity.getCumulativeQuantity().add(oldEntity.getQuantity().negate())
					.add(entity.getQuantity());
			cumulativeAmounts = oldEntity.getCumulativeAmounts().add(oldEntity.getAmounts().negate())
					.add(entity.getAmounts());
			cumulativeTaxAmounts = oldEntity.getCumulativeTaxAmounts().add(oldEntity.getTaxAmounts().negate())
					.add(entity.getTaxAmounts());

			examineCumulativeQuantity = oldEntity.getExamineCumulativeQuantity()
					.add(oldEntity.getExamineQuantity().negate()).add(entity.getExamineQuantity());
			examineCumulativeAmounts = oldEntity.getExamineCumulativeAmounts()
					.add(oldEntity.getExamineAmounts().negate()).add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = oldEntity.getExamineCumulativeTaxAmounts()
					.add(oldEntity.getExamineTaxAmounts().negate()).add(entity.getExamineTaxAmounts());
		} else {// 新增
			cumulativeQuantity = cumulativeQuantity.add(entity.getQuantity());
			cumulativeAmounts = cumulativeAmounts.add(entity.getAmounts());
			cumulativeTaxAmounts = cumulativeTaxAmounts.add(entity.getTaxAmounts());
			examineCumulativeQuantity = examineCumulativeQuantity.add(entity.getExamineQuantity());
			examineCumulativeAmounts = examineCumulativeAmounts.add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(entity.getExamineTaxAmounts());
		}
		entity.setCumulativeQuantity(cumulativeQuantity);
		entity.setCumulativeAmounts(cumulativeAmounts);
		entity.setCumulativeTaxAmounts(cumulativeTaxAmounts);
		entity.setExamineCumulativeQuantity(examineCumulativeQuantity);
		entity.setExamineCumulativeAmounts(examineCumulativeAmounts);
		entity.setExamineCumulativeTaxAmounts(examineCumulativeTaxAmounts);
	}


	@Transactional
	@Override
	public boolean saveOrUpdate(SubcontractingvolumeEntity entity, boolean syncEs) {
		return super.saveOrUpdate(entity, syncEs);
	}

	@Override
	public List<SettlementBookStatementDetailVO> querySubcontractingvolumeDetailByContractId(Long contractId) {
		return mapper.querySubcontractingvolumeDetailByContractId(contractId);
	}

	@Override
	public List<SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId) {
		return mapper.querySubcontractingvolumeMaterialByContractId(contractId);
	}
}
