/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/engineermeasurement"})
public class EngineermeasurementApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEngineermeasurementService service;

    @RequestMapping(value={"/queryByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryByContractId(@RequestParam(value="contractId") Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.last("limit 1");
        List list = this.service.list((Wrapper)queryWrapper);
        EngineermeasurementVO result = new EngineermeasurementVO();
        if (list != null && list.size() > 0) {
            result = (EngineermeasurementVO)((Object)BeanMapper.map(list.get(0), EngineermeasurementVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)result));
    }

    @RequestMapping(value={"/selectByContractIdTime"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> selectByContractIdTime(@RequestParam(value="contractId") Long contractId, @RequestParam String reportTime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)0);
        String start = reportTime.substring(0, 7) + "-01";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(reportTime.substring(0, 4)));
        cal.set(2, Integer.parseInt(reportTime.substring(5, 7)) - 1);
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf1.format(cal.getTime());
        queryWrapper.le((Object)"reporting_time", (Object)end);
        queryWrapper.ge((Object)"reporting_time", (Object)start);
        EngineermeasurementEntity engineermeasurementEntity = (EngineermeasurementEntity)((Object)this.service.getOne((Wrapper)queryWrapper));
        EngineermeasurementVO result = new EngineermeasurementVO();
        if (engineermeasurementEntity != null) {
            result = (EngineermeasurementVO)((Object)BeanMapper.map((Object)((Object)engineermeasurementEntity), EngineermeasurementVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)((Object)result));
    }
}

