package com.ejianc.business.change.excel;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.change.bean.ChangeVisaclaimaccountdetailEntity;
import com.ejianc.business.change.service.IChangeVisaclaimaccountdetailService;
import com.ejianc.business.change.vo.ChangeVisaclaimaccountVO;
import com.ejianc.business.change.vo.ChangeVisaclaimaccountdetailVO;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 总包签证索赔导入导出
 */
@Controller
@RequestMapping("changeVisaclaimaccountExport")
public class ExcelChangeVisaclaimaccountController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IChangeVisaclaimaccountdetailService changeVisaclaimaccountdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadVisaclaimaccount")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "visaclaimaccountdetail-import.xlsx", "总包签证索赔台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportVisaclaimaccount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangeVisaclaimaccountdetailVO> successList = new ArrayList<>();
        List<ChangeVisaclaimaccountdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    ChangeVisaclaimaccountdetailVO changeVisaclaimaccountdetailVO = new ChangeVisaclaimaccountdetailVO();
                    changeVisaclaimaccountdetailVO.setId(IdWorker.getId());//id

                    if (datas.get(0) == null || StringUtils.isBlank(datas.get(0))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'变更内容'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setChangeContent(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 变更内容
                    }

                    if (datas.get(1) == null || StringUtils.isBlank(datas.get(1))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'存档部门'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setDepartmentName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 存档部门
                    }

                    if (datas.get(2) == null || StringUtils.isBlank(datas.get(2))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'变更编号'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setChangeCode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 变更编号
                    }

                    if (datas.get(3) == null || StringUtils.isBlank(datas.get(3))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'合同议价依据'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setBargainingBasist(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 合同议价依据
                    }


                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        if (!DateUtils.grepDate(datas.get(4))) {
                            String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'我方报送时间(合同约定)'格式错误！";
                            changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            changeVisaclaimaccountdetailVO.setContractSubmissionDate(StringUtils.isNotBlank(datas.get(4)) ? DateUtils.Date(datas.get(4)) : null); // 我方报送时间(合同约定)
                        }
                    } else {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送时间(合同约定)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(5) != null && StringUtils.isNotBlank(datas.get(5))) {
                        if (!DateUtils.grepDate(datas.get(5))) {
                            String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'我方报送时间(实际报送)'格式错误！";
                            changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            changeVisaclaimaccountdetailVO.setActualSubmissionDate(StringUtils.isNotBlank(datas.get(5)) ? DateUtils.Date(datas.get(5)) : null); // 我方报送时间(实际报送)
                        }
                    } else {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送时间(实际报送)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(6) == null || StringUtils.isBlank(datas.get(6))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送金额(除税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setExSubmittedAmount(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); //我方报送金额(除税)(元)
                    }

                    if (datas.get(7) == null || StringUtils.isBlank(datas.get(7))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送金额(含税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setInSubmittedAmount(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 我方报送金额(含税)(元)
                    }

                    if (datas.get(8) == null || StringUtils.isBlank(datas.get(8))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'对方确认金额(除税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setExConfirmedAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 对方确认金额(除税)(元)
                    }

                    if (datas.get(9) == null || StringUtils.isBlank(datas.get(9))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'对方确认金额(含税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setInConfirmedAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 对方确认金额(含税)(元)
                    }

                    if (datas.get(10) != null && StringUtils.isNotBlank(datas.get(10))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付时间(当期或结算)'格式错误！";
                        if (!DateUtils.grepDate(datas.get(10))) {
                            changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            changeVisaclaimaccountdetailVO.setDueDate(StringUtils.isBlank(datas.get(10)) ? null : DateUtils.Date(datas.get(10))); // 应付时间(当期或结算)
                        }
                    } else {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付时间(当期或结算)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(11) == null || StringUtils.isBlank(datas.get(11))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付金额(除税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setExPayableAmount(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); //  应付金额(除税)(元)
                    }

                    if (datas.get(12) == null || StringUtils.isBlank(datas.get(12))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付金额(含税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setInPayableAmount(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  应付金额(含税)(元)
                    }

                    if (datas.get(13) == null || StringUtils.isBlank(datas.get(13))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'实付金额(除税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setExPaidinAmount(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 实付金额(除税)(元)
                    }

                    if (datas.get(14) == null || StringUtils.isBlank(datas.get(14))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'实付金额(含税)(元)'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setInPaidinAmount(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 实付金额(含税)(元)
                    }

                    if (StringUtils.isNotBlank(datas.get(15)) && datas.get(15) != null && !NumberUtil.isNumber(datas.get(15))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'涉及工期变更天数'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setChangeDate(Integer.valueOf(Integer.valueOf((int) Float.parseFloat(datas.get(15))))); // 涉及工期变更天数
                    }

                    if (StringUtils.isNotBlank(datas.get(16)) && datas.get(16) != null && !NumberUtil.isNumber(datas.get(16))) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'发包人认可工期顺延天数'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setDeferredDays(StringUtils.isNotBlank(datas.get(16)) ? Integer.valueOf((int) Float.parseFloat(datas.get(16))) : null); // 发包人认可工期顺延天数
                    }

                    if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                        String errorMessage = changeVisaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'责任人'不能为空！";
                        changeVisaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        changeVisaclaimaccountdetailVO.setPersonLiable(StringUtils.isNotBlank(datas.get(17)) ? (datas.get(17)) : null); // 责任人
                    }

                    changeVisaclaimaccountdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(18)) ? datas.get(18) : null); // 备注
                    if (num > 0){
                        errorList.add(changeVisaclaimaccountdetailVO);
                    }else{
                        successList.add(changeVisaclaimaccountdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportVisaclaimaccountFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody ChangeVisaclaimaccountVO changeVisaclaimaccountVO, HttpServletResponse response) {
        QueryWrapper<ChangeVisaclaimaccountdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", changeVisaclaimaccountVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangeVisaclaimaccountdetailEntity> list = changeVisaclaimaccountdetailService.list(queryWrapper);
        List<ChangeVisaclaimaccountdetailVO> changeVisaclaimaccountdetailVOList = BeanMapper.mapList(list, ChangeVisaclaimaccountdetailVO.class);
        if (changeVisaclaimaccountdetailVOList != null && changeVisaclaimaccountdetailVOList.size() > 0) {
            for (int i = 0; i < changeVisaclaimaccountdetailVOList.size(); i++) {
                ChangeVisaclaimaccountdetailVO changeVisaclaimaccountdetailVO = changeVisaclaimaccountdetailVOList.get(i);
                changeVisaclaimaccountdetailVO.setSort(String.valueOf(i + 1));
                if (changeVisaclaimaccountdetailVO.getContractSubmissionDate() != null) {
                    changeVisaclaimaccountdetailVO.setContractSubmissionDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getContractSubmissionDate()));
                }
                if (changeVisaclaimaccountdetailVO.getActualSubmissionDate() != null) {
                    changeVisaclaimaccountdetailVO.setActualSubmissionDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getActualSubmissionDate()));
                }
                if (changeVisaclaimaccountdetailVO.getDueDate() != null) {
                    changeVisaclaimaccountdetailVO.setDueDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getDueDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", changeVisaclaimaccountdetailVOList);
        ExcelExport.getInstance().export("visaclaimaccountdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportVisaclaimaccountFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<ChangeVisaclaimaccountdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangeVisaclaimaccountdetailVO changeVisaclaimaccountdetailVO = list.get(i);
                changeVisaclaimaccountdetailVO.setSort(String.valueOf(i + 1));
                if (changeVisaclaimaccountdetailVO.getContractSubmissionDate() != null) {
                    changeVisaclaimaccountdetailVO.setContractSubmissionDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getContractSubmissionDate()));
                }
                if (changeVisaclaimaccountdetailVO.getActualSubmissionDate() != null) {
                    changeVisaclaimaccountdetailVO.setActualSubmissionDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getActualSubmissionDate()));
                }
                if (changeVisaclaimaccountdetailVO.getDueDate() != null) {
                    changeVisaclaimaccountdetailVO.setDueDateShow(DateUtils.dateSimple(changeVisaclaimaccountdetailVO.getDueDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("visaclaimaccountdetail-export.xlsx", beans, response);
    }

}
