package com.ejianc.business.middlemeasurement.mapper;

import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountPullVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;

import java.util.List;

/**
 * 分包月度报量及申请报告
 * 
 * @author generator
 * 
 */
@Mapper
public interface SubcontractingvolumeMapper extends BaseCrudMapper<SubcontractingvolumeEntity> {
	SubcontractaccountPullVO getSubcontractaccountAmount(@Param("contractId") Long contractId);

	/**
	 * 根据合同id查询以往所有的分包月度报量及申请报告的汇总数据
	 * @param contractId 合同id
	 * @return
	 */
	List<SettlementBookStatementDetailVO> querySubcontractingvolumeDetailByContractId(Long contractId);

	/**
	 * 根据合同id查询以往所有的分包月度报量及申请报告的物资超用扣款明细数据
	 * @param contractId 合同id
	 * @return
	 */
	List<SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId);
	/**
	 * 根据合同id查询以往所有的分包月度报量及申请报告的其他扣款数据
	 * @param contractId 合同id
	 * @return
	 */
	List<SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId);
}
