package com.ejianc.business.middlemeasurement.mapper;

import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.LaborCostVO;
import com.ejianc.foundation.middlemeasurement.vo.OverusedeductionRequestVO;
import com.ejianc.foundation.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SubcontractingvolumedetailsVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;

import java.util.List;
import java.util.Map;

/**
 * 分包月度报量及申请报告月度子表
 * 
 * @author generator
 * 
 */
@Mapper
public interface SubcontractingvolumedetailMapper extends BaseCrudMapper<SubcontractingvolumedetailEntity> {

    //获取计价明细表的数量、无税金额、含税金额
    LaborCostVO getPricing(String contractType,Long projectId,String subitemCode,String section,String reportingTime);

    //获取物资代扣及超用扣款清单中的超用扣款和代扣款
    LaborCostVO getOverdeduction(String contractType,Long projectId,String reportingTime);

    //获取其他扣款金额
    LaborCostVO getOtherCost(String contractType,Long projectId,String reportingTime);

    //查询分包月度报量及申请报告子表数量和金额
    List<LaborCostVO> getDetailAll(String contractType, String projectId, String reportingTime);

    //查询月度周转租赁单根据项目和时间汇总编码和区段汇总月度结算费用
    List<RevolvingleasedetailVO> getRevolvingAll(String projectId, String time);

    //工程分包结算书查询超用扣款信息
    OverusedeductionRequestVO getOveruse(String contractType,String contractId,String subitemCode,String section);

    //工程分包结算书查询其他扣款及代扣款信息
    OverusedeductionRequestVO getOther(String contractType,String contractId,String subitemCode,String section);


}
