/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.service.IMonthlyapprovalService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"monthlyapproval"})
public class MonthlyapprovalController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "middlemeasurement-monthlyapproval";
    @Autowired
    private IMonthlyapprovalService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> saveOrUpdate(@RequestBody MonthlyapprovalVO saveorUpdateVO) throws ParseException {
        MonthlyapprovalEntity entity = (MonthlyapprovalEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MonthlyapprovalEntity.class));
        this.checkBillStateUniq(entity.getId(), entity.getContractId());
        entity = this.checkBillCodeUniq(entity);
        entity = this.handleCumulative(entity);
        this.service.saveOrUpdate((Object)entity, false);
        MonthlyapprovalVO vo = (MonthlyapprovalVO)((Object)BeanMapper.map((Object)((Object)entity), MonthlyapprovalVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private void checkBillStateUniq(Long id, Long contractId) {
        List pro;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (id != null) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u603b\u5305\u6708\u5ea6\u8ba1\u91cf\u8ba1\u91cf\u5ba1\u6279\u5355\u636e\"!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MonthlyapprovalEntity checkBillCodeUniq(MonthlyapprovalEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    private MonthlyapprovalEntity handleCumulative(MonthlyapprovalEntity entity) {
        BigDecimal cumulativeTotalComplete;
        BigDecimal cumulativeCompensationReward;
        BigDecimal cumulativeChangeVisa;
        MonthlyapprovalVO pastVo;
        BigDecimal cumulativeOriginalContract;
        Date currentDate = new Date(System.currentTimeMillis());
        if (entity.getCreateTime() != null) {
            currentDate = entity.getCreateTime();
        }
        if ((cumulativeOriginalContract = (pastVo = this.getPastTotalData(entity.getContractId(), currentDate)).getCumulativeOriginalContract()) != null && entity.getOriginalContract() != null) {
            cumulativeOriginalContract = entity.getOriginalContract().add(cumulativeOriginalContract);
        }
        if ((cumulativeChangeVisa = pastVo.getCumulativeChangeVisa()) != null && entity.getChangeVisa() != null) {
            cumulativeChangeVisa = entity.getChangeVisa().add(cumulativeChangeVisa);
        }
        if ((cumulativeCompensationReward = pastVo.getCumulativeCompensationReward()) != null && entity.getCompensationReward() != null) {
            cumulativeCompensationReward = entity.getCompensationReward().add(cumulativeCompensationReward);
        }
        if ((cumulativeTotalComplete = pastVo.getCumulativeTotalComplete()) != null && entity.getThisMonthTotal() != null) {
            cumulativeTotalComplete = entity.getThisMonthTotal().add(cumulativeTotalComplete);
        }
        entity.setCumulativeOriginalContract(cumulativeOriginalContract);
        entity.setCumulativeChangeVisa(cumulativeChangeVisa);
        entity.setCumulativeCompensationReward(cumulativeCompensationReward);
        entity.setCumulativeTotalComplete(cumulativeTotalComplete);
        entity.setCumulativeTotal(cumulativeTotalComplete);
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> queryDetail(Long id) {
        MonthlyapprovalEntity entity = (MonthlyapprovalEntity)((Object)this.service.selectById(id));
        MonthlyapprovalVO vo = (MonthlyapprovalVO)((Object)BeanMapper.map((Object)((Object)entity), MonthlyapprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthlyapprovalVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthlyapprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List monthlyapprovalList = BeanMapper.mapList((Iterable)list, MonthlyapprovalVO.class);
        for (int i = 0; i < monthlyapprovalList.size(); ++i) {
            String billStateStr;
            MonthlyapprovalVO monthlyapprovalVO = (MonthlyapprovalVO)((Object)monthlyapprovalList.get(i));
            monthlyapprovalVO.setSort(String.valueOf(i + 1));
            if (monthlyapprovalVO.getMeasurementTime() != null) {
                monthlyapprovalVO.setMeasurementTimeShow(DateUtils.dateSimple2(monthlyapprovalVO.getMeasurementTime()));
            }
            if ((billStateStr = monthlyapprovalVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            monthlyapprovalVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", monthlyapprovalList);
        ExcelExport.getInstance().export("MonthlyapprovalMain-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refMonthlyapprovalData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> refMonthlyapprovalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthlyapprovalVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> pastData(Long id, Long contractId) {
        this.checkBillStateUniq(id, contractId);
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            MonthlyapprovalEntity entity = (MonthlyapprovalEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private MonthlyapprovalVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)"0");
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        BigDecimal cumulativeOriginalContract = new BigDecimal(0);
        BigDecimal cumulativeChangeVisa = new BigDecimal(0);
        BigDecimal cumulativeCompensationReward = new BigDecimal(0);
        BigDecimal cumulativeTotalComplete = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                MonthlyapprovalEntity monthlyapprovalEntity = (MonthlyapprovalEntity)((Object)proTotal.get(i));
                cumulativeOriginalContract = cumulativeOriginalContract.add(monthlyapprovalEntity.getOriginalContract());
                cumulativeChangeVisa = cumulativeChangeVisa.add(monthlyapprovalEntity.getChangeVisa());
                cumulativeCompensationReward = cumulativeCompensationReward.add(monthlyapprovalEntity.getCompensationReward());
                cumulativeTotalComplete = cumulativeTotalComplete.add(monthlyapprovalEntity.getThisMonthTotal());
            }
        }
        MonthlyapprovalVO vo = new MonthlyapprovalVO();
        vo.setCumulativeOriginalContract(cumulativeOriginalContract);
        vo.setCumulativeChangeVisa(cumulativeChangeVisa);
        vo.setCumulativeCompensationReward(cumulativeCompensationReward);
        vo.setCumulativeTotalComplete(cumulativeTotalComplete);
        vo.setCumulativeTotal(cumulativeTotalComplete);
        vo.setContractId(contractId);
        return vo;
    }
}

