package com.ejianc.business.middlemeasurement.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 分包经济签证单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_middlemeasurement_subcontract_economic")
public class SubcontractEconomicEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="engineering_order_issue")
    private String engineeringOrderIssue; // 工程指令签发事项
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="economic_visa_amount")
    private BigDecimal economicVisaAmount; // 经济签证金额
    @TableField(value="reported_value")
    private BigDecimal reportedValue; //  报送值（元）
    @TableField(value="subcontracting_submission_date")
    private Date subcontractingSubmissionDate; // 分包报送日期
    @TableField(value="visa_content")
    private String visaContent; // 签证内容
    @TableField(value="amount_calculation_process")
    private String amountCalculationProcess; // 签证金额计算过程
    @TableField(value="subcontractor")
    private String subcontractor; // 分包人（盖章）
    @TableField(value="subcontracting_principal_signature")
    private String subcontractingPrincipalSignature; // 分包委托人签字
    @TableField(value="subcontracting_principal_date")
    private Date subcontractingPrincipalDate; // 分包委托人签字日期
    @TableField(value="sub_contractor")
    private String subContractor; // 转扣分包人（盖章）
    @TableField(value="sub_contracting_principal_signature")
    private String subContractingPrincipalSignature; // 转扣分包委托人签字
    @TableField(value="sub_contracting_principa_date")
    private Date subContractingPrincipaDate; // 转扣分包委托人签字日期
    @TableField(value="opinion_project_professional_engineer")
    private String opinionProjectProfessionalEngineer; // 项目专业工程师意见
    @TableField(value="project_professional_engineer_signature")
    private String projectProfessionalEngineerSignature; // 项目专业工程师签字
    @TableField(value="project_professional_engineer_date")
    private Date projectProfessionalEngineerDate; // 项目专业工程师签字日期
    @TableField(value="reviewed_project_business_manager")
    private String reviewedProjectBusinessManager; // 项目商务经理审核
    @TableField(value="project_business_manager_signature")
    private String projectBusinessManagerSignature; // 项目商务经理签字
    @TableField(value="project_business_manager_date")
    private Date projectBusinessManagerDate; // 项目商务经理签字日期
    @TableField(value="opinion_project_chief_engineer")
    private String opinionProjectChiefEngineer; // 项目总工（或生产经理）意见
    @TableField(value="project_chief_engineer_signature")
    private String projectChiefEngineerSignature; // 项目总工（或生产经理）签字
    @TableField(value="project_chief_engineer_date")
    private Date projectChiefEngineerDate; // 项目总工（或生产经理）签字日期
    @TableField(value="reviewed_project_manager")
    private String reviewedProjectManager; // 项目经理审核
    @TableField(value="project_manager_signature")
    private String projectManagerSignature; // 项目经理签字
    @TableField(value="project_manager_date")
    private Date projectManagerDate; // 项目经理签字日期
    @TableField(value="business_management_department_operator")
    private String businessManagementDepartmentOperator; // 分/子公司商务管理部经办人
    @TableField(value="business_management_department_operator_signature")
    private String businessManagementDepartmentOperatorSignature; // 分/子公司商务管理部经办人签字
    @TableField(value="business_management_department_operator_date")
    private Date businessManagementDepartmentOperatorDate; // 分/子公司商务管理部经办人签字日期
    @TableField(value="business_management_department_head")
    private String businessManagementDepartmentHead; // 分/子公司商务管理部负责人
    @TableField(value="business_management_department_head_signature")
    private String businessManagementDepartmentHeadSignature; // 分/子公司商务管理部负责人签字
    @TableField(value="business_management_department_head_date")
    private Date businessManagementDepartmentHeadDate; // 分/子公司商务管理部负责人签字日期
    @TableField(value="company_leader")
    private String companyLeader; // 分/子公司分管领导（2万元及以上签证）

    @TableField(value="extax_visa_amount")
    private BigDecimal extaxVisaAmount; //签证金额（除税）
    @TableField(value="tax_visa_amount")
    private BigDecimal taxVisaAmount;   //签证金额（税金）
    @TableField(value="intax_visa_amount")
    private BigDecimal intaxVisaAmount;     //签证金额（含税）
    @TableField(value="extax_casual_labour")
    private BigDecimal extaxCasualLabour;   //零星用工（除税）
    @TableField(value="tax_casual_labour")
    private BigDecimal taxCasualLabour;     //零星用工（税金）
    @TableField(value="intax_casual_labour")
    private BigDecimal intaxCasualLabour;   //零星用工（含税）


    public BigDecimal getExtaxVisaAmount() {
        return extaxVisaAmount;
    }

    public void setExtaxVisaAmount(BigDecimal extaxVisaAmount) {
        this.extaxVisaAmount = extaxVisaAmount;
    }

    public BigDecimal getTaxVisaAmount() {
        return taxVisaAmount;
    }

    public void setTaxVisaAmount(BigDecimal taxVisaAmount) {
        this.taxVisaAmount = taxVisaAmount;
    }

    public BigDecimal getIntaxVisaAmount() {
        return intaxVisaAmount;
    }

    public void setIntaxVisaAmount(BigDecimal intaxVisaAmount) {
        this.intaxVisaAmount = intaxVisaAmount;
    }

    public BigDecimal getExtaxCasualLabour() {
        return extaxCasualLabour;
    }

    public void setExtaxCasualLabour(BigDecimal extaxCasualLabour) {
        this.extaxCasualLabour = extaxCasualLabour;
    }

    public BigDecimal getTaxCasualLabour() {
        return taxCasualLabour;
    }

    public void setTaxCasualLabour(BigDecimal taxCasualLabour) {
        this.taxCasualLabour = taxCasualLabour;
    }

    public BigDecimal getIntaxCasualLabour() {
        return intaxCasualLabour;
    }

    public void setIntaxCasualLabour(BigDecimal intaxCasualLabour) {
        this.intaxCasualLabour = intaxCasualLabour;
    }

    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getEngineeringOrderIssue() {
        return engineeringOrderIssue;
    }

    public void setEngineeringOrderIssue(String engineeringOrderIssue) {
        this.engineeringOrderIssue = engineeringOrderIssue;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public BigDecimal getEconomicVisaAmount() {
        return economicVisaAmount;
    }

    public void setEconomicVisaAmount(BigDecimal economicVisaAmount) {
        this.economicVisaAmount = economicVisaAmount;
    }
    public BigDecimal getReportedValue() {
        return reportedValue;
    }

    public void setReportedValue(BigDecimal reportedValue) {
        this.reportedValue = reportedValue;
    }
    public Date getSubcontractingSubmissionDate() {
        return subcontractingSubmissionDate;
    }

    public void setSubcontractingSubmissionDate(Date subcontractingSubmissionDate) {
        this.subcontractingSubmissionDate = subcontractingSubmissionDate;
    }

    public String getVisaContent() {
        return visaContent;
    }

    public void setVisaContent(String visaContent) {
        this.visaContent = visaContent;
    }

    public String getAmountCalculationProcess() {
        return amountCalculationProcess;
    }

    public void setAmountCalculationProcess(String amountCalculationProcess) {
        this.amountCalculationProcess = amountCalculationProcess;
    }

    public String getSubcontractor() {
        return subcontractor;
    }

    public void setSubcontractor(String subcontractor) {
        this.subcontractor = subcontractor;
    }
    public String getSubcontractingPrincipalSignature() {
        return subcontractingPrincipalSignature;
    }

    public void setSubcontractingPrincipalSignature(String subcontractingPrincipalSignature) {
        this.subcontractingPrincipalSignature = subcontractingPrincipalSignature;
    }
    public Date getSubcontractingPrincipalDate() {
        return subcontractingPrincipalDate;
    }

    public void setSubcontractingPrincipalDate(Date subcontractingPrincipalDate) {
        this.subcontractingPrincipalDate = subcontractingPrincipalDate;
    }
    public String getSubContractor() {
        return subContractor;
    }

    public void setSubContractor(String subContractor) {
        this.subContractor = subContractor;
    }
    public String getSubContractingPrincipalSignature() {
        return subContractingPrincipalSignature;
    }

    public void setSubContractingPrincipalSignature(String subContractingPrincipalSignature) {
        this.subContractingPrincipalSignature = subContractingPrincipalSignature;
    }
    public Date getSubContractingPrincipaDate() {
        return subContractingPrincipaDate;
    }

    public void setSubContractingPrincipaDate(Date subContractingPrincipaDate) {
        this.subContractingPrincipaDate = subContractingPrincipaDate;
    }
    public String getOpinionProjectProfessionalEngineer() {
        return opinionProjectProfessionalEngineer;
    }

    public void setOpinionProjectProfessionalEngineer(String opinionProjectProfessionalEngineer) {
        this.opinionProjectProfessionalEngineer = opinionProjectProfessionalEngineer;
    }
    public String getProjectProfessionalEngineerSignature() {
        return projectProfessionalEngineerSignature;
    }

    public void setProjectProfessionalEngineerSignature(String projectProfessionalEngineerSignature) {
        this.projectProfessionalEngineerSignature = projectProfessionalEngineerSignature;
    }
    public Date getProjectProfessionalEngineerDate() {
        return projectProfessionalEngineerDate;
    }

    public void setProjectProfessionalEngineerDate(Date projectProfessionalEngineerDate) {
        this.projectProfessionalEngineerDate = projectProfessionalEngineerDate;
    }
    public String getReviewedProjectBusinessManager() {
        return reviewedProjectBusinessManager;
    }

    public void setReviewedProjectBusinessManager(String reviewedProjectBusinessManager) {
        this.reviewedProjectBusinessManager = reviewedProjectBusinessManager;
    }
    public String getProjectBusinessManagerSignature() {
        return projectBusinessManagerSignature;
    }

    public void setProjectBusinessManagerSignature(String projectBusinessManagerSignature) {
        this.projectBusinessManagerSignature = projectBusinessManagerSignature;
    }
    public Date getProjectBusinessManagerDate() {
        return projectBusinessManagerDate;
    }

    public void setProjectBusinessManagerDate(Date projectBusinessManagerDate) {
        this.projectBusinessManagerDate = projectBusinessManagerDate;
    }
    public String getOpinionProjectChiefEngineer() {
        return opinionProjectChiefEngineer;
    }

    public void setOpinionProjectChiefEngineer(String opinionProjectChiefEngineer) {
        this.opinionProjectChiefEngineer = opinionProjectChiefEngineer;
    }
    public String getProjectChiefEngineerSignature() {
        return projectChiefEngineerSignature;
    }

    public void setProjectChiefEngineerSignature(String projectChiefEngineerSignature) {
        this.projectChiefEngineerSignature = projectChiefEngineerSignature;
    }
    public Date getProjectChiefEngineerDate() {
        return projectChiefEngineerDate;
    }

    public void setProjectChiefEngineerDate(Date projectChiefEngineerDate) {
        this.projectChiefEngineerDate = projectChiefEngineerDate;
    }
    public String getReviewedProjectManager() {
        return reviewedProjectManager;
    }

    public void setReviewedProjectManager(String reviewedProjectManager) {
        this.reviewedProjectManager = reviewedProjectManager;
    }
    public String getProjectManagerSignature() {
        return projectManagerSignature;
    }

    public void setProjectManagerSignature(String projectManagerSignature) {
        this.projectManagerSignature = projectManagerSignature;
    }
    public Date getProjectManagerDate() {
        return projectManagerDate;
    }

    public void setProjectManagerDate(Date projectManagerDate) {
        this.projectManagerDate = projectManagerDate;
    }
    public String getBusinessManagementDepartmentOperator() {
        return businessManagementDepartmentOperator;
    }

    public void setBusinessManagementDepartmentOperator(String businessManagementDepartmentOperator) {
        this.businessManagementDepartmentOperator = businessManagementDepartmentOperator;
    }
    public String getBusinessManagementDepartmentOperatorSignature() {
        return businessManagementDepartmentOperatorSignature;
    }

    public void setBusinessManagementDepartmentOperatorSignature(String businessManagementDepartmentOperatorSignature) {
        this.businessManagementDepartmentOperatorSignature = businessManagementDepartmentOperatorSignature;
    }
    public Date getBusinessManagementDepartmentOperatorDate() {
        return businessManagementDepartmentOperatorDate;
    }

    public void setBusinessManagementDepartmentOperatorDate(Date businessManagementDepartmentOperatorDate) {
        this.businessManagementDepartmentOperatorDate = businessManagementDepartmentOperatorDate;
    }
    public String getBusinessManagementDepartmentHead() {
        return businessManagementDepartmentHead;
    }

    public void setBusinessManagementDepartmentHead(String businessManagementDepartmentHead) {
        this.businessManagementDepartmentHead = businessManagementDepartmentHead;
    }
    public String getBusinessManagementDepartmentHeadSignature() {
        return businessManagementDepartmentHeadSignature;
    }

    public void setBusinessManagementDepartmentHeadSignature(String businessManagementDepartmentHeadSignature) {
        this.businessManagementDepartmentHeadSignature = businessManagementDepartmentHeadSignature;
    }
    public Date getBusinessManagementDepartmentHeadDate() {
        return businessManagementDepartmentHeadDate;
    }

    public void setBusinessManagementDepartmentHeadDate(Date businessManagementDepartmentHeadDate) {
        this.businessManagementDepartmentHeadDate = businessManagementDepartmentHeadDate;
    }
    public String getCompanyLeader() {
        return companyLeader;
    }

    public void setCompanyLeader(String companyLeader) {
        this.companyLeader = companyLeader;
    }
    
}
