package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumemdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeodetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.settlementmanage.api.ISettlementBookApi;
import com.ejianc.foundation.budgetmanage.api.IConsdrawbudgetApi;
import com.ejianc.foundation.budgetmanage.api.ISubpackageApi;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetVO;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetdetailVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackageVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackagedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractingvolume")
public class SubcontractingvolumeController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	@Autowired
	private IOutcontractApi outcontractApi;

	@Autowired
	private IConsdrawbudgetApi consdrawbudgetApi;

	@Autowired
	private ISubpackageApi subpackageApi;

	@Autowired
	private ISettlementBookApi settlementBookApi;

	@Autowired
	private SessionManager sessionManager;

	private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private ISubcontractingvolumeService service;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private ISubcontractingvolumemdetailService subcontractingvolumemdetailService;
	@Autowired
	private ISubcontractingvolumeodetailService subcontractingvolumeodetailService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> saveOrUpdate(@RequestBody SubcontractingvolumeVO saveorUpdateVO) {
		SubcontractingvolumeEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractingvolumeEntity.class);

		//校验：同一合同，只能存在一份自由态或审批中的单据
		checkBillStateUniq(entity.getId(), entity.getContractId(), true);

		//校验：单据编号唯一性
		entity = checkBillCodeUniq(entity);

		//检验：不允许超过分包施工图预算工程量
		checkSubpackageQuantity(entity);

		//校验：工程分包结算书生成之后，不允许再做分包月度报量
		checkSubcontract(entity.getContractId());

		//检验：不允许超过施工图预算工程量
		checkQuantity(entity);

		entity.setIsReference(0);
		service.saveOrUpdate(entity, false);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);
		//构建树形结构
		List<SubcontractingvolumedetailVO> consdrawbudgetdetailVOList = vo.getSubcontractingvolumedetailEntities();
		vo.setSubcontractingvolumedetailEntities(handleChildren(consdrawbudgetdetailVOList));
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * 间计量——分包月度报量及申请报告——工程分包结算书生成之后，不允许再做分包月度报量
	 * @param
	 * @param contractId
	 */
	private void checkSubcontract(Long contractId) {
		CommonResponse<Integer> subcontracts = settlementBookApi.queryContractIds(contractId);
		if (subcontracts.getCode() == 0){
			if (subcontracts.getData() == 0){
				return;
			}else{
				throw new BusinessException("已有工程分包结算书，不能新增分包月度报量及申请报告");
			}
		}
	}



	/**
	 * 不允许超过分包施工图预算工程量
	 * @param entity
	 */
	private void checkSubpackageQuantity(SubcontractingvolumeEntity entity) {
		Long contractId = entity.getContractId();
		CommonResponse<SubpackageVO> subpackageResponse = subpackageApi.queryByContractId(contractId);
		if(subpackageResponse.getCode() != 0){
			return;
		}

		//本单据子表
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
		if(subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0){
			return;
		}

		//分包施工图预算
		SubpackageVO subpackageVO = subpackageResponse.getData();

		//如果subpackageVO 为null，该项目没做分包施工图预算，则认为不开启控制
		if(subpackageVO != null){
			//分包施工图预算子表
			List<SubpackagedetailVO> subpackagedetailVOS = subpackageVO.getSubpackagedetailEntities();
			Long isEnable = subpackageVO.getIsEnable();
			if (isEnable != null && isEnable == 1){//是否开启控制:0 否，1:是
				for (int i = 0; i < subcontractingvolumedetailEntities.size(); i++) {
					boolean isHave = false;//本单据子表的清单编号是否在施工图预算中存在
					SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
					//数量（项目部审核：本期）
					BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
					//数量（项目部审核：累计）
					BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
					//清单编号
					String subitemCode = subcontractingvolumedetail.getSubitemCode();
					//1合同内 2合同外
					String source = subcontractingvolumedetail.getSource();
					if(!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())){
						continue;
					}
					for (int j = 0; j < subpackagedetailVOS.size(); j++) {
						SubpackagedetailVO subpackagedetailVO = subpackagedetailVOS.get(j);
						//分包施工图预算【工程量】
						BigDecimal subpackagEengineeQuatity = subpackagedetailVO.getSubpackageQuantities();
						String subpackagSubtitleCode = subpackagedetailVO.getSubtitleCode();
						if(subitemCode.equals(subpackagSubtitleCode)){
							isHave = true;
							if(examineQuantity != null && (subpackagEengineeQuatity == null || examineQuantity.compareTo(subpackagEengineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过分包施工图预算工程量！");
							}

							if(examineCumulativeQuantity != null && (subpackagEengineeQuatity == null || examineCumulativeQuantity.compareTo(subpackagEengineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过分包施工图预算工程量！");
							}

							break;
						}
					}

					//清单编号不在施工图预算中，以工程量为0做控制
					if(!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过分包施工图预算工程量！");
					}

					if(!isHave && examineCumulativeQuantity != null && examineCumulativeQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过分包施工图预算工程量！");
					}
				}
			}
		}
	}

	/**
	 * 检验：不允许超过施工图预算工程量
	 * @param entity
	 */
	private void checkQuantity(SubcontractingvolumeEntity entity) {
		Long projectId = entity.getProjectId();
		CommonResponse<ConsdrawbudgetVO> consdrawbudgetResponse = consdrawbudgetApi.queryByProjectId(projectId);
		if(consdrawbudgetResponse.getCode() != 0){
			return;
		}

		//本单据子表
		List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
		if(subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0){
			return;
		}

		//施工图预算
		ConsdrawbudgetVO consdrawbudgetVO = consdrawbudgetResponse.getData();

		//如果consdrawbudgetVO 为null，该项目没做施工图预算，则认为不开启控制
		if(consdrawbudgetVO != null){
			//施工图预算子表
			List<ConsdrawbudgetdetailVO> consdrawbudgetdetailVOS = consdrawbudgetVO.getConsdrawbudgetdetailEntities();
			Integer isOpenControl = consdrawbudgetVO.getIsOpenControl();
			if (isOpenControl != null && isOpenControl == 1){//是否开启控制:0 否，1:是
				for (int i = 0; i < subcontractingvolumedetailEntities.size(); i++) {
					boolean isHave = false;//本单据子表的清单编号是否在施工图预算中存在
					SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
					//数量（项目部审核：本期）
					BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
					//数量（项目部审核：累计）
					BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
					//清单编号
					String subitemCode = subcontractingvolumedetail.getSubitemCode();
					//1合同内 2合同外
					String source = subcontractingvolumedetail.getSource();
					if(!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())){
						continue;
					}
					for (int j = 0; j < consdrawbudgetdetailVOS.size(); j++) {
						ConsdrawbudgetdetailVO consdrawbudgetdetailVO = consdrawbudgetdetailVOS.get(j);
						//施工图预算【工程量】
						BigDecimal engineeQuatity = consdrawbudgetdetailVO.getEngineeQuatity();
						String consdrawbudgetSubitemCode = consdrawbudgetdetailVO.getSubitemCode();
						if(subitemCode.equals(consdrawbudgetSubitemCode)){
							isHave = true;
							if(examineQuantity != null && (engineeQuatity == null || examineQuantity.compareTo(engineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过施工图预算工程量！");
							}

							if(examineCumulativeQuantity != null && (engineeQuatity == null || examineCumulativeQuantity.compareTo(engineeQuatity) > 0)){
								throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过施工图预算工程量！");
							}

							break;
						}
					}

					//清单编号不在施工图预算中，以工程量为0做控制
					if(!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核本期【数量】超过施工图预算工程量！");
					}

					if(!isHave && examineCumulativeQuantity != null && examineCumulativeQuantity.compareTo(BigDecimal.ZERO) > 0){
						throw new BusinessException("清单编码：" + subitemCode + "，\n项目部审核累计【数量】超过施工图预算工程量！");
					}
				}
			}
		}
	}

	/**
	 * 同一合同，只能存在一份自由态或审批中的单据
	 * @param id
	 * @param contractId
	 * @param isShowError 是否需要校验（初始化数据不需要，切换合同或保存需要）
	 */
	private void checkBillStateUniq(Long id, Long contractId, boolean isShowError) {
		//创建条件构造器
		QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		if(id != null){
			queryWrapper.ne("id", id);
		}
		List<SubcontractingvolumeEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			throw new BusinessException("同一合同只能存在一份自由态或审批中的\"分包月度报量及申请报告\"!");
		}
	}

	/**
	 * 单据编码唯一性校验
	 * @param entity
	 */
	private SubcontractingvolumeEntity checkBillCodeUniq(SubcontractingvolumeEntity entity) {
		if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}else {
			//单据编码唯一性
			QueryWrapper<SubcontractingvolumeEntity> queryWrapperBillCode = new QueryWrapper<>();
			queryWrapperBillCode.eq("bill_code", entity.getBillCode());
			queryWrapperBillCode.eq("dr", "0");
			Long id = entity.getId();
			if(id != null){
				queryWrapperBillCode.ne("id", id);
			}
			List<SubcontractingvolumeEntity> proBillCode = service.list(queryWrapperBillCode);
			if(proBillCode != null && proBillCode.size() > 0){
				throw new BusinessException("单据编码已存在，请重新录入!");
			}
		}

		return entity;
	}

	/**
	 * 页面新增清单编号后重新构建树
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();
		Map<String, SubcontractingvolumedetailVO> map = new HashMap<>();
		SubcontractingvolumedetailVO add = list.get(list.size() - 1);
		for (SubcontractingvolumedetailVO VO : list) {
			if (VO.getId() == null) VO.setId(IdWorker.getId());
		}
		//add.setId(IdWorker.getId());
		add.setTid(String.valueOf(IdWorker.getId()));
		add.setRowState("edit");
		add.setInnercode(add.getSubitemCode() + "_" + add.getSection());//清单编码确定唯一性
//		if ("01".equals(add.getSubitemCode()) && add.getSubitemCode().contains("装饰")) {
//			add.setInnercode("a1" + "_" + add.getSection());
//		}
		//查询该清单编码往期累计
		//创建条件构造器
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", add.getContractId());
		queryWrapper.eq("subitem_code", add.getSubitemCode());
		queryWrapper.eq("section", add.getSection());
		queryWrapper.eq("examine_unitprice", add.getExamineUnitprice());
		queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
		queryWrapper.eq("dr", "0");
		queryWrapper.orderByDesc("create_time");//最新往期
		queryWrapper.last("limit 1");
		List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
		if(pastDetails != null && pastDetails.size() > 0){
			SubcontractingvolumedetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
			if (pastSubcontractingvolumedetail.getDr() == 0) {
				//数量（分包商上报累计）
				add.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
				//除税金额（分包商上报累计）
				add.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
				//含税金额（分包商上报累计）
				add.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
				//数量（项目部审核累计）
				add.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
				//除税金额（项目部审核累计）
				add.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
				//含税金额（项目部审核累计）
				add.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
			}
		}

		//判断新增行是合同内还是合同外
		CommonResponse<List<OutcontractSubcontractUnitPriceVO>> outcontractResp = outcontractApi.queryListBycontractIdAndCode(add.getContractId(), add.getSubitemCode());
		int responseCode = outcontractResp.getCode();
		if(responseCode == 0){
			List<OutcontractSubcontractUnitPriceVO> voList = outcontractResp.getData();
			if(voList != null && voList.size() > 0){
				OutcontractSubcontractUnitPriceVO priceVO = voList.get(0);
				BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();//综合单价
				add.setSource("1");//合同内
				add.setUnit(priceVO.getUnit());//单位
				add.setTaxUnitprice(comprehensiveUnitPrice);//含税单价

				BigDecimal tax = priceVO.getTax();//税金
				BigDecimal engineeringQuantity = priceVO.getEngineeringQuantity();//工程量
				if(tax != null && engineeringQuantity != null && engineeringQuantity.compareTo(BigDecimal.ZERO) != 0){
					//除税单价 = 综合单价 - 税金/工程量
					BigDecimal temp = tax.divide(engineeringQuantity, 8, BigDecimal.ROUND_HALF_UP);
					add.setUnitprice(comprehensiveUnitPrice.subtract(temp));//除税单价
				}else {
					add.setUnitprice(comprehensiveUnitPrice);
				}
			}else {
				add.setSource("2");//合同外
			}
		}else {
			add.setSource("2");//合同外
		}

		if ("01".equals(add.getSubitemCode()) && add.getSubitemName().contains("装饰")) {
			add.setInnercode("a1"+ "_" + add.getSection());
		}
		if ("01".equals(add.getSubitemCode()) && add.getSubitemName().contains("装饰")) {
			add.setInnercode("a1"+ "_" + add.getSection());
		}
		//判断是否是装饰工程的子节点编码
		if (add.getSubitemCode().length() >= 4) {
			//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
			String code = add.getSubitemCode().substring(0, 4);
			if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
//                            若是的话，将内码改为a1xx
				add.setInnercode("a1" + add.getSubitemCode().substring(2, add.getSubitemCode().length()) + "_" + add.getSection());
			}
		}
		for (SubcontractingvolumedetailVO vo : list) {
			map.put(vo.getInnercode(), vo);
			if (!add.getId().equals(vo.getId()) && add.getInnercode().equals(vo.getInnercode()) && add.getExamineUnitprice().equals(vo.getExamineUnitprice())) {
				throw new BusinessException("除税单价已存在，请重新填写");
			}
		}
		//设置父级id
		for (SubcontractingvolumedetailVO vo : list) {
			String innercode = vo.getInnercode();
			String[] innercodeSubArr = innercode.split("_");
			String innercodeSub = "";
			String sectionSuf = "";
			if (innercodeSubArr.length > 1) {
				innercodeSub = innercodeSubArr[0];
				sectionSuf = "_" + innercodeSubArr[1];
			}

			Long pid = null;
			if (innercodeSub.length() == 2) {
				//最上级
			} else if (innercodeSub.length() == 4) {
				String pcode = innercodeSub.substring(0, 2) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);

			} else if (innercodeSub.length() == 6) {
				String pcode = innercodeSub.substring(0, 4) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercodeSub.length() > 6) {
				String pcode = innercodeSub.substring(0, 6) + sectionSuf;
				//有父节点
				pid = this.setPid(pcode, map);
			}

			if (pid != null) {
				vo.setTpid(pid.toString());
			} else {
				vo.setTpid("");
			}
		}

		//排序、构建树
		list = handleChildren(list);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(list);

		json.put("dataSource", list);

		return CommonResponse.success(json);
	}

	/**
	 * 页面子表新增参照合同价后
	 * 1.查询累计
	 * 2.重新构建树
	 *
	 * @param
	 * @return
	 */
	@RequestMapping(value = "/refreshDetailData", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		JSONObject json = new JSONObject();

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO subcontractingvolumedetailVO = list.get(i);
			String rowState = subcontractingvolumedetailVO.getRowState();
			if("add".equals(rowState)){
				//查询该清单编码往期累计
				//创建条件构造器
				QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("contract_id", subcontractingvolumedetailVO.getContractId());
				queryWrapper.eq("subitem_code", subcontractingvolumedetailVO.getSubitemCode());
				queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
				queryWrapper.eq("dr", "0");
				queryWrapper.orderByDesc("create_time");//最新往期
				queryWrapper.last("limit 1");
				List<SubcontractingvolumedetailEntity> pastDetails = subcontractingvolumedetailService.list(queryWrapper);
				if(pastDetails != null && pastDetails.size() > 0){
					SubcontractingvolumedetailEntity pastSubcontractingvolumedetail = pastDetails.get(0);
					if (pastSubcontractingvolumedetail.getDr() == 0){
						//数量（分包商上报累计）
						subcontractingvolumedetailVO.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
						//除税金额（分包商上报累计）
						subcontractingvolumedetailVO.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
						//含税金额（分包商上报累计）
						subcontractingvolumedetailVO.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
						//数量（项目部审核累计）
						subcontractingvolumedetailVO.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
						//除税金额（项目部审核累计）
						subcontractingvolumedetailVO.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
						//含税金额（项目部审核累计）
						subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
					}
				}

				subcontractingvolumedetailVO.setRowState("edit");
			}
		}

		//排序、构建树
		list = handleChildren(list);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(list);

		json.put("dataSource", list);

		return CommonResponse.success(json);
	}

	/**
	 * @Description  查询往期
	 * @param contractId
	 */
	@RequestMapping(value = "/pastData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> pastData(Long id, Long contractId, boolean isShowError) {
		if(isShowError){
			//校验：同一合同，只能存在一份自由态或审批中的单据
			checkBillStateUniq(id, contractId, isShowError);
		}

		//本期日期
		Date currentDate = new Date(System.currentTimeMillis());
		if(id != null && "".equals(id)){//更新
			SubcontractingvolumeEntity entity = service.selectById(id);
			currentDate = entity.getCreateTime();
		}

		return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
	}

	/**
	 * 获取往期审批通过的合计数据
	 *
	 * @param contractId 合同id
	 * @param currentDate 本期日期
	 */
	private SubcontractingvolumeVO getPastTotalData(Long contractId, Date currentDate) {
		//创建条件构造器
		QueryWrapper<SubcontractingvolumeEntity> queryWrapperTotal = new QueryWrapper<>();
		queryWrapperTotal.eq("contract_id", contractId);
		queryWrapperTotal.eq("dr", 0);
		queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
		queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
		queryWrapperTotal.orderByDesc("create_time");
		queryWrapperTotal.last("limit 1");

		List<SubcontractingvolumeEntity> proTotal = service.list(queryWrapperTotal);

		SubcontractingvolumeVO vo = new SubcontractingvolumeVO();
		if(proTotal != null && proTotal.size() > 0){
			SubcontractingvolumeEntity pastEntity = proTotal.get(0);
			vo = BeanMapper.map(pastEntity, SubcontractingvolumeVO.class);
		}

		vo.setContractId(contractId);
		return vo;
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> queryDetail(Long id) {
		SubcontractingvolumeEntity entity = service.selectById(id);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);

		//构建树形结构
		List<SubcontractingvolumedetailVO> consdrawbudgetdetailVOList = vo.getSubcontractingvolumedetailEntities();
		vo.setSubcontractingvolumedetailEntities(handleChildren(consdrawbudgetdetailVOList));
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<SubcontractingvolumeVO> vos) {
		service.removeByIds(vos.stream().map(SubcontractingvolumeVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		UserContext userContextCache =sessionManager.getUserContext();
		//当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
		String authOrgIds = userContextCache.getAuthOrgIds();
		List<OrgVO> orgVOList = null;
		if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
		}else {//pc端查询
			orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
		}
		//普通组织 id
		List<Long> commonOrgIds = new ArrayList<>();
		//项目部 id
		List<Long> departmentIds = new ArrayList<>();
		orgVOList.stream().forEach(org -> {
			if(5 == org.getOrgType()) {
				//项目部
				departmentIds.add(org.getId());
			} else {
				//普通组织
				commonOrgIds.add(org.getId());
			}
		});
		if(CollectionUtils.isNotEmpty(commonOrgIds)) {
			/** 要求主表有orgId字段，保存单据所属组织 */
			param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
		} else if(CollectionUtils.isNotEmpty(departmentIds)) {
			/** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
			param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
		}
		/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
		List<SubcontractingvolumeEntity> list = service.queryList(param);
		//时间转换
		List<SubcontractingvolumeVO> subcontractingvolumeVOList = BeanMapper.mapList(list, SubcontractingvolumeVO.class);
		for (int i = 0; i < subcontractingvolumeVOList.size(); i++) {
			SubcontractingvolumeVO subcontractingvolumeVO = subcontractingvolumeVOList.get(i);
			subcontractingvolumeVO.setSort(String.valueOf(i+1));
			if (subcontractingvolumeVO.getReportingTime()!=null){
				subcontractingvolumeVO.setReportingTimeShow(DateUtils.dateSimple2(subcontractingvolumeVO.getReportingTime()));
			}

			String billStateStr = subcontractingvolumeVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				subcontractingvolumeVO.setBillStateStr(billStateStr);
			}
		}
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", subcontractingvolumeVOList);
		ExcelExport.getInstance().export("subcontractingvolume-export.xlsx", beans, response);
	}

	/**
	 * 获取RPC数据
	 * resp 返回值
	 * isMustSuc 是否必须成功
	 * errMsg 失败提示
	 */
	private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
		if(isMustSuc && !resp.isSuccess()) {
			throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
		}
		return resp.getData();
	}


	/**
	 * @Description 参照
	 * @param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractingvolumeData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		fuzzyFields.add("supplierName");

		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
			if(_con.get("projectId")!=null){
				param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
			}
		}

		//未被引用
		param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

		//审批通过
		param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
		param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<SubcontractingvolumeVO> subcontractingvolumeVOList = BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class);

		pageData.setRecords(subcontractingvolumeVOList);

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, SubcontractingvolumedetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找
			String[] pcodeSubArr = pcode.split("_");
			String pcodeSub = "";
			String sectionSuf = "";//"_" + 区段
			if (pcodeSubArr.length > 1) {
				pcodeSub = pcodeSubArr[0];
				sectionSuf = "_" + pcodeSubArr[1];
			}
			if (pcodeSub.length() == 2) {
				//最上级
				return null;
			} else if (pcodeSub.length() == 4) {
				String ppcode = pcodeSub.substring(0, 2);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode + sectionSuf, map);
			} else if (pcodeSub.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode + sectionSuf, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 对子表做排序、构建树等处理
	 *
	 * @param voList
	 */
	private List<SubcontractingvolumedetailVO> handleChildren(List<SubcontractingvolumedetailVO> voList) {
		//按子目编码排序
		Collections.sort(voList, new Comparator<SubcontractingvolumedetailVO>() {
			@Override
			public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
				return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
			}
		});


		//构建树
		voList = createTreeData(voList);

		return voList;
	}

	public static List<SubcontractingvolumedetailVO> createTreeData(List<SubcontractingvolumedetailVO> list) {
		List<SubcontractingvolumedetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, SubcontractingvolumedetailVO> listMap = new HashMap<>();
		for (SubcontractingvolumedetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			SubcontractingvolumedetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			SubcontractingvolumedetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<SubcontractingvolumedetailVO> child = (List<SubcontractingvolumedetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<SubcontractingvolumedetailVO> children = new ArrayList<SubcontractingvolumedetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
