package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程计量台账导入导出
 */
@Controller
@RequestMapping("engineermeasurementExport")
public class ExcelEngineermeasurementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEngineermeasurementdetailService engineermeasurementdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadEngineermeasurement",method = RequestMethod.POST)
    @ResponseBody
    public void downloadEngineermeasurement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "engineermeasurementdetail-import.xlsx", "工程计量台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportEngineermeasurement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportEngineermeasurement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<EngineermeasurementdetailVO> successList = new ArrayList<>();
        List<EngineermeasurementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                for (int i = 3; i < result.size(); i++) {
                    EngineermeasurementdetailVO engineermeasurementdetailVO = new EngineermeasurementdetailVO();
                    List<String> datas = result.get(i);
                    if (datas.size()<21){
                        return CommonResponse.error("请检查上传文件是否正确");
                    }
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String imageProgressStr = datas.get(1);//形象进度
                    String ispecificDateStr = datas.get(2);//年月日
                    String declareEngineeringStr = datas.get(3);//土建（申报工程量）
                    String declareInstallStr = datas.get(4);//安装（申报工程量）
                    String declareTotalStr = datas.get(5);//合计（申报工程量）
                    String civilEngineeringStr = datas.get(6);//土建（业主审批工程量）
                    String installStr = datas.get(7);//安装（业主审批工程量）
                    String totalStr = datas.get(8);//合计（业主审批工程量）
                    String actualCivilEngineeringStr = datas.get(9);//土建（实际完成工程量）
                    String actualInstallStr = datas.get(10);//安装（实际完成工程量）
                    String actualTotalStr = datas.get(11);//合计（实际完成工程量）
                    String financialIncomeStr = datas.get(12);//财务列报收入
                    String actualCostStr = datas.get(13);//实际成本
                    BigDecimal rightConfirmationRateStr = new BigDecimal(0);//确权率
                    String contractApprovalTimeStr = datas.get(15);//合同审批时间
                    String actualReportingTimeStr = datas.get(16);//实际上报时间
                    String actualApprovalTimeStr = datas.get(17);//实际审批时间
                    String amountAgreedReceivablesStr = datas.get(18);//合同约定应收款金额
                    String amountCollectedStr = datas.get(19);//收款金额
                    String amongCivilEngineeringStr = datas.get(20);//土建（实际收款金额）
                    String amongInstallStr = datas.get(21);//安装（实际收款金额）
                    String agreedCollectionTimeStr = datas.get(22);//合同约定收款时间
                    String actualCollectionTimeStr = datas.get(23);//实际收款时间
                    String remarksStr = datas.get(24);//备注

                    engineermeasurementdetailVO.setId(IdWorker.getId());//id
                    engineermeasurementdetailVO.setRemarks(remarksStr); // 备注

                    //必填项、格式校验
                    if(StringUtils.isBlank(imageProgressStr)){
                        engineermeasurementdetailVO.setErrorMsg("形象进度不能为空！");
                        errorsMsgBuilder.append("形象进度不能为空！");
                    }else {
                        engineermeasurementdetailVO.setImageProgress(imageProgressStr); // 形象进度
                    }

                    if(StringUtils.isBlank(ispecificDateStr)){
                        engineermeasurementdetailVO.setErrorMsg("年月日不能为空！");
                        errorsMsgBuilder.append("年月日不能为空！");
                    }else {
                        if(DateUtils.grepDate(ispecificDateStr)){
                            engineermeasurementdetailVO.setIspecificDate(DateUtils.Date(ispecificDateStr)); // 年月日
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("年月日格式不正确！");
                            errorsMsgBuilder.append("年月日格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(declareEngineeringStr)){
                        engineermeasurementdetailVO.setErrorMsg("土建（申报工程量）不能为空！");
                        errorsMsgBuilder.append("土建（申报工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(declareEngineeringStr)){
                            engineermeasurementdetailVO.setDeclareEngineering(new BigDecimal(declareEngineeringStr)); //土建
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("土建（申报工程量）格式不正确！");
                            errorsMsgBuilder.append("土建（申报工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(declareInstallStr)){
                        engineermeasurementdetailVO.setErrorMsg("安装（申报工程量）不能为空！");
                        errorsMsgBuilder.append("安装（申报工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(declareInstallStr)){
                            engineermeasurementdetailVO.setDeclareInstall(new BigDecimal(declareInstallStr)); //安装
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("安装（申报工程量）格式不正确！");
                            errorsMsgBuilder.append("安装（申报工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(declareTotalStr)){
                        if(NumberUtil.isNumber(declareTotalStr)){
                            engineermeasurementdetailVO.setDeclareTotal(new BigDecimal(declareTotalStr)); //合计
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合计（申报工程量）格式不正确！");
                            errorsMsgBuilder.append("合计（申报工程量）格式不正确！");
                        }
                    }else {
                        BigDecimal declareEngineeringB = engineermeasurementdetailVO.getDeclareEngineering();
                        BigDecimal declareInstallB = engineermeasurementdetailVO.getDeclareInstall();
                        if(declareEngineeringB != null && declareInstallB != null){
                            engineermeasurementdetailVO.setDeclareTotal(declareInstallB.add(declareEngineeringB));
                        }else if(declareInstallB == null && declareEngineeringB != null){
                            engineermeasurementdetailVO.setDeclareTotal(declareEngineeringB);
                        }else if(declareInstallB != null && declareEngineeringB == null){
                            engineermeasurementdetailVO.setDeclareTotal(declareInstallB);
                        }
                    }


                    if(StringUtils.isBlank(civilEngineeringStr)){
                        engineermeasurementdetailVO.setErrorMsg("土建（业主审批工程量）不能为空！");
                        errorsMsgBuilder.append("土建（业主审批工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(civilEngineeringStr)){
                            engineermeasurementdetailVO.setCivilEngineering(new BigDecimal(civilEngineeringStr)); //土建
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("土建（业主审批工程量）格式不正确！");
                            errorsMsgBuilder.append("土建（业主审批工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(installStr)){
                        engineermeasurementdetailVO.setErrorMsg("安装（业主审批工程量）不能为空！");
                        errorsMsgBuilder.append("安装（业主审批工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(installStr)){
                            engineermeasurementdetailVO.setInstall(new BigDecimal(installStr)); //安装
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("安装（业主审批工程量）格式不正确！");
                            errorsMsgBuilder.append("安装（业主审批工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(totalStr)){
                        if(NumberUtil.isNumber(totalStr)){
                            engineermeasurementdetailVO.setTotal(new BigDecimal(totalStr)); //合计
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合计（业主审批工程量）格式不正确！");
                            errorsMsgBuilder.append("合计（业主审批工程量）格式不正确！");
                        }
                    }else {
                        BigDecimal civilEngineeringB = engineermeasurementdetailVO.getCivilEngineering();
                        BigDecimal installB = engineermeasurementdetailVO.getInstall();
                        if(civilEngineeringB != null && installB != null){
                            engineermeasurementdetailVO.setTotal(installB.add(civilEngineeringB));
                        }else if(installB == null && civilEngineeringB != null){
                            engineermeasurementdetailVO.setTotal(civilEngineeringB);
                        }else if(installB != null && civilEngineeringB == null){
                            engineermeasurementdetailVO.setTotal(installB);
                        }
                    }

                    if(StringUtils.isBlank(actualCivilEngineeringStr)){
                        engineermeasurementdetailVO.setErrorMsg("土建（实际完成工程量）不能为空！");
                        errorsMsgBuilder.append("土建（实际完成工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(actualCivilEngineeringStr)){
                            engineermeasurementdetailVO.setActualCivilEngineering(new BigDecimal(actualCivilEngineeringStr)); //土建（实际完成工程量）
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("土建（实际完成工程量）格式不正确！");
                            errorsMsgBuilder.append("土建（实际完成工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(actualInstallStr)){
                        engineermeasurementdetailVO.setErrorMsg("安装（实际完成工程量）不能为空！");
                        errorsMsgBuilder.append("安装（实际完成工程量）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(actualInstallStr)){
                            engineermeasurementdetailVO.setActualInstall(new BigDecimal(actualInstallStr)); //安装（实际完成工程量）
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("安装（实际完成工程量）格式不正确！");
                            errorsMsgBuilder.append("安装（实际完成工程量）格式不正确！");
                        }
                    }

                    if(StringUtils.isNotBlank(actualTotalStr)){
                        if(NumberUtil.isNumber(actualTotalStr)){
                            engineermeasurementdetailVO.setActualTotal(new BigDecimal(actualTotalStr)); //合计
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合计（实际完成工程量）格式不正确！");
                            errorsMsgBuilder.append("合计（实际完成工程量）格式不正确！");
                        }
                    }else {
                        BigDecimal actualCivilEngineeringB = engineermeasurementdetailVO.getActualCivilEngineering();
                        BigDecimal actualInstallB = engineermeasurementdetailVO.getActualInstall();
                        if(actualCivilEngineeringB != null && actualInstallB != null){
                            engineermeasurementdetailVO.setActualTotal(actualInstallB.add(actualCivilEngineeringB));
                        }else if(actualInstallB == null && actualCivilEngineeringB != null){
                            engineermeasurementdetailVO.setActualTotal(actualCivilEngineeringB);
                        }else if(actualInstallB != null && actualCivilEngineeringB == null){
                            engineermeasurementdetailVO.setActualTotal(actualInstallB);
                        }
                    }

                    if(StringUtils.isBlank(financialIncomeStr)){
                        engineermeasurementdetailVO.setErrorMsg("财务列报收入不能为空！");
                        errorsMsgBuilder.append("财务列报收入不能为空！");
                    }else {
                        if(NumberUtil.isNumber(financialIncomeStr)){
                            engineermeasurementdetailVO.setFinancialIncome(new BigDecimal(financialIncomeStr)); //财务列报收入
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("财务列报收入格式不正确！");
                            errorsMsgBuilder.append("财务列报收入格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(actualCostStr)){
                        engineermeasurementdetailVO.setErrorMsg("实际成本不能为空！");
                        errorsMsgBuilder.append("实际成本不能为空！");
                    }else {
                        if(NumberUtil.isNumber(actualCostStr)){
                            engineermeasurementdetailVO.setActualCost(new BigDecimal(actualCostStr)); //实际成本
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("实际成本格式不正确！");
                            errorsMsgBuilder.append("实际成本格式不正确！");
                        }
                    }


                    //确权率
                    BigDecimal inactualTotalStr = engineermeasurementdetailVO.getActualTotal();
                    BigDecimal inTotal = engineermeasurementdetailVO.getTotal();
                    engineermeasurementdetailVO.setRightConfirmationRate((inTotal.divide(inactualTotalStr,4,BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100))); //确权率

                    if(StringUtils.isBlank(contractApprovalTimeStr)){
                        engineermeasurementdetailVO.setErrorMsg("合同审批时间不能为空！");
                        errorsMsgBuilder.append("合同审批时间不能为空！");
                    }else {
                        if(DateUtils.grepDate(contractApprovalTimeStr)){
                            engineermeasurementdetailVO.setContractApprovalTime(DateUtils.Date(contractApprovalTimeStr)); //合同审批时间
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合同审批时间格式不正确！");
                            errorsMsgBuilder.append("合同审批时间格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(actualReportingTimeStr)){
                        engineermeasurementdetailVO.setErrorMsg("实际上报时间不能为空！");
                        errorsMsgBuilder.append("实际上报时间不能为空！");
                    }else {
                        if(DateUtils.grepDate(actualReportingTimeStr)){
                            engineermeasurementdetailVO.setActualReportingTime(DateUtils.Date(actualReportingTimeStr)); //实际上报时间
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("实际上报时间格式不正确！");
                            errorsMsgBuilder.append("实际上报时间格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(actualApprovalTimeStr)){
                        engineermeasurementdetailVO.setErrorMsg("实际审批时间不能为空！");
                        errorsMsgBuilder.append("实际审批时间不能为空！");
                    }else {
                        if(DateUtils.grepDate(actualApprovalTimeStr)){
                            engineermeasurementdetailVO.setActualApprovalTime(DateUtils.Date(actualApprovalTimeStr)); //实际审批时间
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("实际审批时间格式不正确！");
                            errorsMsgBuilder.append("实际审批时间格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(amountAgreedReceivablesStr)){
                        engineermeasurementdetailVO.setErrorMsg("合同约定应收款金额不能为空！");
                        errorsMsgBuilder.append("合同约定应收款金额不能为空！");
                    }else {
                        if(NumberUtil.isNumber(amountAgreedReceivablesStr)){
                            engineermeasurementdetailVO.setAmountAgreedReceivables(new BigDecimal(amountAgreedReceivablesStr)); //合同约定应收款金额
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合同约定应收款金额格式不正确！");
                            errorsMsgBuilder.append("合同约定应收款金额格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(amountCollectedStr)){
                        engineermeasurementdetailVO.setErrorMsg("收款金额不能为空！");
                        errorsMsgBuilder.append("收款金额不能为空！");
                    }else {
                        if(NumberUtil.isNumber(amountCollectedStr)){
                            engineermeasurementdetailVO.setAmountCollected(new BigDecimal(amountCollectedStr)); //收款金额
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("收款金额格式不正确！");
                            errorsMsgBuilder.append("收款金额格式不正确！");
                        }
                    }
                    if(StringUtils.isBlank(amongCivilEngineeringStr)){
                        engineermeasurementdetailVO.setErrorMsg("土建（实际收款金额）不能为空！");
                        errorsMsgBuilder.append("土建（实际收款金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(amongCivilEngineeringStr)){
                            engineermeasurementdetailVO.setAmongCivilEngineering(new BigDecimal(amongCivilEngineeringStr)); //土建（实际收款金额）
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("土建（实际收款金额）格式不正确！");
                            errorsMsgBuilder.append("土建（实际收款金额）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(amongInstallStr)){
                        engineermeasurementdetailVO.setErrorMsg("安装（实际收款金额）不能为空！");
                        errorsMsgBuilder.append("安装（实际收款金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(amongInstallStr)){
                            engineermeasurementdetailVO.setAmongInstall(new BigDecimal(amongInstallStr)); //安装（实际收款金额）
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("安装（实际收款金额）格式不正确！");
                            errorsMsgBuilder.append("安装（实际收款金额）格式不正确！");
                        }
                    }
                    if(StringUtils.isBlank(agreedCollectionTimeStr)){
                        engineermeasurementdetailVO.setErrorMsg("合同约定收款时间不能为空！");
                        errorsMsgBuilder.append("合同约定收款时间不能为空！");
                    }else {
                        if(DateUtils.grepDate(agreedCollectionTimeStr)){
                            engineermeasurementdetailVO.setAgreedCollectionTime(DateUtils.Date(agreedCollectionTimeStr)); //合同约定收款时间
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("合同约定收款时间格式不正确！");
                            errorsMsgBuilder.append("合同约定收款时间格式不正确！");
                        }
                    }
                    if(StringUtils.isBlank(actualCollectionTimeStr)){
                        engineermeasurementdetailVO.setErrorMsg("实际收款时间不能为空！");
                        errorsMsgBuilder.append("实际收款时间不能为空！");
                    }else {
                        if(DateUtils.grepDate(actualCollectionTimeStr)){
                            engineermeasurementdetailVO.setActualCollectionTime(DateUtils.Date(actualCollectionTimeStr)); //实际收款时间
                        }else {
                            engineermeasurementdetailVO.setErrorMsg("实际收款时间格式不正确！");
                            errorsMsgBuilder.append("实际收款时间格式不正确！");
                        }
                    }
                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(engineermeasurementdetailVO);
                    } else {
                        successList.add(engineermeasurementdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromDatabase(@RequestBody EngineermeasurementVO engineermeasurementVO, HttpServletResponse response) {
        QueryWrapper<EngineermeasurementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", engineermeasurementVO.getId());
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementdetailEntity> list = engineermeasurementdetailService.list(queryWrapper);
        List<EngineermeasurementdetailVO> engineermeasurementdetailVOList = BeanMapper.mapList(list, EngineermeasurementdetailVO.class);
        if (engineermeasurementdetailVOList != null && engineermeasurementdetailVOList.size() > 0) {
            for (int i = 0; i < engineermeasurementdetailVOList.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = engineermeasurementdetailVOList.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", engineermeasurementdetailVOList);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromPage(@RequestBody List<EngineermeasurementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = list.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

}
