package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 项目期中结算台账导入导出
 */
@Controller
@RequestMapping("interimsettlementExport")
public class ExcelInterimsettlementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInterimsettlementService service;

    @Autowired
    private IInterimsettlementdetailService detailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInterimsettlementdetail",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "interimsettlementdetail-import.xlsx", "项目期中结算台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @param id 单据id
     * @param contractId 合同id
     * @return
     */
    @RequestMapping(value = "/excelInterimsettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, String id, String contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<InterimsettlementdetailVO> successList = new ArrayList<>();
        List<InterimsettlementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            Long billId = null;
            Long billContractId = null;
            if(id != null && !"null".equals(id)){
                billId = Long.parseLong(id);
            }else {
                billId = null;
            }
            if(contractId != null){
                billContractId = Long.parseLong(contractId);
            }

            if (result != null && result.size() > 0) {
                //获取往期
                //往期主表
                InterimsettlementVO pastVO = pastData(billId, billContractId);
                //往期子表
                List<InterimsettlementdetailVO> pastDetailVOList = pastVO.getInterimsettlementdetailEntities();
                HashMap<String, InterimsettlementdetailVO> pastDetailMap = new HashMap<>();
                InterimsettlementdetailVO lastPastDetail = new InterimsettlementdetailVO();
                if(pastDetailVOList != null && pastDetailVOList.size() > 0){
                    for (int i = 0; i < pastDetailVOList.size(); i++) {
                        InterimsettlementdetailVO pastDetailVO = pastDetailVOList.get(i);
                        pastDetailMap.put(pastDetailVO.getIssueNumber(), pastDetailVO);
                    }

                    lastPastDetail = pastDetailVOList.get(0);//往期最新的一期
                }

                //导入子表map
                HashMap<String, InterimsettlementdetailVO> importDetailMap = new HashMap<>();
                for (int i = 2; i < result.size(); i++) {
                    InterimsettlementdetailVO interimsettlementdetailVO = new InterimsettlementdetailVO();
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String issueNumber = datas.get(1);//期号
                    String completionMonth = datas.get(2);//完成工程款月份
                    String applicationNo = datas.get(3);//申请单编号
                    String applicationAmount = datas.get(4);//申请金额
                    String currentApproval = datas.get(5);//本期（批准金额）
                    String cumulativeApproval = datas.get(6);//累计（批准金额）
                    String income = datas.get(7);//财务列报收入
                    String currentReceivable = datas.get(8);//本期（按照合同约定收款比例应收金额）
                    String cumulativeReceivable = datas.get(9);//累计（按照合同约定收款比例应收金额）
                    String currentRetention = datas.get(10);//本期（保留金）
                    String cumulativeRetention = datas.get(11);//累计（保留金）
                    String currentActual = datas.get(12);//本期（实际已收金额）
                    String cumulativeActual = datas.get(13);//累计（实际已收金额）
                    String currentUncollected = datas.get(14);//本期（未收金额）
                    String cumulativeUncollected = datas.get(15);//累计（未收金额）
                    String actualCollection = datas.get(16);//实际收款日期
                    String cashFlow = datas.get(17);//现金
                    String remarks = datas.get(18);//备注

                    interimsettlementdetailVO.setId(IdWorker.getId());//id
                    interimsettlementdetailVO.setRemarks(remarks);//备注

                    //根据期号判断是否是往期数据（不校验，以系统带出数据为准）
                    if(pastDetailMap.get(issueNumber) != null){
                        continue;
                    }

                    //必填项、格式校验
                    if(StringUtils.isBlank(issueNumber)){
                        interimsettlementdetailVO.setErrorMsg("期号不能为空！");
                        errorsMsgBuilder.append("期号不能为空！");
                    }else {
                        interimsettlementdetailVO.setIssueNumber(issueNumber); // 期号
                    }

                    if(StringUtils.isBlank(completionMonth)){
                        interimsettlementdetailVO.setErrorMsg("完成工程款月份不能为空！");
                        errorsMsgBuilder.append("完成工程款月份不能为空！");
                    }else {
                        interimsettlementdetailVO.setCompletionMonth(completionMonth);
                    }

                    if(StringUtils.isBlank(applicationNo)){
                        interimsettlementdetailVO.setErrorMsg("申请单编号不能为空！");
                        errorsMsgBuilder.append("申请单编号不能为空！");
                    }else {
                        interimsettlementdetailVO.setApplicationNo(applicationNo);
                    }

                    if(StringUtils.isBlank(applicationAmount)){
                        interimsettlementdetailVO.setErrorMsg("申请金额不能为空！");
                        errorsMsgBuilder.append("申请金额不能为空！");
                    }else {
                        if(NumberUtil.isNumber(applicationAmount)){
                            interimsettlementdetailVO.setApplicationAmount(new BigDecimal(applicationAmount));
                        }else {
                            interimsettlementdetailVO.setErrorMsg("申请金额格式不正确！");
                            errorsMsgBuilder.append("申请金额格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(currentApproval)){
                        interimsettlementdetailVO.setErrorMsg("本期（批准金额）不能为空！");
                        errorsMsgBuilder.append("本期（批准金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(currentApproval)){
                            BigDecimal currentApprovalB = new BigDecimal(currentApproval);
                            interimsettlementdetailVO.setCurrentApproval(currentApprovalB);
                            
                            //往期累计 + 本期
                            BigDecimal pastCumulativeApproval = lastPastDetail.getCumulativeApproval();
                            if(pastCumulativeApproval != null){
                                pastCumulativeApproval = currentApprovalB.add(pastCumulativeApproval);
                            }else {
                                pastCumulativeApproval = currentApprovalB;
                            }
                            interimsettlementdetailVO.setCumulativeApproval(pastCumulativeApproval);
                        }else {
                            interimsettlementdetailVO.setErrorMsg("本期（批准金额）格式不正确！");
                            errorsMsgBuilder.append("本期（批准金额）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(income)){
                        interimsettlementdetailVO.setErrorMsg("财务列报收入不能为空！");
                        errorsMsgBuilder.append("财务列报收入不能为空！");
                    }else {
                        if(NumberUtil.isNumber(income)){
                            interimsettlementdetailVO.setIncome(new BigDecimal(income)); //财务列报收入
                        }else {
                            interimsettlementdetailVO.setErrorMsg("财务列报收入格式不正确！");
                            errorsMsgBuilder.append("财务列报收入格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(currentReceivable)){
                        interimsettlementdetailVO.setErrorMsg("本期（按照合同约定收款比例应收金额）不能为空！");
                        errorsMsgBuilder.append("本期（按照合同约定收款比例应收金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(currentReceivable)){
                            BigDecimal currentReceivableB = new BigDecimal(currentReceivable);
                            interimsettlementdetailVO.setCurrentReceivable(currentReceivableB); //合计

                            //往期累计 + 本期
                            BigDecimal pastCumulativeReceivable =  lastPastDetail.getCumulativeReceivable();
                            if(pastCumulativeReceivable != null){
                                pastCumulativeReceivable = currentReceivableB.add(pastCumulativeReceivable);
                            }else {
                                pastCumulativeReceivable = currentReceivableB;
                            }
                            interimsettlementdetailVO.setCumulativeReceivable(pastCumulativeReceivable);
                        }else {
                            interimsettlementdetailVO.setErrorMsg("本期（按照合同约定收款比例应收金额）格式不正确！");
                            errorsMsgBuilder.append("本期（按照合同约定收款比例应收金额）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(currentRetention)){
                        interimsettlementdetailVO.setErrorMsg("本期（保留金）不能为空！");
                        errorsMsgBuilder.append("本期（保留金）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(currentRetention)){
                            BigDecimal currentRetentionB = new BigDecimal(currentRetention);
                            interimsettlementdetailVO.setCurrentRetention(currentRetentionB); //本期（保留金）

                            //往期累计 + 本期
                            BigDecimal pastCumulativeRetention =  lastPastDetail.getCumulativeRetention();
                            if(pastCumulativeRetention != null){
                                pastCumulativeRetention = currentRetentionB.add(pastCumulativeRetention);
                            }else {
                                pastCumulativeRetention = currentRetentionB;
                            }
                            interimsettlementdetailVO.setCumulativeRetention(pastCumulativeRetention);
                        }else {
                            interimsettlementdetailVO.setErrorMsg("本期（保留金）格式不正确！");
                            errorsMsgBuilder.append("本期（保留金）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(currentActual)){
                        interimsettlementdetailVO.setErrorMsg("本期（实际已收金额）不能为空！");
                        errorsMsgBuilder.append("本期（实际已收金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(currentActual)){
                            BigDecimal currentActualB = new BigDecimal(currentActual);
                            interimsettlementdetailVO.setCurrentActual(currentActualB); //实际已收金额

                            //往期累计 + 本期
                            BigDecimal pastCumulativeActual =  lastPastDetail.getCumulativeActual();
                            if(pastCumulativeActual != null){
                                pastCumulativeActual = currentActualB.add(pastCumulativeActual);
                            }else {
                                pastCumulativeActual = currentActualB;
                            }
                            interimsettlementdetailVO.setCumulativeActual(pastCumulativeActual);
                        }else {
                            interimsettlementdetailVO.setErrorMsg("本期（实际已收金额）格式不正确！");
                            errorsMsgBuilder.append("本期（实际已收金额）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(currentUncollected)){
                        interimsettlementdetailVO.setErrorMsg("本期（未收金额）不能为空！");
                        errorsMsgBuilder.append("本期（未收金额）不能为空！");
                    }else {
                        if(NumberUtil.isNumber(currentUncollected)){
                            BigDecimal currentUncollectedB = new BigDecimal(currentUncollected);
                            interimsettlementdetailVO.setCurrentUncollected(currentUncollectedB);

                            //往期累计 + 本期
                            BigDecimal pastCumulativeUncollected =  lastPastDetail.getCumulativeUncollected();
                            if(pastCumulativeUncollected != null){
                                pastCumulativeUncollected = currentUncollectedB.add(pastCumulativeUncollected);
                            }else {
                                pastCumulativeUncollected = currentUncollectedB;
                            }
                            interimsettlementdetailVO.setCumulativeUncollected(pastCumulativeUncollected);
                        }else {
                            interimsettlementdetailVO.setErrorMsg("本期（未收金额）格式不正确！");
                            errorsMsgBuilder.append("本期（未收金额）格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(actualCollection)){
                        interimsettlementdetailVO.setErrorMsg("实际收款日期不能为空！");
                        errorsMsgBuilder.append("实际收款日期不能为空！");
                    }else {
                        if(DateUtils.grepDate(actualCollection)){
                            interimsettlementdetailVO.setActualCollection(DateUtils.Date(actualCollection)); //实际收款日期
                        }else {
                            interimsettlementdetailVO.setErrorMsg("实际收款日期格式不正确！");
                            errorsMsgBuilder.append("实际收款日期格式不正确！");
                        }
                    }

                    if(StringUtils.isBlank(cashFlow)){
                        interimsettlementdetailVO.setErrorMsg("现金流不能为空！");
                        errorsMsgBuilder.append("现金流不能为空！");
                    }else {
                        interimsettlementdetailVO.setCashFlow(cashFlow); //现金流
                    }

                    //重复项校验
                    if(importDetailMap.get(issueNumber) == null){
                        importDetailMap.put(issueNumber, interimsettlementdetailVO);
                    }else {
                        interimsettlementdetailVO.setErrorMsg("期号不允许重复！");
                        errorsMsgBuilder.append("期号不允许重复！");
                    }

                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(interimsettlementdetailVO);
                    } else {
                        successList.add(interimsettlementdetailVO);
                    }
                }

                //本期新增在首行
                successList.addAll(pastDetailVOList);
            }
        }

        //重新计算累计值
        if(successList.size() > 0){
            InterimsettlementdetailVO lastVO = null;
            for (int i = successList.size() - 1; i >= 0; i--) {
                InterimsettlementdetailVO detailVO = successList.get(i);
                if(lastVO == null){//累计 = 本期
                    //累计（批准金额）
                    detailVO.setCumulativeApproval(detailVO.getCurrentApproval());
                    //累计（按照合同约定收款比例应收金额）
                    detailVO.setCumulativeReceivable(detailVO.getCurrentReceivable());
                    //累计（保留金）
                    detailVO.setCumulativeRetention(detailVO.getCurrentRetention());
                    //累计（实际已收金额）
                    detailVO.setCumulativeActual(detailVO.getCurrentActual());
                    //累计（实际未收金额）
                    detailVO.setCumulativeUncollected(detailVO.getCurrentUncollected());
                }else {//累计 = 往期 + 本期
                    //累计（批准金额）
                    BigDecimal lastCumulativeApproval = lastVO.getCumulativeApproval();
                    detailVO.setCumulativeApproval(lastCumulativeApproval.add(detailVO.getCurrentApproval()));
                    //累计（按照合同约定收款比例应收金额）
                    BigDecimal lastCumulativeReceivable = lastVO.getCumulativeReceivable();
                    detailVO.setCumulativeReceivable(lastCumulativeReceivable.add(detailVO.getCurrentReceivable()));
                    //累计（保留金）
                    BigDecimal lastCumulativeRetention = lastVO.getCumulativeRetention();
                    detailVO.setCumulativeRetention(lastCumulativeRetention.add(detailVO.getCurrentRetention()));
                    //累计（实际已收金额）
                    BigDecimal lastCumulativeActual = lastVO.getCumulativeActual();
                    detailVO.setCumulativeActual(lastCumulativeActual.add(detailVO.getCurrentActual()));
                    //累计（实际未收金额）
                    BigDecimal lastCumulativeUncollected = lastVO.getCumulativeUncollected();
                    detailVO.setCumulativeUncollected(lastCumulativeUncollected.add(detailVO.getCurrentUncollected()));
                }

                lastVO = detailVO;
            }
        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportInterimsettlementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody InterimsettlementVO detailVo, HttpServletResponse response) {
        QueryWrapper<InterimsettlementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<InterimsettlementdetailEntity> list = detailService.list(queryWrapper);
        List<InterimsettlementdetailVO> interimsettlementdetailVOList = BeanMapper.mapList(list, InterimsettlementdetailVO.class);
        if (interimsettlementdetailVOList != null && interimsettlementdetailVOList.size() > 0) {
            for (int i = 0; i < interimsettlementdetailVOList.size(); i++) {
                InterimsettlementdetailVO interimsettlementdetailVO = interimsettlementdetailVOList.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() != null) {
                    interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", interimsettlementdetailVOList);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportInterimsettlementdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<InterimsettlementdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                InterimsettlementdetailVO interimsettlementdetailVO = list.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() != null) {
                    interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * @param contractId
     * @Description
     */
    public InterimsettlementVO pastData(Long id, Long contractId) {
        //本期日期
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            InterimsettlementEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }
        return getPastTotalData(contractId, currentDate);
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private InterimsettlementVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器-该合同下审批通过的项目期中结算台账
        QueryWrapper<InterimsettlementEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        queryWrapperTotal.orderByDesc("create_time");//排序
        queryWrapperTotal.last("limit 1");//最新生效的一期
        List<InterimsettlementEntity> list = service.list(queryWrapperTotal);

        //往期：主表
        InterimsettlementVO resVO = new InterimsettlementVO();
        if (list != null && list.size() > 0) {
            resVO = BeanMapper.map(list.get(0), InterimsettlementVO.class);

            //往期：子表
            //查询往期单据子表
            QueryWrapper<InterimsettlementdetailEntity> queryWrapperDetailList = new QueryWrapper<>();
            queryWrapperDetailList.eq("mid", resVO.getId());
            queryWrapperDetailList.eq("dr", "0");
            queryWrapperDetailList.orderByAsc("sort");
            List<InterimsettlementdetailEntity> detailList = detailService.list(queryWrapperDetailList);

            if (detailList != null && detailList.size() > 0) {
                for (int i = 0; i < detailList.size(); i++) {
                    detailList.get(i).setId(IdWorker.getId());
                    detailList.get(i).setPastFlag(1);//是否为往期数据：1是，0否
                }
                List<InterimsettlementdetailVO> resDetailList = BeanMapper.mapList(detailList, InterimsettlementdetailVO.class);
                resVO.setInterimsettlementdetailEntities(resDetailList);
            }
        }
        return resVO;
    }
}
