package com.ejianc.business.middlemeasurement.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class MonthUtil {
    /**
     * 获取当前月第一天
     * @param month
     * @return
     */
    public static String getFirstDayOfMonth(String year, String month) {
        Calendar calendar = Calendar.getInstance();
        // 设置年度
        calendar.set(Calendar.YEAR ,Integer.parseInt(year));
        // 设置月份
        calendar.set(Calendar.MONTH, Integer.parseInt(month)-1);
        // 获取某月最小天数
        int firstDay = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        // 设置日历中月份的最小天数
        calendar.set(Calendar.DAY_OF_MONTH, firstDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayStr = sdf.format(calendar.getTime())+" 00:00:00";
        return firstDayStr;
    }

    /**
     * 获取当前月最后一天
     * @param month
     * @return
     */
    public static String getLastDayOfMonth(String year, String month) {
        Calendar calendar = Calendar.getInstance();
        // 设置年度
        calendar.set(Calendar.YEAR ,Integer.parseInt(year));
        // 设置月份
        calendar.set(Calendar.MONTH, Integer.parseInt(month)-1);
        // 获取某月最大天数
        int lastDay=0;
        //2月的平年瑞年天数
        if(Integer.parseInt(month) == 2) {
            lastDay = calendar.getLeastMaximum(Calendar.DAY_OF_MONTH);
        }else {
            lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        }
        // 设置日历中月份的最大天数
        calendar.set(Calendar.DAY_OF_MONTH, lastDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayStr = sdf.format(calendar.getTime())+" 23:59:59";
        return lastDayStr;
    }
}
