package com.ejianc.business.middlemeasurement.vo;

import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 咨询及其他类合同过程结算单
 *
 * @author generator
 *
 */
public class ConsultotherVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织name
    private Long projectDepartmentId; // 项目部id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reportingTime; // 报量时间
    private Long agentId; // 经办人id
    private String agentName; // 经办人姓名
    private Long supplierId; // 供方单位id
    private String supplierName; // 供方单位名称
    private String billCode; // 单据编号
    private java.math.BigDecimal farmersWages; // 其中农民工工资
    private java.math.BigDecimal cumulativeFarmersWages; // 其中累计农民工工资
    private String completion; // 工作完成情况
    private java.math.BigDecimal taxCurrentTotal; // 本期合计
    private java.math.BigDecimal taxCumulativeTotal; // 累计合计
    private java.math.BigDecimal taxDeductionAmount; // 扣款金额
    private java.math.BigDecimal taxCurrentContract; // 本期合同内金额
    private java.math.BigDecimal taxCumulativeContract; // 累计合同内金额
    private java.math.BigDecimal taxCurrentContractout; // 本期合同外金额
    private java.math.BigDecimal taxCumulativeContractout; // 累计合同外金额
    private java.math.BigDecimal currentTotal; // 本期合计
    private java.math.BigDecimal cumulativeTotal; // 累计合计
    private java.math.BigDecimal deductionAmount; // 扣款金额
    private java.math.BigDecimal currentContract; // 本期合同内金额
    private java.math.BigDecimal cumulativeContract; // 累计合同内金额
    private java.math.BigDecimal currentContractout; // 本期合同外金额
    private java.math.BigDecimal cumulativeContractout; // 累计合同外金额
    private String completionConfirmation; // 完成情况确认(生产经理)
    private String quality; // 质量(质量工程师)
    private String security; // 安全(安全工程师)
    private String variousDeductions; // 各项扣款项(会计)
    private String verificationWork; // 核实相关工作(项目总工)
    private String verifyOtherWork; // 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
    private java.math.BigDecimal taxCurrentAmounts; // 含税金额（分包商上报：本期）
    private java.math.BigDecimal taxCumulativeAmounts; // 含税金额（分包商上报：累计）
    private java.math.BigDecimal currentAmounts; // 除税金额（分包商上报：本期）
    private java.math.BigDecimal cumulativeAmounts; // 除税金额（分包商上报：累计）
    private String contractType; // 合同类型

    private java.lang.String reportingTimeShow; // 报量时间文本显示
    private java.lang.String billStateStr; // 单据状态文本显示
    private java.lang.String sort; // 序号

    private List<ConsultotherdetailVO> consultotherdetailEntities = new ArrayList<>(); // 咨询及其他类合同过程结算单-计价明细
    private List<ConsultotherodetailVO> consultotherodetailEntities = new ArrayList<>(); // 咨询及其他类合同过程结算单-其他扣款

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织name
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织name
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 报量时间
     */
    public java.util.Date getReportingTime() {
        return reportingTime;
    }

    /**
     * 报量时间
     */
    public void setReportingTime(java.util.Date reportingTime) {
        this.reportingTime = reportingTime;
    }
    /**
     * 经办人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人id
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 供方单位id
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供方单位id
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供方单位名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供方单位名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 其中农民工工资
     */
    public java.math.BigDecimal getFarmersWages() {
        return farmersWages;
    }

    /**
     * 其中农民工工资
     */
    public void setFarmersWages(java.math.BigDecimal farmersWages) {
        this.farmersWages = farmersWages;
    }
    /**
     * 其中累计农民工工资
     */
    public java.math.BigDecimal getCumulativeFarmersWages() {
        return cumulativeFarmersWages;
    }

    /**
     * 其中累计农民工工资
     */
    public void setCumulativeFarmersWages(java.math.BigDecimal cumulativeFarmersWages) {
        this.cumulativeFarmersWages = cumulativeFarmersWages;
    }
    /**
     * 工作完成情况
     */
    public String getCompletion() {
        return completion;
    }

    /**
     * 工作完成情况
     */
    public void setCompletion(String completion) {
        this.completion = completion;
    }
    /**
     * 本期合计
     */
    public java.math.BigDecimal getTaxCurrentTotal() {
        return taxCurrentTotal;
    }

    /**
     * 本期合计
     */
    public void setTaxCurrentTotal(java.math.BigDecimal taxCurrentTotal) {
        this.taxCurrentTotal = taxCurrentTotal;
    }
    /**
     * 累计合计
     */
    public java.math.BigDecimal getTaxCumulativeTotal() {
        return taxCumulativeTotal;
    }

    /**
     * 累计合计
     */
    public void setTaxCumulativeTotal(java.math.BigDecimal taxCumulativeTotal) {
        this.taxCumulativeTotal = taxCumulativeTotal;
    }
    /**
     * 扣款金额
     */
    public java.math.BigDecimal getTaxDeductionAmount() {
        return taxDeductionAmount;
    }

    /**
     * 扣款金额
     */
    public void setTaxDeductionAmount(java.math.BigDecimal taxDeductionAmount) {
        this.taxDeductionAmount = taxDeductionAmount;
    }
    /**
     * 本期合同内金额
     */
    public java.math.BigDecimal getTaxCurrentContract() {
        return taxCurrentContract;
    }

    /**
     * 本期合同内金额
     */
    public void setTaxCurrentContract(java.math.BigDecimal taxCurrentContract) {
        this.taxCurrentContract = taxCurrentContract;
    }
    /**
     * 累计合同内金额
     */
    public java.math.BigDecimal getTaxCumulativeContract() {
        return taxCumulativeContract;
    }

    /**
     * 累计合同内金额
     */
    public void setTaxCumulativeContract(java.math.BigDecimal taxCumulativeContract) {
        this.taxCumulativeContract = taxCumulativeContract;
    }
    /**
     * 本期合同外金额
     */
    public java.math.BigDecimal getTaxCurrentContractout() {
        return taxCurrentContractout;
    }

    /**
     * 本期合同外金额
     */
    public void setTaxCurrentContractout(java.math.BigDecimal taxCurrentContractout) {
        this.taxCurrentContractout = taxCurrentContractout;
    }
    /**
     * 累计合同外金额
     */
    public java.math.BigDecimal getTaxCumulativeContractout() {
        return taxCumulativeContractout;
    }

    /**
     * 累计合同外金额
     */
    public void setTaxCumulativeContractout(java.math.BigDecimal taxCumulativeContractout) {
        this.taxCumulativeContractout = taxCumulativeContractout;
    }
    /**
     * 本期合计
     */
    public java.math.BigDecimal getCurrentTotal() {
        return currentTotal;
    }

    /**
     * 本期合计
     */
    public void setCurrentTotal(java.math.BigDecimal currentTotal) {
        this.currentTotal = currentTotal;
    }
    /**
     * 累计合计
     */
    public java.math.BigDecimal getCumulativeTotal() {
        return cumulativeTotal;
    }

    /**
     * 累计合计
     */
    public void setCumulativeTotal(java.math.BigDecimal cumulativeTotal) {
        this.cumulativeTotal = cumulativeTotal;
    }
    /**
     * 扣款金额
     */
    public java.math.BigDecimal getDeductionAmount() {
        return deductionAmount;
    }

    /**
     * 扣款金额
     */
    public void setDeductionAmount(java.math.BigDecimal deductionAmount) {
        this.deductionAmount = deductionAmount;
    }
    /**
     * 本期合同内金额
     */
    public java.math.BigDecimal getCurrentContract() {
        return currentContract;
    }

    /**
     * 本期合同内金额
     */
    public void setCurrentContract(java.math.BigDecimal currentContract) {
        this.currentContract = currentContract;
    }
    /**
     * 累计合同内金额
     */
    public java.math.BigDecimal getCumulativeContract() {
        return cumulativeContract;
    }

    /**
     * 累计合同内金额
     */
    public void setCumulativeContract(java.math.BigDecimal cumulativeContract) {
        this.cumulativeContract = cumulativeContract;
    }
    /**
     * 本期合同外金额
     */
    public java.math.BigDecimal getCurrentContractout() {
        return currentContractout;
    }

    /**
     * 本期合同外金额
     */
    public void setCurrentContractout(java.math.BigDecimal currentContractout) {
        this.currentContractout = currentContractout;
    }
    /**
     * 累计合同外金额
     */
    public java.math.BigDecimal getCumulativeContractout() {
        return cumulativeContractout;
    }

    /**
     * 累计合同外金额
     */
    public void setCumulativeContractout(java.math.BigDecimal cumulativeContractout) {
        this.cumulativeContractout = cumulativeContractout;
    }
    /**
     * 完成情况确认(生产经理)
     */
    public String getCompletionConfirmation() {
        return completionConfirmation;
    }

    /**
     * 完成情况确认(生产经理)
     */
    public void setCompletionConfirmation(String completionConfirmation) {
        this.completionConfirmation = completionConfirmation;
    }
    /**
     * 质量(质量工程师)
     */
    public String getQuality() {
        return quality;
    }

    /**
     * 质量(质量工程师)
     */
    public void setQuality(String quality) {
        this.quality = quality;
    }
    /**
     * 安全(安全工程师)
     */
    public String getSecurity() {
        return security;
    }

    /**
     * 安全(安全工程师)
     */
    public void setSecurity(String security) {
        this.security = security;
    }
    /**
     * 各项扣款项(会计)
     */
    public String getVariousDeductions() {
        return variousDeductions;
    }

    /**
     * 各项扣款项(会计)
     */
    public void setVariousDeductions(String variousDeductions) {
        this.variousDeductions = variousDeductions;
    }
    /**
     * 核实相关工作(项目总工)
     */
    public String getVerificationWork() {
        return verificationWork;
    }

    /**
     * 核实相关工作(项目总工)
     */
    public void setVerificationWork(String verificationWork) {
        this.verificationWork = verificationWork;
    }
    /**
     * 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
     */
    public String getVerifyOtherWork() {
        return verifyOtherWork;
    }

    /**
     * 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
     */
    public void setVerifyOtherWork(String verifyOtherWork) {
        this.verifyOtherWork = verifyOtherWork;
    }
    /**
     * 含税金额（分包商上报：本期）
     */
    public java.math.BigDecimal getTaxCurrentAmounts() {
        return taxCurrentAmounts;
    }

    /**
     * 含税金额（分包商上报：本期）
     */
    public void setTaxCurrentAmounts(java.math.BigDecimal taxCurrentAmounts) {
        this.taxCurrentAmounts = taxCurrentAmounts;
    }
    /**
     * 含税金额（分包商上报：累计）
     */
    public java.math.BigDecimal getTaxCumulativeAmounts() {
        return taxCumulativeAmounts;
    }

    /**
     * 含税金额（分包商上报：累计）
     */
    public void setTaxCumulativeAmounts(java.math.BigDecimal taxCumulativeAmounts) {
        this.taxCumulativeAmounts = taxCumulativeAmounts;
    }
    /**
     * 除税金额（分包商上报：本期）
     */
    public java.math.BigDecimal getCurrentAmounts() {
        return currentAmounts;
    }

    /**
     * 除税金额（分包商上报：本期）
     */
    public void setCurrentAmounts(java.math.BigDecimal currentAmounts) {
        this.currentAmounts = currentAmounts;
    }
    /**
     * 除税金额（分包商上报：累计）
     */
    public java.math.BigDecimal getCumulativeAmounts() {
        return cumulativeAmounts;
    }

    /**
     * 除税金额（分包商上报：累计）
     */
    public void setCumulativeAmounts(java.math.BigDecimal cumulativeAmounts) {
        this.cumulativeAmounts = cumulativeAmounts;
    }
    /**
     * 合同类型
     */
    public String getContractType() {
        return contractType;
    }

    /**
     * 合同类型
     */
    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

     /**
      * 咨询及其他类合同过程结算单-计价明细
      */
     public List<ConsultotherdetailVO> getConsultotherdetailEntities() {
        return consultotherdetailEntities;
     }

     /**
      * 咨询及其他类合同过程结算单-计价明细
      */
     public void setConsultotherdetailEntities(List<ConsultotherdetailVO> consultotherdetailEntities) {
        this.consultotherdetailEntities = consultotherdetailEntities;
     }
    /**
     * 咨询及其他类合同过程结算单-其他扣款
     */
    public List<ConsultotherodetailVO> getConsultotherodetailEntities() {
        return consultotherodetailEntities;
    }
    /**
     * 咨询及其他类合同过程结算单-其他扣款
     */
    public void setConsultotherodetailEntities(List<ConsultotherodetailVO> consultotherodetailEntities) {
        this.consultotherodetailEntities = consultotherodetailEntities;
    }

    public String getReportingTimeShow() {
        return reportingTimeShow;
    }

    public void setReportingTimeShow(String reportingTimeShow) {
        this.reportingTimeShow = reportingTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}
