package com.ejianc.business.middlemeasurement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 月度机械设备租赁结算汇总
 * 
 * @author generator
 * 
 */
public class MechanicalleasedetotalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.math.BigDecimal exTaxMonthSettlement; // 本月结算金额(除税)
    private java.math.BigDecimal inTaxMonthSettlement; // 本月结算金额(含税)
    private java.math.BigDecimal exTaxCumulativeSettlement; // 累计结算(除税)
    private java.math.BigDecimal inTaxCumulativeSettlement; // 累计结算(含税)
    private java.math.BigDecimal exTaxCumulativeDue; // 本月累计应付款金额
    private java.math.BigDecimal inTaxCumulativePaid; // 本月累计付款金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private java.util.Date statisticalTime; // 统计时间
    private java.math.BigDecimal taxRate; // 税率

    private List<MechanicalleasedetotaldetailVO> mechanicalleasedetotaldetailEntities = new ArrayList<>(); // 月度机械设备租赁结算汇总子表
    private java.lang.String sort;
    private java.lang.String billStateStr;
    private List<String> referenceIdList = new ArrayList<>(); // 被引用的月度周采购结算单id集合

    public List<String> getReferenceIdList() {
        return referenceIdList;
    }

    public void setReferenceIdList(List<String> referenceIdList) {
        this.referenceIdList = referenceIdList;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 税率
     * @return
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     * @param taxRate
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 本月结算金额(除税)
     */
    public java.math.BigDecimal getExTaxMonthSettlement() {
        return exTaxMonthSettlement;
    }

    /**
     * 本月结算金额(除税)
     */
    public void setExTaxMonthSettlement(java.math.BigDecimal exTaxMonthSettlement) {
        this.exTaxMonthSettlement = exTaxMonthSettlement;
    }
    /**
     * 本月结算金额(含税)
     */
    public java.math.BigDecimal getInTaxMonthSettlement() {
        return inTaxMonthSettlement;
    }

    /**
     * 本月结算金额(含税)
     */
    public void setInTaxMonthSettlement(java.math.BigDecimal inTaxMonthSettlement) {
        this.inTaxMonthSettlement = inTaxMonthSettlement;
    }
    /**
     * 累计结算(除税)
     */
    public java.math.BigDecimal getExTaxCumulativeSettlement() {
        return exTaxCumulativeSettlement;
    }

    /**
     * 累计结算(除税)
     */
    public void setExTaxCumulativeSettlement(java.math.BigDecimal exTaxCumulativeSettlement) {
        this.exTaxCumulativeSettlement = exTaxCumulativeSettlement;
    }
    /**
     * 累计结算(含税)
     */
    public java.math.BigDecimal getInTaxCumulativeSettlement() {
        return inTaxCumulativeSettlement;
    }

    /**
     * 累计结算(含税)
     */
    public void setInTaxCumulativeSettlement(java.math.BigDecimal inTaxCumulativeSettlement) {
        this.inTaxCumulativeSettlement = inTaxCumulativeSettlement;
    }
    /**
     * 本月累计应付款金额
     */
    public java.math.BigDecimal getExTaxCumulativeDue() {
        return exTaxCumulativeDue;
    }

    /**
     * 本月累计应付款金额
     */
    public void setExTaxCumulativeDue(java.math.BigDecimal exTaxCumulativeDue) {
        this.exTaxCumulativeDue = exTaxCumulativeDue;
    }
    /**
     * 本月累计付款金额
     */
    public java.math.BigDecimal getInTaxCumulativePaid() {
        return inTaxCumulativePaid;
    }

    /**
     * 本月累计付款金额
     */
    public void setInTaxCumulativePaid(java.math.BigDecimal inTaxCumulativePaid) {
        this.inTaxCumulativePaid = inTaxCumulativePaid;
    }
    
     /**
      * 月度机械设备租赁结算汇总子表
      */
     public List<MechanicalleasedetotaldetailVO> getMechanicalleasedetotaldetailEntities() {
        return mechanicalleasedetotaldetailEntities;
     }

     /**
      * 月度机械设备租赁结算汇总子表
      */
     public void setMechanicalleasedetotaldetailEntities(List<MechanicalleasedetotaldetailVO> mechanicalleasedetotaldetailEntities) {
        this.mechanicalleasedetotaldetailEntities = mechanicalleasedetotaldetailEntities;
     }

    public Date getStatisticalTime() {
        return statisticalTime;
    }

    public void setStatisticalTime(Date statisticalTime) {
        this.statisticalTime = statisticalTime;
    }
}
