package com.ejianc.business.middlemeasurement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 月度周转工具租赁费结算单
 * 
 * @author generator
 * 
 */
public class RevolvingleaseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long contractId; // 合同id
    private java.lang.String sort; // 序号
    private java.lang.String contractName; // 合同名称
    private java.lang.String contractCode; // 合同编号
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.String projectCode; // 项目编号
    private java.lang.Long lesseeId; // 租赁商id
    private java.lang.String lesseeName; // 租赁商名称
    private java.math.BigDecimal settleAccount; // 结算金额(除税)
    private java.math.BigDecimal taxSettleAccount; // 结算金额(含税)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private java.util.Date settleTime; // 结算时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startTime; // 计费起始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date deadline; // 计费截至时间
    private java.lang.String billCode; // 编号
    private java.math.BigDecimal total; // 本月合计(除税)
    private java.math.BigDecimal taxTotal; // 本月合计(含税)
    private java.math.BigDecimal occurrenceTotal; // 累计发生(除税)
    private java.math.BigDecimal taxOccurrenceTotal; // 累计结算金额汇总(含税)
    private java.lang.Integer isReference; // 是否被汇总表引用(0:否，1:是)
    private java.lang.Long referenceId; // 引用租赁单的汇总单id
    private java.lang.String referenceCode; // 引用租赁单的汇总单code
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date saveTime; // 保存时间

    private java.math.BigDecimal taxRate; // 税率
    private java.lang.String settleTimeShow; // 结算时间文本显示
    private java.lang.String startTimeShow; //计费起始时间显示
    private java.lang.String deadlineShow; // 计费截至时间显示
    private java.lang.String billStateStr; // 单据状态文本显示

    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.math.BigDecimal compensationMaintenanceAmount; // 赔偿维修金额（除税）
    private java.math.BigDecimal taxCompensationMaintenanceAmount; // 赔偿维修金额（含税）
    private List<RevolvingleasedetailVO> revolvingleasedetailEntities = new ArrayList<>(); // 月度周转工具租赁费结算单子表

    /**
     * 税率
     * @return
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     * @param taxRate
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 租赁商id
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public java.lang.Long getLesseeId() {
        return lesseeId;
    }

    /**
     * 租赁商id
     */
    @ReferDeserialTransfer
    public void setLesseeId(java.lang.Long lesseeId) {
        this.lesseeId = lesseeId;
    }
    /**
     * 租赁商名称
     */
    public java.lang.String getLesseeName() {
        return lesseeName;
    }

    /**
     * 租赁商名称
     */
    public void setLesseeName(java.lang.String lesseeName) {
        this.lesseeName = lesseeName;
    }
    /**
     * 结算金额(除税)
     */
    public java.math.BigDecimal getSettleAccount() {
        return settleAccount;
    }

    /**
     * 结算金额(除税)
     */
    public void setSettleAccount(java.math.BigDecimal settleAccount) {
        this.settleAccount = settleAccount;
    }
    /**
     * 结算金额(含税)
     */
    public java.math.BigDecimal getTaxSettleAccount() {
        return taxSettleAccount;
    }

    /**
     * 结算金额(含税)
     */
    public void setTaxSettleAccount(java.math.BigDecimal taxSettleAccount) {
        this.taxSettleAccount = taxSettleAccount;
    }
    /**
     * 结算时间
     */
    public java.util.Date getSettleTime() {
        return settleTime;
    }

    /**
     * 结算时间
     */
    public void setSettleTime(java.util.Date settleTime) {
        this.settleTime = settleTime;
    }
    /**
     * 计费起始时间
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 计费起始时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }
    /**
     * 计费截至时间
     */
    public java.util.Date getDeadline() {
        return deadline;
    }

    /**
     * 计费截至时间
     */
    public void setDeadline(java.util.Date deadline) {
        this.deadline = deadline;
    }
    /**
     * 编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 本月合计(除税)
     */
    public java.math.BigDecimal getTotal() {
        return total;
    }

    /**
     * 本月合计(除税)
     */
    public void setTotal(java.math.BigDecimal total) {
        this.total = total;
    }
    /**
     * 本月合计(含税)
     */
    public java.math.BigDecimal getTaxTotal() {
        return taxTotal;
    }

    /**
     * 本月合计(含税)
     */
    public void setTaxTotal(java.math.BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }
    /**
     * 累计发生(除税)
     */
    public java.math.BigDecimal getOccurrenceTotal() {
        return occurrenceTotal;
    }

    /**
     * 累计发生(除税)
     */
    public void setOccurrenceTotal(java.math.BigDecimal occurrenceTotal) {
        this.occurrenceTotal = occurrenceTotal;
    }
    /**
     * 累计结算金额汇总(含税)
     */
    public java.math.BigDecimal getTaxOccurrenceTotal() {
        return taxOccurrenceTotal;
    }

    /**
     * 累计结算金额汇总(含税)
     */
    public void setTaxOccurrenceTotal(java.math.BigDecimal taxOccurrenceTotal) {
        this.taxOccurrenceTotal = taxOccurrenceTotal;
    }
    
     /**
      * 月度周转工具租赁费结算单子表
      */
     public List<RevolvingleasedetailVO> getRevolvingleasedetailEntities() {
        return revolvingleasedetailEntities;
     }

     /**
      * 月度周转工具租赁费结算单子表
      */
     public void setRevolvingleasedetailEntities(List<RevolvingleasedetailVO> revolvingleasedetailEntities) {
        this.revolvingleasedetailEntities = revolvingleasedetailEntities;
     }

    public Integer getIsReference() {
        return isReference;
    }

    public void setIsReference(Integer isReference) {
        this.isReference = isReference;
    }
    public Long getReferenceId() {
        return referenceId;
    }

    public void setReferenceId(Long referenceId) {
        this.referenceId = referenceId;
    }
    public String getReferenceCode() {
        return referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public Date getSaveTime() {
        return saveTime;
    }

    public void setSaveTime(Date saveTime) {
        this.saveTime = saveTime;
    }

    public String getSettleTimeShow() {
        return settleTimeShow;
    }

    public void setSettleTimeShow(String settleTimeShow) {
        this.settleTimeShow = settleTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getStartTimeShow() {
        return startTimeShow;
    }

    public void setStartTimeShow(String startTimeShow) {
        this.startTimeShow = startTimeShow;
    }

    public String getDeadlineShow() {
        return deadlineShow;
    }

    public void setDeadlineShow(String deadlineShow) {
        this.deadlineShow = deadlineShow;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public BigDecimal getCompensationMaintenanceAmount() {
        return compensationMaintenanceAmount;
    }

    public void setCompensationMaintenanceAmount(BigDecimal compensationMaintenanceAmount) {
        this.compensationMaintenanceAmount = compensationMaintenanceAmount;
    }

    public BigDecimal getTaxCompensationMaintenanceAmount() {
        return taxCompensationMaintenanceAmount;
    }

    public void setTaxCompensationMaintenanceAmount(BigDecimal taxCompensationMaintenanceAmount) {
        this.taxCompensationMaintenanceAmount = taxCompensationMaintenanceAmount;
    }
}
