package com.ejianc.business.middlemeasurement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 月度周转工具租赁费结算汇总
 * 
 * @author generator
 * 
 */
public class RevolvingleasesummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.String projectCode; // 项目编号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private java.util.Date statisticalTime; // 统计时间
    private java.lang.String billCode; // 编号
    private java.math.BigDecimal settleAccount; // 本月结算金额(除税)
    private java.math.BigDecimal taxSettleAccount; // 本月结算金额(含税)
    private java.math.BigDecimal cumulativeAmount; // 累计结算金额(含税)
    private java.math.BigDecimal taxCumulativeAmount; // 累计结算金额(含税)
    private java.math.BigDecimal cumulativePayable; // 本月累计应付款金额
    private java.math.BigDecimal cumulativePayment; // 本月累计付款金额

    private java.math.BigDecimal taxRate; // 税率
    private java.lang.String sort; // 序号
    private java.lang.String statisticalTimeShow; // 统计时间文本显示
    private java.lang.String billStateStr; // 单据状态文本显示

    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    
    private List<RevolvingleasesummarydetailVO> revolvingleasesummarydetailEntities = new ArrayList<>(); // 月度周转工具租赁费结算汇总子表
    private List<String> referenceIdList = new ArrayList<>(); // 被引用的月度周转工具租赁费结算单id集合

    /**
     * 税率
     * @return
     */
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     * @param taxRate
     */
    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 统计时间
     */
    public java.util.Date getStatisticalTime() {
        return statisticalTime;
    }

    /**
     * 统计时间
     */
    public void setStatisticalTime(java.util.Date statisticalTime) {
        this.statisticalTime = statisticalTime;
    }
    /**
     * 编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 本月结算金额(除税)
     */
    public java.math.BigDecimal getSettleAccount() {
        return settleAccount;
    }

    /**
     * 本月结算金额(除税)
     */
    public void setSettleAccount(java.math.BigDecimal settleAccount) {
        this.settleAccount = settleAccount;
    }
    /**
     * 本月结算金额(含税)
     */
    public java.math.BigDecimal getTaxSettleAccount() {
        return taxSettleAccount;
    }

    /**
     * 本月结算金额(含税)
     */
    public void setTaxSettleAccount(java.math.BigDecimal taxSettleAccount) {
        this.taxSettleAccount = taxSettleAccount;
    }
    /**
     * 累计结算金额(含税)
     */
    public java.math.BigDecimal getCumulativeAmount() {
        return cumulativeAmount;
    }

    /**
     * 累计结算金额(含税)
     */
    public void setCumulativeAmount(java.math.BigDecimal cumulativeAmount) {
        this.cumulativeAmount = cumulativeAmount;
    }
    /**
     * 累计结算金额(含税)
     */
    public java.math.BigDecimal getTaxCumulativeAmount() {
        return taxCumulativeAmount;
    }

    /**
     * 累计结算金额(含税)
     */
    public void setTaxCumulativeAmount(java.math.BigDecimal taxCumulativeAmount) {
        this.taxCumulativeAmount = taxCumulativeAmount;
    }
    /**
     * 本月累计应付款金额
     */
    public java.math.BigDecimal getCumulativePayable() {
        return cumulativePayable;
    }

    /**
     * 本月累计应付款金额
     */
    public void setCumulativePayable(java.math.BigDecimal cumulativePayable) {
        this.cumulativePayable = cumulativePayable;
    }
    /**
     * 本月累计付款金额
     */
    public java.math.BigDecimal getCumulativePayment() {
        return cumulativePayment;
    }

    /**
     * 本月累计付款金额
     */
    public void setCumulativePayment(java.math.BigDecimal cumulativePayment) {
        this.cumulativePayment = cumulativePayment;
    }
    
     /**
      * 月度周转工具租赁费结算汇总子表
      */
     public List<RevolvingleasesummarydetailVO> getRevolvingleasesummarydetailEntities() {
        return revolvingleasesummarydetailEntities;
     }

     /**
      * 月度周转工具租赁费结算汇总子表
      */
     public void setRevolvingleasesummarydetailEntities(List<RevolvingleasesummarydetailVO> revolvingleasesummarydetailEntities) {
        this.revolvingleasesummarydetailEntities = revolvingleasesummarydetailEntities;
     }

    public List<String> getReferenceIdList() {
        return referenceIdList;
    }

    public void setReferenceIdList(List<String> referenceIdList) {
        this.referenceIdList = referenceIdList;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getStatisticalTimeShow() {
        return statisticalTimeShow;
    }

    public void setStatisticalTimeShow(String statisticalTimeShow) {
        this.statisticalTimeShow = statisticalTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
}
