package com.ejianc.business.middlemeasurement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
public class SubcontractingvolumeVO extends BaseVO {
	private static final long serialVersionUID = 1L;

	private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
	private java.lang.Long contractId; // 合同id
	private java.lang.String contractName; // 合同名称
	private java.lang.String contractType; // 合同类型

	private java.lang.Long projectId; // 项目id
	private java.lang.String projectName; // 项目名称
	private java.lang.Long orgId; // 所属组织id
	private java.lang.String orgName; // 所属组织名称
	private java.lang.Long projectDepartmentId; // 项目部id
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
	private java.util.Date reportingTime; // 报量时间
	private java.lang.Long agentId; // 经办人id
	private java.lang.String agentName; // 经办人姓名
	private java.lang.Long supplierId; // 供方单位id
	private java.lang.String supplierName; // 供方单位名称
	private java.lang.String billCode; // 编号
	private java.math.BigDecimal farmersWages; // 其中农民工工资
	private java.math.BigDecimal cumulativeFarmersWages; // 其中累计农民工工资
	private java.lang.String finishedPart; // 完成形象部位
	private java.lang.String remarks; // 备注
	private java.math.BigDecimal taxCurrentTotal; // 本期合计
	private java.math.BigDecimal taxCumulativeTotal; // 累计合计
	private java.math.BigDecimal taxDeductionAmount; // 扣款金额
	private java.math.BigDecimal taxCurrentContract; // 本期合同内金额
	private java.math.BigDecimal taxCumulativeContract; // 累计合同内金额
	private java.math.BigDecimal taxCurrentContractout; // 本期合同外金额
	private java.math.BigDecimal taxCumulativeContractout; // 累计合同外金额
	private java.math.BigDecimal currentTotal; // 本期合计
	private java.math.BigDecimal cumulativeTotal; // 累计合计
	private java.math.BigDecimal deductionAmount; // 扣款金额
	private java.math.BigDecimal currentContract; // 本期合同内金额
	private java.math.BigDecimal cumulativeContract; // 累计合同内金额
	private java.math.BigDecimal currentContractout; // 本期合同外金额
	private java.math.BigDecimal cumulativeContractout; // 累计合同外金额
	private java.lang.String positionConfirmation; // 形象部位确认及工期(生产经理)
	private java.lang.String quality; // 质量(质量工程师)
	private java.lang.String security; // 安全(安全工程师)
	private java.lang.String materialConsumption; // 材料实际消耗(物资工程师)
	private java.lang.String variousDeductions; // 各项扣款项(会计)
	private java.lang.String verificationWork; // 核实相关工作(项目总工)
	private java.lang.String verifyOtherWork; // 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
	private java.lang.String reportingTimeShow; // 报量时间文本显示
	private java.lang.String billStateStr; // 单据状态文本显示
	private java.lang.String sort; // 序号
	private java.lang.Integer isReference; // 是否被分包月度报量台账引用(0:否，1:是)
	private java.lang.String referenceCode; // 分包月度报量台账code
	private java.math.BigDecimal taxRate; // 税率
	private java.math.BigDecimal monthlyPayment; // 合同付款比例(%)


	private java.math.BigDecimal currentAmounts; // 除税金额（分包商上报：本期）
	private java.math.BigDecimal cumulativeAmounts; // 除税金额（分包商上报：累计）
	private java.math.BigDecimal taxCurrentAmounts; // 含税金额（分包商上报：本期）
	private java.math.BigDecimal taxCumulativeAmounts; // 含税金额（分包商上报：累计）

	private List<SubcontractingvolumedetailVO> subcontractingvolumedetailEntities = new ArrayList<>();
	private List<SubcontractingvolumemdetailVO> subcontractingvolumemdetailEntities = new ArrayList<>();
	private List<SubcontractingvolumeodetailVO> subcontractingvolumeodetailEntities = new ArrayList<>();

	public void setSubcontractingvolumedetailEntities(List<SubcontractingvolumedetailVO> list) {
		this.subcontractingvolumedetailEntities = list;
	}

	public List<SubcontractingvolumedetailVO> getSubcontractingvolumedetailEntities() {
		return subcontractingvolumedetailEntities;
	}

	public void setSubcontractingvolumemdetailEntities(List<SubcontractingvolumemdetailVO> list) {
		this.subcontractingvolumemdetailEntities = list;
	}

	public List<SubcontractingvolumemdetailVO> getSubcontractingvolumemdetailEntities() {
		return subcontractingvolumemdetailEntities;
	}

	public void setSubcontractingvolumeodetailEntities(List<SubcontractingvolumeodetailVO> list) {
		this.subcontractingvolumeodetailEntities = list;
	}

	public List<SubcontractingvolumeodetailVO> getSubcontractingvolumeodetailEntities() {
		return subcontractingvolumeodetailEntities;
	}


	public String getContractType() {
		return contractType;
	}

	public void setContractType(String contractType) {
		this.contractType = contractType;
	}

	public BigDecimal getMonthlyPayment() {
		return monthlyPayment;
	}

	public void setMonthlyPayment(BigDecimal monthlyPayment) {
		this.monthlyPayment = monthlyPayment;
	}

	/**
	 * 税率
	 * @return
	 */
	public BigDecimal getTaxRate() {
		return taxRate;
	}

	/**
	 * 税率
	 * @param taxRate
	 */
	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	/**
	 * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
	 */
	public java.lang.Integer getBillState() {
		return billState;
	}

	/**
	 * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
	 */
	public void setBillState(java.lang.Integer billState) {
		this.billState = billState;
	}

	/**
	 * 合同id
	 */
	@ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
	public java.lang.Long getContractId() {
		return contractId;
	}

	/**
	 * 合同id
	 */
	@ReferDeserialTransfer
	public void setContractId(java.lang.Long contractId) {
		this.contractId = contractId;
	}

	/**
	 * 合同名称
	 */
	public java.lang.String getContractName() {
		return contractName;
	}

	/**
	 * 合同名称
	 */
	public void setContractName(java.lang.String contractName) {
		this.contractName = contractName;
	}

	/**
	 * 项目id
	 */
	@ReferSerialTransfer(referCode = "ejc-zjkj-project")
	public java.lang.Long getProjectId() {
		return projectId;
	}

	/**
	 * 项目id
	 */
	@ReferDeserialTransfer
	public void setProjectId(java.lang.Long projectId) {
		this.projectId = projectId;
	}

	/**
	 * 项目名称
	 */
	public java.lang.String getProjectName() {
		return projectName;
	}

	/**
	 * 项目名称
	 */
	public void setProjectName(java.lang.String projectName) {
		this.projectName = projectName;
	}

	/**
	 * 所属组织id
	 */
	public java.lang.Long getOrgId() {
		return orgId;
	}

	/**
	 * 所属组织id
	 */
	public void setOrgId(java.lang.Long orgId) {
		this.orgId = orgId;
	}

	/**
	 * 所属组织名称
	 */
	public java.lang.String getOrgName() {
		return orgName;
	}

	/**
	 * 所属组织名称
	 */
	public void setOrgName(java.lang.String orgName) {
		this.orgName = orgName;
	}

	/**
	 * 项目部id
	 */
	public java.lang.Long getProjectDepartmentId() {
		return projectDepartmentId;
	}

	/**
	 * 项目部id
	 */
	public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
		this.projectDepartmentId = projectDepartmentId;
	}

	/**
	 * 报量时间
	 */
	public java.util.Date getReportingTime() {
		return reportingTime;
	}

	/**
	 * 报量时间
	 */
	public void setReportingTime(java.util.Date reportingTime) {
		this.reportingTime = reportingTime;
	}

	/**
	 * 经办人id
	 */
	@ReferSerialTransfer(referCode = "idm-user")
	public java.lang.Long getAgentId() {
		return agentId;
	}

	/**
	 * 经办人id
	 */
	@ReferDeserialTransfer
	public void setAgentId(java.lang.Long agentId) {
		this.agentId = agentId;
	}

	/**
	 * 经办人姓名
	 */
	public java.lang.String getAgentName() {
		return agentName;
	}

	/**
	 * 经办人姓名
	 */
	public void setAgentName(java.lang.String agentName) {
		this.agentName = agentName;
	}

	/**
	 * 供方单位id
	 */
	@ReferSerialTransfer(referCode = "support-supplier")
	public java.lang.Long getSupplierId() {
		return supplierId;
	}

	/**
	 * 供方单位id
	 */
	@ReferDeserialTransfer
	public void setSupplierId(java.lang.Long supplierId) {
		this.supplierId = supplierId;
	}

	/**
	 * 供方单位名称
	 */
	public java.lang.String getSupplierName() {
		return supplierName;
	}

	/**
	 * 供方单位名称
	 */
	public void setSupplierName(java.lang.String supplierName) {
		this.supplierName = supplierName;
	}

	/**
	 * 编号
	 */
	public java.lang.String getBillCode() {
		return billCode;
	}

	/**
	 * 编号
	 */
	public void setBillCode(java.lang.String billCode) {
		this.billCode = billCode;
	}

	/**
	 * 其中农民工工资
	 */
	public java.math.BigDecimal getFarmersWages() {
		return farmersWages;
	}

	/**
	 * 其中农民工工资
	 */
	public void setFarmersWages(java.math.BigDecimal farmersWages) {
		this.farmersWages = farmersWages;
	}

	/**
	 * 其中累计农民工工资
	 */
	public java.math.BigDecimal getCumulativeFarmersWages() {
		return cumulativeFarmersWages;
	}

	/**
	 * 其中累计农民工工资
	 */
	public void setCumulativeFarmersWages(java.math.BigDecimal cumulativeFarmersWages) {
		this.cumulativeFarmersWages = cumulativeFarmersWages;
	}

	/**
	 * 完成形象部位
	 */
	public java.lang.String getFinishedPart() {
		return finishedPart;
	}

	/**
	 * 完成形象部位
	 */
	public void setFinishedPart(java.lang.String finishedPart) {
		this.finishedPart = finishedPart;
	}

	/**
	 * 备注
	 */
	public java.lang.String getRemarks() {
		return remarks;
	}

	/**
	 * 备注
	 */
	public void setRemarks(java.lang.String remarks) {
		this.remarks = remarks;
	}

	/**
	 * 本期合计
	 */
	public java.math.BigDecimal getTaxCurrentTotal() {
		return taxCurrentTotal;
	}

	/**
	 * 本期合计
	 */
	public void setTaxCurrentTotal(java.math.BigDecimal taxCurrentTotal) {
		this.taxCurrentTotal = taxCurrentTotal;
	}

	/**
	 * 累计合计
	 */
	public java.math.BigDecimal getTaxCumulativeTotal() {
		return taxCumulativeTotal;
	}

	/**
	 * 累计合计
	 */
	public void setTaxCumulativeTotal(java.math.BigDecimal taxCumulativeTotal) {
		this.taxCumulativeTotal = taxCumulativeTotal;
	}

	/**
	 * 扣款金额
	 */
	public java.math.BigDecimal getTaxDeductionAmount() {
		return taxDeductionAmount;
	}

	/**
	 * 扣款金额
	 */
	public void setTaxDeductionAmount(java.math.BigDecimal taxDeductionAmount) {
		this.taxDeductionAmount = taxDeductionAmount;
	}

	/**
	 * 本期合同内金额
	 */
	public java.math.BigDecimal getTaxCurrentContract() {
		return taxCurrentContract;
	}

	/**
	 * 本期合同内金额
	 */
	public void setTaxCurrentContract(java.math.BigDecimal taxCurrentContract) {
		this.taxCurrentContract = taxCurrentContract;
	}

	/**
	 * 累计合同内金额
	 */
	public java.math.BigDecimal getTaxCumulativeContract() {
		return taxCumulativeContract;
	}

	/**
	 * 累计合同内金额
	 */
	public void setTaxCumulativeContract(java.math.BigDecimal taxCumulativeContract) {
		this.taxCumulativeContract = taxCumulativeContract;
	}

	/**
	 * 本期合同外金额
	 */
	public java.math.BigDecimal getTaxCurrentContractout() {
		return taxCurrentContractout;
	}

	/**
	 * 本期合同外金额
	 */
	public void setTaxCurrentContractout(java.math.BigDecimal taxCurrentContractout) {
		this.taxCurrentContractout = taxCurrentContractout;
	}

	/**
	 * 累计合同外金额
	 */
	public java.math.BigDecimal getTaxCumulativeContractout() {
		return taxCumulativeContractout;
	}

	/**
	 * 累计合同外金额
	 */
	public void setTaxCumulativeContractout(java.math.BigDecimal taxCumulativeContractout) {
		this.taxCumulativeContractout = taxCumulativeContractout;
	}

	/**
	 * 本期合计
	 */
	public java.math.BigDecimal getCurrentTotal() {
		return currentTotal;
	}

	/**
	 * 本期合计
	 */
	public void setCurrentTotal(java.math.BigDecimal currentTotal) {
		this.currentTotal = currentTotal;
	}

	/**
	 * 累计合计
	 */
	public java.math.BigDecimal getCumulativeTotal() {
		return cumulativeTotal;
	}

	/**
	 * 累计合计
	 */
	public void setCumulativeTotal(java.math.BigDecimal cumulativeTotal) {
		this.cumulativeTotal = cumulativeTotal;
	}

	/**
	 * 扣款金额
	 */
	public java.math.BigDecimal getDeductionAmount() {
		return deductionAmount;
	}

	/**
	 * 扣款金额
	 */
	public void setDeductionAmount(java.math.BigDecimal deductionAmount) {
		this.deductionAmount = deductionAmount;
	}

	/**
	 * 本期合同内金额
	 */
	public java.math.BigDecimal getCurrentContract() {
		return currentContract;
	}

	/**
	 * 本期合同内金额
	 */
	public void setCurrentContract(java.math.BigDecimal currentContract) {
		this.currentContract = currentContract;
	}

	/**
	 * 累计合同内金额
	 */
	public java.math.BigDecimal getCumulativeContract() {
		return cumulativeContract;
	}

	/**
	 * 累计合同内金额
	 */
	public void setCumulativeContract(java.math.BigDecimal cumulativeContract) {
		this.cumulativeContract = cumulativeContract;
	}

	/**
	 * 本期合同外金额
	 */
	public java.math.BigDecimal getCurrentContractout() {
		return currentContractout;
	}

	/**
	 * 本期合同外金额
	 */
	public void setCurrentContractout(java.math.BigDecimal currentContractout) {
		this.currentContractout = currentContractout;
	}

	/**
	 * 累计合同外金额
	 */
	public java.math.BigDecimal getCumulativeContractout() {
		return cumulativeContractout;
	}

	/**
	 * 累计合同外金额
	 */
	public void setCumulativeContractout(java.math.BigDecimal cumulativeContractout) {
		this.cumulativeContractout = cumulativeContractout;
	}

	/**
	 * 形象部位确认及工期(生产经理)
	 */
	public java.lang.String getPositionConfirmation() {
		return positionConfirmation;
	}

	/**
	 * 形象部位确认及工期(生产经理)
	 */
	public void setPositionConfirmation(java.lang.String positionConfirmation) {
		this.positionConfirmation = positionConfirmation;
	}

	/**
	 * 质量(质量工程师)
	 */
	public java.lang.String getQuality() {
		return quality;
	}

	/**
	 * 质量(质量工程师)
	 */
	public void setQuality(java.lang.String quality) {
		this.quality = quality;
	}

	/**
	 * 安全(安全工程师)
	 */
	public java.lang.String getSecurity() {
		return security;
	}

	/**
	 * 安全(安全工程师)
	 */
	public void setSecurity(java.lang.String security) {
		this.security = security;
	}

	/**
	 * 材料实际消耗(物资工程师)
	 */
	public java.lang.String getMaterialConsumption() {
		return materialConsumption;
	}

	/**
	 * 材料实际消耗(物资工程师)
	 */
	public void setMaterialConsumption(java.lang.String materialConsumption) {
		this.materialConsumption = materialConsumption;
	}

	/**
	 * 各项扣款项(会计)
	 */
	public java.lang.String getVariousDeductions() {
		return variousDeductions;
	}

	/**
	 * 各项扣款项(会计)
	 */
	public void setVariousDeductions(java.lang.String variousDeductions) {
		this.variousDeductions = variousDeductions;
	}

	/**
	 * 核实相关工作(项目总工)
	 */
	public java.lang.String getVerificationWork() {
		return verificationWork;
	}

	/**
	 * 核实相关工作(项目总工)
	 */
	public void setVerificationWork(java.lang.String verificationWork) {
		this.verificationWork = verificationWork;
	}

	/**
	 * 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
	 */
	public java.lang.String getVerifyOtherWork() {
		return verifyOtherWork;
	}

	/**
	 * 核实本月分包经济签证月清单确认单、确认工程量、各部门奖罚、转扣或分摊费用等(商务经理)
	 */
	public void setVerifyOtherWork(java.lang.String verifyOtherWork) {
		this.verifyOtherWork = verifyOtherWork;
	}

	public String getReportingTimeShow() {
		return reportingTimeShow;
	}

	public void setReportingTimeShow(String reportingTimeShow) {
		this.reportingTimeShow = reportingTimeShow;
	}

	public String getBillStateStr() {
		return billStateStr;
	}

	public void setBillStateStr(String billStateStr) {
		this.billStateStr = billStateStr;
	}
	public String getSort() {
		return sort;
	}

	public void setSort(String sort) {
		this.sort = sort;
	}

	public Integer getIsReference() {
		return isReference;
	}

	public void setIsReference(Integer isReference) {
		this.isReference = isReference;
	}

	public String getReferenceCode() {
		return referenceCode;
	}

	public void setReferenceCode(String referenceCode) {
		this.referenceCode = referenceCode;
	}

	public BigDecimal getCurrentAmounts() {
		return currentAmounts;
	}

	public void setCurrentAmounts(BigDecimal currentAmounts) {
		this.currentAmounts = currentAmounts;
	}

	public BigDecimal getCumulativeAmounts() {
		return cumulativeAmounts;
	}

	public void setCumulativeAmounts(BigDecimal cumulativeAmounts) {
		this.cumulativeAmounts = cumulativeAmounts;
	}

	public BigDecimal getTaxCurrentAmounts() {
		return taxCurrentAmounts;
	}

	public void setTaxCurrentAmounts(BigDecimal taxCurrentAmounts) {
		this.taxCurrentAmounts = taxCurrentAmounts;
	}

	public BigDecimal getTaxCumulativeAmounts() {
		return taxCumulativeAmounts;
	}

	public void setTaxCumulativeAmounts(BigDecimal taxCumulativeAmounts) {
		this.taxCumulativeAmounts = taxCumulativeAmounts;
	}
}
