package com.ejianc.business.middlemeasurement.controller.api;

import com.ejianc.business.middlemeasurement.service.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author yupengjie
 * @createDate 2023/1/12
 * @description Api做为成本分析模块对涉及单据的数据归集状态操作 包括更新归集状态 以及查询是否归集
 */
@RestController
@RequestMapping("/api/midSettlementStateApi")
public class MidSettlementStateApiController {
    /**分包月度报量*/
    @Resource
    private ISubcontractingvolumeService subcontractingvolumeService;
    /**工程计量台账*/
    @Resource
    private IEngineermeasurementService engineermeasurementService;
    /**分包月度报量台账*/
    @Resource
    private ISubcontractaccountService subcontractaccountService;
    /**月度物资采购结算汇总*/
    @Resource
    private IPurchasesummaryService purchasesummaryService;
    /**月度机械设备租赁结算汇总*/
    @Resource
    private IMechanicalleasedetotalService mechanicalleasedetotalService;
    /**月度周转工具租赁费结算汇总*/
    @Resource
    private IRevolvingleasesummaryService revolvingleasesummaryService;
    /**月度周转租赁单*/
    @Resource
    private IRevolvingleaseService revolvingleaseService;
    /**设计过程结算单*/
    @Resource
    private IDesignsubcontractnodeService designsubcontractnodeService;
    /**咨询过程结算单*/
    @Resource
    private IConsultotherService consultotherService;
    /**月度机械设备租赁单*/
    @Resource
    private IMechanicalleaseService mechanicalleaseService;

    /**
     * 成本管理坐月度成本分析更新所有涉及的中间计量的单据为：
     * 工程计量台账
     * 分包月度报量台账
     * 月度物资采购结算汇总
     * 月度机械设备租赁结算汇总
     * 月度周转工具租赁费结算汇总
     * 分包月度报量及申请报告
     * 月度周转租赁单
     * 设计过程结算单
     * 咨询过程结算单
     * 月度机械设备租赁单
     * 更新所有涉及单据的归集状态字段数据
     * @param projectId 项目id
     * @param state    归集状态
     * @param monthStr 要归集单据数据的时间范围
     * @return
     * @createDate 2023/1/12
     * @author yupengjie
     */
    @Transactional(rollbackFor = Exception.class)
    @RequestMapping(value = "/updateMidSettlementState", method = RequestMethod.GET)
    public CommonResponse<String> updateMidSettlementState(Long projectId, Integer state, String monthStr) {
        subcontractingvolumeService.updateSettlementState(projectId,state,monthStr);
        engineermeasurementService.updateSettlementState(projectId,state,monthStr);
        subcontractaccountService.updateSettlementState(projectId,state,monthStr);
        purchasesummaryService.updateSettlementState(projectId,state,monthStr);
        mechanicalleasedetotalService.updateSettlementState(projectId,state,monthStr);
        revolvingleasesummaryService.updateSettlementState(projectId,state,monthStr);
        revolvingleaseService.updateSettlementState(projectId,state,monthStr);
        designsubcontractnodeService.updateSettlementState(projectId,state,monthStr);
        consultotherService.updateSettlementState(projectId,state,monthStr);
        mechanicalleaseService.updateSettlementState(projectId,state,monthStr);
        return CommonResponse.success("更新归集状态成功");
    }
    /***
     * @Description //TODO  查询校验月度成本分析涉及的中间计量的单据是否有未归集的数据
     * 成本管理坐月度成本分析更新所有涉及的中间计量的单据为：
     * 工程计量台账
     * 分包月度报量台账
     * 月度物资采购结算汇总
     * 月度机械设备租赁结算汇总
     * 月度周转工具租赁费结算汇总
     * 分包月度报量及申请报告
     * 月度周转租赁单
     * 设计过程结算单
     * 咨询过程结算单
     * 月度机械设备租赁单
     * @param projectId  项目id
     * @param monthStr    要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/queryIsSettlement", method = RequestMethod.GET)
    public CommonResponse<String> queryIsSettlement(Long projectId, String monthStr) {
        subcontractingvolumeService.queryIsSettlement(projectId,monthStr);
        engineermeasurementService.queryIsSettlement(projectId,monthStr);
        subcontractaccountService.queryIsSettlement(projectId,monthStr);
        purchasesummaryService.queryIsSettlement(projectId,monthStr);
        mechanicalleasedetotalService.queryIsSettlement(projectId,monthStr);
        revolvingleasesummaryService.queryIsSettlement(projectId,monthStr);
        revolvingleaseService.queryIsSettlement(projectId,monthStr);
        designsubcontractnodeService.queryIsSettlement(projectId,monthStr);
        consultotherService.queryIsSettlement(projectId,monthStr);
        mechanicalleaseService.queryIsSettlement(projectId,monthStr);
        return CommonResponse.success();
    }

}
