package com.ejianc.business.middlemeasurement.excel;


import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 月度物资采购结算导入导出
 */
@Controller
@RequestMapping("purchasesettlementExport")
public class ExcelPurchasesettlementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPurchasesettlement")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "purchasesettlementdetail-import.xlsx", "月度物资采购结算模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPurchasesettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PurchasesettlementdetailVO> successList = new ArrayList<>();
        List<PurchasesettlementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Map<String, String> map = new HashMap<>();
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                     int errorCount =0;
                    List<String> datas = result.get(i);
                    PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                    purchasesettlementdetailVO.setId(IdWorker.getId());//id
                    purchasesettlementdetailVO.setSource(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 来源

                   // StringBuffer errorBuffer = new StringBuffer();
                    if (datas.get(1) == null && StringUtils.isBlank(datas.get(1))) {
                        purchasesettlementdetailVO.setErrorMsg("'材料编码'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 材料编码
                    }

                    if (StringUtils.isBlank(datas.get(2)) && datas.get(2) == null) {
                        purchasesettlementdetailVO.setErrorMsg("'材料名称'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 材料名称
                    }

                    if (StringUtils.isBlank(datas.get(3)) && datas.get(3) == null) {
                        purchasesettlementdetailVO.setErrorMsg("'品牌/规格型号'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }else{
                        purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 品牌/规格型号
                    }

                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(1));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        purchasesettlementdetailVO.setErrorMsg("未查询到该材料编码下的物资详情");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }

                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(2))) {
                            purchasesettlementdetailVO.setErrorMsg("'材料名称'未在库中,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(3))) {
                            purchasesettlementdetailVO.setErrorMsg("'品牌/规格型号'未在库中,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(4))) {
                            purchasesettlementdetailVO.setErrorMsg("'单位'未在库中,请检查！");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                            continue;
                        }
                    }else{
                        purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 单位
                    }


                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(3) != null && StringUtils.isNotBlank(datas.get(3))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
//                    if (map.containsKey(materConcat.toString())) {
//                        purchasesettlementdetailVO.setErrorMsg("'材料编码','材料名称','品牌/规格型号','单位不能重复'");
//                        errorCount++;
//                        errorList.add(purchasesettlementdetailVO);
//                        continue;
//                    } else {
                        map.put(materConcat.toString(), materConcat.toString());
//                    }

                    purchasesettlementdetailVO.setBillCode(back0.getData().getCode());
                    purchasesettlementdetailVO.setBillName(back0.getData().getName());
                    purchasesettlementdetailVO.setBrandModel(back0.getData().getSpec());
                    purchasesettlementdetailVO.setUnit(back0.getData().getUnitName());

                    purchasesettlementdetailVO.setMaterialCategoryId(back0.getData().getCategoryId());
                    purchasesettlementdetailVO.setMaterialCategoryCode(back0.getData().getCode());
                    purchasesettlementdetailVO.setMaterialCategory(back0.getData().getCategoryName());

                    BigDecimal supplyNumber = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(5)) || datas.get(5) == null){
                        purchasesettlementdetailVO.setErrorMsg("'供货数量'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(5))){
                            purchasesettlementdetailVO.setErrorMsg("'供货数量'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            supplyNumber = supplyNumber.add(new BigDecimal(datas.get(5)));
                            purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 供货数量
                        }
                    }

                    if(StringUtils.isBlank(datas.get(6)) || datas.get(6) == null){
                        purchasesettlementdetailVO.setErrorMsg("'供货时间'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (DateUtils.grepDate(datas.get(6))) {
                            purchasesettlementdetailVO.setErrorMsg("'供货时间'格式到月份");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank(datas.get(6)) ?  DateUtils.Dates(datas.get(6)) : null); //供货时间
                        }
                    }
                    if(StringUtils.isBlank(datas.get(7)) || datas.get(7) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(7))) {
                            purchasesettlementdetailVO.setErrorMsg("'网价'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setNetPrice(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 网价(元)
                        }
                    }
                    if(StringUtils.isBlank(datas.get(8)) || datas.get(8) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(8))) {
                            purchasesettlementdetailVO.setErrorMsg("'浮动价'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setFloatPrice(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 浮动价(元)
                        }
                    }

                    if(StringUtils.isBlank(datas.get(9)) || datas.get(9) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'不能为空");
                        errorBuffer.append("'合同单价除税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(9))) {
                            purchasesettlementdetailVO.setErrorMsg("'合同单价除税(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 合同单价除税(元)
                        }
                    }


                    if(StringUtils.isBlank(datas.get(10)) || datas.get(10) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'合同单价含税(元)'不能为空");
                        errorBuffer.append("'合同单价含税(元)'不能为空");*/
                    }else{
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            purchasesettlementdetailVO.setErrorMsg("'合同单价含税(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 合同单价含税(元)
                        }
                    }


                    BigDecimal exPrice = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(11)) || datas.get(11) == null){
                        purchasesettlementdetailVO.setErrorMsg("'结算单价(除税)(元)'不能为空");
                        errorCount++;
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (!NumberUtil.isNumber(datas.get(11))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算单价(除税)(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            exPrice = exPrice.add(new BigDecimal(datas.get(11)));
                            purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 结算单价(除税)(元)
                        }
                    }

                    BigDecimal inPrice = new BigDecimal(0);
                    if(StringUtils.isBlank(datas.get(12)) || datas.get(12) == null){
                        purchasesettlementdetailVO.setErrorMsg("'结算单价(含税)(元)'不能为空");
                        errorList.add(purchasesettlementdetailVO);
                    }else{
                        if (!NumberUtil.isNumber(datas.get(12))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算单价(含税)(元)'格式错误");
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            inPrice = inPrice.add(new BigDecimal(datas.get(12)));
                            purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); // 结算单价(含税)(元)
                        }
                    }

                    if(StringUtils.isBlank(datas.get(13)) || datas.get(13) == null){
                       /* purchasesettlementdetailVO.setErrorMsg("'结算金额(除税)(元)'不能为空");
                        errorBuffer.append("'结算金额(除税)(元)'不能为空");*/
                        BigDecimal settlementAmout = supplyNumber.multiply(exPrice);
                        purchasesettlementdetailVO.setSettlementAmount(settlementAmout);
                    }else{
                        if (!NumberUtil.isNumber(datas.get(13))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算金额(除税)(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setSettlementAmount(new BigDecimal(datas.get(13))); //  结算金额(除税)(元)
                        }
                    }

                    if(StringUtils.isBlank(datas.get(14)) || datas.get(14) == null){
                        /*purchasesettlementdetailVO.setErrorMsg("'结算金额(含税)(元)'不能为空");
                        errorBuffer.append("'结算金额(含税)(元)'不能为空");*/
                        BigDecimal taxSettlementAmout = supplyNumber.multiply(inPrice);
                        purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmout); //  结算金额(含税)(元)
                    }else{
                        if (!NumberUtil.isNumber(datas.get(14))) {
                            purchasesettlementdetailVO.setErrorMsg("'结算金额(含税)(元)'格式错误");
                            errorCount++;
                            errorList.add(purchasesettlementdetailVO);
                        }else{
                            purchasesettlementdetailVO.setTaxSettlementAmount( new BigDecimal(datas.get(14))); //  结算金额(含税)(元)
                        }
                    }

                    purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(15)) ?datas.get(15) : null); // 备注
                    if(errorCount==0){
                        successList.add(purchasesettlementdetailVO);
                    }
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper<PurchasesettlementdetailEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("mid", purchasesettlementVO.getId());
        queryWrapper.eq("dr", 0);
        List<PurchasesettlementdetailEntity> list = purchasesettlementdetailService.list(queryWrapper);
        List<PurchasesettlementdetailVO> purchasesettlementdetailVOList = BeanMapper.mapList(list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = purchasesettlementdetailVOList.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    String sdates = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                    purchasesettlementdetailVO.setSupplyTimeShow(sdates);

                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    String sdate = DateUtils.dateSimple3(purchasesettlementdetailVO.getSupplyTime());
                    purchasesettlementdetailVO.setSupplyTimeShow(sdate);
                }

            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

}
