package com.ejianc.business.middlemeasurement.excel;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountdetailEntity;
import com.ejianc.business.middlemeasurement.service.IVisaclaimaccountdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountVO;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 总包签证索赔导入导出
 */
@Controller
@RequestMapping("visaclaimaccountExport")
public class ExcelVisaclaimaccountController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IVisaclaimaccountdetailService visaclaimaccountdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadVisaclaimaccount")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "visaclaimaccountdetail-import.xlsx", "总包签证索赔台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportVisaclaimaccount", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<VisaclaimaccountdetailVO> successList = new ArrayList<>();
        List<VisaclaimaccountdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    int num = 0;
                    List<String> datas = result.get(i);
                    VisaclaimaccountdetailVO visaclaimaccountdetailVO = new VisaclaimaccountdetailVO();
                    visaclaimaccountdetailVO.setId(IdWorker.getId());//id

                    if (datas.get(0) == null || StringUtils.isBlank(datas.get(0))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'变更内容'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setChangeContent(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 变更内容
                    }

                    if (datas.get(1) == null || StringUtils.isBlank(datas.get(1))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'存档部门'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setDepartmentName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 存档部门
                    }

                    if (datas.get(2) == null || StringUtils.isBlank(datas.get(2))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'变更编号'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setChangeCode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 变更编号
                    }

                    if (datas.get(3) == null || StringUtils.isBlank(datas.get(3))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'合同议价依据'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setBargainingBasist(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 合同议价依据
                    }


                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        if (!DateUtils.grepDate(datas.get(4))) {
                            String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'我方报送时间(合同约定)'格式错误！";
                            visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            visaclaimaccountdetailVO.setContractSubmissionDate(StringUtils.isNotBlank(datas.get(4)) ? DateUtils.Date(datas.get(4)) : null); // 我方报送时间(合同约定)
                        }
                    } else {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送时间(合同约定)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(5) != null && StringUtils.isNotBlank(datas.get(5))) {
                        if (!DateUtils.grepDate(datas.get(5))) {
                            String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                            if (errorMessage == null) errorMessage = "";
                            errorMessage +="'我方报送时间(实际报送)'格式错误！";
                            visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            visaclaimaccountdetailVO.setActualSubmissionDate(StringUtils.isNotBlank(datas.get(5)) ? DateUtils.Date(datas.get(5)) : null); // 我方报送时间(实际报送)
                        }
                    } else {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送时间(实际报送)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(6) == null || StringUtils.isBlank(datas.get(6))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送金额(除税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setExSubmittedAmount(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); //我方报送金额(除税)(元)
                    }

                    if (datas.get(7) == null || StringUtils.isBlank(datas.get(7))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'我方报送金额(含税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setInSubmittedAmount(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 我方报送金额(含税)(元)
                    }

                    if (datas.get(8) == null || StringUtils.isBlank(datas.get(8))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'对方确认金额(除税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setExConfirmedAmount(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 对方确认金额(除税)(元)
                    }

                    if (datas.get(9) == null || StringUtils.isBlank(datas.get(9))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'对方确认金额(含税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setInConfirmedAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 对方确认金额(含税)(元)
                    }

                    if (datas.get(10) != null && StringUtils.isNotBlank(datas.get(10))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付时间(当期或结算)'格式错误！";
                        if (!DateUtils.grepDate(datas.get(10))) {
                            visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                            num++;
                        } else {
                            visaclaimaccountdetailVO.setDueDate(StringUtils.isBlank(datas.get(10)) ? null : DateUtils.Date(datas.get(10))); // 应付时间(当期或结算)
                        }
                    } else {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付时间(当期或结算)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    }

                    if (datas.get(11) == null || StringUtils.isBlank(datas.get(11))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付金额(除税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setExPayableAmount(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); //  应付金额(除税)(元)
                    }

                    if (datas.get(12) == null || StringUtils.isBlank(datas.get(12))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'应付金额(含税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setInPayableAmount(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  应付金额(含税)(元)
                    }

                    if (datas.get(13) == null || StringUtils.isBlank(datas.get(13))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'实付金额(除税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setExPaidinAmount(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); // 实付金额(除税)(元)
                    }

                    if (datas.get(14) == null || StringUtils.isBlank(datas.get(14))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'实付金额(含税)(元)'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setInPaidinAmount(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 实付金额(含税)(元)
                    }

                    if (StringUtils.isNotBlank(datas.get(15)) && datas.get(15) != null && !NumberUtil.isNumber(datas.get(15))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'涉及工期变更天数'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setChangeDate(Integer.valueOf(Integer.valueOf((int) Float.parseFloat(datas.get(15))))); // 涉及工期变更天数
                    }

                    if (StringUtils.isNotBlank(datas.get(16)) && datas.get(16) != null && !NumberUtil.isNumber(datas.get(16))) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'发包人认可工期顺延天数'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setDeferredDays(StringUtils.isNotBlank(datas.get(16)) ? Integer.valueOf((int) Float.parseFloat(datas.get(16))) : null); // 发包人认可工期顺延天数
                    }

                    if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                        String errorMessage = visaclaimaccountdetailVO.getErrorMsg();
                        if (errorMessage == null) errorMessage = "";
                        errorMessage +="'责任人'不能为空！";
                        visaclaimaccountdetailVO.setErrorMsg(errorMessage);
                        num++;
                    } else {
                        visaclaimaccountdetailVO.setPersonLiable(StringUtils.isNotBlank(datas.get(17)) ? (datas.get(17)) : null); // 责任人
                    }

                    visaclaimaccountdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(18)) ? datas.get(18) : null); // 备注
                    if (num > 0){
                        errorList.add(visaclaimaccountdetailVO);
                    }else{
                        successList.add(visaclaimaccountdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportVisaclaimaccountFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody VisaclaimaccountVO visaclaimaccountVO, HttpServletResponse response) {
        QueryWrapper<VisaclaimaccountdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", visaclaimaccountVO.getId());
        queryWrapper.eq("dr", 0);
        List<VisaclaimaccountdetailEntity> list = visaclaimaccountdetailService.list(queryWrapper);
        List<VisaclaimaccountdetailVO> visaclaimaccountdetailVOList = BeanMapper.mapList(list, VisaclaimaccountdetailVO.class);
        if (visaclaimaccountdetailVOList != null && visaclaimaccountdetailVOList.size() > 0) {
            for (int i = 0; i < visaclaimaccountdetailVOList.size(); i++) {
                VisaclaimaccountdetailVO visaclaimaccountdetailVO = visaclaimaccountdetailVOList.get(i);
                visaclaimaccountdetailVO.setSort(String.valueOf(i + 1));
                if (visaclaimaccountdetailVO.getContractSubmissionDate() != null) {
                    visaclaimaccountdetailVO.setContractSubmissionDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getContractSubmissionDate()));
                }
                if (visaclaimaccountdetailVO.getActualSubmissionDate() != null) {
                    visaclaimaccountdetailVO.setActualSubmissionDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getActualSubmissionDate()));
                }
                if (visaclaimaccountdetailVO.getDueDate() != null) {
                    visaclaimaccountdetailVO.setDueDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getDueDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", visaclaimaccountdetailVOList);
        ExcelExport.getInstance().export("visaclaimaccountdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportVisaclaimaccountFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<VisaclaimaccountdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                VisaclaimaccountdetailVO visaclaimaccountdetailVO = list.get(i);
                visaclaimaccountdetailVO.setSort(String.valueOf(i + 1));
                if (visaclaimaccountdetailVO.getContractSubmissionDate() != null) {
                    visaclaimaccountdetailVO.setContractSubmissionDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getContractSubmissionDate()));
                }
                if (visaclaimaccountdetailVO.getActualSubmissionDate() != null) {
                    visaclaimaccountdetailVO.setActualSubmissionDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getActualSubmissionDate()));
                }
                if (visaclaimaccountdetailVO.getDueDate() != null) {
                    visaclaimaccountdetailVO.setDueDateShow(DateUtils.dateSimple(visaclaimaccountdetailVO.getDueDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("visaclaimaccountdetail-export.xlsx", beans, response);
    }

}
