package com.ejianc.business.middlemeasurement.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummaryEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.mapper.SubcontractaccountMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;

import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;

/**
 * 分包月度报量台账
 * 
 * @author generator
 * 
 */
@Service("subcontractaccountService")
public class SubcontractaccountServiceImpl extends BaseServiceImpl<SubcontractaccountMapper, SubcontractaccountEntity>
		implements ISubcontractaccountService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubcontractaccountService service;
	@Override
	public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
		boolean flag = true;
		QueryWrapper<SubcontractaccountEntity> query = new QueryWrapper();
		query.eq("project_id",projectId);
		query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
		List<SubcontractaccountEntity> list = service.list(query);
		if (!list.isEmpty()){
			for (SubcontractaccountEntity entity : list) {
				entity.setIsSettlement(state);
			}
			flag = service.updateBatchById(list);
		}
		return flag;
	}

	@Override
	public boolean queryIsSettlement(Long projectId, String monthStr) {
		logger.info("查询分包月度报量及申请报告月份传参{}"+monthStr);
		logger.info("查询分包月度报量及申请报告项目id传参{}"+projectId);
		LambdaQueryWrapper<SubcontractaccountEntity> query = new LambdaQueryWrapper<SubcontractaccountEntity>()
				.eq(SubcontractaccountEntity::getProjectId, projectId)
				.apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
				.and(qw -> qw.isNull(SubcontractaccountEntity::getIsSettlement)
						.or().eq(SubcontractaccountEntity::getIsSettlement, 0));
		int count = service.count(query);
		if (count > 0) throw new BusinessException("分包月度报量台账有往期未归集的数据");
		LambdaQueryWrapper<SubcontractaccountEntity> query1 = new LambdaQueryWrapper<SubcontractaccountEntity>()
				.eq(SubcontractaccountEntity::getProjectId, projectId)
				.ne(SubcontractaccountEntity::getBillState, 3)
				.ne(SubcontractaccountEntity::getBillState, 1)
				.apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
		int count1 = service.count(query1);
		if (count1 > 0) throw new BusinessException("分包月度报量台账有本期审批未通过的数据");
		return true;
	}
}
