package com.ejianc.business.middlemeasurement.mapper;

import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;

import java.util.List;

/**
 * 设计分包节点报量申请
 * 
 * @author generator
 * 
 */
@Mapper
public interface DesignsubcontractnodeMapper extends BaseCrudMapper<DesignsubcontractnodeEntity> {
    /**
     * 根据合同id查询设计分包节点申请报量合价和金额
     * @param projectId
     * @return
     */
    List<CostManageVO> queryDesign(Long projectId,String monthStr);

    /**
     * 根据合同id和月份查询计分包节点申请报量合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */

    List<CostManageVO> queryDesignMonth(Long projectId,String monthStr);

    /**
     * 根据合同id和结算日期查询往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<DesignSettlementDetailVO> queryDesignDetailCumPast(Long contractId, String date);
}
