package com.ejianc.business.middlemeasurement.service;

import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookMaterialDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookOtherDetailVO;
import com.ejianc.foundation.middlemeasurement.vo.SettlementBookStatementDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 分包月度报量及申请报告
 * 
 * @author generator
 * 
 */
public interface ISubcontractingvolumeService extends IBaseService<SubcontractingvolumeEntity> {
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的汇总数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookStatementDetailVO> querySubcontractingvolumeDetailByContractId(Long contractId);
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的物资超用扣款明细数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookMaterialDetailVO> querySubcontractingvolumeMaterialByContractId(Long contractId);
    /**
     * 根据合同id查询以往所有的分包月度报量及申请报告的其他扣款数据
     * @param contractId 合同id
     * @return
     */
    List<SettlementBookOtherDetailVO> querySubcontractingvolumeOtherByContractId(Long contractId);

    /**
     * 更新单据数据的归集状态
     * @param projectId  项目id
     * @param state     状态
     * @return
     */
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);
}
