/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedataService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleaseVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"mechanicallease"})
public class MechanicalleaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-mechanicallease";
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMechanicalleasedataService dataService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> saveOrUpdate(@RequestBody MechanicalleaseVO saveorUpdateVO) {
        List pro;
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), MechanicalleaseEntity.class));
        entity.setSaveTime(new Date());
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                Date currentDate = new Date(System.currentTimeMillis());
                if (saveorUpdateVO.getCreateTime() != null) {
                    currentDate = saveorUpdateVO.getCreateTime();
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setIsReference(0);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u6708\u5ea6\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5355\"!");
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        MechanicalleaseVO pastVo = this.getPastTotal(saveorUpdateVO.getContractId(), currentDate, true);
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (saveorUpdateVO.getExTaxCumulative() != null && saveorUpdateVO.getExTaxThisMonthTotal() != null) {
            occurrenceTotal = saveorUpdateVO.getExTaxThisMonthTotal().add(pastVo.getExTaxCumulative());
        }
        if (saveorUpdateVO.getInTaxCumulative() != null && saveorUpdateVO.getInTaxThisMonthTotal() != null) {
            taxOccurrenceTotal = saveorUpdateVO.getInTaxThisMonthTotal().add(pastVo.getInTaxCumulative());
        }
        entity.setExTaxCumulative(occurrenceTotal);
        entity.setInTaxCumulative(taxOccurrenceTotal);
        List<MechanicalleasedetailVO> voMechanicalleasedetailEntities = saveorUpdateVO.getMechanicalleasedetailEntities();
        List<MechanicalleasedetailVO> mechanicalleasedetailVOList = pastVo.getMechanicalleasedetailEntities();
        if (voMechanicalleasedetailEntities != null && mechanicalleasedetailVOList != null) {
            for (int i = 0; i < voMechanicalleasedetailEntities.size(); ++i) {
                MechanicalleasedetailVO mechanicalleasedetail = voMechanicalleasedetailEntities.get(i);
                String equipmentCode = mechanicalleasedetail.getEquipmentCode();
                BigDecimal saveMonthlyExpenses = mechanicalleasedetail.getExTaxSettlementMonth();
                BigDecimal saveTaxMonthlyExpenses = mechanicalleasedetail.getInTaxSettlementMonth();
                for (int j = 0; j < mechanicalleasedetailVOList.size(); ++j) {
                    MechanicalleasedetailVO mechanicalleasedetailVO = mechanicalleasedetailVOList.get(j);
                    String equipmentCodes = mechanicalleasedetailVO.getEquipmentCode();
                    if (!equipmentCodes.equals(equipmentCode)) continue;
                    if (mechanicalleasedetailVO.getExTaxSettlementMonth() != null) {
                        BigDecimal monthlyExpenses = mechanicalleasedetailVO.getExTaxSettlementMonth();
                        if (saveMonthlyExpenses != null) {
                            saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses);
                        }
                    }
                    if (mechanicalleasedetailVO.getInTaxSettlementMonth() == null) continue;
                    BigDecimal taxMonthlyExpenses = mechanicalleasedetailVO.getInTaxSettlementMonth();
                    if (saveTaxMonthlyExpenses == null) continue;
                    saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses);
                }
                mechanicalleasedetail.setBillCode(entity.getBillCode());
                mechanicalleasedetail.setProjectId(entity.getProjectId());
                mechanicalleasedetail.setProjectName(entity.getProjectName());
                mechanicalleasedetail.setSettlementTime(entity.getSettlementTime());
                mechanicalleasedetail.setExTaxCumulative(saveMonthlyExpenses);
                mechanicalleasedetail.setInTaxCumulative(saveTaxMonthlyExpenses);
            }
            entity.setMechanicalleasedetailEntities(BeanMapper.mapList(voMechanicalleasedetailEntities, MechanicalleasedetailEntity.class));
        }
        entity.setSaveTime(currentDate);
        this.service.saveOrUpdate((Object)entity, false);
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> queryDetail(Long id) {
        MechanicalleaseEntity entity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
        MechanicalleaseVO vo = (MechanicalleaseVO)((Object)BeanMapper.map((Object)((Object)entity), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleaseVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)list, MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); ++i) {
            String billStateStr;
            MechanicalleaseVO mechanicalleaseVO = (MechanicalleaseVO)((Object)mechanicalleaseVOList.get(i));
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            if (mechanicalleaseVO.getSettlementTime() != null) {
                mechanicalleaseVO.setSettlementTime((Date)DateUtil.date((Date)mechanicalleaseVO.getSettlementTime()));
            }
            if (mechanicalleaseVO.getBillingStartTime() != null) {
                mechanicalleaseVO.setBillingStartTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingStartTime()));
            }
            if (mechanicalleaseVO.getBillingEndTime() != null) {
                mechanicalleaseVO.setBillingEndTime((Date)DateUtil.date((Date)mechanicalleaseVO.getBillingEndTime()));
            }
            if ((billStateStr = mechanicalleaseVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            mechanicalleaseVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", mechanicalleaseVOList);
        ExcelExport.getInstance().export("mechanicalleaseList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMechanicalleaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> refMechanicalleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("supplier_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("bill_code");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List mechanicalleaseVOList = BeanMapper.mapList((Iterable)page.getRecords(), MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); ++i) {
            MechanicalleaseVO mechanicalleaseVO = (MechanicalleaseVO)((Object)mechanicalleaseVOList.get(i));
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"mid", (Object)mechanicalleaseVO.getId());
            List entityList = this.detailService.list((Wrapper)detailWrapper);
            if (entityList == null || entityList.size() <= 0) continue;
            List detailList = BeanMapper.mapList((Iterable)entityList, MechanicalleasedetailVO.class);
            mechanicalleaseVO.setMechanicalleasedetailEntities(detailList);
        }
        pageData.setRecords(mechanicalleaseVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refMechanicalleasedetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MechanicalleasedetailVO>> refMechanicalleasedetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String projectIdStr = _con.getString("projectId");
        if (StringUtils.isBlank((CharSequence)projectIdStr)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6projectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String settleTimeStr = _con.getString("settleTime");
        if (StringUtils.isBlank((CharSequence)settleTimeStr)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6settleTime\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONArray refmechanicallease = new JSONArray();
        if (_con.getJSONArray("refmechanicallease") != null) {
            refmechanicallease = _con.getJSONArray("refmechanicallease");
        }
        List mechanicalleasedataVOS = refmechanicallease.toJavaList(MechanicalleasedetailVO.class);
        List<Long> idList = mechanicalleasedataVOS.stream().map(item -> item.getId()).collect(Collectors.toList());
        Long projectId = Long.parseLong(projectIdStr);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.CHINA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date date = format.parse(settleTimeStr);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
            String strDate1 = sdf1.format(date);
            IPage<MechanicalleasedetailVO> pageData = this.dataService.listData(searchText, strDate1, projectId, pageNumber, pageSize, idList);
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", pageData);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", null);
        }
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> pastData(Long id, Long contractId, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            MechanicalleaseEntity mechanicalleaseEntity = (MechanicalleaseEntity)((Object)this.service.selectById(id));
            currentDate = mechanicalleaseEntity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate, projectId)));
    }

    private MechanicalleaseVO getPastTotal(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.orderByDesc((Object)"create_time");
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList mechanicalleasedetailEntityList = new ArrayList();
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            MechanicalleaseEntity mechanicalleaseEntity = (MechanicalleaseEntity)((Object)proTotal.get(0));
            occurrenceTotal = occurrenceTotal.add(mechanicalleaseEntity.getExTaxCumulative());
            taxOccurrenceTotal = taxOccurrenceTotal.add(mechanicalleaseEntity.getInTaxCumulative());
            if (isSave) {
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)mechanicalleaseEntity.getId());
                List detailList = this.detailService.list((Wrapper)detailWrapper);
                mechanicalleasedetailEntityList.addAll(detailList);
            }
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(occurrenceTotal);
        vo.setInTaxCumulative(taxOccurrenceTotal);
        vo.setContractId(contractId);
        vo.setMechanicalleasedetailEntities(BeanMapper.mapList(mechanicalleasedetailEntityList, MechanicalleasedetailVO.class));
        return vo;
    }

    private MechanicalleaseVO getPastTotalData(Long contractId, Date currentDate, Long projectId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        List list = this.service.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MechanicalleaseEntity entitys = (MechanicalleaseEntity)((Object)list.get(i));
                exTaxCumulative = exTaxCumulative.add(entitys.getExTaxThisMonthTotal() == null ? BigDecimal.valueOf(0L) : entitys.getExTaxThisMonthTotal());
                inTaxCumulative = inTaxCumulative.add(entitys.getInTaxThisMonthTotal() == null ? BigDecimal.valueOf(0L) : entitys.getInTaxThisMonthTotal());
            }
        }
        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(exTaxCumulative);
        vo.setInTaxCumulative(inTaxCumulative);
        return vo;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

