/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummarydetailService;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummarydetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"revolvingleasesummaryExport"})
public class ExcelRevolvingleasesummaryController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRevolvingleasesummarydetailService revolvingleasesummarydetailService;

    @RequestMapping(value={"/downloadRevolvingleasesummary"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadRevolvingleasesummary(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"revolvingleasesummarydetail-import.xlsx", (String)"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u5355\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportRevolvingleasesummary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvingleasesummary(HttpServletRequest request, HttpServletResponse response, String revolvingleaseDetailVo) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<RevolvingleasesummarydetailVO> successList = new ArrayList<RevolvingleasesummarydetailVO>();
        ArrayList<RevolvingleasesummarydetailVO> errorList = new ArrayList<RevolvingleasesummarydetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        HashMap<String, String> frontMap = new HashMap<String, String>();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = new RevolvingleasesummarydetailVO();
                List datas = (List)result.get(i);
                List revolvingleasesummarydetailVOS = JSON.parseArray((String)revolvingleaseDetailVo, RevolvingleasesummarydetailVO.class);
                for (RevolvingleasesummarydetailVO vo : revolvingleasesummarydetailVOS) {
                    StringBuffer materBuffer = new StringBuffer();
                    if (vo.getContractName() != null && StringUtils.isNotBlank((CharSequence)vo.getContractName())) {
                        materBuffer.append(vo.getContractName());
                    }
                    if (vo.getMaterialCode() != null && StringUtils.isNotBlank((CharSequence)vo.getMaterialCode())) {
                        materBuffer.append(vo.getMaterialCategoryCode());
                    }
                    if (vo.getCategoryName() != null && StringUtils.isNotBlank((CharSequence)vo.getCategoryName())) {
                        materBuffer.append(vo.getCategoryName());
                    }
                    if (vo.getLesseeName() != null && StringUtils.isNotBlank((CharSequence)vo.getLesseeName())) {
                        materBuffer.append(vo.getLesseeName());
                    }
                    if (vo.getPaymentProportion() != null) {
                        materBuffer.append(vo.getPaymentProportion());
                    }
                    frontMap.put(materBuffer.toString(), materBuffer.toString());
                }
                revolvingleasesummarydetailVO.setId(IdWorker.getId());
                revolvingleasesummarydetailVO.setContractName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? String.valueOf(datas.get(1)) : null);
                revolvingleasesummarydetailVO.setMaterialCategoryCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                revolvingleasesummarydetailVO.setCategoryName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                revolvingleasesummarydetailVO.setLesseeName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                revolvingleasesummarydetailVO.setPaymentProportion(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                String keyValue = (String)frontMap.get((String)datas.get(1) + (String)datas.get(2) + (String)datas.get(3) + (String)datas.get(4) + (String)datas.get(9));
                if (keyValue == null || !StringUtils.isNotBlank((CharSequence)keyValue)) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u5408\u540c\u540d\u79f0,\u7269\u8d44\u7f16\u53f7,\u8bbe\u5907\u7c7b\u522b,\u79df\u8d41\u5546\u540d\u79f0,\u5408\u540c\u4ed8\u6b3e\u6bd4\u4f8b'\u4e0e\u53c2\u7167\u5185\u5bb9\u4e0d\u7b26,\u8bf7\u68c0\u67e5!");
                    errorList.add(revolvingleasesummarydetailVO);
                }
                for (RevolvingleasesummarydetailVO vos : revolvingleasesummarydetailVOS) {
                    if (vos.getPaymentProportion() == null) {
                        if (!vos.getContractName().equals(datas.get(1)) || !vos.getMaterialCode().equals(datas.get(2)) || !vos.getCategoryName().equals(datas.get(3)) || !vos.getLesseeName().equals(datas.get(4))) continue;
                        revolvingleasesummarydetailVO.setSettleAccount(vos.getSettleAccount());
                        revolvingleasesummarydetailVO.setTaxSettleAccount(vos.getTaxSettleAccount());
                        revolvingleasesummarydetailVO.setCumulativeAmount(vos.getCumulativeAmount());
                        revolvingleasesummarydetailVO.setTaxCumulativeAmount(vos.getTaxCumulativeAmount());
                        continue;
                    }
                    if (!vos.getContractName().equals(datas.get(1)) || !vos.getMaterialCode().equals(datas.get(2)) || !vos.getCategoryName().equals(datas.get(3)) || !vos.getLesseeName().equals(datas.get(4)) || !vos.getPaymentProportion().equals(datas.get(9))) continue;
                    revolvingleasesummarydetailVO.setSettleAccount(vos.getSettleAccount());
                    revolvingleasesummarydetailVO.setTaxSettleAccount(vos.getTaxSettleAccount());
                    revolvingleasesummarydetailVO.setCumulativeAmount(vos.getCumulativeAmount());
                    revolvingleasesummarydetailVO.setTaxCumulativeAmount(vos.getTaxCumulativeAmount());
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10))) || datas.get(10) == null) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u5e94\u4ed8\u6b3e\u91d1\u989d'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(revolvingleasesummarydetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(10)))) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u5e94\u4ed8\u6b3e\u91d1\u989d'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(revolvingleasesummarydetailVO);
                } else {
                    revolvingleasesummarydetailVO.setCumulativePayable(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11))) || datas.get(11) == null) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(revolvingleasesummarydetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(11)))) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u81f3\u672c\u6708\u7d2f\u8ba1\u4ed8\u6b3e\u91d1\u989d'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(revolvingleasesummarydetailVO);
                } else {
                    revolvingleasesummarydetailVO.setCumulativePayment(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12))) || datas.get(12) == null) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u8054\u7cfb\u4eba'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(revolvingleasesummarydetailVO);
                } else {
                    revolvingleasesummarydetailVO.setContacts(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? (String)datas.get(12) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13))) || datas.get(13) == null) {
                    revolvingleasesummarydetailVO.setErrorMsg("'\u8054\u7cfb\u65b9\u5f0f'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(revolvingleasesummarydetailVO);
                } else {
                    revolvingleasesummarydetailVO.setContactsWay(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? (String)datas.get(13) : null);
                }
                revolvingleasesummarydetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? String.valueOf(datas.get(14)) : null);
                if (!CollectionUtil.isEmpty(errorList)) continue;
                successList.add(revolvingleasesummarydetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportRevolvingleasesummaryFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleasesummaryFromDatabase(@RequestBody RevolvingleasesummaryVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)revolvingleaseVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.revolvingleasesummarydetailService.list((Wrapper)queryWrapper);
        List revolvingleasesummarydetailVOList = BeanMapper.mapList((Iterable)list, RevolvingleasesummarydetailVO.class);
        if (revolvingleasesummarydetailVOList != null && revolvingleasesummarydetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasesummarydetailVOList.size(); ++i) {
                RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = (RevolvingleasesummarydetailVO)((Object)revolvingleasesummarydetailVOList.get(i));
                revolvingleasesummarydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasesummarydetailVOList);
        ExcelExport.getInstance().export("revolvingleasesummarydetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportRevolvingleasesummaryFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleasesummaryFromPage(@RequestBody List<RevolvingleasesummarydetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = list.get(i);
                revolvingleasesummarydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<RevolvingleasesummarydetailVO>> beans = new HashMap<String, List<RevolvingleasesummarydetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasesummarydetail-export.xlsx", beans, response);
    }
}

