/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherEntity;
import com.ejianc.business.middlemeasurement.bean.ConsultotherdetailEntity;
import com.ejianc.business.middlemeasurement.mapper.ConsultotherMapper;
import com.ejianc.business.middlemeasurement.service.IConsultotherService;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.business.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinalOtherdetailVO;
import com.ejianc.foundation.middlemeasurement.vo.ConsultfinaldetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="consultotherService")
public class ConsultotherServiceImpl
extends BaseServiceImpl<ConsultotherMapper, ConsultotherEntity>
implements IConsultotherService {
    @Autowired
    private ConsultotherMapper mapper;
    @Autowired
    private IConsultotherdetailService consultotherdetailService;
    @Autowired
    private IConsultotherService service;

    @Override
    public List<CostManageVO> queryConsultother(Long projectId, String monthStr) {
        return this.mapper.queryConsultother(projectId, monthStr);
    }

    @Override
    public List<CostManageVO> queryConsultotherMonth(Long projectId, String monthStr) {
        BigDecimal curExTaxAmount = BigDecimal.ZERO;
        List<CostManageVO> costManageVOS1 = this.mapper.queryConsultotherMonth(projectId, monthStr);
        for (CostManageVO costManageVO : costManageVOS1) {
            curExTaxAmount = curExTaxAmount.add(costManageVO.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO.getTotalPrice());
        }
        List<CostManageVO> costManageVOS = this.mapper.queryConsultotherOtherdetailMonth(projectId, monthStr);
        for (CostManageVO costManageVO3 : costManageVOS) {
            curExTaxAmount = curExTaxAmount.subtract(costManageVO3.getTotalPrice() == null ? BigDecimal.ZERO : costManageVO3.getTotalPrice());
        }
        CostManageVO costManageVO = new CostManageVO();
        costManageVO.setTotalPrice(curExTaxAmount);
        ArrayList<CostManageVO> list = new ArrayList<CostManageVO>();
        list.add(costManageVO);
        return list;
    }

    @Override
    public ConsultotherdetailVO queryConsultotherPastData(ConsultotherdetailVO vo) {
        String rowState = vo.getRowState();
        if ("add".equals(rowState)) {
            ConsultotherdetailEntity pastSubcontractingvolumedetail;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)vo.getContractId());
            queryWrapper.eq((Object)"subitem_name", (Object)vo.getSubitemName());
            queryWrapper.eq((Object)"spec", (Object)vo.getSpec());
            queryWrapper.eq((Object)"unit", (Object)vo.getUnit());
            queryWrapper.eq((Object)"unitprice", (Object)vo.getUnitprice());
            queryWrapper.eq((Object)"tax_unitprice", (Object)vo.getTaxUnitprice());
            queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
            queryWrapper.orderByDesc((Object)"create_time");
            queryWrapper.last("limit 1");
            List pastDetails = this.consultotherdetailService.list((Wrapper)queryWrapper);
            if (pastDetails != null && pastDetails.size() > 0 && (pastSubcontractingvolumedetail = (ConsultotherdetailEntity)((Object)pastDetails.get(0))).getDr() == 0) {
                vo.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
                vo.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
                vo.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
                vo.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
                vo.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
                vo.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
            }
        }
        return vo;
    }

    @Override
    public List<ConsultfinalOtherdetailVO> queryConsultOtherDetailCumPast(Long contractId, String date) {
        return this.mapper.queryConsultOtherDetailCumPast(contractId, date);
    }

    @Override
    public List<ConsultfinaldetailVO> queryConsultDetailCumPast(Long contractId, String date) {
        return this.mapper.queryConsultDetailCumPast(contractId, date);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( reporting_time, '%Y-%m' )", (Object)monthStr);
        List list = this.service.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (ConsultotherEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(ConsultotherEntity::getIsSettlement)).or()).eq(ConsultotherEntity::getIsSettlement, (Object)0));
        int count = this.service.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97\u5355\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ConsultotherEntity::getProjectId, (Object)projectId)).ne(ConsultotherEntity::getBillState, (Object)3)).ne(ConsultotherEntity::getBillState, (Object)1)).apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.service.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u54a8\u8be2\u53ca\u5176\u4ed6\u7c7b\u5408\u540c\u8fc7\u7a0b\u7ed3\u7b97\u5355\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e");
        }
        return true;
    }
}

