/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    public static String dateSimple(Date date) {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = sDateFormat.format(date);
        return formatDate;
    }

    public static String dateSimple2(Date date) {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatDate = sDateFormat.format(date);
        return formatDate;
    }

    public static String dateSimple3(Date date) {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM");
        String formatDate = sDateFormat.format(date);
        return formatDate;
    }

    public static Date Date(String days) throws ParseException {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = DateUtils.ExcelDoubleToDate(days);
        Date date = sDateFormat.parse(dateStr);
        return date;
    }

    public static Date Dates(String days) throws ParseException {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM");
        String dateStr = DateUtils.ExcelDoubleToDate(days);
        Date date = sDateFormat.parse(dateStr);
        return date;
    }

    public static String ExcelDoubleToDate(String strDate) {
        if (strDate.length() == 5) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DateUtils.DoubleToDate(Double.parseDouble(strDate));
                return sdf.format(tDate);
            }
            catch (Exception e) {
                e.printStackTrace();
                return strDate;
            }
        }
        return strDate;
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }

    public static Date getFirstDayOfMonth(int year, int month) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        int firstDay = calendar.getActualMinimum(5);
        calendar.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayStr = sdf.format(calendar.getTime()) + " 00:00:00";
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf1.parse(firstDayStr);
        return date;
    }

    public static Date getLastDayOfMonth(int year, int month) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, month - 1);
        int lastDay = 0;
        lastDay = month == 2 ? calendar.getLeastMaximum(5) : calendar.getActualMaximum(5);
        calendar.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayStr = sdf.format(calendar.getTime()) + " 23:59:59";
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf1.parse(lastDayStr);
        return date;
    }

    public static boolean grepDate(String date) {
        date = DateUtils.ExcelDoubleToDate(date);
        String rexp1 = "((\\d{2}(([02468][048])|([13579][26]))[\\-]((((0?[13578])|(1[02]))[\\-]((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-]((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-]((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-]((((0?[13578])|(1[02]))[\\-]((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-]((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-]((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        Pattern compile = Pattern.compile(rexp1);
        Matcher matcher = compile.matcher(date);
        boolean rs = matcher.matches();
        return rs;
    }

    public static String getBeginMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int first = cal.getActualMinimum(5);
        cal.set(5, first);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }

    public static String getEndMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(5);
        cal.set(5, last);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }
}

