/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"mechanicalleaseExport"})
public class ExcelmechanicalleaseController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMechanicalleaseService service;
    @Autowired
    private IMechanicalleasedetailService detailService;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    @RequestMapping(value={"/downloadMechanicalleasedetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"mechanicalleasedetail-imports.xlsx", (String)"\u6708\u5ea6\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelMechanicallease"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMechanicallease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MechanicalleasedetailVO> successList = new ArrayList<MechanicalleasedetailVO>();
        ArrayList<MechanicalleasedetailVO> errorList = new ArrayList<MechanicalleasedetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 1; i < result.size(); ++i) {
                MechanicalleasedetailVO mechanicalleasedetailVO = new MechanicalleasedetailVO();
                List datas = (List)result.get(i);
                mechanicalleasedetailVO.setId(IdWorker.getId());
                mechanicalleasedetailVO.setSort(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                mechanicalleasedetailVO.setEquipmentCode(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                mechanicalleasedetailVO.setName(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                mechanicalleasedetailVO.setSpec(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                CommonResponse back0 = this.shareEquipmentApi.queryEquipmentByCode((String)datas.get(1));
                if (back0.getCode() == 1 || back0.getData() == null) {
                    mechanicalleasedetailVO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u8be5\u7269\u8d44\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((EquipmentVO)back0.getData()).getName()) && !((EquipmentVO)back0.getData()).getName().equals(datas.get(2))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u79df\u8d41\u7269\u8d44\u540d\u79f0'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((EquipmentVO)back0.getData()).getSpec()) && !((EquipmentVO)back0.getData()).getSpec().equals(datas.get(3))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u89c4\u683c\u578b\u53f7'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((EquipmentVO)back0.getData()).getUnitName())) {
                    if (!((EquipmentVO)back0.getData()).getUnitName().equals(datas.get(4))) {
                        mechanicalleasedetailVO.setErrorMsg("'\u8ba1\u91cf\u5355\u4f4d'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                        errorList.add(mechanicalleasedetailVO);
                        continue;
                    }
                } else {
                    mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                }
                StringBuffer materConcat = new StringBuffer();
                if (datas.get(3) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    materConcat.append(((EquipmentVO)back0.getData()).getCode()).append(((EquipmentVO)back0.getData()).getName()).append(((EquipmentVO)back0.getData()).getSpec());
                }
                if (datas.get(4) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    materConcat.append(((EquipmentVO)back0.getData()).getUnitName());
                }
                if (map.containsKey(materConcat.toString())) {
                    mechanicalleasedetailVO.setErrorMsg("'\u7f16\u7801','\u7269\u8d44\u540d\u79f0','\u7269\u8d44\u89c4\u683c','\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u91cd\u590d'");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                map.put(materConcat.toString(), materConcat.toString());
                mechanicalleasedetailVO.setCategoryId(((EquipmentVO)back0.getData()).getCategoryId());
                mechanicalleasedetailVO.setCategoryCode(((EquipmentVO)back0.getData()).getCode());
                mechanicalleasedetailVO.setCategoryName(((EquipmentVO)back0.getData()).getCategoryName());
                BigDecimal leaseNum = new BigDecimal(0);
                if (!NumberUtil.isNumber((String)((String)datas.get(5)))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u79df\u8d41\u6570\u91cf'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                mechanicalleasedetailVO.setLeaseNum(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                leaseNum = leaseNum.add(new BigDecimal((String)datas.get(5)));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6))) || datas.get(6) == null) {
                    mechanicalleasedetailVO.setErrorMsg("'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65e5\u671f'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                if (!DateUtils.grepDate((String)datas.get(6))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65e5\u671f'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                mechanicalleasedetailVO.setBillingStartTime(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(6))) ? DateUtils.Date((String)datas.get(6)) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7))) || datas.get(7) == null) {
                    mechanicalleasedetailVO.setErrorMsg("'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65e5\u671f'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                if (!DateUtils.grepDate((String)datas.get(7))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65e5\u671f'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                mechanicalleasedetailVO.setBillingEndTime(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(7))) ? DateUtils.Date((String)datas.get(7)) : null);
                Date billingStartTime = mechanicalleasedetailVO.getBillingStartTime();
                Date billingEndTime = mechanicalleasedetailVO.getBillingEndTime();
                if (billingStartTime != null && billingEndTime != null) {
                    BigDecimal day = this.getDays2(billingStartTime, billingEndTime);
                    BigDecimal leaseDaysThisTime = day.add(new BigDecimal(1)).divide(new BigDecimal(30), 8, 4);
                    mechanicalleasedetailVO.setLeaseDaysThisTime(leaseDaysThisTime);
                }
                BigDecimal exTaxLeaseUnit = BigDecimal.ZERO;
                if (!NumberUtil.isNumber((String)((String)datas.get(9)))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u79df\u8d41\u5355\u4ef7\uff08\u9664\u7a0e\uff09\uff08\u5143\uff09'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                exTaxLeaseUnit = exTaxLeaseUnit.add(new BigDecimal((String)datas.get(9)));
                mechanicalleasedetailVO.setExTaxLeaseUnit(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                BigDecimal inTaxLeaseUnit = BigDecimal.ZERO;
                if (!NumberUtil.isNumber((String)((String)datas.get(10)))) {
                    mechanicalleasedetailVO.setErrorMsg("'\u79df\u8d41\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(mechanicalleasedetailVO);
                    continue;
                }
                inTaxLeaseUnit = inTaxLeaseUnit.add(new BigDecimal((String)datas.get(10)));
                mechanicalleasedetailVO.setInTaxLeaseUnit(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                if (mechanicalleasedetailVO.getLeaseDaysThisTime() != null) {
                    BigDecimal exTaxLeaseTotal = mechanicalleasedetailVO.getLeaseDaysThisTime().multiply(leaseNum).multiply(exTaxLeaseUnit);
                    mechanicalleasedetailVO.setExTaxLeaseTotal(exTaxLeaseTotal);
                }
                if (mechanicalleasedetailVO.getLeaseDaysThisTime() != null) {
                    BigDecimal inTaxLeaseTotal = mechanicalleasedetailVO.getLeaseDaysThisTime().multiply(leaseNum).multiply(inTaxLeaseUnit);
                    mechanicalleasedetailVO.setInTaxLeaseTotal(inTaxLeaseTotal);
                }
                if (mechanicalleasedetailVO.getLeaseDaysThisTime() != null) {
                    BigDecimal exTaxSettlementMonth = mechanicalleasedetailVO.getLeaseDaysThisTime().multiply(leaseNum).multiply(exTaxLeaseUnit);
                    mechanicalleasedetailVO.setExTaxSettlementMonth(exTaxSettlementMonth);
                }
                if (mechanicalleasedetailVO.getLeaseDaysThisTime() != null) {
                    BigDecimal inTaxSettlementMonth = mechanicalleasedetailVO.getLeaseDaysThisTime().multiply(leaseNum).multiply(inTaxLeaseUnit);
                    mechanicalleasedetailVO.setInTaxSettlementMonth(inTaxSettlementMonth);
                }
                mechanicalleasedetailVO.setRemarks(StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(15))) ? (String)datas.get(15) : null);
                successList.add(mechanicalleasedetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMechanicalleaseFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMechanicalleaseFromDatabase(@RequestBody MechanicalleasedetailVO detailVo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)detailVo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.detailService.list((Wrapper)queryWrapper);
        List mechanicalleasedetailVOList = BeanMapper.mapList((Iterable)list, MechanicalleasedetailVO.class);
        if (mechanicalleasedetailVOList != null && mechanicalleasedetailVOList.size() > 0) {
            for (int i = 0; i < mechanicalleasedetailVOList.size(); ++i) {
                MechanicalleasedetailVO mechanicalleasedetailVO = (MechanicalleasedetailVO)((Object)mechanicalleasedetailVOList.get(i));
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingStartTime() == null) continue;
                mechanicalleasedetailVO.setBillingStartTime(mechanicalleasedetailVO.getBillingStartTime());
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>(16);
        beans.put("records", mechanicalleasedetailVOList);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMechanicalleasedetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMechanicalleasedetailFromPage(@RequestBody List<MechanicalleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MechanicalleasedetailVO mechanicalleasedetailVO = list.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingEndTime() != null) {
                    mechanicalleasedetailVO.setBillingEndTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingEndTime()));
                }
                if (mechanicalleasedetailVO.getBillingStartTime() == null) continue;
                mechanicalleasedetailVO.setBillingStartTimeShow(DateUtils.dateSimple(mechanicalleasedetailVO.getBillingStartTime()));
            }
        }
        HashMap<String, List<MechanicalleasedetailVO>> beans = new HashMap<String, List<MechanicalleasedetailVO>>(16);
        beans.put("records", list);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

    public BigDecimal getDays2(Date start, Date end) {
        BigDecimal day = new BigDecimal(0);
        Long startTime = start.getTime();
        Long endTime = end.getTime();
        BigDecimal day1 = new BigDecimal(endTime - startTime);
        BigDecimal day2 = new BigDecimal(86400000);
        day = day1.divide(day2, 8, 4);
        return day;
    }
}

