package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.EngineermeasurementMapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;

import java.util.List;

/**
 * 工程计量台账
 * 
 * @author generator
 * 
 */
@Service("engineermeasurementService")
public class EngineermeasurementServiceImpl extends BaseServiceImpl<EngineermeasurementMapper, EngineermeasurementEntity> implements IEngineermeasurementService{
    @Autowired
    private IEngineermeasurementService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<EngineermeasurementEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( reporting_time, '%Y-%m' )",monthStr);
        List<EngineermeasurementEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (EngineermeasurementEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<EngineermeasurementEntity> query = new LambdaQueryWrapper<EngineermeasurementEntity>()
                .eq(EngineermeasurementEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(EngineermeasurementEntity::getIsSettlement)
                        .or().eq(EngineermeasurementEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("工程计量台账有往期未归集的数据");
        LambdaQueryWrapper<EngineermeasurementEntity> query1 = new LambdaQueryWrapper<EngineermeasurementEntity>()
                .eq(EngineermeasurementEntity::getProjectId, projectId)
                .ne(EngineermeasurementEntity::getBillState, 3)
                .ne(EngineermeasurementEntity::getBillState, 1)
                .apply("DATE_FORMAT(reporting_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("工程计量台账有本期审批未通过的数据");
        return true;
    }
}
