package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotalEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.RevolvingleaseMapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;

import java.util.List;

/**
 * 月度周转工具租赁费结算单
 * 
 * @author generator
 * 
 */
@Service("revolvingleaseService")
public class RevolvingleaseServiceImpl extends BaseServiceImpl<RevolvingleaseMapper, RevolvingleaseEntity> implements IRevolvingleaseService{
    @Autowired
    private IRevolvingleaseService service;
    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper<RevolvingleaseEntity> query = new QueryWrapper();
        query.eq("project_id",projectId);
        query.eq("DATE_FORMAT( settle_time, '%Y-%m' )",monthStr);
        List<RevolvingleaseEntity> list = service.list(query);
        if (!list.isEmpty()){
            for (RevolvingleaseEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = service.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper<RevolvingleaseEntity> query = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') < '" + monthStr + "'")
                .and(qw -> qw.isNull(RevolvingleaseEntity::getIsSettlement)
                        .or().eq(RevolvingleaseEntity::getIsSettlement, 0));
        int count = service.count(query);
        if (count > 0) throw new BusinessException("月度周转工具租赁费结算单有往期未归集的数据");
        LambdaQueryWrapper<RevolvingleaseEntity> query1 = new LambdaQueryWrapper<RevolvingleaseEntity>()
                .eq(RevolvingleaseEntity::getProjectId, projectId)
                .ne(RevolvingleaseEntity::getBillState, 3)
                .ne(RevolvingleaseEntity::getBillState, 1)
                .apply("DATE_FORMAT(settle_time, '%Y-%m') = '" + monthStr + "'");
        int count1 = service.count(query1);
        if (count1 > 0) throw new BusinessException("月度周转工具租赁费结算单有本期审批未通过的数据");
        return true;
    }
}
