/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumemdetailService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeodetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.settlementmanage.api.ISettlementBookApi;
import com.ejianc.foundation.budgetmanage.api.IConsdrawbudgetApi;
import com.ejianc.foundation.budgetmanage.api.ISubpackageApi;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetVO;
import com.ejianc.foundation.budgetmanage.vo.ConsdrawbudgetdetailVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackageVO;
import com.ejianc.foundation.budgetmanage.vo.SubpackagedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractingvolume"})
public class SubcontractingvolumeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutcontractApi outcontractApi;
    @Autowired
    private IConsdrawbudgetApi consdrawbudgetApi;
    @Autowired
    private ISubpackageApi subpackageApi;
    @Autowired
    private ISettlementBookApi settlementBookApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";
    @Autowired
    private ISubcontractingvolumeService service;
    @Autowired
    private ISubcontractingvolumedetailService subcontractingvolumedetailService;
    @Autowired
    private ISubcontractingvolumemdetailService subcontractingvolumemdetailService;
    @Autowired
    private ISubcontractingvolumeodetailService subcontractingvolumeodetailService;
    List<SubcontractingvolumedetailVO> subcontractingvolumedetailVOList = new ArrayList<SubcontractingvolumedetailVO>();
    BigDecimal num = null;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractingvolumeVO> saveOrUpdate(@RequestBody SubcontractingvolumeVO saveorUpdateVO) {
        SubcontractingvolumeEntity entity = (SubcontractingvolumeEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SubcontractingvolumeEntity.class));
        this.checkBillStateUniq(entity.getId(), entity.getContractId(), true);
        entity = this.checkBillCodeUniq(entity);
        this.checkSubpackageQuantity(entity);
        this.checkSubcontract(entity.getContractId());
        this.checkQuantity(entity);
        entity.setIsReference(0);
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractingvolumeVO vo = (SubcontractingvolumeVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractingvolumeVO.class));
        List<SubcontractingvolumedetailVO> consdrawbudgetdetailVOList = vo.getSubcontractingvolumedetailEntities();
        vo.setSubcontractingvolumedetailEntities(this.handleChildren(consdrawbudgetdetailVOList));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private void checkSubcontract(Long contractId) {
        CommonResponse subcontracts = this.settlementBookApi.queryContractIds(contractId);
        if (subcontracts.getCode() == 0) {
            if ((Integer)subcontracts.getData() == 0) {
                return;
            }
            throw new BusinessException("\u5df2\u6709\u5de5\u7a0b\u5206\u5305\u7ed3\u7b97\u4e66\uff0c\u4e0d\u80fd\u65b0\u589e\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u53ca\u7533\u8bf7\u62a5\u544a");
        }
    }

    private void checkSubpackageQuantity(SubcontractingvolumeEntity entity) {
        Long contractId = entity.getContractId();
        CommonResponse subpackageResponse = this.subpackageApi.queryByContractId(contractId);
        if (subpackageResponse.getCode() != 0) {
            return;
        }
        List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
        if (subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0) {
            return;
        }
        SubpackageVO subpackageVO = (SubpackageVO)subpackageResponse.getData();
        if (subpackageVO != null) {
            List subpackagedetailVOS = subpackageVO.getSubpackagedetailEntities();
            Long isEnable = subpackageVO.getIsEnable();
            if (isEnable != null && isEnable == 1L) {
                for (int i = 0; i < subcontractingvolumedetailEntities.size(); ++i) {
                    boolean isHave = false;
                    SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
                    BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
                    BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
                    String subitemCode = subcontractingvolumedetail.getSubitemCode();
                    String source = subcontractingvolumedetail.getSource();
                    if (!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())) continue;
                    for (int j = 0; j < subpackagedetailVOS.size(); ++j) {
                        SubpackagedetailVO subpackagedetailVO = (SubpackagedetailVO)subpackagedetailVOS.get(j);
                        BigDecimal subpackagEengineeQuatity = subpackagedetailVO.getSubpackageQuantities();
                        String subpackagSubtitleCode = subpackagedetailVO.getSubtitleCode();
                        if (!subitemCode.equals(subpackagSubtitleCode)) continue;
                        isHave = true;
                        if (examineQuantity != null && (subpackagEengineeQuatity == null || examineQuantity.compareTo(subpackagEengineeQuatity) > 0)) {
                            throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u672c\u671f\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                        }
                        if (examineCumulativeQuantity == null || subpackagEengineeQuatity != null && examineCumulativeQuantity.compareTo(subpackagEengineeQuatity) <= 0) break;
                        throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u7d2f\u8ba1\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                    }
                    if (!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0) {
                        throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u672c\u671f\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                    }
                    if (isHave || examineCumulativeQuantity == null || examineCumulativeQuantity.compareTo(BigDecimal.ZERO) <= 0) continue;
                    throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u7d2f\u8ba1\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u5206\u5305\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                }
            }
        }
    }

    private void checkQuantity(SubcontractingvolumeEntity entity) {
        Long projectId = entity.getProjectId();
        CommonResponse consdrawbudgetResponse = this.consdrawbudgetApi.queryByProjectId(projectId);
        if (consdrawbudgetResponse.getCode() != 0) {
            return;
        }
        List<SubcontractingvolumedetailEntity> subcontractingvolumedetailEntities = entity.getSubcontractingvolumedetailEntities();
        if (subcontractingvolumedetailEntities == null && subcontractingvolumedetailEntities.size() == 0) {
            return;
        }
        ConsdrawbudgetVO consdrawbudgetVO = (ConsdrawbudgetVO)consdrawbudgetResponse.getData();
        if (consdrawbudgetVO != null) {
            List consdrawbudgetdetailVOS = consdrawbudgetVO.getConsdrawbudgetdetailEntities();
            Integer isOpenControl = consdrawbudgetVO.getIsOpenControl();
            if (isOpenControl != null && isOpenControl == 1) {
                for (int i = 0; i < subcontractingvolumedetailEntities.size(); ++i) {
                    boolean isHave = false;
                    SubcontractingvolumedetailEntity subcontractingvolumedetail = subcontractingvolumedetailEntities.get(i);
                    BigDecimal examineQuantity = subcontractingvolumedetail.getExamineQuantity();
                    BigDecimal examineCumulativeQuantity = subcontractingvolumedetail.getExamineCumulativeQuantity();
                    String subitemCode = subcontractingvolumedetail.getSubitemCode();
                    String source = subcontractingvolumedetail.getSource();
                    if (!"1".equals(source) || "del".equals(subcontractingvolumedetail.getRowState())) continue;
                    for (int j = 0; j < consdrawbudgetdetailVOS.size(); ++j) {
                        ConsdrawbudgetdetailVO consdrawbudgetdetailVO = (ConsdrawbudgetdetailVO)consdrawbudgetdetailVOS.get(j);
                        BigDecimal engineeQuatity = consdrawbudgetdetailVO.getEngineeQuatity();
                        String consdrawbudgetSubitemCode = consdrawbudgetdetailVO.getSubitemCode();
                        if (!subitemCode.equals(consdrawbudgetSubitemCode)) continue;
                        isHave = true;
                        if (examineQuantity != null && (engineeQuatity == null || examineQuantity.compareTo(engineeQuatity) > 0)) {
                            throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u672c\u671f\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                        }
                        if (examineCumulativeQuantity == null || engineeQuatity != null && examineCumulativeQuantity.compareTo(engineeQuatity) <= 0) break;
                        throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u7d2f\u8ba1\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                    }
                    if (!isHave && examineQuantity != null && examineQuantity.compareTo(BigDecimal.ZERO) > 0) {
                        throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u672c\u671f\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                    }
                    if (isHave || examineCumulativeQuantity == null || examineCumulativeQuantity.compareTo(BigDecimal.ZERO) <= 0) continue;
                    throw new BusinessException("\u6e05\u5355\u7f16\u7801\uff1a" + subitemCode + "\uff0c\n\u9879\u76ee\u90e8\u5ba1\u6838\u7d2f\u8ba1\u3010\u6570\u91cf\u3011\u8d85\u8fc7\u65bd\u5de5\u56fe\u9884\u7b97\u5de5\u7a0b\u91cf\uff01");
                }
            }
        }
    }

    private void checkBillStateUniq(Long id, Long contractId, boolean isShowError) {
        List pro;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (id != null) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u53ca\u7533\u8bf7\u62a5\u544a\"!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SubcontractingvolumeEntity checkBillCodeUniq(SubcontractingvolumeEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/refreshData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
        CommonResponse outcontractResp;
        int responseCode;
        JSONObject json = new JSONObject();
        HashMap<String, SubcontractingvolumedetailVO> map = new HashMap<String, SubcontractingvolumedetailVO>();
        SubcontractingvolumedetailVO add = list.get(list.size() - 1);
        for (SubcontractingvolumedetailVO VO : list) {
            if (VO.getId() != null) continue;
            VO.setId(IdWorker.getId());
        }
        add.setTid(String.valueOf(IdWorker.getId()));
        add.setRowState("edit");
        add.setInnercode(add.getSubitemCode() + "_" + add.getSection());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)add.getContractId());
        queryWrapper.eq((Object)"subitem_code", (Object)add.getSubitemCode());
        queryWrapper.eq((Object)"section", (Object)add.getSection());
        queryWrapper.eq((Object)"examine_unitprice", (Object)add.getExamineUnitprice());
        queryWrapper.eq((Object)"examine_tax_unitprice", (Object)add.getExamineTaxUnitprice());
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pastDetails = this.subcontractingvolumedetailService.list((Wrapper)queryWrapper);
        if (pastDetails != null && pastDetails.size() > 0) {
            BigDecimal examineQuantity = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineTaxAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            add.setExamineCumulativeQuantity(examineQuantity);
            add.setExamineCumulativeAmounts(examineAmounts);
            add.setExamineCumulativeTaxAmounts(examineTaxAmounts);
        }
        QueryWrapper queryWrapperNum = new QueryWrapper();
        queryWrapperNum.eq((Object)"contract_id", (Object)add.getContractId());
        queryWrapperNum.eq((Object)"subitem_code", (Object)add.getSubitemCode());
        queryWrapperNum.eq((Object)"section", (Object)add.getSection());
        queryWrapperNum.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperNum.eq((Object)"dr", (Object)"0");
        List subcontractingvolumedetailEntityList = this.subcontractingvolumedetailService.list((Wrapper)queryWrapperNum);
        if (CollectionUtils.isNotEmpty((Collection)subcontractingvolumedetailEntityList)) {
            BigDecimal examineQuantity = subcontractingvolumedetailEntityList.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            add.setSumNum(examineQuantity);
        }
        if ((responseCode = (outcontractResp = this.outcontractApi.queryListBycontractIdAndCode(add.getContractId(), add.getSubitemCode())).getCode()) == 0) {
            List voList = (List)outcontractResp.getData();
            if (voList != null && voList.size() > 0) {
                OutcontractSubcontractUnitPriceVO priceVO = (OutcontractSubcontractUnitPriceVO)voList.get(0);
                BigDecimal comprehensiveUnitPrice = priceVO.getComprehensiveUnitPrice();
                add.setSource("1");
                add.setUnit(priceVO.getUnit());
                add.setTaxUnitprice(comprehensiveUnitPrice);
                BigDecimal tax = priceVO.getTax();
                BigDecimal engineeringQuantity = priceVO.getEngineeringQuantity();
                if (tax != null && engineeringQuantity != null && engineeringQuantity.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal temp = tax.divide(engineeringQuantity, 8, 4);
                    add.setUnitprice(comprehensiveUnitPrice.subtract(temp));
                } else {
                    add.setUnitprice(comprehensiveUnitPrice);
                }
            } else {
                add.setSource("2");
            }
        } else {
            add.setSource("2");
        }
        for (SubcontractingvolumedetailVO vo : list) {
            map.put(vo.getInnercode(), vo);
            if (add.getId().equals(vo.getId()) || !add.getInnercode().equals(vo.getInnercode()) || !add.getExamineUnitprice().equals(vo.getExamineUnitprice()) || !add.getExamineTaxUnitprice().equals(vo.getExamineTaxUnitprice())) continue;
            throw new BusinessException("\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
        }
        String subitemCode = add.getSubitemCode();
        String section = add.getSection();
        String innercodeDouble = null;
        Map<String, List<SubcontractingvolumedetailVO>> mapDouble = list.stream().collect(Collectors.groupingBy(s -> s.getSubitemCode() + '_' + s.getSection()));
        if (subitemCode.length() == 4) {
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() == 6) {
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        if (subitemCode.length() > 6) {
            innercodeDouble = subitemCode.substring(0, 6) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 4) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
            innercodeDouble = subitemCode.substring(0, 2) + "_" + section;
            this.checkDouble(innercodeDouble, mapDouble);
        }
        for (SubcontractingvolumedetailVO vo : list) {
            String innercode = vo.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                vo.setTpid(pid.toString());
                continue;
            }
            vo.setTpid("");
        }
        list = this.handleChildren(list);
        json.put("dataSource", list);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/getInfoById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractingvolumedetailVO> getInfoById(SubcontractingvolumedetailVO subcontractingvolumedetailVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)subcontractingvolumedetailVO.getContractId());
        queryWrapper.eq((Object)"subitem_code", (Object)subcontractingvolumedetailVO.getSubitemCode());
        queryWrapper.eq((Object)"section", (Object)subcontractingvolumedetailVO.getSection());
        queryWrapper.eq((Object)"examine_unitprice", (Object)subcontractingvolumedetailVO.getExamineUnitprice());
        queryWrapper.eq((Object)"examine_tax_unitprice", (Object)subcontractingvolumedetailVO.getExamineTaxUnitprice());
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pastDetails = this.subcontractingvolumedetailService.list((Wrapper)queryWrapper);
        BigDecimal money = subcontractingvolumedetailVO.getExamineQuantity().multiply(subcontractingvolumedetailVO.getExamineUnitprice());
        BigDecimal moneyTax = subcontractingvolumedetailVO.getExamineQuantity().multiply(subcontractingvolumedetailVO.getExamineTaxUnitprice());
        if (pastDetails != null && pastDetails.size() > 0) {
            BigDecimal examineQuantity = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal examineTaxAmounts = pastDetails.stream().map(SubcontractingvolumedetailEntity::getExamineTaxAmounts).reduce(BigDecimal.ZERO, BigDecimal::add);
            subcontractingvolumedetailVO.setExamineCumulativeQuantity(examineQuantity);
            subcontractingvolumedetailVO.setExamineCumulativeAmounts(examineAmounts.add(money));
            subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(examineTaxAmounts.add(moneyTax));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)subcontractingvolumedetailVO));
    }

    private void checkDouble(String innercode, Map<String, List<SubcontractingvolumedetailVO>> mapDouble) {
        List<SubcontractingvolumedetailVO> subcontractingvolumedetailVOS;
        if (mapDouble.containsKey(innercode) && (subcontractingvolumedetailVOS = mapDouble.get(innercode)).size() > 1) {
            throw new BusinessException("\u7236\u7ea7\u6709\u91cd\u590d\u6570\u636e,\u65e0\u6cd5\u65b0\u589e!");
        }
    }

    @RequestMapping(value={"/refreshDetailData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> refreshDetailData(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
        JSONObject json = new JSONObject();
        for (int i = 0; i < list.size(); ++i) {
            SubcontractingvolumedetailEntity pastSubcontractingvolumedetail;
            SubcontractingvolumedetailVO subcontractingvolumedetailVO = list.get(i);
            String rowState = subcontractingvolumedetailVO.getRowState();
            if (!"add".equals(rowState)) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)subcontractingvolumedetailVO.getContractId());
            queryWrapper.eq((Object)"subitem_code", (Object)subcontractingvolumedetailVO.getSubitemCode());
            queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
            queryWrapper.eq((Object)"dr", (Object)"0");
            queryWrapper.orderByDesc((Object)"create_time");
            queryWrapper.last("limit 1");
            List pastDetails = this.subcontractingvolumedetailService.list((Wrapper)queryWrapper);
            if (pastDetails != null && pastDetails.size() > 0 && (pastSubcontractingvolumedetail = (SubcontractingvolumedetailEntity)((Object)pastDetails.get(0))).getDr() == 0) {
                subcontractingvolumedetailVO.setCumulativeQuantity(pastSubcontractingvolumedetail.getCumulativeQuantity());
                subcontractingvolumedetailVO.setCumulativeAmounts(pastSubcontractingvolumedetail.getCumulativeAmounts());
                subcontractingvolumedetailVO.setCumulativeTaxAmounts(pastSubcontractingvolumedetail.getCumulativeTaxAmounts());
                subcontractingvolumedetailVO.setExamineCumulativeQuantity(pastSubcontractingvolumedetail.getExamineCumulativeQuantity());
                subcontractingvolumedetailVO.setExamineCumulativeAmounts(pastSubcontractingvolumedetail.getExamineCumulativeAmounts());
                subcontractingvolumedetailVO.setExamineCumulativeTaxAmounts(pastSubcontractingvolumedetail.getExamineCumulativeTaxAmounts());
            }
            subcontractingvolumedetailVO.setRowState("edit");
        }
        list = this.handleChildren(list);
        json.put("dataSource", list);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractingvolumeVO> pastData(Long id, Long contractId, boolean isShowError) {
        if (isShowError) {
            this.checkBillStateUniq(id, contractId, isShowError);
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null) {
            SubcontractingvolumeEntity entity = (SubcontractingvolumeEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private SubcontractingvolumeVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.orderByDesc((Object)"create_time");
        queryWrapperTotal.last("limit 1");
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        SubcontractingvolumeVO vo = new SubcontractingvolumeVO();
        if (proTotal != null && proTotal.size() > 0) {
            SubcontractingvolumeEntity pastEntity = (SubcontractingvolumeEntity)((Object)proTotal.get(0));
            vo = (SubcontractingvolumeVO)((Object)BeanMapper.map((Object)((Object)pastEntity), SubcontractingvolumeVO.class));
        }
        vo.setContractId(contractId);
        return vo;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractingvolumeVO> queryDetail(Long id) {
        SubcontractingvolumeEntity entity = (SubcontractingvolumeEntity)((Object)this.service.selectById(id));
        SubcontractingvolumeVO vo = (SubcontractingvolumeVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractingvolumeVO.class));
        List<SubcontractingvolumedetailVO> consdrawbudgetdetailVOList = vo.getSubcontractingvolumedetailEntities();
        vo.setSubcontractingvolumedetailEntities(this.handleChildren(consdrawbudgetdetailVOList));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractingvolumeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractingvolumeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractingvolumeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List subcontractingvolumeVOList = BeanMapper.mapList((Iterable)list, SubcontractingvolumeVO.class);
        for (int i = 0; i < subcontractingvolumeVOList.size(); ++i) {
            String billStateStr;
            SubcontractingvolumeVO subcontractingvolumeVO = (SubcontractingvolumeVO)((Object)subcontractingvolumeVOList.get(i));
            subcontractingvolumeVO.setSort(String.valueOf(i + 1));
            if (subcontractingvolumeVO.getReportingTime() != null) {
                subcontractingvolumeVO.setReportingTimeShow(DateUtils.dateSimple2(subcontractingvolumeVO.getReportingTime()));
            }
            if ((billStateStr = subcontractingvolumeVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            subcontractingvolumeVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", subcontractingvolumeVOList);
        ExcelExport.getInstance().export("subcontractingvolume-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/refSubcontractingvolumeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractingvolumeVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List subcontractingvolumeVOList = BeanMapper.mapList((Iterable)page.getRecords(), SubcontractingvolumeVO.class);
        pageData.setRecords(subcontractingvolumeVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Long setPid(String pcode, Map<String, SubcontractingvolumedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    private List<SubcontractingvolumedetailVO> handleChildren(List<SubcontractingvolumedetailVO> voList) {
        Collections.sort(voList, new Comparator<SubcontractingvolumedetailVO>(){

            @Override
            public int compare(SubcontractingvolumedetailVO o1, SubcontractingvolumedetailVO o2) {
                return (o1.getSubitemCode() + o1.getSection()).compareTo(o2.getSubitemCode() + o2.getSection());
            }
        });
        voList = SubcontractingvolumeController.createTreeData(voList);
        return voList;
    }

    public static List<SubcontractingvolumedetailVO> createTreeData(List<SubcontractingvolumedetailVO> list) {
        ArrayList<SubcontractingvolumedetailVO> resp = new ArrayList<SubcontractingvolumedetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, SubcontractingvolumedetailVO> listMap = new HashMap<String, SubcontractingvolumedetailVO>();
        for (SubcontractingvolumedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            SubcontractingvolumedetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            SubcontractingvolumedetailVO parent = (SubcontractingvolumedetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<SubcontractingvolumedetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<SubcontractingvolumedetailVO> children = new ArrayList<SubcontractingvolumedetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((SubcontractingvolumedetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }
}

