/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodeVO;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"designsubcontractnode"})
public class DesignsubcontractnodeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "middlemeasurement-designsubcontractnode";
    @Autowired
    private IDesignsubcontractnodeService service;
    @Autowired
    private IDesignsubcontractnodedetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> saveOrUpdate(@RequestBody DesignsubcontractnodeVO saveorUpdateVO) {
        DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DesignsubcontractnodeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract", (Object)entity.getContract());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u8bbe\u8ba1\u5206\u5305\u8282\u70b9\u62a5\u91cf\u7533\u8bf7");
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"contract", (Object)entity.getContract());
            queryWrapper1.eq((Object)"settlement_date", (Object)entity.getSettlementDate());
            List list = this.service.list((Wrapper)queryWrapper1);
            if (pro != null && list.size() > 0) {
                throw new BusinessException("\u76f8\u540c\u5408\u540c\u7684\u7ed3\u7b97\u65e5\u671f\u4e0d\u5141\u8bb8\u91cd\u590d!");
            }
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            for (DesignsubcontractnodedetailEntity designsubcontractnodedetail : entity.getDesignsubcontractnodedetailEntities()) {
                if (designsubcontractnodedetail.getProjectId() != null) continue;
                designsubcontractnodedetail.setProjectId(entity.getProjectId());
                designsubcontractnodedetail.setContract(entity.getContract());
            }
        }
        List<DesignsubcontractnodedetailEntity> designsubcontractnodedetailEntities = entity.getDesignsubcontractnodedetailEntities();
        if (entity.getId() == null) {
            List designsubcontractnodedetailEntityList = this.detailService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_id", (Object)entity.getProjectId())).in((Object)"bill_state", new Object[]{1, 3}));
            BigDecimal lastExTaxTotalCumulativeAudit = designsubcontractnodedetailEntityList.stream().map(it -> it.getExTaxTotalThisAudit()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lastInTaxTotalCumulativeAudit = designsubcontractnodedetailEntityList.stream().map(it -> it.getInTaxTotalThisAudit()).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setLastExTaxTotalCumulativeAuditAll(lastExTaxTotalCumulativeAudit);
            entity.setLastInTaxTotalCumulativeAuditAll(lastInTaxTotalCumulativeAudit);
        }
        if (CollectionUtils.isNotEmpty(designsubcontractnodedetailEntities)) {
            BigDecimal exTaxTotalThisAuditAll = designsubcontractnodedetailEntities.stream().map(DesignsubcontractnodedetailEntity::getExTaxTotalThisAudit).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal inTaxTotalThisAuditAll = designsubcontractnodedetailEntities.stream().map(DesignsubcontractnodedetailEntity::getInTaxTotalThisAudit).reduce(BigDecimal.ZERO, BigDecimal::add);
            entity.setExTaxTotalThisAuditAll(exTaxTotalThisAuditAll);
            entity.setInTaxTotalThisAuditAll(inTaxTotalThisAuditAll);
            entity.setExTaxTotalCumulativeAuditAll(ComputeUtil.safeAdd((BigDecimal)exTaxTotalThisAuditAll, (BigDecimal)entity.getLastExTaxTotalCumulativeAuditAll()));
            entity.setInTaxTotalCumulativeAuditAll(ComputeUtil.safeAdd((BigDecimal)inTaxTotalThisAuditAll, (BigDecimal)entity.getLastInTaxTotalCumulativeAuditAll()));
        }
        this.service.saveOrUpdate((Object)entity, false);
        DesignsubcontractnodeVO vo = (DesignsubcontractnodeVO)((Object)BeanMapper.map((Object)((Object)entity), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DesignsubcontractnodeVO> queryDetail(Long id) {
        DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)this.service.selectById(id));
        DesignsubcontractnodeVO vo = (DesignsubcontractnodeVO)((Object)BeanMapper.map((Object)((Object)entity), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DesignsubcontractnodeVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List designsubcontractnodeVOList = BeanMapper.mapList((Iterable)list, DesignsubcontractnodeVO.class);
        for (int i = 0; i < designsubcontractnodeVOList.size(); ++i) {
            DesignsubcontractnodeVO designsubcontractnodeVO = (DesignsubcontractnodeVO)((Object)designsubcontractnodeVOList.get(i));
            designsubcontractnodeVO.setSort(String.valueOf(i + 1));
            String billStateStr = designsubcontractnodeVO.getBillState().toString();
            if (billStateStr == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            designsubcontractnodeVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", designsubcontractnodeVOList);
        ExcelExport.getInstance().export("designsubcontractnodeList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDesignsubcontractnodeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DesignsubcontractnodeVO>> refDesignsubcontractnodeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("project_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("design_units_name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DesignsubcontractnodeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DesignsubcontractnodedetailVO>> pastData(Long id, Long contractId, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            DesignsubcontractnodeEntity entity = (DesignsubcontractnodeEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", this.getPastTotalData(contractId, currentDate, projectId));
    }

    private List<DesignsubcontractnodedetailVO> getPastTotalData(Long contractId, Date currentDate, Long projectId) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"project_id", (Object)projectId);
        queryWrapperTotal.eq((Object)"contract", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List list = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList<DesignsubcontractnodedetailVO> voList = new ArrayList<DesignsubcontractnodedetailVO>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"mid", (Object)((DesignsubcontractnodeEntity)((Object)list.get(0))).getId());
            List entityList = this.detailService.list((Wrapper)wrapper);
            DesignsubcontractnodedetailVO vo = new DesignsubcontractnodedetailVO();
            if (CollectionUtil.isEmpty((Collection)entityList)) {
                vo.setCompleteLastAudit(null);
                vo.setExTaxUnitLastAudit(null);
                vo.setInTaxUnitLastAudit(null);
                vo.setExTaxTotalLastAudit(null);
                vo.setInTaxTotalLastAudit(null);
                vo.setCompleteCumulativeAudit(null);
                vo.setExTaxUnitCumulativeAudit(null);
                vo.setInTaxUnitCumulativeAudit(null);
                vo.setExTaxTotalCumulativeAudit(null);
                vo.setInTaxTotalCumulativeAudit(null);
            } else {
                for (DesignsubcontractnodedetailEntity entity : entityList) {
                    vo.setCompleteLastAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getCompleteCumulativeAudit());
                    vo.setExTaxUnitLastAudit(entity.getExTaxUnitLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxUnitLastAudit());
                    vo.setInTaxUnitLastAudit(entity.getInTaxUnitLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxUnitLastAudit());
                    vo.setExTaxTotalLastAudit(entity.getExTaxTotalLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxTotalLastAudit());
                    vo.setInTaxTotalLastAudit(entity.getInTaxTotalLastAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxTotalLastAudit());
                    vo.setCompleteCumulativeAudit(entity.getCompleteCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getCompleteCumulativeAudit());
                    vo.setExTaxUnitCumulativeAudit(entity.getExTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxUnitCumulativeAudit());
                    vo.setInTaxUnitCumulativeAudit(entity.getInTaxUnitCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxUnitCumulativeAudit());
                    vo.setExTaxTotalCumulativeAudit(entity.getExTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getExTaxTotalCumulativeAudit());
                    vo.setInTaxTotalCumulativeAudit(entity.getInTaxTotalCumulativeAudit() == null ? BigDecimal.valueOf(0L) : entity.getInTaxTotalCumulativeAudit());
                    vo.setContractId(contractId);
                    vo.setProjectName(entity.getProjectName());
                }
            }
            voList.add(vo);
        }
        return voList;
    }
}

