/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"revolvinglease"})
public class RevolvingleaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-revolvinglease";
    @Autowired
    private IRevolvingleaseService service;
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;
    @Autowired
    private SessionManager sessionManager;
    List<RevolvingleasedetailVO> subList = new ArrayList<RevolvingleasedetailVO>();

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> saveOrUpdate(@RequestBody RevolvingleaseVO saveorUpdateVO) {
        List pro;
        RevolvingleaseEntity entity = (RevolvingleaseEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), RevolvingleaseEntity.class));
        entity.setSaveTime(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        if (entity.getId() != null) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(pro = this.service.list((Wrapper)queryWrapper)))) {
            for (RevolvingleaseEntity revolvingleaseEntity : pro) {
                int numDate = entity.getSettleTime().compareTo(revolvingleaseEntity.getSettleTime());
                if (revolvingleaseEntity.getBillState() != 1 && revolvingleaseEntity.getBillState() != 3) {
                    throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u6708\u5ea6\u5468\u8f6c\u7ed3\u7b97\u5355\"!");
                }
                if (numDate > 0) continue;
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u4e0b\u7684\u7ed3\u7b97\u5355\u7ed3\u7b97\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u540e\u4e00\u671f\u7684\"\u6708\u5ea6\u5468\u8f6c\u7ed3\u7b97\u5355\"!");
            }
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (saveorUpdateVO.getCreateTime() != null) {
            currentDate = saveorUpdateVO.getCreateTime();
        }
        RevolvingleaseVO pastVo = this.getPastTotalData(saveorUpdateVO.getContractId(), currentDate, true);
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (saveorUpdateVO.getTotal() != null) {
            occurrenceTotal = saveorUpdateVO.getTotal().add(pastVo.getOccurrenceTotal());
        }
        if (saveorUpdateVO.getTaxTotal() != null) {
            taxOccurrenceTotal = saveorUpdateVO.getTaxTotal().add(pastVo.getTaxOccurrenceTotal());
        }
        entity.setOccurrenceTotal(occurrenceTotal);
        entity.setTaxOccurrenceTotal(taxOccurrenceTotal);
        List<RevolvingleasedetailVO> saveRevolvingleasedetailEntities = saveorUpdateVO.getRevolvingleasedetailEntities();
        List<RevolvingleasedetailVO> revolvingleasedetailVOList = pastVo.getRevolvingleasedetailEntities();
        if (saveRevolvingleasedetailEntities != null && revolvingleasedetailVOList != null) {
            for (int i = 0; i < saveRevolvingleasedetailEntities.size(); ++i) {
                RevolvingleasedetailVO saveRevolvingleasedetailVO = saveRevolvingleasedetailEntities.get(i);
                String saveMaterialCode = saveRevolvingleasedetailVO.getMaterialCode();
                BigDecimal saveMonthlyExpenses = saveRevolvingleasedetailVO.getMonthlyExpenses();
                BigDecimal saveTaxMonthlyExpenses = saveRevolvingleasedetailVO.getTaxMonthlyExpenses() == null ? BigDecimal.ZERO : saveRevolvingleasedetailVO.getTaxMonthlyExpenses();
                for (int j = 0; j < revolvingleasedetailVOList.size(); ++j) {
                    RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(j);
                    String materialCode = revolvingleasedetailVO.getMaterialCode();
                    if (!materialCode.equals(saveMaterialCode)) continue;
                    BigDecimal monthlyExpenses = revolvingleasedetailVO.getMonthlyExpenses();
                    if (saveMonthlyExpenses != null) {
                        saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses == null ? new BigDecimal(0) : monthlyExpenses);
                    }
                    BigDecimal taxMonthlyExpenses = revolvingleasedetailVO.getTaxMonthlyExpenses() == null ? BigDecimal.ZERO : revolvingleasedetailVO.getTaxMonthlyExpenses();
                    saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses == null ? new BigDecimal(0) : taxMonthlyExpenses);
                }
                saveRevolvingleasedetailVO.setCumulativeAmount(saveMonthlyExpenses);
                saveRevolvingleasedetailVO.setTaxCumulativeAmount(saveTaxMonthlyExpenses);
            }
            for (RevolvingleasedetailVO vo : saveRevolvingleasedetailEntities) {
                RevolvingleasedetailVO revolvingleasedetailVO = this.service.queryCumulative(entity.getProjectId(), entity.getContractId(), vo.getMaterialCode(), vo.getEncode(), vo.getSection(), vo.getLesseeUnitprice(), vo.getTaxLesseeUnitprice());
                if (revolvingleasedetailVO != null) {
                    vo.setSumRentMoney(ComputeUtil.safeAdd((BigDecimal)vo.getLesseeTotalprice(), (BigDecimal)revolvingleasedetailVO.getSumRentMoney()));
                    vo.setSumRentMoneyTax(ComputeUtil.safeAdd((BigDecimal)vo.getTaxLesseeTotalprice(), (BigDecimal)revolvingleasedetailVO.getSumRentMoneyTax()));
                    vo.setSumCompensationMoney(ComputeUtil.safeAdd((BigDecimal)vo.getCompensateAccount(), (BigDecimal)revolvingleasedetailVO.getSumCompensationMoney()));
                    vo.setSumCompensationMoneyTax(ComputeUtil.safeAdd((BigDecimal)vo.getTaxCompensateAccount(), (BigDecimal)revolvingleasedetailVO.getSumCompensationMoneyTax()));
                    vo.setSumFeeMoney(ComputeUtil.safeAdd((BigDecimal)vo.getOtherExpenses(), (BigDecimal)revolvingleasedetailVO.getSumFeeMoney()));
                    vo.setSumFeeMoneyTax(ComputeUtil.safeAdd((BigDecimal)vo.getTaxOtherExpenses(), (BigDecimal)revolvingleasedetailVO.getSumFeeMoneyTax()));
                    vo.setLeaseDaysSumTime(ComputeUtil.safeAdd((BigDecimal)new BigDecimal(vo.getLesseeTerm()), (BigDecimal)revolvingleasedetailVO.getLeaseDaysSumTime()));
                } else {
                    vo.setSumRentMoney(vo.getLesseeTotalprice());
                    vo.setSumRentMoneyTax(vo.getTaxLesseeTotalprice());
                    vo.setSumCompensationMoney(vo.getCompensateAccount());
                    vo.setSumCompensationMoneyTax(vo.getTaxCompensateAccount());
                    vo.setSumFeeMoney(vo.getOtherExpenses());
                    vo.setSumFeeMoneyTax(vo.getTaxOtherExpenses());
                    vo.setLeaseDaysSumTime(new BigDecimal(vo.getLesseeTerm() == null ? 0 : vo.getLesseeTerm()));
                }
                entity.setCurrentCompensationMny(ComputeUtil.safeAdd((BigDecimal)entity.getCurrentCompensationMny(), (BigDecimal)vo.getCompensateAccount()));
                entity.setCurrentCompensationMnyTax(ComputeUtil.safeAdd((BigDecimal)entity.getCurrentCompensationMnyTax(), (BigDecimal)vo.getTaxCompensateAccount()));
                entity.setCurrentFeeMny(ComputeUtil.safeAdd((BigDecimal)entity.getCurrentFeeMny(), (BigDecimal)vo.getOtherExpenses()));
                entity.setCurrentFeeMnyTax(ComputeUtil.safeAdd((BigDecimal)entity.getCurrentFeeMnyTax(), (BigDecimal)vo.getTaxOtherExpenses()));
                entity.setSumCompensationMny(ComputeUtil.safeAdd((BigDecimal)entity.getSumCompensationMny(), (BigDecimal)vo.getSumCompensationMoney()));
                entity.setSumCompensationMnyTax(ComputeUtil.safeAdd((BigDecimal)entity.getSumCompensationMnyTax(), (BigDecimal)vo.getSumCompensationMoneyTax()));
                entity.setSumFeeMny(ComputeUtil.safeAdd((BigDecimal)entity.getSumFeeMny(), (BigDecimal)vo.getSumFeeMoney()));
                entity.setSumFeeMnyTax(ComputeUtil.safeAdd((BigDecimal)entity.getSumFeeMnyTax(), (BigDecimal)vo.getSumFeeMoneyTax()));
            }
            entity.setRevolvingleasedetailEntities(BeanMapper.mapList(saveRevolvingleasedetailEntities, RevolvingleasedetailEntity.class));
        }
        entity = this.checkBillCodeUniq(entity);
        entity.setIsFlag(0);
        this.service.saveOrUpdate((Object)entity, false);
        RevolvingleaseVO vo = (RevolvingleaseVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleaseVO.class));
        vo.setRevolvingleasedetailEntities(this.handleChildren(vo.getRevolvingleasedetailEntities()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/querySumById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<RevolvingleasedetailVO>> querySumById(@RequestBody List<RevolvingleasedetailVO> vos) {
        List<RevolvingleasedetailVO> list = this.service.querySumById(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RevolvingleaseEntity checkBillCodeUniq(RevolvingleaseEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> queryDetail(Long id) {
        RevolvingleaseEntity entity = (RevolvingleaseEntity)((Object)this.service.selectById(id));
        RevolvingleaseVO vo = (RevolvingleaseVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleaseVO.class));
        vo.setRevolvingleasedetailEntities(this.handleChildren(vo.getRevolvingleasedetailEntities()));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleaseVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List revolvingleaseVOList = BeanMapper.mapList((Iterable)list, RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); ++i) {
            String billStateStr;
            RevolvingleaseVO revolvingleaseVO = (RevolvingleaseVO)((Object)revolvingleaseVOList.get(i));
            revolvingleaseVO.setSort(String.valueOf(i + 1));
            if (revolvingleaseVO.getSettleTime() != null) {
                revolvingleaseVO.setSettleTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getSettleTime()));
            }
            if (revolvingleaseVO.getStartTime() != null) {
                revolvingleaseVO.setStartTimeShow(DateUtils.dateSimple2(revolvingleaseVO.getStartTime()));
            }
            if (revolvingleaseVO.getDeadline() != null) {
                revolvingleaseVO.setDeadlineShow(DateUtils.dateSimple2(revolvingleaseVO.getDeadline()));
            }
            if ((billStateStr = revolvingleaseVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            revolvingleaseVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleaseVOList);
        ExcelExport.getInstance().export("RevolvingleaseMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRevolvingleaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleaseVO>> refRevolvingleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("lessee_name");
        fuzzyFields.add("bill_code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List revolvingleaseVOList = BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleaseVO.class);
        for (int i = 0; i < revolvingleaseVOList.size(); ++i) {
            RevolvingleaseVO revolvingleaseVO = (RevolvingleaseVO)((Object)revolvingleaseVOList.get(i));
            revolvingleaseVO.setSort(String.valueOf(i + 1));
            QueryWrapper detailWrapper = new QueryWrapper();
            detailWrapper.eq((Object)"mid", (Object)revolvingleaseVO.getId());
            List entityList = this.revolvingleasedetailService.list((Wrapper)detailWrapper);
            if (entityList == null || entityList.size() <= 0) continue;
            List detailList = BeanMapper.mapList((Iterable)entityList, RevolvingleasedetailVO.class);
            revolvingleaseVO.setRevolvingleasedetailEntities(detailList);
        }
        pageData.setRecords(revolvingleaseVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> pastData(Long id, Long contractId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u6708\u5ea6\u5468\u8f6c\u7ed3\u7b97\u5355");
        }
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            RevolvingleaseEntity entity = (RevolvingleaseEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate, false)));
    }

    private RevolvingleaseVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList revolvingleasedetailEntityList = new ArrayList();
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                RevolvingleaseEntity revolvingleaseEntity = (RevolvingleaseEntity)((Object)proTotal.get(i));
                BigDecimal Total = revolvingleaseEntity.getTotal();
                BigDecimal TaxTotal = revolvingleaseEntity.getTaxTotal();
                if (occurrenceTotal != null && Total != null) {
                    occurrenceTotal = occurrenceTotal.add(revolvingleaseEntity.getTotal());
                }
                if (taxOccurrenceTotal != null && TaxTotal != null) {
                    taxOccurrenceTotal = taxOccurrenceTotal.add(revolvingleaseEntity.getTaxTotal());
                }
                if (!isSave) continue;
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)revolvingleaseEntity.getId());
                List detailList = this.revolvingleasedetailService.list((Wrapper)detailWrapper);
                revolvingleasedetailEntityList.addAll(detailList);
            }
        }
        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setOccurrenceTotal(occurrenceTotal);
        vo.setTaxOccurrenceTotal(taxOccurrenceTotal);
        vo.setContractId(contractId);
        vo.setRevolvingleasedetailEntities(BeanMapper.mapList(revolvingleasedetailEntityList, RevolvingleasedetailVO.class));
        return vo;
    }

    @RequestMapping(value={"/queryAmount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RevolvingleaseVO> queryAmount(Long contractId, Long projectId) {
        BigDecimal exTaxSettlementMonth = new BigDecimal(0);
        BigDecimal inTaxSettlementMonth = new BigDecimal(0);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List entityList = this.service.list((Wrapper)wrapper);
        for (RevolvingleaseEntity revolvinglease : entityList) {
            if (revolvinglease.getOccurrenceTotal() != null) {
                exTaxCumulative = exTaxCumulative.add(revolvinglease.getOccurrenceTotal());
            }
            if (revolvinglease.getTaxOccurrenceTotal() != null) {
                inTaxCumulative = inTaxCumulative.add(revolvinglease.getTaxOccurrenceTotal());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"mid", (Object)revolvinglease.getId());
            queryWrapper.eq((Object)"dr", (Object)0);
            List revolvingleasedetailEntities = this.revolvingleasedetailService.list((Wrapper)queryWrapper);
            for (RevolvingleasedetailEntity revolvingleasedetail : revolvingleasedetailEntities) {
                if (revolvingleasedetail.getMonthlyExpenses() != null) {
                    exTaxSettlementMonth = exTaxSettlementMonth.add(revolvingleasedetail.getMonthlyExpenses());
                }
                if (revolvingleasedetail.getTaxMonthlyExpenses() == null) continue;
                inTaxSettlementMonth = inTaxSettlementMonth.add(revolvingleasedetail.getTaxMonthlyExpenses());
            }
        }
        RevolvingleaseVO vo = new RevolvingleaseVO();
        vo.setTotal(exTaxSettlementMonth);
        vo.setTaxTotal(inTaxSettlementMonth);
        vo.setOccurrenceTotal(exTaxCumulative);
        vo.setTaxOccurrenceTotal(inTaxCumulative);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private List<RevolvingleasedetailVO> handleChildren(List<RevolvingleasedetailVO> voList) {
        Collections.sort(voList, new Comparator<RevolvingleasedetailVO>(){

            @Override
            public int compare(RevolvingleasedetailVO o1, RevolvingleasedetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });
        List tpidList = voList.stream().map(RevolvingleasedetailVO::getTpid).collect(Collectors.toList());
        for (RevolvingleasedetailVO revolvingleasedetailVO : voList) {
            List<RevolvingleasedetailVO> detailByPid = this.getDetailByPid(revolvingleasedetailVO.getTid(), voList);
            if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
            revolvingleasedetailVO.setSettleTime(null);
            revolvingleasedetailVO.setSettleTimeShow(null);
            revolvingleasedetailVO.setLesseeTerm(null);
            revolvingleasedetailVO.setLesseeQuantity(null);
            revolvingleasedetailVO.setLesseeUnitprice(null);
            revolvingleasedetailVO.setTaxLesseeUnitprice(null);
            revolvingleasedetailVO.setLossDamage(null);
            revolvingleasedetailVO.setCompensateUnitprice(null);
            revolvingleasedetailVO.setTaxCompensateUnitprice(null);
            revolvingleasedetailVO.setOtherExpenses(null);
            revolvingleasedetailVO.setTaxOtherExpenses(null);
            revolvingleasedetailVO.setEndTimeShow(null);
            BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeTotalprice() != null).map(RevolvingleasedetailVO::getLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxLesseeTotalprice() != null).map(RevolvingleasedetailVO::getTaxLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCompensateAccount() != null).map(RevolvingleasedetailVO::getCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCompensateAccount() != null).map(RevolvingleasedetailVO::getTaxCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getMonthlyExpenses() != null).map(RevolvingleasedetailVO::getMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxMonthlyExpenses() != null).map(RevolvingleasedetailVO::getTaxMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoney() != null).map(RevolvingleasedetailVO::getSumRentMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoneyTax() != null).map(RevolvingleasedetailVO::getSumRentMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoney() != null).map(RevolvingleasedetailVO::getSumCompensationMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoneyTax() != null).map(RevolvingleasedetailVO::getSumCompensationMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoney() != null).map(RevolvingleasedetailVO::getSumFeeMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoneyTax() != null).map(RevolvingleasedetailVO::getSumFeeMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCumulativeAmount() != null).map(RevolvingleasedetailVO::getCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCumulativeAmount() != null).map(RevolvingleasedetailVO::getTaxCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
            revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
            revolvingleasedetailVO.setCompensateAccount(compensateAccount);
            revolvingleasedetailVO.setTaxCompensateAccount(taxCompensateAccount);
            revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
            revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
            revolvingleasedetailVO.setSumRentMoney(sumRentMoney);
            revolvingleasedetailVO.setSumRentMoneyTax(sumRentMoneyTax);
            revolvingleasedetailVO.setSumCompensationMoney(sumCompensationMoney);
            revolvingleasedetailVO.setSumCompensationMoneyTax(sumCompensationMoneyTax);
            revolvingleasedetailVO.setSumFeeMoney(sumFeeMoney);
            revolvingleasedetailVO.setSumFeeMoneyTax(sumFeeMoneyTax);
            revolvingleasedetailVO.setCumulativeAmount(cumulativeAmount);
            revolvingleasedetailVO.setTaxCumulativeAmount(taxCumulativeAmount);
            this.subList.clear();
        }
        voList = RevolvingleaseController.createTreeData(voList);
        return voList;
    }

    public static List<RevolvingleasedetailVO> createTreeData(List<RevolvingleasedetailVO> list) {
        ArrayList<RevolvingleasedetailVO> resp = new ArrayList<RevolvingleasedetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, RevolvingleasedetailVO> listMap = new HashMap<String, RevolvingleasedetailVO>();
        for (RevolvingleasedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            RevolvingleasedetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            RevolvingleasedetailVO parent = (RevolvingleasedetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<RevolvingleasedetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<RevolvingleasedetailVO> children = new ArrayList<RevolvingleasedetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((RevolvingleasedetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private List<RevolvingleasedetailVO> getDetailByPid(String tid, List<RevolvingleasedetailVO> list) {
        for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            if (tid == null || !tid.equals(revolvingleasedetailVO.getTpid())) continue;
            this.getDetailByPid(revolvingleasedetailVO.getTid(), list);
            this.subList.add(revolvingleasedetailVO);
        }
        return this.subList;
    }
}

