/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.BigDecimalUtils;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"revolvingleaseExport"})
public class ExcelRevolvingleaseController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    List<RevolvingleasedetailVO> subList = new ArrayList<RevolvingleasedetailVO>();

    @RequestMapping(value={"/downloadRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"revolvingleasedetail-import.xlsx", (String)"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u5355\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        HashMap<String, RevolvingleasedetailVO> mapVO = new HashMap<String, RevolvingleasedetailVO>();
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<RevolvingleasedetailVO> successList = new ArrayList<RevolvingleasedetailVO>();
        ArrayList<RevolvingleasedetailVO> errorList = new ArrayList<RevolvingleasedetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        HashMap map = new HashMap();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                String errorMessage;
                String errorMessage2;
                String errorMessage3;
                String errorMessage4;
                String errorMessage5;
                String errorMessage6;
                String errorMessage7;
                int num1 = 0;
                RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                Object back = null;
                List datas = (List)result.get(i);
                revolvingleasedetailVO.setId(IdWorker.getId());
                revolvingleasedetailVO.setTid(String.valueOf(IdWorker.getId()));
                String encode = (String)datas.get(1);
                String section = (String)datas.get(2);
                String branch = (String)datas.get(3);
                String subitemDesc = (String)datas.get(4);
                if (StringUtils.isBlank((CharSequence)encode)) {
                    errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "'\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setEncode(StringUtils.isNotBlank((CharSequence)encode) ? encode : null);
                }
                if (StringUtils.isNotBlank((CharSequence)encode)) {
                    String code;
                    revolvingleasedetailVO.setInnercode(encode + "_" + section);
                    if ("01".equals(encode) && encode != null && encode.contains("\u88c5\u9970")) {
                        revolvingleasedetailVO.setInnercode("a1_" + revolvingleasedetailVO.getSection());
                    }
                    if (encode.length() >= 4 && ("0111".equals(code = encode.substring(0, 4)) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code))) {
                        revolvingleasedetailVO.setInnercode("a1" + encode.substring(2, encode.length()) + "_" + section);
                    }
                    if (encode == null || encode.length() != 2 && encode.length() != 4 && encode.length() != 6 && encode.length() < 9) {
                        revolvingleasedetailVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u5fc5\u987b\u7b26\u5408\uff1a2\u4f4d\u30014\u4f4d\u30016\u4f4d\u30019\u4f4d\u62169\u4f4d\u4ee5\u4e0a\u4e2d\u4efb\u610f\u4e00\u89c4\u5219");
                        ++num1;
                    }
                    revolvingleasedetailVO.setEncode(encode);
                    RevolvingleasedetailVO reVo = (RevolvingleasedetailVO)((Object)mapVO.get(revolvingleasedetailVO.getInnercode()));
                    if (reVo == null) {
                        mapVO.put(revolvingleasedetailVO.getInnercode(), revolvingleasedetailVO);
                    } else {
                        revolvingleasedetailVO.setErrorMsg("\u6e05\u5355\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
                        ++num1;
                    }
                    revolvingleasedetailVO.setEncode(encode);
                }
                if (StringUtils.isBlank((CharSequence)section)) {
                    errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "'\u533a\u6bb5'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                }
                revolvingleasedetailVO.setSection(StringUtils.isNotBlank((CharSequence)section) ? section : null);
                if (StringUtils.isBlank((CharSequence)branch)) {
                    errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "'\u5b50\u76ee\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                }
                revolvingleasedetailVO.setBranch(StringUtils.isNotBlank((CharSequence)branch) ? branch : null);
                if (StringUtils.isBlank((CharSequence)subitemDesc)) {
                    errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "'\u5b50\u76ee\u7279\u5f81\u63cf\u8ff0'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                }
                revolvingleasedetailVO.setSubitemDesc(StringUtils.isNotBlank((CharSequence)subitemDesc) ? subitemDesc : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5)))) {
                    errorMessage7 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage7 == null) {
                        errorMessage7 = "";
                    }
                    errorMessage7 = errorMessage7 + "'\u7269\u8d44\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage7);
                    ++num1;
                }
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(5));
                MaterialVO back0Data = (MaterialVO)back0.getData();
                if (back0.getCode() == 1 || back0Data == null) {
                    String errorMessage8 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage8 == null) {
                        errorMessage8 = "";
                    }
                    errorMessage8 = errorMessage8 + "\u672a\u67e5\u8be2\u5230\u8be5\u7269\u8d44\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5";
                    revolvingleasedetailVO.setErrorMsg(errorMessage8);
                    ++num1;
                    errorList.add(revolvingleasedetailVO);
                    continue;
                }
                revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? (String)datas.get(5) : null);
                revolvingleasedetailVO.setLesseeMaterialsName(((MaterialVO)back0.getData()).getName());
                revolvingleasedetailVO.setSpecifications(((MaterialVO)back0.getData()).getSpec());
                revolvingleasedetailVO.setMeasurementUnit(((MaterialVO)back0.getData()).getUnitName());
                revolvingleasedetailVO.setMaterialCategoryId(((MaterialVO)back0.getData()).getCategoryId());
                revolvingleasedetailVO.setMaterialCategoryCode(((MaterialVO)back0.getData()).getCode());
                revolvingleasedetailVO.setMaterialCategoryName(((MaterialVO)back0.getData()).getCategoryName());
                BigDecimal num = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9))) || datas.get(9) == null) {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u79df\u8d41\u6570\u91cf'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    if (!NumberUtil.isNumber((String)((String)datas.get(9)))) {
                        if (errorMessage6 == null) {
                            errorMessage6 = "";
                        }
                        errorMessage6 = errorMessage6 + "'\u79df\u8d41\u6570\u91cf'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    }
                    ++num1;
                } else {
                    num = num.add(new BigDecimal((int)Float.parseFloat((String)datas.get(9))));
                    revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? Integer.valueOf((int)Float.parseFloat((String)datas.get(9))) : null);
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) && datas.get(10) != null) {
                    if (!DateUtils.grepDate((String)datas.get(10))) {
                        errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage6 == null) {
                            errorMessage6 = "";
                        }
                        errorMessage6 = errorMessage6 + "'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage6);
                        ++num1;
                    } else {
                        revolvingleasedetailVO.setSettleTime(DateUtils.Date((String)datas.get(10)));
                    }
                } else {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u672c\u671f\u8ba1\u7b97\u8d77\u59cb\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) && datas.get(11) != null) {
                    revolvingleasedetailVO.setEndTime(DateUtils.Date((String)datas.get(11)));
                    if (!DateUtils.grepDate((String)datas.get(11))) {
                        errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage6 == null) {
                            errorMessage6 = "";
                        }
                        errorMessage6 = errorMessage6 + "'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65f6\u95f4'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage6);
                        ++num1;
                    }
                } else {
                    errorMessage6 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage6 == null) {
                        errorMessage6 = "";
                    }
                    errorMessage6 = errorMessage6 + "'\u672c\u671f\u8ba1\u7b97\u7ec8\u6b62\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage6);
                    ++num1;
                }
                BigDecimal dayValue = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) && datas.get(12) != null) {
                    Integer value = (int)Float.parseFloat((String)datas.get(12));
                    if (!NumberUtil.isNumber((String)((String)datas.get(12)))) {
                        errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage5 == null) {
                            errorMessage5 = "";
                        }
                        errorMessage5 = errorMessage5 + "'\u672c\u671f\u79df\u8d41\u671f\u957f(\u5929)'\u8f93\u5165\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage5);
                        ++num1;
                    } else {
                        revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? value : null);
                        dayValue = dayValue.add(new BigDecimal(value));
                        revolvingleasedetailVO.setTaxLesseeUnitprice(dayValue);
                    }
                    revolvingleasedetailVO.setLesseeTerm((int)value);
                } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) && datas.get(11) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) && datas.get(10) != null) {
                    long between = DateUtil.between((Date)DateUtils.Date((String)datas.get(10)), (Date)DateUtils.Date((String)datas.get(11)), (DateUnit)DateUnit.DAY);
                    dayValue = new BigDecimal((int)between);
                    revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int)between) + 1);
                }
                BigDecimal exUnitPrice = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) && datas.get(13) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(13)))) {
                        errorMessage5 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage5 == null) {
                            errorMessage5 = "";
                        }
                        errorMessage5 = errorMessage5 + "'\u79df\u8d41\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage5);
                        ++num1;
                    } else {
                        exUnitPrice = exUnitPrice.add(new BigDecimal((String)datas.get(13)));
                        revolvingleasedetailVO.setLesseeUnitprice(exUnitPrice);
                    }
                } else {
                    revolvingleasedetailVO.setLesseeUnitprice(null);
                }
                BigDecimal inUnitPrice = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) && datas.get(14) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(14)))) {
                        String errorMessage9 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage9 == null) {
                            errorMessage9 = "";
                        }
                        errorMessage9 = errorMessage9 + "'\u79df\u8d41\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage9);
                        ++num1;
                    } else {
                        inUnitPrice = inUnitPrice.add(new BigDecimal((String)datas.get(14)));
                        revolvingleasedetailVO.setTaxLesseeUnitprice(inUnitPrice);
                    }
                } else {
                    revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                }
                BigDecimal exTotal = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) && datas.get(15) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(15)))) {
                        String errorMessage10 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage10 == null) {
                            errorMessage10 = "";
                        }
                        errorMessage10 = errorMessage10 + "'\u79df\u8d41\u5408\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage10);
                        ++num1;
                    } else {
                        exTotal = exTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                        revolvingleasedetailVO.setLesseeTotalprice(num.multiply(dayValue).multiply(exUnitPrice));
                    }
                } else {
                    BigDecimal lesseeTotalprice = new BigDecimal(revolvingleasedetailVO.getLesseeQuantity() == null ? 0 : revolvingleasedetailVO.getLesseeQuantity()).multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm())).multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getLesseeUnitprice()));
                    revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
                }
                BigDecimal inTotal = new BigDecimal(0);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) && datas.get(16) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(16)))) {
                        String errorMessage11 = revolvingleasedetailVO.getErrorMsg();
                        if (errorMessage11 == null) {
                            errorMessage11 = "";
                        }
                        errorMessage11 = errorMessage11 + "'\u79df\u8d41\u5408\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                        revolvingleasedetailVO.setErrorMsg(errorMessage11);
                        ++num1;
                    } else {
                        inTotal = inTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                        revolvingleasedetailVO.setTaxLesseeTotalprice(num.multiply(dayValue).multiply(inUnitPrice));
                    }
                } else {
                    BigDecimal taxLesseeTotalprice = new BigDecimal(revolvingleasedetailVO.getLesseeQuantity() == null ? 0 : revolvingleasedetailVO.getLesseeQuantity()).multiply(new BigDecimal(revolvingleasedetailVO.getLesseeTerm() == null ? 0 : revolvingleasedetailVO.getLesseeTerm())).multiply(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxLesseeUnitprice()));
                    revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
                }
                BigDecimal findNum = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(17))) || datas.get(17) == null) {
                    errorMessage4 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage4 == null) {
                        errorMessage4 = "";
                    }
                    errorMessage4 = errorMessage4 + "'\u4e22\u5931\u635f\u574f\u91cf'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage4);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(17)))) {
                    errorMessage4 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage4 == null) {
                        errorMessage4 = "";
                    }
                    errorMessage4 = errorMessage4 + "'\u4e22\u5931\u635f\u574f\u91cf'\u8f93\u5165\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage4);
                    ++num1;
                } else {
                    findNum = findNum.add(new BigDecimal((String)datas.get(17)));
                    revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17))) ? new BigDecimal((String)datas.get(17)) : null);
                }
                BigDecimal pexUnitPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(18))) || datas.get(18) == null) {
                    errorMessage3 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage3 == null) {
                        errorMessage3 = "";
                    }
                    errorMessage3 = errorMessage3 + "'\u8d54\u507f\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage3);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(18)))) {
                    errorMessage3 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage3 == null) {
                        errorMessage3 = "";
                    }
                    errorMessage3 = errorMessage3 + "'\u8d54\u507f\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage3);
                    ++num1;
                } else {
                    pexUnitPrice = pexUnitPrice.add(new BigDecimal((String)datas.get(18)));
                    revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18))) ? new BigDecimal((String)datas.get(18)) : null);
                }
                BigDecimal pinUnitPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(19))) || datas.get(19) == null) {
                    errorMessage2 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage2 == null) {
                        errorMessage2 = "";
                    }
                    errorMessage2 = errorMessage2 + "'\u8d54\u507f\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage2);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(19)))) {
                    errorMessage2 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage2 == null) {
                        errorMessage2 = "";
                    }
                    errorMessage2 = errorMessage2 + "'\u8d54\u507f\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage2);
                    ++num1;
                } else {
                    pinUnitPrice = pinUnitPrice.add(new BigDecimal((String)datas.get(19)));
                    revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19))) ? new BigDecimal((String)datas.get(19)) : null);
                }
                BigDecimal exAmount = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(20))) || datas.get(20) == null) {
                    exAmount = exAmount.add(findNum.multiply(pexUnitPrice));
                    revolvingleasedetailVO.setCompensateAccount(exAmount);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(20)))) {
                    String errorMessage12 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage12 == null) {
                        errorMessage12 = "";
                    }
                    errorMessage12 = errorMessage12 + "'\u8d54\u507f\u91d1\u989d((\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage12);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setCompensateAccount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(20))) ? new BigDecimal((String)datas.get(20)) : null);
                }
                BigDecimal inAmount = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(21))) || datas.get(21) == null) {
                    inAmount = inAmount.add(findNum.multiply(pinUnitPrice));
                    revolvingleasedetailVO.setTaxCompensateAccount(inAmount);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(21)))) {
                    String errorMessage13 = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage13 == null) {
                        errorMessage13 = "";
                    }
                    errorMessage13 = errorMessage13 + "'\u8d54\u507f\u91d1\u989d((\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage13);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(21))) ? new BigDecimal((String)datas.get(21)) : null);
                }
                BigDecimal cleanEx = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(22))) || datas.get(22) == null) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(22)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(22))) ? new BigDecimal((String)datas.get(22)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(23))) || datas.get(23) == null) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else if (!NumberUtil.isNumber((String)((String)datas.get(23)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6e05\u7406\u7ef4\u4fee\u8d39\u975e\u7b49\u5176\u4ed6\u8d39\u7528(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(23))) ? new BigDecimal((String)datas.get(23)) : null);
                }
                if (datas.get(24) != null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(24)))) {
                    BigDecimal monthlyExpenses = BigDecimalUtils.ofNullable(revolvingleasedetailVO.getLesseeTotalprice()).add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getCompensateAccount())).add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getOtherExpenses()));
                    revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(24)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(24))) ? new BigDecimal((String)datas.get(24)) : null);
                }
                if (datas.get(25) != null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(25)))) {
                    BigDecimal taxMonthlyExpenses = BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxLesseeTotalprice()).add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxCompensateAccount())).add(BigDecimalUtils.ofNullable(revolvingleasedetailVO.getTaxOtherExpenses()));
                    revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(25)))) {
                    errorMessage = revolvingleasedetailVO.getErrorMsg();
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "'\u6708\u5ea6\u7ed3\u7b97\u8d39\u7528(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef";
                    revolvingleasedetailVO.setErrorMsg(errorMessage);
                    ++num1;
                } else {
                    revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(25))) ? new BigDecimal((String)datas.get(25)) : null);
                }
                revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(26))) ? String.valueOf(datas.get(26)) : null);
                if (num1 > 0) {
                    errorList.add(revolvingleasedetailVO);
                    continue;
                }
                successList.add(revolvingleasedetailVO);
            }
        }
        Collections.sort(successList, new Comparator<RevolvingleasedetailVO>(){

            @Override
            public int compare(RevolvingleasedetailVO o1, RevolvingleasedetailVO o2) {
                return (o1.getEncode() + o1.getSection()).compareTo(o2.getEncode() + o2.getSection());
            }
        });
        List<RevolvingleasedetailVO> resList = this.setTidAndTpid(successList, mapVO);
        List tpidList = resList.stream().map(RevolvingleasedetailVO::getTpid).collect(Collectors.toList());
        for (RevolvingleasedetailVO revolvingleasedetailVO : resList) {
            List<RevolvingleasedetailVO> detailByPid = this.getDetailByPid(revolvingleasedetailVO.getTid(), resList);
            if (!CollectionUtils.isNotEmpty(detailByPid)) continue;
            revolvingleasedetailVO.setSettleTime(null);
            revolvingleasedetailVO.setSettleTimeShow(null);
            revolvingleasedetailVO.setLesseeTerm(null);
            revolvingleasedetailVO.setLesseeQuantity(null);
            revolvingleasedetailVO.setLesseeUnitprice(null);
            revolvingleasedetailVO.setTaxLesseeUnitprice(null);
            revolvingleasedetailVO.setLossDamage(null);
            revolvingleasedetailVO.setCompensateUnitprice(null);
            revolvingleasedetailVO.setTaxCompensateUnitprice(null);
            revolvingleasedetailVO.setOtherExpenses(null);
            revolvingleasedetailVO.setTaxOtherExpenses(null);
            revolvingleasedetailVO.setEndTimeShow(null);
            BigDecimal lesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getLesseeTotalprice() != null).map(RevolvingleasedetailVO::getLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxLesseeTotalprice = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxLesseeTotalprice() != null).map(RevolvingleasedetailVO::getTaxLesseeTotalprice).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal compensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCompensateAccount() != null).map(RevolvingleasedetailVO::getCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCompensateAccount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCompensateAccount() != null).map(RevolvingleasedetailVO::getTaxCompensateAccount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal monthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getMonthlyExpenses() != null).map(RevolvingleasedetailVO::getMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxMonthlyExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxMonthlyExpenses() != null).map(RevolvingleasedetailVO::getTaxMonthlyExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoney() != null).map(RevolvingleasedetailVO::getSumRentMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumRentMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumRentMoneyTax() != null).map(RevolvingleasedetailVO::getSumRentMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoney() != null).map(RevolvingleasedetailVO::getSumCompensationMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumCompensationMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumCompensationMoneyTax() != null).map(RevolvingleasedetailVO::getSumCompensationMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoney = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoney() != null).map(RevolvingleasedetailVO::getSumFeeMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumFeeMoneyTax = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getSumFeeMoneyTax() != null).map(RevolvingleasedetailVO::getSumFeeMoneyTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getCumulativeAmount() != null).map(RevolvingleasedetailVO::getCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxCumulativeAmount = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxCumulativeAmount() != null).map(RevolvingleasedetailVO::getTaxCumulativeAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal otherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getOtherExpenses() != null).map(RevolvingleasedetailVO::getOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxOtherExpenses = detailByPid.stream().filter(s -> !tpidList.contains(s.getTid()) && s.getTaxOtherExpenses() != null).map(RevolvingleasedetailVO::getTaxOtherExpenses).reduce(BigDecimal.ZERO, BigDecimal::add);
            revolvingleasedetailVO.setOtherExpenses(otherExpenses);
            revolvingleasedetailVO.setTaxOtherExpenses(taxOtherExpenses);
            revolvingleasedetailVO.setLesseeTotalprice(lesseeTotalprice);
            revolvingleasedetailVO.setTaxLesseeTotalprice(taxLesseeTotalprice);
            revolvingleasedetailVO.setCompensateAccount(compensateAccount);
            revolvingleasedetailVO.setTaxCompensateAccount(taxCompensateAccount);
            revolvingleasedetailVO.setMonthlyExpenses(monthlyExpenses);
            revolvingleasedetailVO.setTaxMonthlyExpenses(taxMonthlyExpenses);
            revolvingleasedetailVO.setSumRentMoney(sumRentMoney);
            revolvingleasedetailVO.setSumRentMoneyTax(sumRentMoneyTax);
            revolvingleasedetailVO.setSumCompensationMoney(sumCompensationMoney);
            revolvingleasedetailVO.setSumCompensationMoneyTax(sumCompensationMoneyTax);
            revolvingleasedetailVO.setSumFeeMoney(sumFeeMoney);
            revolvingleasedetailVO.setSumFeeMoneyTax(sumFeeMoneyTax);
            revolvingleasedetailVO.setCumulativeAmount(cumulativeAmount);
            revolvingleasedetailVO.setTaxCumulativeAmount(taxCumulativeAmount);
            this.subList.clear();
        }
        resList = ExcelRevolvingleaseController.createTreeData(resList);
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)resList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    private List<RevolvingleasedetailVO> getDetailByPid(String tid, List<RevolvingleasedetailVO> list) {
        for (RevolvingleasedetailVO revolvingleasedetailVO : list) {
            if (tid == null || !tid.equals(revolvingleasedetailVO.getTpid())) continue;
            this.getDetailByPid(revolvingleasedetailVO.getTid(), list);
            this.subList.add(revolvingleasedetailVO);
        }
        return this.subList;
    }

    public static List<RevolvingleasedetailVO> createTreeData(List<RevolvingleasedetailVO> list) {
        ArrayList<RevolvingleasedetailVO> resp = new ArrayList<RevolvingleasedetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, RevolvingleasedetailVO> listMap = new HashMap<String, RevolvingleasedetailVO>();
        for (RevolvingleasedetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            RevolvingleasedetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            RevolvingleasedetailVO parent = (RevolvingleasedetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<RevolvingleasedetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<RevolvingleasedetailVO> children = new ArrayList<RevolvingleasedetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((RevolvingleasedetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    private List<RevolvingleasedetailVO> setTidAndTpid(List<RevolvingleasedetailVO> vos, Map<String, RevolvingleasedetailVO> map) {
        if (vos == null) {
            return null;
        }
        for (int i = 0; i < vos.size(); ++i) {
            RevolvingleasedetailVO consdrawbudgetdetailVO = vos.get(i);
            String innercode = consdrawbudgetdetailVO.getInnercode();
            String[] innercodeSubArr = innercode.split("_");
            String innercodeSub = "";
            String sectionSuf = "";
            if (innercodeSubArr.length > 1) {
                innercodeSub = innercodeSubArr[0];
                sectionSuf = "_" + innercodeSubArr[1];
            }
            Long pid = null;
            if (innercodeSub.length() != 2) {
                String pcode;
                if (innercodeSub.length() == 4) {
                    pcode = innercodeSub.substring(0, 2) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() == 6) {
                    pcode = innercodeSub.substring(0, 4) + sectionSuf;
                    pid = this.setPid(pcode, map);
                } else if (innercodeSub.length() > 6) {
                    pcode = innercodeSub.substring(0, 6) + sectionSuf;
                    pid = this.setPid(pcode, map);
                }
            }
            if (pid != null) {
                consdrawbudgetdetailVO.setTpid(pid.toString());
                continue;
            }
            consdrawbudgetdetailVO.setTpid("");
        }
        return vos;
    }

    private Long setPid(String pcode, Map<String, RevolvingleasedetailVO> map) {
        if (map.get(pcode) != null) {
            return Long.valueOf(map.get(pcode).getTid());
        }
        String[] pcodeSubArr = pcode.split("_");
        String pcodeSub = "";
        String sectionSuf = "";
        if (pcodeSubArr.length > 1) {
            pcodeSub = pcodeSubArr[0];
            sectionSuf = "_" + pcodeSubArr[1];
        }
        if (pcodeSub.length() == 2) {
            return null;
        }
        if (pcodeSub.length() == 4) {
            String ppcode = pcodeSub.substring(0, 2);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() == 6) {
            String ppcode = pcode.substring(0, 4);
            return this.setPid(ppcode + sectionSuf, map);
        }
        if (pcodeSub.length() > 6) {
            String ppcode = pcode.substring(0, 6);
            return this.setPid(ppcode + sectionSuf, map);
        }
        return null;
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)revolvingleaseVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.revolvingleasedetailService.list((Wrapper)queryWrapper);
        List revolvingleasedetailVOList = BeanMapper.mapList((Iterable)list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = (RevolvingleasedetailVO)((Object)revolvingleasedetailVOList.get(i));
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List<RevolvingleasedetailVO>> beans = new HashMap<String, List<RevolvingleasedetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }
}

