package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.*;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.*;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 成本管理
 */
@Controller
@RequestMapping("/api/cost/")
public class CostApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubcontractingvolumeService subcontractingvolumeService;

    @Autowired
    private IVisaclaimaccountService iVisaclaimaccountService;

    @Autowired
    private IEngineermeasurementService iEngineermeasurementService;//工程计量台账

    @Autowired
    private ISubcontractaccountService iSubcontractaccountService;//分包月度报量台账

    @Autowired
    private IPurchasesummaryService iPurchasesummaryService;//月度物资采购结算汇总

    @Autowired
    private IRevolvingleasesummaryService iRevolvingleasesummaryService;//月度周转租赁结算汇总

    @Autowired
    private IMechanicalleasedetotalService iMechanicalleasedetotalService;//月度机械设备租赁结算汇总

    @Autowired
    private ISubcontractingvolumeService iSubcontractingvolumeService;//分包月度报量及申请报告-月度（中间）计量计价明细表

    @Autowired
    private IRevolvingleaseService iRevolvingleaseService;//月度周转租赁单

    @Autowired
    private IRevolvingleasedetailService iRevolvingleasedetailService;//月度周转租赁单明细

    @Autowired
    private ISubcontractingvolumemdetailService iSubcontractingvolumemdetailService;//分包月度报量及申请报告-物资代扣及超用扣款清单

    @Autowired
    private ISubcontractingvolumeodetailService iSubcontractingvolumeodetailService;//分包月度报量及申请报告-其他

    @Autowired
    private ISubcontractingvolumedetailService iSubcontractingvolumedetailService;//分包月度报量及申请报告-月度（中间）计量计价明细表

    @Autowired
    private ISubcontractaccountdetailService subcontractaccountdetailService;//分包月度报量台账子表

    @Autowired
    IRevolvingleasedetailService revolvingleasedetailService; // 月度周转租赁结算单子表

    /**
     * 成本核算的人工费、分包费
     *
     * @return
     */
    @RequestMapping(value = "queryCostaccountLabor", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryCostaccountLabor(@RequestParam(value = "projectId") Long projectId, @RequestParam String costaccountTime) {
        QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.le("create_time", costaccountTime);
        List<SubcontractingvolumeEntity> list = subcontractingvolumeService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            SubcontractingvolumeEntity subcontractingvolume = list.get(i);
            if (subcontractingvolume.getTaxCurrentTotal() != null) {
                total = total.add(subcontractingvolume.getTaxCurrentTotal());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-合同延长天数
     */
    @RequestMapping(value = "queryProjectreportExtendday", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Integer> queryProjectreportExtendday(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr", 0);
        List<VisaclaimaccountEntity> visaclaimaccountList = iVisaclaimaccountService.list(queryWrapper);
        Integer total = 0;
        for (int j = 0; j < visaclaimaccountList.size(); j++) {
            List<VisaclaimaccountdetailEntity> visaclaimaccountDetailList = iVisaclaimaccountService.selectById(visaclaimaccountList.get(j).getId()).getVisaclaimaccountdetailEntities();
            for (int i = 0; i < visaclaimaccountDetailList.size(); i++) {
                VisaclaimaccountdetailEntity visaclaimaccountdetailEntity = visaclaimaccountDetailList.get(i);
                if (visaclaimaccountdetailEntity.getDeferredDays() != null) {
                    total = total + visaclaimaccountdetailEntity.getDeferredDays();
                }
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-合同期内已获索赔的签证份数
     */
    @RequestMapping(value = "queryProjectreportNum", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Integer> queryProjectreportNum(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr", 0);
        List<VisaclaimaccountEntity> visaclaimaccountList = iVisaclaimaccountService.list(queryWrapper);
        return CommonResponse.success("查询数据成功", visaclaimaccountList.size());
    }

    /**
     * 项目部商务经理月度报告-合同期内已获批准的费用索赔费用金额
     */
    @RequestMapping(value = "queryProjectreportMoney", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportMoney(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr", 0);
        List<VisaclaimaccountEntity> list = iVisaclaimaccountService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).getInConfirmAmountOpposite() != null) {
                total = total.add(list.get(i).getInConfirmAmountOpposite());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-建设方核定工程量
     */
    @RequestMapping(value = "queryProjectreportBulider", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportBulider(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).getCurrentBatch() != null) {
                total = total.add(list.get(i).getCurrentBatch());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-已申报工程量、已完成工程数额
     */
    @RequestMapping(value = "queryProjectreportDeclared", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportDeclared(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).getActualCompletedThisPeriod() != null) {
                total = total.add(list.get(i).getActualCompletedThisPeriod());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-已完成工程到款总计
     */
    @RequestMapping(value = "queryProjectreportFinishprojectmoneytotal", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportFinishprojectmoneytotal(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).getCurrentCollection() != null) {
                total = total.add(list.get(i).getCurrentCollection());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 债务分析-项目债务
     */
    @RequestMapping(value = "queryDebtanalysisProjectdebt", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryDebtanalysisProjectdebt(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        BigDecimal totalSub1 = new BigDecimal("0.00");
        BigDecimal totalSub2 = new BigDecimal("0.00");
        QueryWrapper<SubcontractaccountEntity> queryWrapperSub = new QueryWrapper<>();
        queryWrapperSub.eq("project_id", projectId);
        queryWrapperSub.le("create_time", time);
        queryWrapperSub.eq("dr", 0);
        List<SubcontractaccountEntity> listSub = iSubcontractaccountService.list(queryWrapperSub);
        for (int j = 0; j < listSub.size(); j++) {
            List<SubcontractaccountdetailEntity> detailListSub = iSubcontractaccountService.selectById(listSub.get(j).getId()).getSubcontractaccountdetailEntities();
            for (int i = 0; i < detailListSub.size(); i++) {
                if (detailListSub.get(i).getTaxCumulativeApproval() != null) {
                    totalSub1 = totalSub1.add(detailListSub.get(i).getTaxCumulativeApproval());
                }
                if (detailListSub.get(i).getCumulativePayment() != null) {
                    totalSub2 = totalSub2.add(detailListSub.get(i).getCumulativePayment());
                }
            }
        }

        BigDecimal totalPur1 = new BigDecimal("0.00");
        BigDecimal totalPur2 = new BigDecimal("0.00");
        QueryWrapper<PurchasesummaryEntity> queryWrapperPur = new QueryWrapper<>();
        queryWrapperPur.eq("project_id", projectId);
        queryWrapperPur.le("create_time", time);
        queryWrapperPur.eq("dr", 0);
        List<PurchasesummaryEntity> listPur = iPurchasesummaryService.list(queryWrapperPur);
        for (int j = 0; j < listPur.size(); j++) {
            if (listPur.get(j).getTaxSettlementAmount() != null) {
                totalPur1 = totalPur1.add(listPur.get(j).getTaxSettlementAmount());
            }
            if (listPur.get(j).getCumulativePayment() != null) {
                totalPur2 = totalPur2.add(listPur.get(j).getCumulativePayment());
            }
        }

        BigDecimal totalRev1 = new BigDecimal("0.00");
        BigDecimal totalRev2 = new BigDecimal("0.00");
        QueryWrapper<RevolvingleasesummaryEntity> queryWrapperRev = new QueryWrapper<>();
        queryWrapperRev.eq("project_id", projectId);
        queryWrapperRev.le("create_time", time);
        queryWrapperRev.eq("dr", 0);
        List<RevolvingleasesummaryEntity> listRev = iRevolvingleasesummaryService.list(queryWrapperRev);
        for (int j = 0; j < listRev.size(); j++) {
            if (listRev.get(j).getTaxSettleAccount() != null) {
                totalRev1 = totalRev1.add(listRev.get(j).getTaxSettleAccount());
            }
            if (listRev.get(j).getCumulativePayment() != null) {
                totalRev2 = totalRev2.add(listRev.get(j).getCumulativePayment());
            }
        }

        BigDecimal totalMec1 = new BigDecimal("0.00");
        BigDecimal totalMec2 = new BigDecimal("0.00");
        QueryWrapper<MechanicalleasedetotalEntity> queryWrapperMec = new QueryWrapper<>();
        queryWrapperMec.eq("project_id", projectId);
        queryWrapperMec.le("create_time", time);
        queryWrapperMec.eq("dr", 0);
        List<MechanicalleasedetotalEntity> listMec = iMechanicalleasedetotalService.list(queryWrapperMec);
        for (int j = 0; j < listMec.size(); j++) {
            if (listMec.get(j).getInTaxMonthSettlement() != null) {
                totalMec1 = totalMec1.add(listMec.get(j).getInTaxMonthSettlement());
            }
            if (listMec.get(j).getInTaxCumulativePaid() != null) {
                totalMec2 = totalMec2.add(listMec.get(j).getInTaxCumulativePaid());
            }
        }
        BigDecimal total1 = totalSub1.add(totalPur1).add(totalRev1).add(totalMec1);
        BigDecimal total2 = totalSub2.add(totalPur2).add(totalRev2).add(totalMec2);

        return CommonResponse.success("查询数据成功", total1.subtract(total2));
    }

   /**
    * @Description
    * <p>
    * 使用：成本管理-项目月度成本分析报告-子表人工费分包费本期实际成本
    * 数据来源：中间计量-分包月度报量及申请报告-月度（中间）计量计价明细表
    * 人工费或分包费
    * status 0-获取计价明细表的数量、无税金额、含税金额 1-获取物资代扣及超用扣款清单中的超用扣款和代扣款 2-获取其他扣款金额
    */
    @RequestMapping(value = "/queryLaborCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,LaborCostVO>> queryLaborCost(@RequestBody LaborCostRequestVO laborCostRequestVO) throws ParseException {
        logger.info("时间=" + laborCostRequestVO.getReportingTime());
        Map<String,LaborCostVO> map = new HashMap<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        Date time = sdf.parse(laborCostRequestVO.getReportingTime());
        String date = sdf1.format(time);
        if(laborCostRequestVO.getStatus() == null && laborCostRequestVO.getList().size() > 0){
            for(LaborCostRequestDetailVO entity : laborCostRequestVO.getList()){
                LaborCostVO vo =  iSubcontractingvolumedetailService.getPricing(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),entity.getSubitemCode(),entity.getSection(),date);
                map.put(entity.getSubitemCode()+entity.getSection(),vo);
            }
            LaborCostVO vo1 = iSubcontractingvolumedetailService.getOverdeduction(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            map.put("超用扣款",vo1);
            LaborCostVO vo2 = iSubcontractingvolumedetailService.getOtherCost(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            map.put("其他扣款及代扣款",vo2);
        }
        if(laborCostRequestVO.getStatus() != null && laborCostRequestVO.getStatus().equals("0")){
            LaborCostVO vo1 = iSubcontractingvolumedetailService.getOverdeduction(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            map.put("超用扣款",vo1);
            LaborCostVO vo2 = iSubcontractingvolumedetailService.getOtherCost(laborCostRequestVO.getContractType(),laborCostRequestVO.getProjectId(),date);
            map.put("其他扣款及代扣款",vo2);
        }
        return CommonResponse.success("查询数据成功!",map);
    }
    /**
     * @Description queryActualCost
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表人工费分包费本期实际成本
     * 数据来源：中间计量-分包月度报量及申请报告-月度（中间）计量计价明细表
     */
    @RequestMapping(value = "/queryActualCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvolumeResultVo> queryActualCost(Long projectId, String subitemCode, String section, String reportingTime) {
        SubcontractvolumeResultVo resList = new SubcontractvolumeResultVo();
        List<SubcontractvolumeVo> resList2 = new ArrayList<>();
        List<SubcontractvolumemVo> resList3 = new ArrayList<>();
        List<SubcontractvolumeotherVo> resList4 = new ArrayList<>();

        if (reportingTime == null || reportingTime.length() < 7) {
            throw new BusinessException("日期不能为空");
        }

        //当月第一天
        String start = reportingTime.substring(0, 7) + "-01";
        //当月最后一天
//        String end = "2022-06-30";

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(reportingTime.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(reportingTime.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());

        if (StringUtils.isBlank(reportingTime)) {
            return CommonResponse.error("报量时间为空！");
        }

        String[] strArr = reportingTime.split("-");
        if (strArr.length > 1) {
//            String year = strArr[0];
//            String month = strArr[1];
//            String firstDay = MonthUtil.getFirstDayOfMonth(year, month);
//            String lastDay = MonthUtil.getLastDayOfMonth(year, month);

            QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper();
            queryWrapper.eq("project_id", projectId);
            queryWrapper.eq("dr", 0);
            queryWrapper.in("bill_state", "1", "3");
            queryWrapper.le("reporting_time", end);
            queryWrapper.ge("reporting_time", start);
            //  queryWrapper.ge("reporting_time", reportingTime);
            List<SubcontractingvolumeEntity> mList = iSubcontractingvolumeService.list(queryWrapper);
            if (mList != null && mList.size() > 0) {
                Map<String, SubcontractvolumeVo> detailMap = new HashMap<>();
                for (SubcontractingvolumeEntity item :
                        mList) {
                    //合同类型
                    String contractType = item.getContractType();

                    if ("劳务分包".equals(contractType)) {
                        QueryWrapper<SubcontractingvolumedetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("subitem_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        //月度（中间）计量计价明细表
                        List<SubcontractingvolumedetailEntity> detailList = iSubcontractingvolumedetailService.list(statementDetailQueryWrapper);
                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                SubcontractingvolumedetailEntity detailEntity = detailList.get(i);
                                String subitemCode1 = detailEntity.getSubitemCode();//编码
                                String section1 = detailEntity.getSection();//区段
                                //从map获取月度（中间）计量计价明细表，如果为空，把service查回的数据放进map，否则，用map的数据和查回的相加
                                SubcontractvolumeVo mapDetailVo = detailMap.get(subitemCode1 + section1);

                                SubcontractvolumeVo subcontractvolumeVo = new SubcontractvolumeVo();

                                BigDecimal examineQuantity = detailEntity.getExamineQuantity() == null ? new BigDecimal(0): detailEntity.getExamineQuantity();//项目部审核-数量
                                BigDecimal examineAmounts = detailEntity.getExamineAmounts() == null ? new BigDecimal(0) : detailEntity.getExamineAmounts();//项目部审核-除税金额
                                BigDecimal examineTaxAmounts = detailEntity.getExamineTaxAmounts() == null ? new BigDecimal(0) : detailEntity.getExamineTaxAmounts();//项目部审核-含税金额
                                subcontractvolumeVo.setMid(detailEntity.getMid());
                                subcontractvolumeVo.setSubitemCode(subitemCode1);
                                subcontractvolumeVo.setSection(section1);
                                subcontractvolumeVo.setExamineQuantity(examineQuantity);
                                subcontractvolumeVo.setExamineUnitprice(detailEntity.getExamineUnitprice());//项目部审核-除税单价
                                subcontractvolumeVo.setExamineTaxUnitprice(detailEntity.getExamineTaxUnitprice());//项目部审核-含税单价);
                                subcontractvolumeVo.setExamineAmounts(detailEntity.getExamineAmounts());//项目部审核-除税金额);
                                subcontractvolumeVo.setExamineTaxAmounts(detailEntity.getExamineTaxAmounts());//项目部审核-含税金额
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                if(mapDetailVo == null){
                                    detailMap.put(subitemCode1 + section1,subcontractvolumeVo);
                                }else {
                                    BigDecimal mapExamineQuantity = mapDetailVo.getExamineQuantity() == null ? new BigDecimal(0) : mapDetailVo.getExamineQuantity();
                                    BigDecimal mapExamineAmounts = mapDetailVo.getExamineAmounts() == null ? new BigDecimal(0) : mapDetailVo.getExamineAmounts();
                                    BigDecimal mapExamineTaxAmounts = mapDetailVo.getExamineTaxAmounts() == null ? new BigDecimal(0): mapDetailVo.getExamineTaxAmounts();

                                    BigDecimal examineQuantityTotal = examineQuantity.add(mapExamineQuantity);//汇总的数量
                                    BigDecimal examineAmountsTotal = examineAmounts.add(mapExamineAmounts);//项目部审核-除税金额
                                    BigDecimal examineTaxAmountsTotal = examineTaxAmounts.add(mapExamineTaxAmounts);////项目部审核-含税金额
                                    subcontractvolumeVo.setExamineQuantity(examineQuantityTotal);
                                    subcontractvolumeVo.setExamineAmounts(examineAmountsTotal);
                                    subcontractvolumeVo.setExamineTaxAmounts(examineTaxAmountsTotal);

                                    if(examineQuantityTotal.intValue() != 0){
                                        BigDecimal examineUnitprice = examineAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        BigDecimal examineTaxUnitprice = examineTaxAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        subcontractvolumeVo.setExamineUnitprice(examineUnitprice);//项目部审核-除税单价
                                        subcontractvolumeVo.setExamineTaxUnitprice(examineTaxUnitprice);//项目部审核-含税单价);
                                    }

                                    detailMap.put(subitemCode1 + section1,subcontractvolumeVo);
                                }

                            }
                        }
                        //物资代扣及超用扣款清单
                        //List<SubcontractingvolumemdetailEntity> subcontractingvolumemdetailEntities = item.getSubcontractingvolumemdetailEntities();
                        QueryWrapper<SubcontractingvolumemdetailEntity> subcontractingvolumemdetailEntityQueryWrapper = new QueryWrapper();
                        subcontractingvolumemdetailEntityQueryWrapper.eq("mid", item.getId());
                        subcontractingvolumemdetailEntityQueryWrapper.eq("dr", 0);
                        List<SubcontractingvolumemdetailEntity> detailLists = iSubcontractingvolumemdetailService.list(subcontractingvolumemdetailEntityQueryWrapper);

                        if (detailLists != null && detailLists.size() > 0) {
                            for (int i = 0; i < detailLists.size(); i++) {
                                SubcontractingvolumemdetailEntity detailEntitys = detailLists.get(i);

                                SubcontractvolumemVo subcontractvolumemVo = new SubcontractvolumemVo();

                                subcontractvolumemVo.setMid(detailEntitys.getMid());
                                subcontractvolumemVo.setOverdraftDeduction(detailEntitys.getOverdraftDeduction());//超用扣款（元）
                                //detailEntitys.getWithholding();//代扣款
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SubcontractvolumemVo detailVO1 = BeanMapper.map(subcontractvolumemVo, SubcontractvolumemVo.class);
                                resList3.add(detailVO1);
                                resList.setSubcontractvolumemVo(resList3);
                            }
                        }

                        //其它扣款清单
                        // List<SubcontractingvolumeodetailEntity> subcontractingvolumeodetailEntities = item.getSubcontractingvolumeodetailEntities();
                        QueryWrapper<SubcontractingvolumeodetailEntity> volumeothers = new QueryWrapper();
                        volumeothers.eq("mid", item.getId());
                        subcontractingvolumemdetailEntityQueryWrapper.eq("dr", 0);
                        List<SubcontractingvolumeodetailEntity> listOther = iSubcontractingvolumeodetailService.list(volumeothers);
                        if (listOther != null && listOther.size() > 0) {
                            for (SubcontractingvolumeodetailEntity volumeother1 : listOther) {
                                SubcontractvolumeotherVo subcontractvolumeotherVo = new SubcontractvolumeotherVo();
                                subcontractvolumeotherVo.setMid(volumeother1.getMid());
                                subcontractvolumeotherVo.setAmounts(volumeother1.getAmounts());
                                SubcontractvolumeotherVo detailVO2 = BeanMapper.map(subcontractvolumeotherVo, SubcontractvolumeotherVo.class);
                                resList4.add(detailVO2);
                                resList.setSubcontractvolumeotherVo(resList4);
                            }
                        }
                        resList.setId(item.getId());
                        resList.setContractType(contractType);
//
//                        SubcontractvolumeResultVo detailVO = BeanMapper.map(subcontractvolumedetailVO, SubcontractvolumeResultVo.class);
//                        resList.add(detailVO);

                    } else if ("专业分包".equals(contractType)) {
                        QueryWrapper<SubcontractingvolumedetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                        statementDetailQueryWrapper.eq("mid", item.getId());
                        statementDetailQueryWrapper.eq("subitem_code", subitemCode);
                        statementDetailQueryWrapper.eq("section", section);
                        statementDetailQueryWrapper.eq("dr", 0);
                        //月度（中间）计量计价明细表
                        List<SubcontractingvolumedetailEntity> detailList = iSubcontractingvolumedetailService.list(statementDetailQueryWrapper);
                        if (detailList != null && detailList.size() > 0) {
                            for (int i = 0; i < detailList.size(); i++) {
                                SubcontractingvolumedetailEntity detailEntity = detailList.get(i);
                                String subitemCode1 = detailEntity.getSubitemCode();//编码
                                String section1 = detailEntity.getSection();//区段
                                //从map获取月度（中间）计量计价明细表，如果为空，把service查回的数据放进map，否则，用map的数据和查回的相加
                                SubcontractvolumeVo mapDetailVo = detailMap.get(subitemCode1 + section1);

                                SubcontractvolumeVo subcontractvolumeVo = new SubcontractvolumeVo();

                                BigDecimal examineQuantity = detailEntity.getExamineQuantity() == null ? new BigDecimal(0): detailEntity.getExamineQuantity();//项目部审核-数量
                                BigDecimal examineAmounts = detailEntity.getExamineAmounts() == null ? new BigDecimal(0) : detailEntity.getExamineAmounts();//项目部审核-除税金额
                                BigDecimal examineTaxAmounts = detailEntity.getExamineTaxAmounts() == null ? new BigDecimal(0) : detailEntity.getExamineTaxAmounts();//项目部审核-含税金额
                                subcontractvolumeVo.setMid(detailEntity.getMid());
                                subcontractvolumeVo.setSubitemCode(subitemCode1);
                                subcontractvolumeVo.setSection(section1);
                                subcontractvolumeVo.setExamineQuantity(examineQuantity);
                                subcontractvolumeVo.setExamineUnitprice(detailEntity.getExamineUnitprice());//项目部审核-除税单价
                                subcontractvolumeVo.setExamineTaxUnitprice(detailEntity.getExamineTaxUnitprice());//项目部审核-含税单价);
                                subcontractvolumeVo.setExamineAmounts(detailEntity.getExamineAmounts());//项目部审核-除税金额);
                                subcontractvolumeVo.setExamineTaxAmounts(detailEntity.getExamineTaxAmounts());//项目部审核-含税金额
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                if(mapDetailVo == null){
                                    detailMap.put(subitemCode1 + section1,subcontractvolumeVo);
                                }else {
                                    BigDecimal mapExamineQuantity = mapDetailVo.getExamineQuantity() == null ? new BigDecimal(0) : mapDetailVo.getExamineQuantity();
                                    BigDecimal mapExamineAmounts = mapDetailVo.getExamineAmounts() == null ? new BigDecimal(0) : mapDetailVo.getExamineAmounts();
                                    BigDecimal mapExamineTaxAmounts = mapDetailVo.getExamineTaxAmounts() == null ? new BigDecimal(0): mapDetailVo.getExamineTaxAmounts();

                                    BigDecimal examineQuantityTotal = examineQuantity.add(mapExamineQuantity);//汇总的数量
                                    BigDecimal examineAmountsTotal = examineAmounts.add(mapExamineAmounts);//项目部审核-除税金额
                                    BigDecimal examineTaxAmountsTotal = examineTaxAmounts.add(mapExamineTaxAmounts);////项目部审核-含税金额
                                    subcontractvolumeVo.setExamineQuantity(examineQuantityTotal);
                                    subcontractvolumeVo.setExamineAmounts(examineAmountsTotal);
                                    subcontractvolumeVo.setExamineTaxAmounts(examineTaxAmountsTotal);

                                    if(examineQuantityTotal.intValue() != 0){
                                        BigDecimal examineUnitprice = examineAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        BigDecimal examineTaxUnitprice = examineTaxAmountsTotal.divide(examineQuantityTotal, 8, BigDecimal.ROUND_HALF_UP);
                                        subcontractvolumeVo.setExamineUnitprice(examineUnitprice);//项目部审核-除税单价
                                        subcontractvolumeVo.setExamineTaxUnitprice(examineTaxUnitprice);//项目部审核-含税单价);
                                    }

                                    detailMap.put(subitemCode1 + section1,subcontractvolumeVo);
                                }

                            }
                        }
                        //物资代扣及超用扣款清单
                        //List<SubcontractingvolumemdetailEntity> subcontractingvolumemdetailEntities = item.getSubcontractingvolumemdetailEntities();
                        QueryWrapper<SubcontractingvolumemdetailEntity> subcontractingvolumemdetailEntityQueryWrapper = new QueryWrapper();
                        subcontractingvolumemdetailEntityQueryWrapper.eq("mid", item.getId());
                        subcontractingvolumemdetailEntityQueryWrapper.eq("dr", 0);
                        List<SubcontractingvolumemdetailEntity> detailLists = iSubcontractingvolumemdetailService.list(subcontractingvolumemdetailEntityQueryWrapper);

                        if (detailLists != null && detailLists.size() > 0) {
                            for (int i = 0; i < detailLists.size(); i++) {
                                SubcontractingvolumemdetailEntity detailEntitys = detailLists.get(i);

                                SubcontractvolumemVo subcontractvolumemVo = new SubcontractvolumemVo();

                                subcontractvolumemVo.setMid(detailEntitys.getMid());
                                subcontractvolumemVo.setOverdraftDeduction(detailEntitys.getOverdraftDeduction());//超用扣款（元）
                                //detailEntitys.getWithholding();//代扣款
                                //TODO 如有多条数据，工程量、合价是否需要汇总返回？
                                SubcontractvolumemVo detailVO1 = BeanMapper.map(subcontractvolumemVo, SubcontractvolumemVo.class);
                                resList3.add(detailVO1);
                                resList.setSubcontractvolumemVo(resList3);
                            }
                        }

                        //其它扣款清单
                        // List<SubcontractingvolumeodetailEntity> subcontractingvolumeodetailEntities = item.getSubcontractingvolumeodetailEntities();
                        QueryWrapper<SubcontractingvolumeodetailEntity> volumeothers = new QueryWrapper();
                        volumeothers.eq("mid", item.getId());
                        subcontractingvolumemdetailEntityQueryWrapper.eq("dr", 0);
                        List<SubcontractingvolumeodetailEntity> listOther = iSubcontractingvolumeodetailService.list(volumeothers);
                        if (listOther != null && listOther.size() > 0) {
                            for (SubcontractingvolumeodetailEntity volumeother1 : listOther) {
                                SubcontractvolumeotherVo subcontractvolumeotherVo = new SubcontractvolumeotherVo();
                                subcontractvolumeotherVo.setMid(volumeother1.getMid());
                                subcontractvolumeotherVo.setAmounts(volumeother1.getAmounts());
                                SubcontractvolumeotherVo detailVO2 = BeanMapper.map(subcontractvolumeotherVo, SubcontractvolumeotherVo.class);
                                resList4.add(detailVO2);
                                resList.setSubcontractvolumeotherVo(resList4);
                            }
                        }
                        resList.setId(item.getId());
                        resList.setContractType(contractType);

                    }
                }


                Iterator<Map.Entry<String, SubcontractvolumeVo>> iterator = detailMap.entrySet().iterator();
                while (iterator.hasNext()){
                    Map.Entry<String, SubcontractvolumeVo> next = iterator.next();
                    SubcontractvolumeVo valueVo = next.getValue();
                    resList2.add(valueVo);
                }
                resList.setSubcontractvolumeVo(resList2);
            }
        }

        return CommonResponse.success("查询详情数据成功！", resList);
    }


    /**
     * @Description queryActualCosts
     * <p>
     * 使用：成本管理-项目月度成本分析报告-子表施工措施费的本期实际成本
     * 数据来源：中间计量-分包月度报量及申请报告-月度周转租赁单
     */
    @RequestMapping(value = "/queryActualCosts", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RevolvingleasesVO>> queryActualCosts(Long projectId, String subitemCode, String section, String reportingTime) {
        List<RevolvingleasesVO> resList = new ArrayList<>();
        RevolvingleasesVO revolvingleasesVO = new RevolvingleasesVO();
        if (reportingTime == null || reportingTime.length() < 7) {
            throw new BusinessException("日期不能为空");
        }
        //当月第一天
        String start = reportingTime.substring(0, 7) + "-01";
        //当月最后一天
//        String end = "2022-06-30";

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(reportingTime.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(reportingTime.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());
        QueryWrapper<RevolvingleaseEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", "1", "3");
        queryWrapper.le("settle_time", end);
        queryWrapper.ge("settle_time", start);
        List<RevolvingleaseEntity> mList = iRevolvingleaseService.list(queryWrapper);
        if (mList != null && mList.size() > 0) {
            for (RevolvingleaseEntity item :
                    mList) {

                QueryWrapper<RevolvingleasedetailEntity> statementDetailQueryWrapper = new QueryWrapper();
                statementDetailQueryWrapper.eq("mid", item.getId());
                statementDetailQueryWrapper.eq("encode", subitemCode);
                statementDetailQueryWrapper.eq("section", section);
                statementDetailQueryWrapper.eq("dr", 0);
                //月度周转租赁单
                List<RevolvingleasedetailEntity> detailList = iRevolvingleasedetailService.list(statementDetailQueryWrapper);
                if (detailList != null && detailList.size() > 0) {
                    for (int i = 0; i < detailList.size(); i++) {
                        RevolvingleaseEntity revolvingleasedetailEntity = new RevolvingleaseEntity();
                        List<RevolvingleasedetailEntity> revolvingleasedetailEntities = revolvingleasedetailEntity.getRevolvingleasedetailEntities();
                        RevolvingleasedetailEntity detailEntity = detailList.get(i);
                        Integer lesseeQuantity = detailEntity.getLesseeQuantity();//数量
                        //BigDecimal quantity = new BigDecimal(Integer.parseInt(lesseeQuantity.toString()));////数量
//                        BigDecimal lesseeTotalprice = detailEntity.getLesseeTotalprice();//租赁合价(除税)(元)
                        BigDecimal monthlyExpenses = detailEntity.getMonthlyExpenses();//租赁合价(除税)(元)
//                        BigDecimal taxLesseeTotalprice = detailEntity.getTaxLesseeTotalprice();//租赁合价(含税)(元)
                        BigDecimal taxMonthlyExpenses = detailEntity.getTaxMonthlyExpenses();//租赁合价(含税)(元)
                        revolvingleasesVO.setLesseeQuantity(lesseeQuantity);
                        revolvingleasesVO.setLesseeTotalprice(monthlyExpenses);
                        revolvingleasesVO.setTaxLesseeTotalprice(taxMonthlyExpenses);
                        RevolvingleasesVO details = BeanMapper.map(revolvingleasesVO, RevolvingleasesVO.class);
                        resList.add(details);

                    }
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！", resList);
    }


    /**
     * 成本管理-项目成本月度分析报告-税金
     *
     * @param projectId
     * @param time
     * @return
     */
    @RequestMapping(value = "queryCostanalysisTax", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<CostanalysistaxVO> queryCostanalysisTax(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {

        CostanalysistaxVO costanalysistaxVO = new CostanalysistaxVO();
        List<CostanalysistaxdataVO> costanalysistaxdataVOList = new ArrayList<>();

        if (time == null || time.length() < 7) {
            throw new BusinessException("日期不能为空");
        }
        //当月第一天
        String start = time.substring(0, 7) + "-01";
        //当月最后一天
//        String end = "2022-06-30";

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(time.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(time.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());

//        //月度物资采购结算汇总
//        QueryWrapper<PurchasesummaryEntity> queryWrapperPur = new QueryWrapper<>();
//
//        queryWrapperPur.eq("project_id", projectId);
//        queryWrapperPur.le("statistical_time", end);
//        queryWrapperPur.ge("statistical_time", start);
//        queryWrapperPur.eq("dr", 0);
//        List<PurchasesummaryEntity> listPur = iPurchasesummaryService.list(queryWrapperPur);
//        CostanalysistaxdataVO costanalysistaxdataVOPur = new CostanalysistaxdataVO();
//        costanalysistaxdataVOPur.setBillName("月度物资采购结算汇总");
//        if (listPur.size() > 0) {
//            //本月结算金额(含税)
//            BigDecimal taxSettlementAmount = listPur.get(0).getTaxSettlementAmount();
//            //本月结算金额(除税)
//            BigDecimal settlementAmount = listPur.get(0).getSettlementAmount();
//            //除税额:本月结算金额(除税)
//            costanalysistaxdataVOPur.setAmount(settlementAmount);
//            //含税额：本月结算金额(含税)
//            costanalysistaxdataVOPur.setAmountTax(taxSettlementAmount);
//            BigDecimal taxPur = taxSettlementAmount.subtract(settlementAmount);
//            if (settlementAmount.equals(taxSettlementAmount)) {
//                costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
//            } else {
//                //税金:本月结算金额(含税)-本月结算金额(除税)
//                costanalysistaxdataVOPur.setTax(taxPur);
//            }
//            //税率:（本月结算金额(含税)-本月结算金额(除税)）/本月结算金额(除税)
//            costanalysistaxdataVOPur.setRate(taxPur.divide(settlementAmount, 2, BigDecimal.ROUND_HALF_UP));
//        } else {
//            costanalysistaxdataVOPur.setAmount(new BigDecimal("0.00"));
//            costanalysistaxdataVOPur.setAmountTax(new BigDecimal("0.00"));
//            costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
//            costanalysistaxdataVOPur.setRate(new BigDecimal("0.00"));
//        }
//        costanalysistaxdataVOList.add(costanalysistaxdataVOPur);


        //分包月度报量台账
        QueryWrapper<SubcontractaccountEntity> queryWrapperSub = new QueryWrapper<>();
        queryWrapperSub.eq("project_id", projectId);
        queryWrapperSub.eq("statistical_month", start);
        queryWrapperSub.eq("dr", 0);
        List<SubcontractaccountEntity> listSub = iSubcontractaccountService.list(queryWrapperSub);
        CostanalysistaxdataVO costanalysistaxdataVOSub = new CostanalysistaxdataVO();
        costanalysistaxdataVOSub.setBillName("分包月度报量台账");
        if (listSub.size() > 0) {
            //本月审批工程量(含税)
            BigDecimal taxApprovalQuantity = listSub.get(0).getTaxApprovalQuantity();
            //本月审批工程量(除税)
            BigDecimal approvalQuantity = listSub.get(0).getApprovalQuantity();
            //除税额:本月审批工程量(含税)
            costanalysistaxdataVOSub.setAmount(approvalQuantity);
            //含税额：本月审批工程量(除税)
            costanalysistaxdataVOSub.setAmountTax(taxApprovalQuantity);
            BigDecimal taxSub = taxApprovalQuantity.subtract(approvalQuantity);
            if (approvalQuantity.equals(taxApprovalQuantity)) {
                costanalysistaxdataVOSub.setTax(new BigDecimal("0.00"));
            } else {
                //税金:本月审批工程量(含税)-本月审批工程量(除税)
                costanalysistaxdataVOSub.setTax(taxSub);
            }
            //税率:（本月审批工程量(含税)-本月审批工程量(除税)）/本月审批工程量(除税)
            costanalysistaxdataVOSub.setRate(taxSub.divide(approvalQuantity, 2, BigDecimal.ROUND_HALF_UP));
        } else {
            costanalysistaxdataVOSub.setAmount(new BigDecimal("0.00"));
            costanalysistaxdataVOSub.setAmountTax(new BigDecimal("0.00"));
            costanalysistaxdataVOSub.setTax(new BigDecimal("0.00"));
            costanalysistaxdataVOSub.setRate(new BigDecimal("0.00"));
        }
        costanalysistaxdataVOList.add(costanalysistaxdataVOSub);

        //月度周转租赁结算汇总
        QueryWrapper<RevolvingleasesummaryEntity> queryWrapperRev = new QueryWrapper<>();
        queryWrapperRev.eq("project_id", projectId);
        queryWrapperRev.eq("statistical_time", start);
        queryWrapperRev.eq("dr", 0);
        List<RevolvingleasesummaryEntity> listRev = iRevolvingleasesummaryService.list(queryWrapperRev);
        CostanalysistaxdataVO costanalysistaxdataVORev = new CostanalysistaxdataVO();
        costanalysistaxdataVORev.setBillName("月度周转租赁结算汇总");
        if (listRev.size() > 0) {
            //本月结算金额(含税)
            BigDecimal taxSettlementAmount = listRev.get(0).getTaxSettleAccount();
            //本月结算金额(除税)
            BigDecimal settlementAmount = listRev.get(0).getSettleAccount();
            //除税额:本月结算金额(除税)
            costanalysistaxdataVORev.setAmount(settlementAmount);
            //含税额：本月结算金额(含税)
            costanalysistaxdataVORev.setAmountTax(taxSettlementAmount);
            BigDecimal taxRev = taxSettlementAmount.subtract(settlementAmount);
            if (settlementAmount.equals(taxSettlementAmount)) {
                costanalysistaxdataVORev.setTax(new BigDecimal("0.00"));
            } else {
                //税金:本月结算金额(含税)-本月结算金额(除税)
                costanalysistaxdataVORev.setTax(taxRev);
            }
            //税率:（本月结算金额(含税)-本月结算金额(除税)）/本月结算金额(除税)
            costanalysistaxdataVORev.setRate(taxRev.divide(settlementAmount, 2, BigDecimal.ROUND_HALF_UP));
        } else {
            costanalysistaxdataVORev.setAmount(new BigDecimal("0.00"));
            costanalysistaxdataVORev.setAmountTax(new BigDecimal("0.00"));
            costanalysistaxdataVORev.setTax(new BigDecimal("0.00"));
            costanalysistaxdataVORev.setRate(new BigDecimal("0.00"));
        }
        costanalysistaxdataVOList.add(costanalysistaxdataVORev);


        //月度机械设备租赁结算汇总
        QueryWrapper<MechanicalleasedetotalEntity> queryWrapperMec = new QueryWrapper<>();
        queryWrapperMec.eq("project_id", projectId);
        queryWrapperMec.eq("statistical_time", start);
        queryWrapperMec.eq("dr", 0);
        List<MechanicalleasedetotalEntity> listMec = iMechanicalleasedetotalService.list(queryWrapperMec);
        CostanalysistaxdataVO costanalysistaxdataVOMec = new CostanalysistaxdataVO();
        costanalysistaxdataVOMec.setBillName("月度机械设备租赁结算汇总");
        if (listMec.size() > 0) {
            //本月结算金额(含税)
            BigDecimal taxSettlementAmount = listMec.get(0).getInTaxMonthSettlement();
            //本月结算金额(除税)
            BigDecimal settlementAmount = listMec.get(0).getExTaxMonthSettlement();
            //除税额:本月结算金额(除税)
            costanalysistaxdataVOMec.setAmount(settlementAmount);
            //含税额：本月结算金额(含税)
            costanalysistaxdataVOMec.setAmountTax(taxSettlementAmount);
            BigDecimal taxMec = taxSettlementAmount.subtract(settlementAmount);
            if (settlementAmount.equals(taxSettlementAmount)) {
                costanalysistaxdataVOMec.setTax(new BigDecimal("0.00"));
            } else {
                //税金:本月结算金额(含税)-本月结算金额(除税)
                costanalysistaxdataVOMec.setTax(taxMec);
            }
            //税率:（本月结算金额(含税)-本月结算金额(除税)）/本月结算金额(除税)
            costanalysistaxdataVOMec.setRate(taxMec.divide(settlementAmount, 2, BigDecimal.ROUND_HALF_UP));
        } else {
            costanalysistaxdataVOMec.setAmount(new BigDecimal("0.00"));
            costanalysistaxdataVOMec.setAmountTax(new BigDecimal("0.00"));
            costanalysistaxdataVOMec.setTax(new BigDecimal("0.00"));
            costanalysistaxdataVOMec.setRate(new BigDecimal("0.00"));
        }
        costanalysistaxdataVOList.add(costanalysistaxdataVOMec);

        BigDecimal greaterTax = new BigDecimal("0.00");
        BigDecimal lessAndEqualsTax = new BigDecimal("0.00");
        for (int i = 0; costanalysistaxdataVOList.size() > i; i++) {
            if (costanalysistaxdataVOList.get(i).getRate().compareTo(new BigDecimal("0.03")) == 1) {
                greaterTax = greaterTax.add(costanalysistaxdataVOList.get(i).getTax());
            } else {
                lessAndEqualsTax = lessAndEqualsTax.add(costanalysistaxdataVOList.get(i).getTax());
            }
        }
        costanalysistaxVO.setGreaterTax(greaterTax);
        costanalysistaxVO.setLessAndEqualsTax(lessAndEqualsTax);
        costanalysistaxVO.setDataSource(costanalysistaxdataVOList);
        return CommonResponse.success("查询数据成功", costanalysistaxVO);
    }


    /**
     * 成本管理-项目月度成本分析报告-现金流量-收入
     *
     * @param projectId
     * @param time
     * @return
     */
    @RequestMapping(value = "queryCostanalysisCashflowIncome", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<CostanalysiscashflowincomeVO> queryCostanalysisCashflowIncome(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        CostanalysiscashflowincomeVO costanalysiscashflowincomeVO = new CostanalysiscashflowincomeVO();
        costanalysiscashflowincomeVO.setProjectId(projectId);
        costanalysiscashflowincomeVO.setTime(time);
        List<CostanalysiscashflowincomedataVO> costanalysiscashflowincomedataVOList = new ArrayList<>();

        //当月第一天
        String start = time.substring(0, 7) + "-01";
        //当月最后一天
//        String end = "2022-06-30";
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(time.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(time.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());

        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.le("reporting_time", end);
        queryWrapper.ge("reporting_time", start);
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        for (int i = 0; list.size() > i; i++) {
            CostanalysiscashflowincomedataVO costanalysiscashflowincomedataVO = new CostanalysiscashflowincomedataVO();
            costanalysiscashflowincomedataVO.setBillCode(list.get(i).getBillCode());
            costanalysiscashflowincomedataVO.setProjectId(list.get(i).getProjectId());
            costanalysiscashflowincomedataVO.setTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(list.get(i).getReportingTime()));
            costanalysiscashflowincomedataVO.setCumulativeCollection(list.get(i).getCumulativeCollection());// 本期收款金额
            costanalysiscashflowincomedataVO.setAccumulatedContractualReceivables(list.get(i).getAccumulatedContractualReceivables());//本期合同约定应收款金额
            costanalysiscashflowincomedataVO.setCurrentCollection(list.get(i).getCurrentCollection());//累计收款金额
            costanalysiscashflowincomedataVOList.add(costanalysiscashflowincomedataVO);
        }
        BigDecimal currentCollection = new BigDecimal("0.00");
        BigDecimal accumulatedContractualReceivables = new BigDecimal("0.00");
        BigDecimal cumulativeCollection = new BigDecimal("0.00");
        for (int i = 0; costanalysiscashflowincomedataVOList.size() > i; i++) {
            if (costanalysiscashflowincomedataVOList.get(i).getCurrentCollection() != null) {
                currentCollection = currentCollection.add(costanalysiscashflowincomedataVOList.get(i).getCurrentCollection());
            }
            if (costanalysiscashflowincomedataVOList.get(i).getAccumulatedContractualReceivables() != null) {
                accumulatedContractualReceivables = accumulatedContractualReceivables.add(costanalysiscashflowincomedataVOList.get(i).getAccumulatedContractualReceivables());
            }
            if (costanalysiscashflowincomedataVOList.get(i).getCumulativeCollection() != null) {
                cumulativeCollection = cumulativeCollection.add(costanalysiscashflowincomedataVOList.get(i).getCumulativeCollection());
            }
        }
        //截止目前累计收支情况：本期收款金额的合计
        costanalysiscashflowincomeVO.setIncomeAndExpenses(currentCollection);
        //截止目前应收未收及应付未付情况：表体合同约定应收款金额之和-累计收款金额的合计
        costanalysiscashflowincomeVO.setReceivableUnpaid(accumulatedContractualReceivables.subtract(cumulativeCollection));
        costanalysiscashflowincomeVO.setDataSource(costanalysiscashflowincomedataVOList);
        return CommonResponse.success("查询数据成功", costanalysiscashflowincomeVO);
    }

    /**
     * 根据项目id和年月查询，人工费和分包费
     */
    @RequestMapping(value = "sumArticialAndSubpackage", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<SumVO> sumArticialAndSubpackage(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        List<SumArticialAndSubpackageVO> list = subcontractaccountdetailService.findlist(projectId, time);
        List<SumArticialAndSubpackageVO> list1 = new ArrayList<>();//劳务分包数组
        List<SumArticialAndSubpackageVO> list2 = new ArrayList<>();//专业分包数组
        for (SumArticialAndSubpackageVO vo : list) {
            SumArticialAndSubpackageVO entity = new SumArticialAndSubpackageVO();
            if (vo.getContractType().equals("劳务分包")) {
                entity.setSumPayment(vo.getSumPayment());
                entity.setSumNum(vo.getSumNum());
                entity.setName(vo.getName());
                list1.add(entity);
            } else if (vo.getContractType().equals("专业分包")) {
                entity.setSumPayment(vo.getSumPayment());
                entity.setSumNum(vo.getSumNum());
                entity.setName(vo.getName());
                list2.add(entity);
            }
        }
        SumVO vos = new SumVO();
        vos.setLabour(list1);
        vos.setProfessional(list2);
        return CommonResponse.success("查询数据成功", vos);
    }

    /**
     * 根据项目id和年月查询，月度物资采购结算汇总收支情况
     */
    @RequestMapping(value = "sumSettlement", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<List<SumArticialAndSubpackageVO>> sumSettlement(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        List<SumArticialAndSubpackageVO> list = subcontractaccountdetailService.getList(projectId, time);
        return CommonResponse.success("查询数据成功", list);
    }

    /**
     * 根据项目id和年月查询，月度机械设备租赁结算汇总中的机械费
     */
    @RequestMapping(value = "sumMachinery", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<List<SumArticialAndSubpackageVO>> sumMachinery(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        List<SumArticialAndSubpackageVO> list = subcontractaccountdetailService.selectMachinery(projectId, time);
        return CommonResponse.success("查询数据成功", list);
    }

    /**
     * 根据项目id和年月查询，月度周转租赁结算汇总的施工措施费（现金流量）
     */
    @RequestMapping(value = "sumConstruction", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<List<SumArticialAndSubpackageVO>> sumConstruction(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {
        List<SumArticialAndSubpackageVO> list = subcontractaccountdetailService.selectConstruction(projectId, time);
        return CommonResponse.success("查询数据成功", list);
    }

    /**
     * 查询施工措施费
     */
    @RequestMapping(value = "constructionData", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<RevolvingleasedetaildataVO> constructionData(@RequestParam(value = "projectId") Long projectId, @RequestParam String time, @RequestParam String encode, @RequestParam String section) {
        RevolvingleasedetaildataVO revolvingleasedetaildataVO = revolvingleasedetailService.constructionData(projectId, time, encode, section);
        return CommonResponse.success("查询数据成功", revolvingleasedetaildataVO);
    }

    /**
     * 根据项目id、合同类型、时间查询分包月度报量子表所有数据  人工费和分包费都可用
     */
    @RequestMapping(value = "queryDetailAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<LaborCostVO>> queryDetailAll(@RequestParam String contractType, @RequestParam String projectId,@RequestParam String reportingTime){
        logger.info("所有方法时间=" + reportingTime);
        List<LaborCostVO> detailAll = iSubcontractingvolumedetailService.getDetailAll(contractType, projectId, reportingTime);
        return CommonResponse.success("查询数据成功",detailAll);
    }

    /**
     * 根据项目id、时间查询月度周转租赁单根据项目和时间汇总编码和区段汇总月度结算费用
     */
    @RequestMapping(value = "queryRevolvingAll", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,BigDecimal>> queryRevolvingAll(@RequestParam String projectId,@RequestParam String time){
        List<RevolvingleasedetailVO> revolvingAll = iSubcontractingvolumedetailService.getRevolvingAll(projectId, time);
        Map<String,BigDecimal> map = new HashMap<>();
        if(revolvingAll.size() > 0){
            for(RevolvingleasedetailVO entity: revolvingAll){
                map.put(entity.getEncode()+entity.getSection(),entity.getMonthlyExpenses());
            }
        }
        return CommonResponse.success("查询数据成功",map);
    }
    /**
     * 根据项目id、时间查询月度周转租赁单根据项目和时间汇总编码和区段对应的实体VO
     */
    @RequestMapping(value = "queryRevolvingAllVO", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,RevolvingleasedetailVO>> queryRevolvingAllVO(@RequestParam String projectId,@RequestParam String time){
        List<RevolvingleasedetailVO> revolvingAll = iSubcontractingvolumedetailService.getRevolvingAll(projectId, time);
        Map<String,RevolvingleasedetailVO> map = new HashMap<>();
        if(revolvingAll.size() > 0){
            for(RevolvingleasedetailVO entity: revolvingAll){
                map.put(entity.getEncode()+entity.getSection(),entity);
            }
        }
        return CommonResponse.success("查询数据成功",map);
    }

    /**
     * 根据合同id、合同类型、编码、区段查询超用口扣款
     * @param list
     * @return
     */
    @RequestMapping(value = "/queryOveruse", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,OverusedeductionRequestVO>> queryOveruse(@RequestBody List<OverusedeductionVO> list){
        Map<String,OverusedeductionRequestVO> map = new HashMap<>();
        if(list.size() > 0){
            for(OverusedeductionVO vo : list){
                OverusedeductionRequestVO overuse = iSubcontractingvolumedetailService.getOveruse(vo.getContractType(), vo.getContractId(), vo.getSubitemCode(), vo.getSection(),vo.getUnitPrice(),vo.getTaxUnitPrice());
                map.put(vo.getSubitemCode()+vo.getSection()+vo.getUnitPrice()+vo.getTaxUnitPrice(),overuse);
            }
        }
        return CommonResponse.success("查询成功！",map);
    }

    /**
     * 根据合同id、合同类型、编码、区段查询其他及代扣款
     * @param list
     * @return
     */
    @RequestMapping(value = "/queryOther", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,OverusedeductionRequestVO>> queryOther(@RequestBody List<OverusedeductionVO> list){
        Map<String,OverusedeductionRequestVO> map = new HashMap<>();
        if(list.size() > 0){
            for(OverusedeductionVO vo : list){
                OverusedeductionRequestVO overuse = iSubcontractingvolumedetailService.getOther(vo.getContractType(), vo.getContractId(), vo.getSubitemCode(), vo.getSection(),vo.getUnitPrice(),vo.getTaxUnitPrice());
                map.put(vo.getSubitemCode()+vo.getSection()+vo.getUnitPrice()+vo.getTaxUnitPrice(),overuse);
            }
        }
        return CommonResponse.success("查询成功！",map);
    }
}