package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 工程计量台账导入导出
 */
@Controller
@RequestMapping("engineermeasurementExport")
public class ExcelEngineermeasurementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEngineermeasurementdetailService engineermeasurementdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadEngineermeasurement",method = RequestMethod.POST)
    @ResponseBody
    public void downloadEngineermeasurement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "engineermeasurementdetail-import.xlsx", "工程计量台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportEngineermeasurement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportEngineermeasurement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<EngineermeasurementdetailVO> successList = new ArrayList<>();
        List<EngineermeasurementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    EngineermeasurementdetailVO engineermeasurementdetailVO = new EngineermeasurementdetailVO();
                    List<String> datas = result.get(i);
                    if (datas.size()>12){
                        return CommonResponse.error("请检查上传文件是否正确");
                    }
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String imageProgressStr = datas.get(1);//形象进度
                    String actualReportingValue = datas.get(2);//实际上报产值
                    String nowActualDoneValue = datas.get(3);//本期实际完成产值
                    String nowOwnerApprovalValue = datas.get(4);//本期业主审批产值
                    String financialIncome = datas.get(5);//财务列报收入
                    String rightConfirmationRate = datas.get(6);//确权率(%)
                    String contractApprovalTime = datas.get(7);//合同审批时间
                    String actualReportingTime = datas.get(8);//实际上报时间
                    String actualApprovalTime = datas.get(9);//实际审批时间
                    String amountAgreedReceivables = datas.get(10);//本期应收款金额
                    String remarksStr = datas.get(11);//备注

                    engineermeasurementdetailVO.setId(IdWorker.getId());//id
                    engineermeasurementdetailVO.setActualReportingValue(actualReportingValue == null ? BigDecimal.ZERO : new BigDecimal(actualReportingValue));//实际上报产值
                    engineermeasurementdetailVO.setNowActualDoneValue(nowActualDoneValue == null ? BigDecimal.ZERO : new BigDecimal(nowActualDoneValue));//本期实际完成产值
                    engineermeasurementdetailVO.setNowOwnerApprovalValue(nowOwnerApprovalValue == null ? BigDecimal.ZERO : new BigDecimal(nowOwnerApprovalValue));//本期业主审批产值
                    engineermeasurementdetailVO.setFinancialIncome(financialIncome == null ? BigDecimal.ZERO : new BigDecimal(financialIncome));//财务列报收入
                    engineermeasurementdetailVO.setRightConfirmationRate(rightConfirmationRate == null ? BigDecimal.ZERO : new BigDecimal(rightConfirmationRate));//确权率(%)
                    engineermeasurementdetailVO.setContractApprovalTime(contractApprovalTime == null ? null : new SimpleDateFormat("yyyy/MM/dd").parse(contractApprovalTime));//合同审批时间
                    engineermeasurementdetailVO.setActualReportingTime(actualReportingTime == null ? null : new SimpleDateFormat("yyyy/MM/dd").parse(actualReportingTime));//实际上报时间
                    engineermeasurementdetailVO.setActualApprovalTime(actualApprovalTime == null ? null : new SimpleDateFormat("yyyy/MM/dd").parse(actualApprovalTime));//实际审批时间
                    engineermeasurementdetailVO.setAmountAgreedReceivables(amountAgreedReceivables == null ? BigDecimal.ZERO : new BigDecimal(amountAgreedReceivables));//本期应收款金额
                    engineermeasurementdetailVO.setRemarks(remarksStr); // 备注

                    //必填项、格式校验
                    if(StringUtils.isBlank(imageProgressStr)){
                        engineermeasurementdetailVO.setErrorMsg("形象进度不能为空！");
                        errorsMsgBuilder.append("形象进度不能为空！");
                    }else {
                        engineermeasurementdetailVO.setImageProgress(imageProgressStr); // 形象进度
                    }


                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(engineermeasurementdetailVO);
                    } else {
                        successList.add(engineermeasurementdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromDatabase(@RequestBody EngineermeasurementVO engineermeasurementVO, HttpServletResponse response) {
        QueryWrapper<EngineermeasurementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", engineermeasurementVO.getId());
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementdetailEntity> list = engineermeasurementdetailService.list(queryWrapper);
        List<EngineermeasurementdetailVO> engineermeasurementdetailVOList = BeanMapper.mapList(list, EngineermeasurementdetailVO.class);
        if (engineermeasurementdetailVOList != null && engineermeasurementdetailVOList.size() > 0) {
            for (int i = 0; i < engineermeasurementdetailVOList.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = engineermeasurementdetailVOList.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", engineermeasurementdetailVOList);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromPage(@RequestBody List<EngineermeasurementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = list.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

}
