package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodeService;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("designsubcontractnodeExport")
public class ExceldesignsubcontractnodeController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignsubcontractnodedetailService detailService;
    @Autowired
    private IDesignsubcontractnodeService service;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsubcontractnode-import.xlsx", "设计分包节点报量申请模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, Long contract, Long projectId,String monthStr) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignsubcontractnodedetailVO> successList = new ArrayList<>();
        List<DesignsubcontractnodedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {

                for (int i = 2; i < result.size(); i++) {
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    DesignsubcontractnodedetailVO designsubcontractnodedetailVO = new DesignsubcontractnodedetailVO();
                    List<String> datas = result.get(i);
                    designsubcontractnodedetailVO.setSort(String.valueOf(IdWorker.getId()));//id
                    //设置子表合同id
                    designsubcontractnodedetailVO.setContract(contract);
                    //设置子表项目id
                    designsubcontractnodedetailVO.setProjectId(projectId);

                    //累计审核
                    BigDecimal completeAmt = new BigDecimal(0);

                    String completeContent = datas.get(0);//完成内容
                    String projectName = datas.get(1);//项目名称
                    String measuringUnit = datas.get(2);//计量单位

                    String completeLastAudit = datas.get(3);//完成量（上期累计审核）
                    String exTaxUnitLastAudit = datas.get(4);//除税单价（上期累计审核）
                    String inTaxUnitLastAudit = datas.get(5);//含税单价（上期累计审核）
//                    String exTaxTotalLastAudit = datas.get(6);//除税合价（上期累计审核）
//                    String inTaxTotalLastAudit = datas.get(7);//含税合价（上期累计审核）

                    String completeThisAudit = datas.get(8);//完成量（本期审核）
                    String exTaxUnitThisAudit = datas.get(9);//除税单价（本期审核）
                    String inTaxUnitThisAudit = datas.get(10);//含税单价（本期审核）
//                    String exTaxTotalThisAudit = datas.get(11);//除税合价（本期审核）
//                    String inTaxTotalThisAudit = datas.get(12);//含税合价（本期审核）

                    String completeCumulativeAudit = datas.get(13);//完成量（累计审核）
                    String exTaxUnitCumulativeAudit = datas.get(14);//除税单价（累计审核）
                    String inTaxUnitCumulativeAudit = datas.get(15);//含税单价（累计审核）
//                    String exTaxTotalCumulativeAudit = datas.get(16);//除税合价（累计审核）
//                    String inTaxTotalCumulativeAudit = datas.get(17);//含税合价（累计审核）

                    String remarks = datas.get(18);//完成内容

                    //先导入与往期无关的列
                    designsubcontractnodedetailVO.setId(IdWorker.getId());
                    designsubcontractnodedetailVO.setCompleteContent(completeContent); // 完成内容

                    if (StringUtils.isBlank(projectName)) {
                        designsubcontractnodedetailVO.setErrorMsg("项目名称不能为空！");
                        errorsMsgBuilder.append("项目名称不能为空");
                    } else {
                        designsubcontractnodedetailVO.setProjectName(projectName); // 项目名称
                    }

                    if (StringUtils.isBlank(measuringUnit)) {
                        designsubcontractnodedetailVO.setErrorMsg("计量单位不能为空！");
                        errorsMsgBuilder.append("计量单位不能为空");
                    } else {
                        designsubcontractnodedetailVO.setMeasuringUnit(measuringUnit); //计量单位
                    }

                    if (StringUtils.isBlank(completeLastAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("完成量（上期累计审核）不能为空！");
                        errorsMsgBuilder.append("完成量（上期累计审核）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(completeLastAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("完成量（上期累计审核）格式错误！");
                            errorsMsgBuilder.append("完成量（上期累计审核）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setCompleteLastAudit(new BigDecimal(completeLastAudit)); //  完成量（本期申报）
                        }
                    }
                    if (StringUtils.isBlank(exTaxUnitLastAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("除税单价（上期累计审核）不能为空！");
                        errorsMsgBuilder.append("除税单价（上期累计审核）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(exTaxUnitLastAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("除税单价（上期累计审核）格式错误！");
                            errorsMsgBuilder.append("除税单价（上期累计审核）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitLastAudit(new BigDecimal(exTaxUnitLastAudit)); //  完成量（本期申报）
                        }
                    }
                    if (StringUtils.isBlank(inTaxUnitLastAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("含税单价（上期累计审核）不能为空！");
                        errorsMsgBuilder.append("含税单价（上期累计审核）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(inTaxUnitLastAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("含税单价（上期累计审核）格式错误！");
                            errorsMsgBuilder.append("含税单价（上期累计审核）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitLastAudit(new BigDecimal(inTaxUnitLastAudit)); //  完成量（本期申报）
                        }
                    }


                    if (StringUtils.isBlank(completeThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("完成量（本期审核）不能为空！");
                        errorsMsgBuilder.append("完成量（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(completeThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("完成量（本期审核）格式错误！");
                            errorsMsgBuilder.append("完成量（本期审核）格式错误！");
                        } else {
                            designsubcontractnodedetailVO.setCompleteThisAudit(new BigDecimal(completeThisAudit)); // 完成量（本期审核）
                        }
                    }
                    if (StringUtils.isBlank(exTaxUnitThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("除税单价（本期审核）不能为空！");
                        errorsMsgBuilder.append("除税单价（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(exTaxUnitThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("除税单价（本期审核）格式错误！");
                            errorsMsgBuilder.append("除税单价（本期审核）不能为空！");
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitThisAudit(new BigDecimal(exTaxUnitThisAudit)); // 除税单价（本期审核）
                        }
                    }
                    if (StringUtils.isBlank(inTaxUnitThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("含税单价（本期审核）不能为空！");
                        errorsMsgBuilder.append("含税单价（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(inTaxUnitThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("含税单价（本期审核）格式错误！");
                            errorsMsgBuilder.append("含税单价（本期审核）格式错误！");
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitThisAudit(new BigDecimal(inTaxUnitThisAudit));// 含税单价（本期审核）
                        }
                    }

                    if (StringUtils.isBlank(completeCumulativeAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("完成量（累计审核）不能为空！");
                        errorsMsgBuilder.append("完成量（累计审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(completeCumulativeAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("完成量（累计审核）格式错误！");
                            errorsMsgBuilder.append("完成量（累计审核）格式错误！");
                        } else {
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(new BigDecimal(completeCumulativeAudit)); // 完成量（累计审核）
                        }
                    }
                    if (StringUtils.isBlank(exTaxUnitCumulativeAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("除税单价（累计审核）不能为空！");
                        errorsMsgBuilder.append("除税单价（累计审核）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(exTaxUnitCumulativeAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("除税单价（累计审核）格式错误！");
                            errorsMsgBuilder.append("除税单价（累计审核）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(new BigDecimal(exTaxUnitCumulativeAudit)); //  除税单价（累计审核）
                        }
                    }
                    if (StringUtils.isBlank(inTaxUnitCumulativeAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("含税单价（累计审核）不能为空！");
                        errorsMsgBuilder.append("含税单价（累计审核）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(inTaxUnitCumulativeAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("含税单价（累计审核）格式错误！");
                            errorsMsgBuilder.append("含税单价（累计审核）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(new BigDecimal(inTaxUnitCumulativeAudit)); //  含税单价（累计审核）
                        }
                    }

                    designsubcontractnodedetailVO.setExTaxTotalLastAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteLastAudit(), designsubcontractnodedetailVO.getExTaxUnitLastAudit()));
                    designsubcontractnodedetailVO.setInTaxTotalLastAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteLastAudit(), designsubcontractnodedetailVO.getInTaxUnitLastAudit()));

                    designsubcontractnodedetailVO.setExTaxTotalThisAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteThisAudit(), designsubcontractnodedetailVO.getExTaxUnitThisAudit()));
                    designsubcontractnodedetailVO.setInTaxTotalThisAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteThisAudit(), designsubcontractnodedetailVO.getInTaxUnitThisAudit()));

                    designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteCumulativeAudit(), designsubcontractnodedetailVO.getExTaxUnitCumulativeAudit()));
                    designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(ComputeUtil.safeMultiply(designsubcontractnodedetailVO.getCompleteCumulativeAudit(), designsubcontractnodedetailVO.getInTaxUnitCumulativeAudit()));


                    designsubcontractnodedetailVO.setRemarks(remarks); // 备注

                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        successList.add(designsubcontractnodedetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody DesignsubcontractnodedetailVO
                                                              detailVo, HttpServletResponse response) {
        QueryWrapper<DesignsubcontractnodedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<DesignsubcontractnodedetailEntity> list = detailService.list(queryWrapper);
        List<DesignsubcontractnodedetailVO> designsubcontractnodedetailVOList = BeanMapper.mapList(list, DesignsubcontractnodedetailVO.class);
        if (designsubcontractnodedetailVOList != null && designsubcontractnodedetailVOList.size() > 0) {
            for (int i = 0; i < designsubcontractnodedetailVOList.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = designsubcontractnodedetailVOList.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", designsubcontractnodedetailVOList);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage
    (@RequestBody List<DesignsubcontractnodedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = list.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }


}
