package com.ejianc.business.middlemeasurement.mapper;

import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.foundation.middlemeasurement.vo.CostManageVO;
import com.ejianc.foundation.middlemeasurement.vo.DesignSettlementDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodeEntity;

import java.util.List;
import java.util.Map;

/**
 * 设计分包节点报量申请
 * 
 * @author generator
 * 
 */
@Mapper
public interface DesignsubcontractnodeMapper extends BaseCrudMapper<DesignsubcontractnodeEntity> {
    /**
     * 根据合同id查询设计分包节点申请报量合价和金额
     * @param projectId
     * @return
     */
    List<CostManageVO> queryDesign(Long projectId,String monthStr);

    /**
     * 根据合同id和月份查询计分包节点申请报量合价和金额
     * @param projectId
     * @param monthStr
     * @return
     */

    List<CostManageVO> queryDesignMonth(Long projectId,String monthStr);

    /**
     * 根据合同id和结算日期查询往期累计得数量和含税合价 除税合价
     * 查询根据名称 除税单价 含税单价分组汇总
     * @param contractId
     * @param date
     * @return
     */
    List<DesignSettlementDetailVO> queryDesignDetailCumPast(Long contractId, String date);
    /***
     * @Description //TODO
     * 查询涉及类过程结算单的子表往期数据
     * @param map
     * @return java.util.List<com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO>
     * @createDate 2023/2/3
     * @author yupengjie
     **/
    List<DesignsubcontractnodedetailVO> queryDesignsubcontractnodedetail(Map<String ,String> map);
}
